/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.preferences.initializer;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.fusesource.ide.preferences.Activator;

public class StagingRepositoriesPreferenceInitializer
extends AbstractPreferenceInitializer {
    private static final String PRODUCT_STAGING_REPO_URI = "fuse-internal,http://download.eng.brq.redhat.com/brewroot/repos/jb-fuse-6.2-build/latest/maven/";
    private static final String PRODUCT_FIS_STAGING_REPO_URI = "fis-internal,http://download-node-02.eng.bos.redhat.com/brewroot/repos/jb-fis-2.0-maven-build/latest/maven/";
    private static final String PRODUCT_FUSE_NON_PRODUCTIZED_STAGING_REPO_URI = "fuse-early-access,https://origin-repository.jboss.org/nexus/content/groups/ea/";
    private static final String THIRD_PARTY_STAGING_REPO_URI = "redhat-ea,https://maven.repository.redhat.com/earlyaccess/all";
    private static final String ASF_SNAPSHOT_REPO_URI = "asf-snapshots,https://repository.apache.org/content/groups/snapshots/";

    public void initializeDefaultPreferences() {
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        preferenceStore.setDefault("enableStagingRepositories", false);
        preferenceStore.setDefault("stagingRepositories", "fuse-internal,http://download.eng.brq.redhat.com/brewroot/repos/jb-fuse-6.2-build/latest/maven/;redhat-ea,https://maven.repository.redhat.com/earlyaccess/all;fis-internal,http://download-node-02.eng.bos.redhat.com/brewroot/repos/jb-fis-2.0-maven-build/latest/maven/;asf-snapshots,https://repository.apache.org/content/groups/snapshots/;fuse-early-access,https://origin-repository.jboss.org/nexus/content/groups/ea/");
    }

    IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public boolean isStagingRepositoriesEnabled() {
        return this.getPreferenceStore().getBoolean("enableStagingRepositories");
    }

    public void setStagingRepositoriesEnablement(boolean enable) {
        this.getPreferenceStore().setValue("enableStagingRepositories", enable);
    }

    public List<List<String>> getStagingRepositories() {
        String storedValue = this.getStagingRepositoriesString();
        return this.getStagingRepositoriesAsList(storedValue);
    }

    public String getStagingRepositoriesString() {
        return this.getPreferenceStore().getString("stagingRepositories");
    }

    public List<List<String>> getStagingRepositoriesAsList(String list) {
        return Arrays.asList(list.split(";")).stream().map(repoName -> Arrays.asList(repoName.split(","))).collect(Collectors.toList());
    }

    public void addStagingRepository(String repoName, String repoUrl) {
        if (this.getStagingRepositoriesString().indexOf(repoUrl) != -1) {
            String newRepoString = String.format("%s%s%s%s%s", this.getStagingRepositoriesString(), ";", repoName, ",", repoUrl);
            this.getPreferenceStore().setValue("stagingRepositories", newRepoString);
        }
    }
}

