/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.adopters.configurators;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.fusesource.ide.projecttemplates.adopters.configurators.TemplateConfiguratorSupport;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.CommonNewProjectMetaData;
import org.fusesource.ide.projecttemplates.util.NewFuseIntegrationProjectMetaData;
import org.fusesource.ide.projecttemplates.util.camel.CamelFacetDataModelProvider;

public class DefaultTemplateConfigurator
implements TemplateConfiguratorSupport {
    private static final String LAUNCH_CONFIGURATION_FILE_EXTENSION = ".launch";
    private static final String SETTINGS_FUSETOOLING = ".settings/fusetooling";
    private static final String PLACEHOLDER_PROJECTNAME_IN_LAUNCH_CONFIGURATION = "%%%PLACEHOLDER_PROJECTNAME%%%";
    private static final String PLACEHOLDER_BOMVERSION = "%%%PLACEHOLDER_BOMVERSION%%%";
    protected String bomVersion;

    public DefaultTemplateConfigurator(String bomVersion) {
        this.bomVersion = bomVersion;
    }

    @Override
    public boolean configure(IProject project, CommonNewProjectMetaData metadata, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.defaultTemplateConfiguratorConfiguringJavaProjectMonitorMessage, (int)10);
        IProjectFacetVersion javaFacet = ProjectFacetsManager.getProjectFacet((String)"jst.java").getDefaultVersion();
        try {
            this.configureVersions(project, (IProgressMonitor)subMonitor.split(1));
            this.installFacet(project, "jst.java", javaFacet.getVersionString(), null, (IProgressMonitor)subMonitor.split(1));
            project.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
            this.installFacet(project, "jboss.m2", null, null, (IProgressMonitor)subMonitor.split(1));
            project.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
            this.installFacet(project, "jst.utility", null, null, (IProgressMonitor)subMonitor.split(1));
            project.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
            project.getFile(".classpath").delete(true, (IProgressMonitor)subMonitor.split(1));
            project.refreshLocal(2, (IProgressMonitor)subMonitor.split(1));
            this.configureLaunchConfiguration(project, (IProgressMonitor)subMonitor.split(1));
        }
        catch (CoreException ex) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            return false;
        }
        return true;
    }

    protected void configureVersions(IProject project, IProgressMonitor monitor) throws CoreException {
        if (this.bomVersion != null) {
            IFile pom = project.getFile("pom.xml");
            Path pomAbsolutePath = pom.getLocation().toFile().toPath();
            this.replace(this.bomVersion, PLACEHOLDER_BOMVERSION, pomAbsolutePath, pomAbsolutePath);
            project.refreshLocal(1, monitor);
        }
    }

    private void configureLaunchConfiguration(IProject project, IProgressMonitor monitor) throws CoreException {
        IFolder fuseToolingSettingsFolder = project.getFolder(SETTINGS_FUSETOOLING);
        if (fuseToolingSettingsFolder.exists()) {
            IResource[] potentialLaunchConfigurations = fuseToolingSettingsFolder.members();
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(potentialLaunchConfigurations.length + 1));
            IResource[] iResourceArray = potentialLaunchConfigurations;
            int n = potentialLaunchConfigurations.length;
            int n2 = 0;
            while (n2 < n) {
                IResource potentialLaunchConfiguration = iResourceArray[n2];
                if (potentialLaunchConfiguration.getName().endsWith(LAUNCH_CONFIGURATION_FILE_EXTENSION) && potentialLaunchConfiguration instanceof IFile) {
                    this.replaceInLaunchConfiguration(project, (IFile)potentialLaunchConfiguration);
                }
                subMonitor.worked(1);
                ++n2;
            }
            fuseToolingSettingsFolder.refreshLocal(1, (IProgressMonitor)subMonitor.split(1));
        }
    }

    private void replaceInLaunchConfiguration(IProject project, IFile fileInWhichToReplace) {
        this.replace(fileInWhichToReplace, project.getName(), PLACEHOLDER_PROJECTNAME_IN_LAUNCH_CONFIGURATION);
    }

    protected void replace(IFile fileInWhichToReplace, String valueRoReplace, String placeHolderToReplace) {
        Path filePathInWhichToReplace = fileInWhichToReplace.getLocation().toFile().toPath();
        String targetFileName = fileInWhichToReplace.getName().replaceAll(placeHolderToReplace, valueRoReplace);
        Path newFilePathWitReplacedValue = filePathInWhichToReplace.getParent().resolve(targetFileName);
        this.replace(valueRoReplace, placeHolderToReplace, filePathInWhichToReplace, newFilePathWitReplacedValue);
        this.cleanTemplate(filePathInWhichToReplace);
    }

    protected void replace(String valueRoReplace, String placeHolderToReplace, Path filePathInWhichToReplace, Path newFilePathWitReplacedValue) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (Stream<String> lines = Files.lines(filePathInWhichToReplace);){
                List replaced = lines.map(line -> line.replaceAll(placeHolderToReplace, valueRoReplace)).collect(Collectors.toList());
                Files.write(newFilePathWitReplacedValue, replaced, new OpenOption[0]);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)e);
        }
    }

    private void cleanTemplate(Path templateLaunchConfiguration) {
        File templateLaunchConfigurationFile = templateLaunchConfiguration.toFile();
        if (!templateLaunchConfigurationFile.delete()) {
            templateLaunchConfigurationFile.deleteOnExit();
        }
    }

    protected IDataModel getCamelFacetDataModel(NewFuseIntegrationProjectMetaData projectMetaData) {
        CamelFacetDataModelProvider dmProv = new CamelFacetDataModelProvider();
        dmProv.create();
        IDataModel dm = dmProv.getDataModel();
        dm.setStringProperty("ICamelFacetDataModelProperties.Content_Folder", "camelcontent");
        dm.setStringProperty("ICamelFacetDataModelProperties.Project.CamelDSL", projectMetaData.getDslType().toString());
        dm.setStringProperty("ICamelFacetDataModelProperties.Project.Version", projectMetaData.getCamelVersion());
        dm.setBooleanProperty("camel.project.structure.update", true);
        dm.setProperty("ICamelFacetDataModelProperties.Project.MetaData", (Object)projectMetaData);
        return dm;
    }

    protected void installFacet(IProject project, String facetName, String facetVersion, IDataModel config, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        IFacetedProject fp = ProjectFacetsManager.create((IProject)project, (boolean)true, (IProgressMonitor)subMonitor.newChild(1));
        if (facetVersion != null) {
            fp.installProjectFacet(ProjectFacetsManager.getProjectFacet((String)facetName).getVersion(facetVersion), (Object)config, (IProgressMonitor)subMonitor.newChild(1));
        } else {
            fp.installProjectFacet(ProjectFacetsManager.getProjectFacet((String)facetName).getDefaultVersion(), (Object)config, (IProgressMonitor)subMonitor.newChild(1));
        }
    }
}

