/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.util.maven;

import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Repository;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.fusesource.ide.camel.editor.provider.ext.IDependenciesManager;
import org.fusesource.ide.camel.model.service.core.util.CamelCatalogUtils;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;
import org.fusesource.ide.camel.model.service.core.util.FuseBomFilter;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.preferences.PreferenceManager;
import org.fusesource.ide.preferences.initializer.StagingRepositoriesPreferenceInitializer;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.CommonNewProjectMetaData;
import org.fusesource.ide.projecttemplates.util.ProjectTemplatePatcher;

public class MavenUtils {
    private static final String REDHAT_NAMING_USED_IN_VERSION = "redhat";
    private static final String FUSE_NAMING_USED_IN_VERSION = "fuse";
    private static final String CAMEL_ARTIFACT_ID_PREFIX = "camel-";
    private static final String ORG_APACHE_CAMEL = "org.apache.camel";
    private static final String MAVEN_PROPERTY_JBOSS_FUSE_BOM_VERSION = "jboss.fuse.bom.version";
    private static final String MAVEN_PROPERTY_CAMEL_VERSION = "camel.version";
    private static final String MAVEN_PROPERTY_CAMEL_VERSION_REFERENCE = "${camel.version}";

    private MavenUtils() {
    }

    public static void updateContributedPlugins(List<Plugin> plugins, String camelVersion) {
        IConfigurationElement[] iConfigurationElementArray = MavenUtils.getExtensionPoints();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o;
                if (e.getAttribute("dependenciesManager") != null && (o = e.createExecutableExtension("dependenciesManager")) instanceof IDependenciesManager) {
                    IDependenciesManager dm = (IDependenciesManager)o;
                    dm.updatePluginDependencies(plugins, camelVersion);
                }
            }
            catch (CoreException e1) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)e1);
            }
            ++n2;
        }
    }

    private static IConfigurationElement[] getExtensionPoints() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("org.fusesource.ide.editor.paletteContributor");
    }

    public static void updateCamelVersionPlugins(Model mavenModel, List<Plugin> plugins, String camelVersion) {
        Properties properties = mavenModel.getProperties();
        if (MavenUtils.isMavenPropertyCamelVersionSet(properties)) {
            properties.setProperty(MAVEN_PROPERTY_CAMEL_VERSION, camelVersion);
        }
        if (camelVersion.contains(REDHAT_NAMING_USED_IN_VERSION) || camelVersion.contains(FUSE_NAMING_USED_IN_VERSION)) {
            MavenUtils.updatePluginVersionsForProductizedVersion(plugins, camelVersion, properties);
        } else {
            MavenUtils.updatePluginVersionForNonProductizedVersion(plugins, camelVersion);
        }
    }

    private static void updatePluginVersionForNonProductizedVersion(List<Plugin> plugins, String camelVersion) {
        for (Plugin p : plugins) {
            if (!MavenUtils.isCamelPlugin(p) || MAVEN_PROPERTY_CAMEL_VERSION_REFERENCE.equals(p.getVersion())) continue;
            p.setVersion(camelVersion);
        }
    }

    private static void updatePluginVersionsForProductizedVersion(List<Plugin> plugins, String camelVersion, Properties properties) {
        for (Plugin p : plugins) {
            if (!MavenUtils.isCamelPlugin(p)) continue;
            if (MavenUtils.isMavenPropertyCamelVersionSet(properties)) {
                p.setVersion(MAVEN_PROPERTY_CAMEL_VERSION_REFERENCE);
                continue;
            }
            p.setVersion(camelVersion);
        }
    }

    public static void updateCamelVersionDependencies(Model mavenModel, List<Dependency> dependencies, String camelVersion) {
        Properties properties = mavenModel.getProperties();
        if (MavenUtils.isMavenPropertyCamelVersionSet(properties)) {
            properties.setProperty(MAVEN_PROPERTY_CAMEL_VERSION, camelVersion);
        }
        if (camelVersion.contains(REDHAT_NAMING_USED_IN_VERSION) || camelVersion.contains(FUSE_NAMING_USED_IN_VERSION)) {
            MavenUtils.updateDependenciesForProductizedVersion(mavenModel, dependencies, camelVersion, properties);
        } else {
            MavenUtils.updateDependenciesForNonProductizedVersion(dependencies, camelVersion);
        }
    }

    private static void updateDependenciesForNonProductizedVersion(List<Dependency> dependencies, String camelVersion) {
        for (Dependency dep : dependencies) {
            if (!MavenUtils.isCamelDependency(dep) || MAVEN_PROPERTY_CAMEL_VERSION_REFERENCE.equals(dep.getVersion())) continue;
            dep.setVersion(camelVersion);
        }
    }

    private static void updateDependenciesForProductizedVersion(Model mavenModel, List<Dependency> dependencies, String camelVersion, Properties properties) {
        for (Dependency dep : dependencies) {
            if (!MavenUtils.isCamelDependency(dep)) continue;
            if (MavenUtils.isMavenPropertyFuseBomVersionSet(properties) && mavenModel.getDependencyManagement() != null && MavenUtils.isFuseBomImported(mavenModel.getDependencyManagement().getDependencies()) && !CamelCatalogUtils.isPureFISVersion((String)camelVersion)) {
                dep.setVersion(null);
                continue;
            }
            if (MavenUtils.isMavenPropertyCamelVersionSet(properties)) {
                dep.setVersion(MAVEN_PROPERTY_CAMEL_VERSION_REFERENCE);
                continue;
            }
            dep.setVersion(camelVersion);
        }
    }

    private static boolean isFuseBomImported(List<Dependency> dependencies) {
        for (Dependency dep : dependencies) {
            if (!MavenUtils.isFuseBomImportDependency(dep)) continue;
            return true;
        }
        return false;
    }

    private static boolean isFuseBomImportDependency(Dependency dep) {
        return new FuseBomFilter().test(dep);
    }

    private static boolean isCamelDependency(Dependency dep) {
        return ORG_APACHE_CAMEL.equalsIgnoreCase(dep.getGroupId()) && dep.getArtifactId().startsWith(CAMEL_ARTIFACT_ID_PREFIX);
    }

    private static boolean isCamelPlugin(Plugin plugin) {
        return ORG_APACHE_CAMEL.equalsIgnoreCase(plugin.getGroupId()) && plugin.getArtifactId().startsWith(CAMEL_ARTIFACT_ID_PREFIX);
    }

    private static boolean isMavenPropertyFuseBomVersionSet(Properties properties) {
        return properties != null && properties.getProperty(MAVEN_PROPERTY_JBOSS_FUSE_BOM_VERSION) != null;
    }

    private static boolean isMavenPropertyCamelVersionSet(Properties properties) {
        return properties != null && properties.getProperty(MAVEN_PROPERTY_CAMEL_VERSION) != null;
    }

    public static void updateContributedDependencies(List<Dependency> dependencies, String camelVersion) {
        IConfigurationElement[] iConfigurationElementArray = MavenUtils.getExtensionPoints();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                Object o;
                if (e.getAttribute("dependenciesManager") != null && (o = e.createExecutableExtension("dependenciesManager")) instanceof IDependenciesManager) {
                    IDependenciesManager dm = (IDependenciesManager)o;
                    dm.updateDependencies(dependencies, camelVersion);
                }
            }
            catch (CoreException e1) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)e1);
            }
            ++n2;
        }
    }

    public static boolean ensureRepositoryExists(List<Repository> repositories, String repoURI, String newId) {
        boolean exists = false;
        for (Repository rep : repositories) {
            if (!rep.getUrl().equalsIgnoreCase(repoURI)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            Repository repo = new Repository();
            repo.setId(newId);
            repo.setUrl(repoURI);
            repositories.add(repo);
        }
        return !exists;
    }

    public static void alignFuseRuntimeVersion(Model mavenModel, String camelVersion, IProject project, IProgressMonitor monitor) {
        String fuseVersionForCamelVersion = CamelCatalogUtils.getBomVersionForCamelVersion((String)camelVersion, (IProject)project, (Model)mavenModel, (IProgressMonitor)monitor);
        if (fuseVersionForCamelVersion != null) {
            Properties properties = mavenModel.getProperties();
            if (MavenUtils.isMavenPropertyFuseBomVersionSet(properties) && mavenModel.getDependencyManagement() != null && MavenUtils.isFuseBomImported(mavenModel.getDependencyManagement().getDependencies())) {
                properties.setProperty(MAVEN_PROPERTY_JBOSS_FUSE_BOM_VERSION, fuseVersionForCamelVersion);
            } else {
                MavenUtils.alignFuseRuntimeVersionForNonBOMUsage(mavenModel, project, camelVersion, monitor);
            }
        }
    }

    private static void alignFuseRuntimeVersionForNonBOMUsage(Model mavenModel, IProject project, String camelVersion, IProgressMonitor monitor) {
        if (mavenModel.getDependencyManagement() != null) {
            for (Dependency dependency : mavenModel.getDependencyManagement().getDependencies()) {
                if (!MavenUtils.isFuseBomImportDependency(dependency)) continue;
                dependency.setVersion(CamelCatalogUtils.getBomVersionForCamelVersion((String)camelVersion, (IProject)project, (Model)mavenModel, (IProgressMonitor)monitor));
                return;
            }
        }
    }

    public static boolean manageStagingRepositories(Model mavenModel) {
        if (new StagingRepositoriesPreferenceInitializer().isStagingRepositoriesEnabled()) {
            String stagingRepoString = PreferenceManager.getInstance().loadPreferenceAsString("stagingRepositories");
            boolean hasBeenUpdated = false;
            for (List nameURlPair : new StagingRepositoriesPreferenceInitializer().getStagingRepositoriesAsList(stagingRepoString)) {
                String repoURI = (String)nameURlPair.get(1);
                hasBeenUpdated |= MavenUtils.ensureRepositoryExists(mavenModel.getRepositories(), repoURI, (String)nameURlPair.get(0));
                hasBeenUpdated |= MavenUtils.ensureRepositoryExists(mavenModel.getPluginRepositories(), repoURI, (String)nameURlPair.get(0));
            }
            return hasBeenUpdated;
        }
        return false;
    }

    public static boolean configureCamelVersionForProject(IProject project, String camelVersion, IProgressMonitor monitor) {
        return MavenUtils.configurePomCamelVersion(project, null, camelVersion, monitor);
    }

    public static boolean configurePomCamelVersion(IProject project, CommonNewProjectMetaData projectMetaData, String camelVersion, IProgressMonitor monitor) {
        String newCamelVersion = Strings.isBlank((String)camelVersion) && projectMetaData != null && !Strings.isBlank((String)projectMetaData.getCamelVersion()) ? projectMetaData.getCamelVersion() : camelVersion;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.mavenTemplateConfiguratorAdaptingprojectToCamelVersionMonitorMessage, (int)8);
        try {
            File pomFile = new File(project.getFile("pom.xml").getLocation().toOSString());
            Model m2m = new CamelMavenUtils().getMavenModel(project);
            subMonitor.setWorkRemaining(7);
            if (m2m.getDependencyManagement() != null) {
                MavenUtils.updateCamelVersionDependencies(m2m, m2m.getDependencyManagement().getDependencies(), newCamelVersion);
            }
            subMonitor.setWorkRemaining(6);
            MavenUtils.updateCamelVersionDependencies(m2m, m2m.getDependencies(), newCamelVersion);
            if (m2m.getBuild().getPluginManagement() != null) {
                MavenUtils.updateCamelVersionPlugins(m2m, m2m.getBuild().getPluginManagement().getPlugins(), newCamelVersion);
            }
            subMonitor.setWorkRemaining(5);
            MavenUtils.updateCamelVersionPlugins(m2m, m2m.getBuild().getPlugins(), newCamelVersion);
            subMonitor.setWorkRemaining(4);
            MavenUtils.alignFuseRuntimeVersion(m2m, newCamelVersion, project, (IProgressMonitor)subMonitor.split(1));
            MavenUtils.manageStagingRepositories(m2m);
            subMonitor.setWorkRemaining(2);
            if (projectMetaData != null) {
                ProjectTemplatePatcher patcher = new ProjectTemplatePatcher(projectMetaData);
                patcher.patch(m2m, (IProgressMonitor)subMonitor.split(1));
            }
            subMonitor.setWorkRemaining(1);
            new org.fusesource.ide.camel.editor.utils.MavenUtils().writeNewPomFile(project, pomFile, m2m, (IProgressMonitor)subMonitor.split(1));
        }
        catch (Exception ex) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            return false;
        }
        return true;
    }
}

