/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.MavenPlugin;
import org.fusesource.ide.camel.model.service.core.util.CamelMavenUtils;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.BasicProjectCreatorRunnable;
import org.fusesource.ide.projecttemplates.util.BasicProjectCreatorRunnableUtils;
import org.fusesource.ide.projecttemplates.util.NewFuseIntegrationProjectMetaData;

public final class FuseIntegrationProjectCreatorRunnable
extends BasicProjectCreatorRunnable {
    private static final String ORG_APACHE_FELIX = "org.apache.felix";
    private static final String MAVEN_BUNDLE_PLUGIN = "maven-bundle-plugin";

    public FuseIntegrationProjectCreatorRunnable(NewFuseIntegrationProjectMetaData metadata) {
        super(metadata);
    }

    @Override
    protected void doAdditionalProjectConfiguration(IProject prj, IProgressMonitor monitor) {
        super.doAdditionalProjectConfiguration(prj, monitor);
        try {
            this.updateBundlePluginConfiguration(prj, monitor);
        }
        catch (CoreException ex) {
            ProjectTemplatesActivator.pluginLog().logError("Unable to create project...", (Throwable)ex);
        }
    }

    @Override
    protected void openRequiredFilesInEditor(IProject prj, IProgressMonitor monitor) {
        super.openRequiredFilesInEditor(prj, monitor);
        try {
            this.openCamelContextFile(prj, monitor);
        }
        catch (CoreException ex) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
        }
    }

    protected void updateBundlePluginConfiguration(IProject project, IProgressMonitor monitor) throws CoreException {
        try {
            File pomFile = project.getFile("pom.xml").getLocation().toFile();
            Model pomModel = new CamelMavenUtils().getMavenModel(project);
            this.customizeBundlePlugin(pomModel, project);
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(pomFile));){
                MavenPlugin.getMaven().writeModel(pomModel, (OutputStream)out);
                project.getFile("pom.xml").refreshLocal(0, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | XmlPullParserException | CoreException e1) {
            ProjectTemplatesActivator.pluginLog().logError(e1);
        }
    }

    private void customizeBundlePlugin(Model pomModel, IProject project) throws XmlPullParserException, IOException {
        Build build = pomModel.getBuild();
        Map pluginsByName = build.getPluginsAsMap();
        Plugin plugin = (Plugin)pluginsByName.get("org.apache.felix:maven-bundle-plugin");
        if (plugin != null) {
            this.manageConfigurations(plugin, project, pomModel);
        }
    }

    private void manageConfigurations(Plugin plugin, IProject project, Model pomModel) throws XmlPullParserException, IOException {
        Xpp3Dom config = (Xpp3Dom)plugin.getConfiguration();
        if (config == null) {
            config = Xpp3DomBuilder.build((InputStream)new ByteArrayInputStream("<configuration></configuration>".getBytes(StandardCharsets.UTF_8)), (String)StandardCharsets.UTF_8.name());
            plugin.setConfiguration((Object)config);
        }
        this.manageInstructions(config, project, pomModel);
    }

    private void manageInstructions(Xpp3Dom config, IProject project, Model pomModel) throws XmlPullParserException, IOException {
        Xpp3Dom instructions = config.getChild("instructions");
        if (instructions == null) {
            instructions = Xpp3DomBuilder.build((InputStream)new ByteArrayInputStream("<instructions></instructions>".getBytes(StandardCharsets.UTF_8)), (String)StandardCharsets.UTF_8.name());
            config.addChild(instructions);
        }
        this.manageCustomInstructions(instructions, project, pomModel);
    }

    private void manageCustomInstructions(Xpp3Dom instructions, IProject project, Model pomModel) throws XmlPullParserException, IOException {
        String description;
        Xpp3Dom bundleSymbolicName = instructions.getChild("Bundle-SymbolicName");
        if (bundleSymbolicName == null) {
            bundleSymbolicName = Xpp3DomBuilder.build((InputStream)new ByteArrayInputStream(("<Bundle-SymbolicName>" + BasicProjectCreatorRunnableUtils.getBundleSymbolicNameForProjectName(project.getName()) + "</Bundle-SymbolicName>").getBytes(StandardCharsets.UTF_8)), (String)StandardCharsets.UTF_8.name());
            instructions.addChild(bundleSymbolicName);
        }
        String desc = (description = pomModel.getDescription()) != null && description.trim().length() > 0 ? description : String.format("%s.%s", pomModel.getGroupId(), pomModel.getArtifactId());
        Xpp3Dom bundleName = instructions.getChild("Bundle-Name");
        if (bundleName == null) {
            bundleName = Xpp3DomBuilder.build((InputStream)new ByteArrayInputStream(("<Bundle-Name>" + String.format("%s [%s]", desc, project.getName()) + "</Bundle-Name>").getBytes(StandardCharsets.UTF_8)), (String)StandardCharsets.UTF_8.name());
            instructions.addChild(bundleName);
        }
    }

    private void openCamelContextFile(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project != null) {
            IFile[] holder = new IFile[1];
            boolean isJavaEditorToOpen = false;
            BasicProjectCreatorRunnableUtils.searchCamelContextXMLFile(project, holder);
            if (holder[0] == null && project.hasNature("org.eclipse.jdt.core.javanature")) {
                BasicProjectCreatorRunnableUtils.searchCamelContextJavaFile(project, monitor, holder);
                isJavaEditorToOpen = true;
            }
            if (holder[0] != null) {
                BasicProjectCreatorRunnableUtils.openCamelFile(holder[0], monitor, isJavaEditorToOpen);
            }
        }
    }
}

