/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards.pages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.ServerUIUtil;
import org.fusesource.ide.camel.model.service.core.util.CamelCatalogUtils;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.foundation.ui.util.Widgets;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.util.CamelVersionChecker;
import org.fusesource.ide.projecttemplates.wizards.pages.FuseIntegrationProjectWizardTemplatePage;
import org.fusesource.ide.projecttemplates.wizards.pages.RuntimeCamelVersionFinder;

public class FuseIntegrationProjectWizardRuntimeAndCamelPage
extends WizardPage {
    static final String UNKNOWN_CAMEL_VERSION = "unknown";
    private static final Pattern MAVEN_VERSION_PATTERN = Pattern.compile("^(\\d+){1}(\\.\\d+){1}(\\.\\d+){1}?((\\.|\\-).*)?$");
    private boolean activeCamelVersionValidation;
    private ComboViewer runtimeComboViewer;
    private Map<String, IRuntime> serverRuntimes;
    private String lastSelectedRuntime;
    private Combo camelVersionCombo;

    public FuseIntegrationProjectWizardRuntimeAndCamelPage() {
        super(Messages.newProjectWizardRuntimePageName);
        this.setTitle(Messages.newProjectWizardRuntimePageTitle);
        this.setDescription(Messages.newProjectWizardRuntimePageDescription);
        this.setImageDescriptor(ProjectTemplatesActivator.imageDescriptorFromPlugin((String)"org.fusesource.ide.projecttemplates", (String)"icons/camel_project_64x64.png"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Group runtimeGrp = new Group(container, 0);
        GridData runtimeGrpData = new GridData(4, 0x1000000, true, false, 3, 1);
        runtimeGrp.setLayout((Layout)new GridLayout(3, false));
        runtimeGrp.setLayoutData((Object)runtimeGrpData);
        runtimeGrp.setText(Messages.newProjectWizardRuntimePageRuntimeGroupLabel);
        Label runtimeLabel = new Label((Composite)runtimeGrp, 0);
        GridData runtimeLabelData = new GridData(4, 0x1000000, true, false, 3, 1);
        runtimeLabel.setLayoutData((Object)runtimeLabelData);
        runtimeLabel.setText(Messages.newProjectWizardRuntimePageRuntimeLabel);
        this.runtimeComboViewer = new ComboViewer((Composite)runtimeGrp, 8);
        this.runtimeComboViewer.setComparator(new ViewerComparator((o1, o2) -> {
            if (Messages.newProjectWizardRuntimePageNoRuntimeSelectedLabel.equals(o1)) {
                return -1;
            }
            return o1.compareTo((String)o2);
        }));
        GridData runtimeComboData = new GridData(4, 4, true, false, 2, 1);
        this.runtimeComboViewer.getCombo().setLayoutData((Object)runtimeComboData);
        this.runtimeComboViewer.getCombo().setToolTipText(Messages.newProjectWizardRuntimePageRuntimeDescription);
        this.runtimeComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.runtimeComboViewer.getCombo().addModifyListener(e -> {
            this.lastSelectedRuntime = this.getSelectedRuntimeAsString();
            this.preselectCamelVersionForRuntime(this.determineRuntimeCamelVersion(this.getSelectedRuntime()));
            this.validate();
        });
        this.configureRuntimeCombo();
        Button runtimeNewButton = new Button((Composite)runtimeGrp, 0);
        GridData runtimeNewButtonData = new GridData(4, 0x1000000, false, false);
        runtimeNewButton.setLayoutData((Object)runtimeNewButtonData);
        runtimeNewButton.setText(Messages.newProjectWizardRuntimePageRuntimeNewButtonLabel);
        runtimeNewButton.setToolTipText(Messages.newProjectWizardRuntimePageRuntimeNewButtonDescription);
        runtimeNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String[] newRuntimes;
                String newRuntime;
                String[] oldRuntimes = FuseIntegrationProjectWizardRuntimeAndCamelPage.this.runtimeComboViewer.getCombo().getItems();
                boolean created = ServerUIUtil.showNewRuntimeWizard((Shell)FuseIntegrationProjectWizardRuntimeAndCamelPage.this.getShell(), null, null);
                if (created && (newRuntime = FuseIntegrationProjectWizardRuntimeAndCamelPage.this.getNewRuntime(oldRuntimes, newRuntimes = FuseIntegrationProjectWizardRuntimeAndCamelPage.this.runtimeComboViewer.getCombo().getItems())) != null) {
                    FuseIntegrationProjectWizardRuntimeAndCamelPage.this.runtimeComboViewer.setSelection((ISelection)new StructuredSelection((Object)newRuntime));
                }
            }
        });
        new Label((Composite)runtimeGrp, 0);
        Group camelGrp = new Group(container, 0);
        GridData camelGrpData = new GridData(4, 0x1000000, true, false, 3, 1);
        camelGrp.setLayout((Layout)new GridLayout(3, false));
        camelGrp.setLayoutData((Object)camelGrpData);
        camelGrp.setText(Messages.newProjectWizardRuntimePageCamelGroupLabel);
        Label camelVersionLabel = new Label((Composite)camelGrp, 0);
        GridData camelLabelData = new GridData(4, 0x1000000, true, false, 3, 1);
        camelVersionLabel.setLayoutData((Object)camelLabelData);
        camelVersionLabel.setText(Messages.newProjectWizardRuntimePageCamelLabel);
        this.camelVersionCombo = new Combo((Composite)camelGrp, 131076);
        GridData camelComboData = new GridData(4, 0x1000000, true, false, 2, 1);
        this.camelVersionCombo.setLayoutData((Object)camelComboData);
        this.camelVersionCombo.setItems((String[])CamelCatalogUtils.getAllCamelCatalogVersions().stream().sorted((o1, o2) -> o2.compareToIgnoreCase((String)o1)).toArray(String[]::new));
        this.camelVersionCombo.setText(CamelCatalogUtils.getLatestCamelVersion());
        this.camelVersionCombo.setToolTipText(Messages.newProjectWizardRuntimePageCamelDescription);
        this.camelVersionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                FuseIntegrationProjectWizardRuntimeAndCamelPage.this.validate();
            }
        });
        this.camelVersionCombo.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                FuseIntegrationProjectWizardRuntimeAndCamelPage.this.setMessage(null);
            }
        });
        this.camelVersionCombo.addModifyListener(e -> {
            this.validate();
            ((FuseIntegrationProjectWizardTemplatePage)this.getWizard().getPage(Messages.newProjectWizardTemplatePageName)).refresh(this.camelVersionCombo.getText());
        });
        Button camelVersionValidationBtn = new Button((Composite)camelGrp, 8);
        GridData camelButtonData = new GridData(131072, 0x1000000, false, false, 1, 1);
        camelVersionValidationBtn.setLayoutData((Object)camelButtonData);
        camelVersionValidationBtn.setText(Messages.newProjectWizardRuntimePageCamelVersionValidationLabel);
        camelVersionValidationBtn.setToolTipText(Messages.newProjectWizardRuntimePageCamelVersionValidationDescription);
        camelVersionValidationBtn.addSelectionListener((SelectionListener)new VersionValidationHandler());
        new Label((Composite)camelGrp, 0);
        this.setControl((Control)container);
        ServerCore.addRuntimeLifecycleListener((IRuntimeLifecycleListener)new FuseRuntimeLifecycleListener());
        this.validate();
    }

    private void configureRuntimeCombo() {
        if (Widgets.isDisposed((Viewer)this.runtimeComboViewer)) {
            return;
        }
        String lastUsedRuntime = this.lastSelectedRuntime;
        ArrayList<String> runtimesList = new ArrayList<String>();
        String selectedRuntime = null;
        this.serverRuntimes = this.getServerRuntimes(null);
        this.runtimeComboViewer.setInput((Object)ArrayContentProvider.getInstance());
        runtimesList.addAll(this.serverRuntimes.keySet());
        runtimesList.add(Messages.newProjectWizardRuntimePageNoRuntimeSelectedLabel);
        this.runtimeComboViewer.setInput(runtimesList);
        this.runtimeComboViewer.setSelection((ISelection)new StructuredSelection((Object)Messages.newProjectWizardRuntimePageNoRuntimeSelectedLabel));
        for (Map.Entry<String, IRuntime> entry : this.serverRuntimes.entrySet()) {
            IRuntime runtime = entry.getValue();
            if (lastUsedRuntime == null || !lastUsedRuntime.equals(runtime.getId())) continue;
            selectedRuntime = lastUsedRuntime;
        }
        if (selectedRuntime != null) {
            this.runtimeComboViewer.setSelection((ISelection)new StructuredSelection(selectedRuntime));
        }
    }

    private Map<String, IRuntime> getServerRuntimes(IProjectFacetVersion facetVersion) {
        Set runtimesSet = facetVersion == null ? RuntimeManager.getRuntimes() : RuntimeManager.getRuntimes(Collections.singleton(facetVersion));
        LinkedHashMap<String, IRuntime> runtimesMap = new LinkedHashMap<String, IRuntime>();
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime r : runtimesSet) {
            IRuntime serverRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)r);
            if (serverRuntime == null) continue;
            runtimesMap.put(r.getLocalizedName(), serverRuntime);
        }
        return runtimesMap;
    }

    private String getNewRuntime(String[] oldRuntimes, String[] newRuntimes) {
        String[] stringArray = newRuntimes;
        int n = newRuntimes.length;
        int n2 = 0;
        while (n2 < n) {
            String newRuntime = stringArray[n2];
            boolean found = false;
            String[] stringArray2 = oldRuntimes;
            int n3 = oldRuntimes.length;
            int n4 = 0;
            while (n4 < n3) {
                String oldRuntime = stringArray2[n4];
                if (newRuntime.equals(oldRuntime)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            if (!found) {
                return newRuntime;
            }
            ++n2;
        }
        return Messages.newProjectWizardRuntimePageNoRuntimeSelectedLabel;
    }

    public void preselectCamelVersionForRuntime(String runtimeCamelVersion) {
        if (Widgets.isDisposed((Control)this.camelVersionCombo)) {
            return;
        }
        if (UNKNOWN_CAMEL_VERSION.equals(runtimeCamelVersion)) {
            this.camelVersionCombo.setEnabled(true);
        } else {
            this.camelVersionCombo.setText(runtimeCamelVersion);
        }
    }

    public String determineRuntimeCamelVersion(IRuntime runtime) {
        return new RuntimeCamelVersionFinder().getVersion(runtime);
    }

    private boolean isCompatible(String runtimeCamelVersion, String selectedCamelVersion) {
        boolean productizedSelectedCamelVersion;
        String[] runtimeVersionParts = runtimeCamelVersion.split("\\.");
        String[] camelVersionParts = selectedCamelVersion.split("\\.");
        boolean productizedRuntimeCamelVersion = runtimeCamelVersion.indexOf(".redhat-") != -1 || runtimeCamelVersion.indexOf(".fuse-") != -1;
        boolean bl = productizedSelectedCamelVersion = selectedCamelVersion.indexOf(".redhat-") != -1 || selectedCamelVersion.indexOf(".fuse-") != -1;
        return runtimeVersionParts.length > 1 && camelVersionParts.length > 1 && runtimeVersionParts[0].equals(camelVersionParts[0]) && runtimeVersionParts[1].equals(camelVersionParts[1]) && productizedRuntimeCamelVersion == productizedSelectedCamelVersion;
    }

    public IRuntime getSelectedRuntime() {
        String runtimeId;
        if (!Widgets.isDisposed((Viewer)this.runtimeComboViewer) && !Messages.newProjectWizardRuntimePageNoRuntimeSelectedLabel.equalsIgnoreCase(runtimeId = this.getSelectedRuntimeAsString())) {
            return this.serverRuntimes.get(runtimeId);
        }
        return null;
    }

    public String getSelectedRuntimeAsString() {
        IStructuredSelection structuredSelection = this.runtimeComboViewer.getStructuredSelection();
        if (!structuredSelection.isEmpty()) {
            return (String)structuredSelection.getFirstElement();
        }
        return null;
    }

    public String getSelectedCamelVersion() {
        if (!Widgets.isDisposed((Control)this.camelVersionCombo)) {
            return this.camelVersionCombo.getText();
        }
        return null;
    }

    public void setCamelVersionCombo(Combo camelVersionCombo) {
        this.camelVersionCombo = camelVersionCombo;
    }

    public void validate() {
        this.setErrorMessage(null);
        if (this.getSelectedRuntime() != null) {
            this.validateForRuntimeCamelVersion(this.determineRuntimeCamelVersion(this.getSelectedRuntime()));
        } else {
            String selectedCamelVersion;
            if (!Widgets.isDisposed((Control)this.camelVersionCombo)) {
                this.camelVersionCombo.setEnabled(true);
            }
            if (!this.isValidCamelVersionSyntax(selectedCamelVersion = this.getSelectedCamelVersion())) {
                this.setErrorMessage(NLS.bind((String)Messages.newProjectWizardRuntimePageCamelVersionInvalidSyntaxWarning, (Object)selectedCamelVersion));
            }
        }
        if (Strings.isBlank((String)this.getSelectedRuntimeAsString())) {
            this.setErrorMessage(Messages.newProjectWizardRuntimePageNoRuntimeSelectedLabel);
        }
        if (Strings.isBlank((String)this.getSelectedCamelVersion())) {
            this.setErrorMessage(Messages.newProjectWizardRuntimePageNoCamelVersionSelectedLabel);
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private void validateForRuntimeCamelVersion(String runtimeCamelVersion) {
        if (UNKNOWN_CAMEL_VERSION.equals(runtimeCamelVersion)) {
            if (!Widgets.isDisposed((Control)this.camelVersionCombo)) {
                this.camelVersionCombo.setEnabled(true);
            }
            this.setErrorMessage(Messages.fuseIntegrationProjectWizardRuntimeAndCamelPageWarningMessageWhenCamelVersionCannotBeDeterminedInRuntime);
        } else {
            if (!this.isCompatible(runtimeCamelVersion, this.getSelectedCamelVersion())) {
                this.setErrorMessage(NLS.bind((String)Messages.newProjectWizardRuntimePageCamelVersionsDontMatchWarning, (Object)runtimeCamelVersion));
            }
            if (!Widgets.isDisposed((Control)this.camelVersionCombo)) {
                this.camelVersionCombo.setEnabled(false);
            }
        }
    }

    public boolean isValidCamelVersionSyntax(String camelVersion) {
        if (camelVersion != null) {
            Matcher m = MAVEN_VERSION_PATTERN.matcher(camelVersion);
            return m.matches();
        }
        return false;
    }

    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && !this.activeCamelVersionValidation && this.isPageComplete();
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.getErrorMessage() == null;
    }

    static /* synthetic */ void access$0(FuseIntegrationProjectWizardRuntimeAndCamelPage fuseIntegrationProjectWizardRuntimeAndCamelPage) {
        fuseIntegrationProjectWizardRuntimeAndCamelPage.configureRuntimeCombo();
    }

    class FuseRuntimeLifecycleListener
    implements IRuntimeLifecycleListener {
        FuseRuntimeLifecycleListener() {
        }

        public void runtimeRemoved(IRuntime runtime) {
            this.runInUIThread();
        }

        public void runtimeChanged(IRuntime runtime) {
            this.runInUIThread();
        }

        public void runtimeAdded(IRuntime runtime) {
            this.runInUIThread();
        }

        private void runInUIThread() {
            Display.getDefault().asyncExec(() -> FuseIntegrationProjectWizardRuntimeAndCamelPage.access$0(FuseIntegrationProjectWizardRuntimeAndCamelPage.this));
        }
    }

    class VersionValidationHandler
    extends SelectionAdapter {
        VersionValidationHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            String camelVersion = FuseIntegrationProjectWizardRuntimeAndCamelPage.this.getSelectedCamelVersion();
            CamelVersionChecker versionChecker = new CamelVersionChecker(camelVersion);
            try {
                FuseIntegrationProjectWizardRuntimeAndCamelPage.this.activeCamelVersionValidation = true;
                FuseIntegrationProjectWizardRuntimeAndCamelPage.this.getWizard().getContainer().run(true, true, (IRunnableWithProgress)versionChecker);
            }
            catch (InterruptedException interruptedException) {
                versionChecker.cancel();
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            }
            while (!versionChecker.isDone()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            FuseIntegrationProjectWizardRuntimeAndCamelPage.this.activeCamelVersionValidation = !versionChecker.isDone();
            this.updateCamelValidation(camelVersion, versionChecker.isValid());
        }

        private void updateCamelValidation(String camelVersion, boolean valid) {
            if (!valid) {
                FuseIntegrationProjectWizardRuntimeAndCamelPage.this.setMessage(null);
                FuseIntegrationProjectWizardRuntimeAndCamelPage.this.setErrorMessage(NLS.bind((String)Messages.newProjectWizardRuntimePageCamelVersionInvalidWarning, (Object)camelVersion));
            } else {
                FuseIntegrationProjectWizardRuntimeAndCamelPage.this.setErrorMessage(null);
                FuseIntegrationProjectWizardRuntimeAndCamelPage.this.setMessage(Messages.newProjectWizardRuntimePageCamelVersionValidInfo, 1);
            }
            FuseIntegrationProjectWizardRuntimeAndCamelPage.this.setPageComplete(valid);
        }
    }
}

