/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards.pages;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.fusesource.ide.foundation.ui.util.Selections;
import org.fusesource.ide.foundation.ui.util.Widgets;
import org.fusesource.ide.projecttemplates.adopters.util.CamelDSLType;
import org.fusesource.ide.projecttemplates.internal.Messages;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.wizards.pages.FuseIntegrationProjectWizardRuntimeAndCamelPage;
import org.fusesource.ide.projecttemplates.wizards.pages.filter.CompatibleCamelVersionFilter;
import org.fusesource.ide.projecttemplates.wizards.pages.filter.ExcludeEmptyCategoriesFilter;
import org.fusesource.ide.projecttemplates.wizards.pages.filter.TemplateNameAndKeywordPatternFilter;
import org.fusesource.ide.projecttemplates.wizards.pages.model.CategoryItem;
import org.fusesource.ide.projecttemplates.wizards.pages.model.TemplateItem;
import org.fusesource.ide.projecttemplates.wizards.pages.model.TemplateModel;
import org.fusesource.ide.projecttemplates.wizards.pages.provider.TemplateContentProvider;
import org.fusesource.ide.projecttemplates.wizards.pages.provider.TemplateLabelProvider;

public class FuseIntegrationProjectWizardTemplatePage
extends WizardPage {
    private Button buttonEmptyProject;
    private Button buttonTemplateProject;
    private Button buttonBlueprintDSL;
    private Button buttonSpringDSL;
    private Button buttonJavaDSL;
    private FilteredTree listTemplates;
    private Text templateInfoText;
    private FuseIntegrationProjectWizardRuntimeAndCamelPage runtimeAndCamelVersionPage;
    private CompatibleCamelVersionFilter compatibleCamelVersionFilter;
    private Label filteredTemplatesInformationMessage;
    private Label filteredTemplatesInformationIcon;

    public FuseIntegrationProjectWizardTemplatePage(FuseIntegrationProjectWizardRuntimeAndCamelPage runtimeAndCamelVersionPage) {
        super(Messages.newProjectWizardTemplatePageName);
        this.runtimeAndCamelVersionPage = runtimeAndCamelVersionPage;
        this.setTitle(Messages.newProjectWizardTemplatePageTitle);
        this.setDescription(Messages.newProjectWizardTemplatePageDescription);
        this.setImageDescriptor(ProjectTemplatesActivator.imageDescriptorFromPlugin((String)"org.fusesource.ide.projecttemplates", (String)"icons/camel_project_64x64.png"));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        Label lblHeadline = new Label(container, 0);
        lblHeadline.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        lblHeadline.setText(Messages.newProjectWizardTemplatePageHeadlineLabel);
        Composite grpEmptyVsTemplate = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        grpEmptyVsTemplate.setLayout((Layout)gridLayout);
        grpEmptyVsTemplate.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.buttonEmptyProject = new Button(grpEmptyVsTemplate, 16);
        this.buttonEmptyProject.setText(Messages.newProjectWizardTemplatePageEmptyProjectLabel);
        this.buttonEmptyProject.setToolTipText(Messages.newProjectWizardTemplatePageEmptyProjectDescription);
        this.buttonEmptyProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FuseIntegrationProjectWizardTemplatePage.this.setTemplatesActive(false);
                FuseIntegrationProjectWizardTemplatePage.this.validate();
            }
        });
        this.createTemplatesPanel(grpEmptyVsTemplate);
        this.createDSLRadioButtons(container);
        this.buttonEmptyProject.setSelection(true);
        this.buttonBlueprintDSL.setSelection(true);
        this.setControl((Control)container);
        this.setTemplatesActive(false);
        this.validate();
    }

    protected void createTemplatesPanel(Composite grpEmptyVsTemplate) {
        this.buttonTemplateProject = new Button(grpEmptyVsTemplate, 16);
        this.buttonTemplateProject.setText(Messages.newProjectWizardTemplatePageTemplateProjectLabel);
        this.buttonTemplateProject.setToolTipText(Messages.newProjectWizardTemplatePageTemplateProjectDescription);
        this.buttonTemplateProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FuseIntegrationProjectWizardTemplatePage.this.setTemplatesActive(true);
                FuseIntegrationProjectWizardTemplatePage.this.validate();
            }
        });
        Composite templates = new Composite(grpEmptyVsTemplate, 0);
        GridData gd = new GridData(4, 4, true, true, 3, 1);
        gd.horizontalIndent = 20;
        templates.setLayoutData((Object)gd);
        templates.setLayout((Layout)new GridLayout(2, true));
        this.listTemplates = this.createFilteredTree(templates);
        this.templateInfoText = new Text(templates, 2890);
        this.templateInfoText.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTemplatesBottomInformation(templates);
    }

    protected void createTemplatesBottomInformation(Composite templates) {
        Composite infoComposite = new Composite(templates, 0);
        infoComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(2, 1).create());
        infoComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).create());
        this.filteredTemplatesInformationIcon = new Label(infoComposite, 0);
        this.filteredTemplatesInformationIcon.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK"));
        this.filteredTemplatesInformationMessage = new Label(infoComposite, 0);
        this.filteredTemplatesInformationMessage.setText(Messages.newProjectWizardTemplatePageTemplateFilterMessageInformation);
        this.filteredTemplatesInformationMessage.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
    }

    protected void createDSLRadioButtons(Composite container) {
        Label lblDsl = new Label(container, 0);
        lblDsl.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        lblDsl.setText(Messages.newProjectWizardTemplatePageDSLLabel);
        Composite grpDslSelection = new Composite(container, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        grpDslSelection.setLayout((Layout)gridLayout);
        GridData gd = new GridData(16384, 128, true, false, 3, 1);
        gd.horizontalIndent = 20;
        grpDslSelection.setLayoutData((Object)gd);
        this.buttonBlueprintDSL = this.createDSLRadioButton(grpDslSelection, Messages.newProjectWizardTemplatePageBlueprintDSLLabel, Messages.newProjectWizardTemplatePageBlueprintDSLDescription);
        this.buttonSpringDSL = this.createDSLRadioButton(grpDslSelection, Messages.newProjectWizardTemplatePageSpringDSLLabel, Messages.newProjectWizardTemplatePageSpringDSLDescription);
        this.buttonJavaDSL = this.createDSLRadioButton(grpDslSelection, Messages.newProjectWizardTemplatePageJavaDSLLabel, Messages.newProjectWizardTemplatePageJavaDSLDescription);
    }

    protected Button createDSLRadioButton(Composite grpDslSelection, String text, String tooltipText) {
        Button button = new Button(grpDslSelection, 16);
        button.setText(text);
        button.setToolTipText(tooltipText);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FuseIntegrationProjectWizardTemplatePage.this.validate();
            }
        });
        return button;
    }

    private FilteredTree createFilteredTree(Composite parent) {
        this.listTemplates = new FilteredTree(parent, 2820, (PatternFilter)new TemplateNameAndKeywordPatternFilter(), true);
        this.listTemplates.getFilterControl().setMessage(Messages.newProjectWizardTemplatePageFilterBoxText);
        this.listTemplates.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 4).create());
        this.listTemplates.getViewer().setContentProvider((IContentProvider)new TemplateContentProvider());
        this.listTemplates.getViewer().setLabelProvider((IBaseLabelProvider)new TemplateLabelProvider());
        this.compatibleCamelVersionFilter = new CompatibleCamelVersionFilter(this.runtimeAndCamelVersionPage.getSelectedCamelVersion());
        this.listTemplates.getViewer().setFilters(new ViewerFilter[]{new ExcludeEmptyCategoriesFilter(), this.compatibleCamelVersionFilter});
        this.listTemplates.getViewer().setInput((Object)this.getTemplates());
        this.listTemplates.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selObj;
                if (!event.getSelection().isEmpty() && (selObj = Selections.getFirstSelection((ISelection)event.getSelection())) instanceof TemplateItem) {
                    FuseIntegrationProjectWizardTemplatePage.this.updateTemplateInfo((TemplateItem)selObj);
                    FuseIntegrationProjectWizardTemplatePage.this.updateDSLButtonGroup((TemplateItem)selObj);
                    FuseIntegrationProjectWizardTemplatePage.this.validate();
                    return;
                }
                FuseIntegrationProjectWizardTemplatePage.this.updateTemplateInfo(null);
            }
        });
        return this.listTemplates;
    }

    private void updateTemplateInfo(TemplateItem template) {
        if (template == null) {
            this.buttonBlueprintDSL.setEnabled(true);
            this.buttonSpringDSL.setEnabled(true);
            this.buttonJavaDSL.setEnabled(true);
            this.templateInfoText.setText("");
        } else {
            this.buttonBlueprintDSL.setEnabled(template.getTemplate().supportsDSL(CamelDSLType.BLUEPRINT));
            this.buttonSpringDSL.setEnabled(template.getTemplate().supportsDSL(CamelDSLType.SPRING));
            this.buttonJavaDSL.setEnabled(template.getTemplate().supportsDSL(CamelDSLType.JAVA));
            this.templateInfoText.setText(template.getDescription());
        }
        this.validate();
    }

    public TemplateModel getTemplates() {
        return new TemplateModel();
    }

    private void setTemplatesActive(boolean active) {
        this.listTemplates.getViewer().getTree().setEnabled(active);
        this.listTemplates.getViewer().getTree().getParent().setEnabled(active);
        this.listTemplates.getFilterControl().setEnabled(active);
        this.listTemplates.setEnabled(active);
        this.templateInfoText.setEnabled(active);
        this.filteredTemplatesInformationIcon.setEnabled(active);
        this.filteredTemplatesInformationMessage.setEnabled(active);
        if (!active) {
            this.buttonBlueprintDSL.setEnabled(true);
            this.buttonSpringDSL.setEnabled(true);
            this.buttonJavaDSL.setEnabled(true);
        } else {
            this.buttonBlueprintDSL.setEnabled(this.getSelectedTemplate() != null && this.getSelectedTemplate().getTemplate().supportsDSL(CamelDSLType.BLUEPRINT));
            this.buttonSpringDSL.setEnabled(this.getSelectedTemplate() != null && this.getSelectedTemplate().getTemplate().supportsDSL(CamelDSLType.SPRING));
            this.buttonJavaDSL.setEnabled(this.getSelectedTemplate() != null && this.getSelectedTemplate().getTemplate().supportsDSL(CamelDSLType.JAVA));
            this.updateDSLButtonGroup(this.getSelectedTemplate());
        }
    }

    private void selectFirstSupportedDSLType(TemplateItem template) {
        CamelDSLType[] camelDSLTypeArray = CamelDSLType.values();
        int n = camelDSLTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CamelDSLType dslType = camelDSLTypeArray[n2];
            if (template.getTemplate().supportsDSL(dslType)) {
                this.selectButtonForDSL(dslType);
                return;
            }
            ++n2;
        }
    }

    private void updateDSLButtonGroup(TemplateItem template) {
        if (template == null || !this.disabledDSLSelected()) {
            return;
        }
        this.selectFirstSupportedDSLType(template);
    }

    private void selectButtonForDSL(CamelDSLType dsltype) {
        if (dsltype.equals((Object)CamelDSLType.BLUEPRINT)) {
            this.buttonBlueprintDSL.setSelection(true);
            this.buttonJavaDSL.setSelection(false);
            this.buttonSpringDSL.setSelection(false);
        } else if (dsltype.equals((Object)CamelDSLType.JAVA)) {
            this.buttonBlueprintDSL.setSelection(false);
            this.buttonJavaDSL.setSelection(true);
            this.buttonSpringDSL.setSelection(false);
        } else {
            this.buttonBlueprintDSL.setSelection(false);
            this.buttonJavaDSL.setSelection(false);
            this.buttonSpringDSL.setSelection(true);
        }
    }

    private boolean isSelectedAndDisabled(Button button) {
        return button.getSelection() && !button.isEnabled();
    }

    private boolean disabledDSLSelected() {
        return this.isSelectedAndDisabled(this.buttonBlueprintDSL) || this.isSelectedAndDisabled(this.buttonJavaDSL) || this.isSelectedAndDisabled(this.buttonSpringDSL);
    }

    private void validate() {
        if (this.buttonTemplateProject.getSelection() && (this.listTemplates.getViewer().getSelection().isEmpty() || Selections.getFirstSelection((ISelection)this.listTemplates.getViewer().getSelection()) instanceof CategoryItem || !this.isSelectedDSLSupported())) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
        }
    }

    private boolean isSelectedDSLSupported() {
        CamelDSLType dsl = null;
        if (this.buttonBlueprintDSL.getSelection()) {
            dsl = CamelDSLType.BLUEPRINT;
        } else if (this.buttonSpringDSL.getSelection()) {
            dsl = CamelDSLType.SPRING;
        } else if (this.buttonJavaDSL.getSelection()) {
            dsl = CamelDSLType.JAVA;
        }
        return dsl != null && this.getSelectedTemplate() != null && this.getSelectedTemplate().getTemplate() != null && this.getSelectedTemplate().getTemplate().supportsDSL(dsl);
    }

    public boolean isEmptyProject() {
        if (!Widgets.isDisposed((Control)this.buttonEmptyProject)) {
            return this.buttonEmptyProject.getSelection();
        }
        return this.getSelectedTemplate() == null;
    }

    public boolean isTemplateProject() {
        if (this.buttonTemplateProject != null && !this.buttonTemplateProject.isDisposed()) {
            return this.buttonTemplateProject.getSelection();
        }
        return false;
    }

    public TemplateItem getSelectedTemplate() {
        Object o;
        if (this.buttonTemplateProject.getSelection() && !this.listTemplates.getViewer().getSelection().isEmpty() && (o = Selections.getFirstSelection((ISelection)this.listTemplates.getViewer().getSelection())) instanceof TemplateItem) {
            return (TemplateItem)o;
        }
        return null;
    }

    public CamelDSLType getDSL() {
        if (this.buttonBlueprintDSL.getSelection()) {
            return CamelDSLType.BLUEPRINT;
        }
        if (this.buttonSpringDSL.getSelection()) {
            return CamelDSLType.SPRING;
        }
        if (this.buttonJavaDSL.getSelection()) {
            return CamelDSLType.JAVA;
        }
        return null;
    }

    public FilteredTree getListTemplates() {
        return this.listTemplates;
    }

    public Button getBtnBlueprintDSL() {
        return this.buttonBlueprintDSL;
    }

    public Button getBtnJavaDSL() {
        return this.buttonJavaDSL;
    }

    public Button getBtnSpringDSL() {
        return this.buttonSpringDSL;
    }

    public Button getBtnTemplateProject() {
        return this.buttonTemplateProject;
    }

    public void refresh(String camelVersion) {
        this.compatibleCamelVersionFilter.setCamelVersion(camelVersion);
        this.listTemplates.getViewer().refresh();
    }
}

