/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards.pages.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fusesource.ide.projecttemplates.wizards.pages.model.NameAndWeightComparator;
import org.fusesource.ide.projecttemplates.wizards.pages.model.NameAndWeightSupport;
import org.fusesource.ide.projecttemplates.wizards.pages.model.TemplateItem;

public class CategoryItem
implements NameAndWeightSupport {
    private String id;
    private String name;
    private String parent;
    private int weight;
    private CategoryItem parentCategory;
    private List<CategoryItem> subCategories = new ArrayList<CategoryItem>();
    private List<TemplateItem> templates = new ArrayList<TemplateItem>();
    private NameAndWeightComparator comparator = new NameAndWeightComparator();

    public CategoryItem(String id, String name, int weight, String parent) {
        this.id = id;
        this.name = name;
        this.weight = weight;
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    public String getParent() {
        return this.parent;
    }

    public List<TemplateItem> getTemplates() {
        return this.templates;
    }

    public List<CategoryItem> getSubCategories() {
        return this.subCategories;
    }

    public void addTemplate(TemplateItem template) {
        if (!this.templates.contains(template)) {
            this.templates.add(template);
            Collections.sort(this.templates, this.comparator);
        }
    }

    public void addSubCategory(CategoryItem subCategory) {
        if (!this.subCategories.contains(subCategory)) {
            this.subCategories.add(subCategory);
            subCategory.setParentCategory(this);
            Collections.sort(this.subCategories, this.comparator);
        }
    }

    public CategoryItem getParentCategory() {
        return this.parentCategory;
    }

    public void setParentCategory(CategoryItem parentCategory) {
        this.parentCategory = parentCategory;
    }
}

