/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.ide.projecttemplates.wizards.pages.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.fusesource.ide.foundation.core.util.Strings;
import org.fusesource.ide.projecttemplates.adopters.AbstractProjectTemplate;
import org.fusesource.ide.projecttemplates.internal.ProjectTemplatesActivator;
import org.fusesource.ide.projecttemplates.wizards.pages.model.CategoryItem;
import org.fusesource.ide.projecttemplates.wizards.pages.model.NameAndWeightComparator;
import org.fusesource.ide.projecttemplates.wizards.pages.model.TemplateItem;

public class TemplateModel {
    private static final String PROJECT_TEMPLATE_EXT_POINT_ID = "org.fusesource.ide.projecttemplates.templates";
    private static final String PROJECT_TEMPLATE_CATEGORY_ELEMENT = "projectTemplateCategory";
    private static final String PROJECT_TEMPLATE_CATEGORY_ATTR_ID = "id";
    private static final String PROJECT_TEMPLATE_CATEGORY_ATTR_NAME = "name";
    private static final String PROJECT_TEMPLATE_CATEGORY_ATTR_PARENT = "parent";
    private static final String PROJECT_TEMPLATE_CATEGORY_ATTR_WEIGHT = "weight";
    private static final String DEFAULT_CAT_ID = "fuse.projecttemplates.DEFAULT_CATEGORY";
    private static final String PROJECT_TEMPLATE_PROVIDER_ELEMENT = "projectTemplate";
    private static final String PROJECT_TEMPLATE_PROVIDER_ATTR_ID = "id";
    private static final String PROJECT_TEMPLATE_PROVIDER_ATTR_NAME = "name";
    private static final String PROJECT_TEMPLATE_PROVIDER_ATTR_KEYWORDS = "keywords";
    private static final String PROJECT_TEMPLATE_PROVIDER_ATTR_DESCRIPTION = "description";
    private static final String PROJECT_TEMPLATE_PROVIDER_ATTR_CATEGORY = "category";
    private static final String PROJECT_TEMPLATE_PROVIDER_ATTR_CONFIGURATOR = "class";
    private static final String PROJECT_TEMPLATE_PROVIDER_ATTR_WEIGHT = "weight";
    private List<CategoryItem> templateCategories = new ArrayList<CategoryItem>();
    private NameAndWeightComparator comparator = new NameAndWeightComparator();

    public TemplateModel() {
        this.initialize();
    }

    private void initialize() {
        IConfigurationElement e;
        IConfigurationElement[] extensions;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(PROJECT_TEMPLATE_EXT_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            e = iConfigurationElementArray[n2];
            if (e.getName().equals(PROJECT_TEMPLATE_CATEGORY_ELEMENT)) {
                this.determineCategoryExtension(e);
            }
            ++n2;
        }
        iConfigurationElementArray = extensions;
        n = extensions.length;
        n2 = 0;
        while (n2 < n) {
            e = iConfigurationElementArray[n2];
            if (e.getName().equals(PROJECT_TEMPLATE_PROVIDER_ELEMENT)) {
                this.determineProviderExtension(e);
            }
            ++n2;
        }
    }

    private void determineProviderExtension(IConfigurationElement e) {
        block5: {
            try {
                Object o = e.createExecutableExtension(PROJECT_TEMPLATE_PROVIDER_ATTR_CONFIGURATOR);
                if (!(o instanceof AbstractProjectTemplate)) break block5;
                AbstractProjectTemplate template = (AbstractProjectTemplate)o;
                String id = e.getAttribute("id");
                String name = e.getAttribute("name");
                String description = e.getAttribute(PROJECT_TEMPLATE_PROVIDER_ATTR_DESCRIPTION);
                String weight = e.getAttribute("weight");
                String keywords = e.getAttribute(PROJECT_TEMPLATE_PROVIDER_ATTR_KEYWORDS);
                int iWeight = 10;
                try {
                    iWeight = Integer.parseInt(weight);
                }
                catch (NumberFormatException ex) {
                    ProjectTemplatesActivator.pluginLog().logError("Error in Template Provider definition for ID: " + id, (Throwable)ex);
                }
                String catId = e.getAttribute(PROJECT_TEMPLATE_PROVIDER_ATTR_CATEGORY);
                CategoryItem category = this.getCategory(catId);
                if (category == null) {
                    category = this.getCategory(DEFAULT_CAT_ID);
                }
                TemplateItem item = new TemplateItem(id, name, description, iWeight, category, template, keywords);
                category.addTemplate(item);
            }
            catch (Exception ex) {
                ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
            }
        }
    }

    private void determineCategoryExtension(IConfigurationElement e) {
        try {
            String id = e.getAttribute("id");
            String name = e.getAttribute("name");
            String parent = e.getAttribute(PROJECT_TEMPLATE_CATEGORY_ATTR_PARENT);
            int iWeight = this.getWeight(e, id);
            CategoryItem item = new CategoryItem(id, name, iWeight, parent);
            this.templateCategories.add(item);
        }
        catch (Exception ex) {
            ProjectTemplatesActivator.pluginLog().logError((Throwable)ex);
        }
        Iterator<CategoryItem> catIt = this.templateCategories.iterator();
        while (catIt.hasNext()) {
            CategoryItem cat = catIt.next();
            String parentCategory = cat.getParent();
            if (Strings.isBlank((String)parentCategory)) continue;
            CategoryItem parentCat = this.getCategory(parentCategory);
            parentCat.addSubCategory(cat);
            catIt.remove();
        }
        Collections.sort(this.templateCategories, this.comparator);
    }

    private int getWeight(IConfigurationElement e, String id) {
        String weight = e.getAttribute("weight");
        int iWeight = 10;
        try {
            iWeight = Integer.parseInt(weight);
        }
        catch (NumberFormatException ex) {
            ProjectTemplatesActivator.pluginLog().logError("Error in Template Category definition for ID: " + id, (Throwable)ex);
        }
        return iWeight;
    }

    private CategoryItem getCategory(String id) {
        return this.findCategory(this.templateCategories, id);
    }

    private CategoryItem findCategory(List<CategoryItem> categories, String catId) {
        for (CategoryItem cat : categories) {
            CategoryItem catItemFoundInSubCategory;
            if (cat.getId().equals(catId)) {
                return cat;
            }
            if (cat.getSubCategories().isEmpty() || (catItemFoundInSubCategory = this.findCategory(cat.getSubCategories(), catId)) == null) continue;
            return catItemFoundInSubCategory;
        }
        return null;
    }

    public List<CategoryItem> getTemplateCategories() {
        return this.templateCategories;
    }
}

