/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.jmx.integration;

import java.io.IOException;
import java.net.NoRouteToHostException;
import java.util.HashMap;
import java.util.Properties;
import javax.management.MBeanServerConnection;
import javax.naming.InitialContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.jmx.integration.AbstractJBossJMXConnectionProvider;
import org.jboss.ide.eclipse.as.jmx.integration.Activator;
import org.jboss.ide.eclipse.as.jmx.integration.JBossJVMFacadeUtility;
import org.jboss.ide.eclipse.as.jmx.integration.JMXUtil;
import org.jboss.ide.eclipse.as.jmx.integration.jvmmonitor.JBossActiveJvm;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionProviderListener;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.IJMXRunnable;
import org.jboss.tools.jmx.core.JMXException;
import org.jboss.tools.jmx.core.tree.ErrorRoot;
import org.jboss.tools.jmx.core.tree.NodeUtils;
import org.jboss.tools.jmx.core.tree.Root;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.jvmmonitor.core.IJvmFacade;
import org.jboss.tools.jmx.jvmmonitor.core.JvmCoreException;

public class JBossServerConnection
implements IConnectionWrapper,
IServerListener,
IConnectionProviderListener,
IJvmFacade,
IAdaptable {
    private IServer server;
    private Root root;
    private boolean isConnected;
    private boolean isLoading;
    private MBeanServerConnection activeConnection;
    private JBossActiveJvm customJvm;

    public JBossServerConnection(IServer server) {
        this.server = server;
        this.isConnected = false;
        this.isLoading = false;
        this.connectViaJmxIfRequired(server);
        ((AbstractJBossJMXConnectionProvider)this.getProvider()).addListener(this);
        server.addServerListener((IServerListener)this);
    }

    public void connect() throws IOException {
        this.connectToStartedServer();
    }

    public void disconnect() throws IOException {
        if (this.activeConnection != null) {
            this.cleanupConnection(this.server, this.activeConnection);
        }
        if (this.customJvm != null) {
            this.customJvm.disconnect();
            this.customJvm = null;
        }
        this.activeConnection = null;
        this.root = null;
        this.isConnected = false;
        ((AbstractJBossJMXConnectionProvider)this.getProvider()).fireChanged(this);
    }

    public IConnectionProvider getProvider() {
        return ExtensionManager.getProvider((String)"org.jboss.ide.eclipse.as.core.extensions.jmx.JBossServerConnectionProvider");
    }

    protected AbstractJBossJMXConnectionProvider getProvider2() {
        return (AbstractJBossJMXConnectionProvider)this.getProvider();
    }

    public Root getRoot() {
        return this.root;
    }

    public void loadRoot(IProgressMonitor monitor) {
        if (this.isConnected() && !this.isLoading) {
            this.isLoading = true;
            this.getProvider2().getClassloaderRepository().addConcerned(this.server, this);
            try {
                try {
                    if (this.root == null) {
                        this.root = NodeUtils.createObjectNameTree((IConnectionWrapper)this, (IProgressMonitor)monitor);
                    }
                }
                catch (CoreException ce) {
                    Status status = new Status(4, "org.jboss.ide.eclipse.as.core", ce.getMessage(), (Throwable)ce);
                    JBossServerCorePlugin.getDefault().getLog().log((IStatus)status);
                    this.root = new ErrorRoot();
                    this.getProvider2().getClassloaderRepository().removeConcerned(this.server, this);
                    this.isLoading = false;
                }
            }
            finally {
                this.getProvider2().getClassloaderRepository().removeConcerned(this.server, this);
                this.isLoading = false;
            }
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void run(IJMXRunnable runnable) throws JMXException {
        this.run(runnable, new HashMap<String, String>());
    }

    public void run(IJMXRunnable runnable, HashMap<String, String> prefs) throws JMXException {
        this.run(runnable, prefs, false);
    }

    public void run(IJMXRunnable runnable, HashMap<String, String> prefs, boolean saveActiveConnection) throws JMXException {
        boolean force;
        boolean bl = force = prefs.get("force") == null ? false : Boolean.parseBoolean(prefs.get("force"));
        if (force || this.server.getServerState() == 2) {
            IJBossServer jbs = ServerConverter.getJBossServer((IServer)this.server);
            String storedOrDefaultUser = jbs.getUsername();
            String storedOrDefaultPass = jbs.getPassword();
            String rawStoredUser = ((JBossServer)jbs).getRawUsername();
            String rawStoredPassword = ((JBossServer)jbs).getRawPassword();
            String user = prefs.get("user");
            String pass = prefs.get("pass");
            if (user == null || pass == null) {
                user = rawStoredUser;
                pass = rawStoredPassword;
            }
            if (this.shouldUseDefaultCredentials() && (user == null || pass == null)) {
                user = user == null ? storedOrDefaultUser : user;
                pass = pass == null ? storedOrDefaultPass : pass;
            }
            this.run(this.server, runnable, user, pass, saveActiveConnection);
        }
    }

    protected boolean shouldUseDefaultCredentials() {
        return true;
    }

    protected void run(IServer s, IJMXRunnable r, String user, String pass) throws JMXException {
        this.run(s, r, user, pass, false);
    }

    protected void run(IServer s, IJMXRunnable r, String user, String pass, boolean saveActiveConnection) throws JMXException {
        this.getProvider2().getClassloaderRepository().addConcerned(s, r);
        ClassLoader currentLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader newLoader = this.getProvider2().getClassloaderRepository().getClassLoader(s);
        if (newLoader == null) {
            this.getProvider2().getClassloaderRepository().removeConcerned(s, r);
            throw new JMXException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "No JMX Client jars were found to communicate with server " + s.getName() + ". Assigning a local runtime to your server will allow client jars to be found."));
        }
        Thread.currentThread().setContextClassLoader(newLoader);
        MBeanServerConnection connection = null;
        try {
            try {
                if (this.activeConnection != null) {
                    connection = this.activeConnection;
                } else {
                    this.initializeEnvironment(s, user, pass);
                    connection = this.createConnection(s);
                }
                if (connection != null) {
                    r.run(connection);
                }
                if (saveActiveConnection && this.activeConnection == null && connection != null) {
                    this.activeConnection = connection;
                }
            }
            catch (JMXException jmxe) {
                throw jmxe;
            }
            catch (Exception e) {
                if (e.getCause() != null && e.getCause() instanceof NoRouteToHostException) {
                    throw new JMXException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Error connecting to remote JMX. Please ensure your server is properly configured for JMX access. A firewall may be blocking the request. You may wish to review your application server's security guide for information on ports used.", (Throwable)e));
                }
                throw new JMXException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.core", "Error connecting to remote JMX. Please ensure your server is properly configured for JMX access.", (Throwable)e));
            }
        }
        finally {
            if (connection != this.activeConnection) {
                this.cleanupConnection(s, connection);
            }
            this.getProvider2().getClassloaderRepository().removeConcerned(s, r);
            Thread.currentThread().setContextClassLoader(currentLoader);
        }
    }

    protected MBeanServerConnection createConnection(IServer s) throws Exception {
        Properties p = JMXUtil.getDefaultProperties(s);
        Object obj = null;
        try (InitialContext ic = new InitialContext(p);){
            obj = ic.lookup("jmx/invoker/RMIAdaptor");
        }
        if (obj != null && obj instanceof MBeanServerConnection) {
            ((MBeanServerConnection)obj).getDomains();
            return (MBeanServerConnection)obj;
        }
        return null;
    }

    protected void cleanupConnection(IServer server, MBeanServerConnection connection) {
    }

    protected void initializeEnvironment(IServer s, String user, String pass) throws JMXUtil.CredentialException {
        JMXUtil.setCredentials(s, user, pass);
    }

    public String getName() {
        return this.server.getName();
    }

    public void serverChanged(ServerEvent event) {
        int eventKind = event.getKind();
        if ((eventKind & 0x10) != 0 && (eventKind & 1) != 0) {
            this.connectViaJmxIfRequired(event.getServer());
        }
    }

    protected void connectViaJmxIfRequired(IServer server) {
        if (!this.shouldConnect(server)) {
            try {
                this.disconnect();
            }
            catch (IOException ioe) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.jmx.integration", "Unable to cleanly disconnect jmx connection", (Throwable)ioe));
            }
        }
    }

    protected boolean shouldConnect(IServer server) {
        boolean hasRuntime;
        IDeployableServer jbs = ServerConverter.getDeployableServer((IServerAttributes)server);
        boolean supportsJMX = jbs != null && jbs.hasJMXProvider();
        boolean started = server.getServerState() == 2;
        boolean bl = hasRuntime = server.getRuntime() != null;
        return started && supportsJMX && hasRuntime;
    }

    protected void launchConnectionJob(final IServer server) {
        new Job("Connecting to " + server.getName() + " via JMX"){

            protected IStatus run(IProgressMonitor monitor) {
                if (server.getServerState() == 2) {
                    JBossServerConnection.this.connectToStartedServer();
                }
                return Status.OK_STATUS;
            }
        }.schedule(5000L);
    }

    protected void connectToStartedServer() {
        block3: {
            try {
                IJMXRunnable run = new IJMXRunnable(){

                    public void run(MBeanServerConnection connection) throws Exception {
                    }
                };
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("force", new Boolean(true).toString());
                this.run(run, map, true);
                if (!this.isConnected) {
                    this.isConnected = true;
                    ((AbstractJBossJMXConnectionProvider)this.getProvider()).fireChanged(this);
                }
            }
            catch (Exception jmxe) {
                Status status = new Status(4, "org.jboss.ide.eclipse.as.jmx.integration", "Error connecting to jmx for server " + this.server.getName(), (Throwable)jmxe);
                JBossServerCorePlugin.log((IStatus)status);
                if (!this.isConnected) break block3;
                this.isConnected = false;
                ((AbstractJBossJMXConnectionProvider)this.getProvider()).fireChanged(this);
            }
        }
    }

    public void connectionAdded(IConnectionWrapper connection) {
    }

    public void connectionChanged(IConnectionWrapper connection) {
    }

    public void connectionRemoved(IConnectionWrapper connection) {
        if (connection == this) {
            this.server.removeServerListener((IServerListener)this);
        }
    }

    public boolean canControl() {
        return this.server.getServerState() == 2 && this.server.getRuntime() != null;
    }

    public IActiveJvm getActiveJvm() {
        if (this.server.getServerState() == 2 && this.isConnected) {
            if (this.customJvm == null) {
                IActiveJvm active = JBossJVMFacadeUtility.findJvmForServer(this.server);
                try {
                    if (active == null) {
                        throw new JvmCoreException(4, "Cannot find matching local process for server " + this.server.getName(), null);
                    }
                    this.customJvm = new JBossActiveJvm(this, active);
                }
                catch (JvmCoreException jvmce) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.jmx.integration", jvmce.getMessage(), (Throwable)jvmce));
                }
            }
            return this.customJvm;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        ITabbedPropertySheetPageContributor contributor = new ITabbedPropertySheetPageContributor(){

            public String getContributorId() {
                return "org.jboss.tools.jmx.jvmmonitor.ui.JvmExplorer";
            }
        };
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage(contributor);
        }
        if (adapter == ITabbedPropertySheetPageContributor.class) {
            return contributor;
        }
        return null;
    }

    public MBeanServerConnection getActiveConnection() {
        return this.activeConnection;
    }
}

