/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.marker;

import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.cdi.core.CDIImages;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.IScopeDeclaration;
import org.jboss.tools.cdi.internal.core.refactoring.CDIMarkerResolutionUtils;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.common.refactoring.BaseMarkerResolution;

public class MakeBeanScopedDependentMarkerResolution
extends BaseMarkerResolution {
    private IBean bean;
    private IAnnotation annotation;

    public MakeBeanScopedDependentMarkerResolution(ICompilationUnit compilationUnit, IBean bean) {
        super(compilationUnit);
        this.label = MessageFormat.format(CDIUIMessages.MAKE_BEAN_SCOPED_DEPENDENT_MARKER_RESOLUTION_TITLE, bean.getElementName());
        this.bean = bean;
        this.annotation = this.getScopeAnnotation();
        this.init();
    }

    protected CompilationUnitChange getChange(ICompilationUnit compilationUnit) {
        CompilationUnitChange change = new CompilationUnitChange("", compilationUnit);
        if (this.annotation != null) {
            MultiTextEdit edit = new MultiTextEdit();
            change.setEdit((TextEdit)edit);
            try {
                CDIMarkerResolutionUtils.addImport((String)"javax.enterprise.context.Dependent", (ICompilationUnit)compilationUnit, (MultiTextEdit)edit);
                IAnnotation workingCopyAnnotation = this.getWorkingCopyAnnotation(this.annotation, compilationUnit);
                if (workingCopyAnnotation != null) {
                    String shortName = CDIMarkerResolutionUtils.getShortName((String)"javax.enterprise.context.Dependent");
                    ReplaceEdit re = new ReplaceEdit(workingCopyAnnotation.getSourceRange().getOffset(), workingCopyAnnotation.getSourceRange().getLength(), "@" + shortName);
                    edit.addChild((TextEdit)re);
                    IBuffer buffer = compilationUnit.getBuffer();
                    String qualifiedName = this.getFullyQualifiedName();
                    if (qualifiedName != null) {
                        CDIMarkerResolutionUtils.deleteImportForAnnotation((String)qualifiedName, (IAnnotation)workingCopyAnnotation, (ICompilationUnit)compilationUnit, (IBuffer)buffer, (MultiTextEdit)edit);
                    }
                }
            }
            catch (JavaModelException e) {
                CDIUIPlugin.getDefault().logError(e);
            }
        }
        return change;
    }

    private IAnnotation getWorkingCopyAnnotation(IAnnotation annotation, ICompilationUnit compilationUnit) {
        IType type = compilationUnit.getType(this.bean.getBeanClass().getElementName());
        if (type != null) {
            return type.getAnnotation(annotation.getElementName());
        }
        return null;
    }

    private IAnnotation getScopeAnnotation() {
        for (IScopeDeclaration declaration : this.bean.getScopeDeclarations()) {
            if (declaration.getJavaAnnotation() == null) continue;
            return declaration.getJavaAnnotation();
        }
        return null;
    }

    private String getFullyQualifiedName() {
        Iterator iterator = this.bean.getScopeDeclarations().iterator();
        if (iterator.hasNext()) {
            IScopeDeclaration declaration = (IScopeDeclaration)iterator.next();
            return declaration.getScope().getSourceType().getFullyQualifiedName();
        }
        return null;
    }

    public Image getImage() {
        return CDIImages.getImage((ImageDescriptor)CDIImages.QUICKFIX_EDIT);
    }
}

