/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cdi.ui.refactoring;

import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.internal.services.IWorkbenchLocationService;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.services.IServiceLocator;
import org.jboss.tools.cdi.core.CDICoreNature;
import org.jboss.tools.cdi.core.CDICorePlugin;
import org.jboss.tools.cdi.core.IBean;
import org.jboss.tools.cdi.core.ICDIProject;
import org.jboss.tools.cdi.internal.core.refactoring.RenameNamedBeanProcessor;
import org.jboss.tools.cdi.ui.CDIUIMessages;
import org.jboss.tools.cdi.ui.CDIUIPlugin;
import org.jboss.tools.cdi.ui.refactoring.RenameNamedBeanWizard;
import org.jboss.tools.common.text.ITextSourceReference;

public class CDIRefactorContributionFactory
extends AbstractContributionFactory {
    private static final String JAVA_EXT = "java";
    private Shell shell;

    public CDIRefactorContributionFactory() {
        super("", "");
    }

    public CDIRefactorContributionFactory(String location, String namespace) {
        super(location, namespace);
    }

    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        if (serviceLocator.hasService(IWorkbenchLocationService.class)) {
            TextSelection selection;
            IBean bean;
            IWorkbenchLocationService service = (IWorkbenchLocationService)serviceLocator.getService(IWorkbenchLocationService.class);
            IEditorPart editor = service.getWorkbenchWindow().getActivePage().getActiveEditor();
            this.shell = service.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (!(editor.getEditorInput() instanceof FileEditorInput)) {
                return;
            }
            FileEditorInput input = (FileEditorInput)editor.getEditorInput();
            IFile editorFile = input.getFile();
            String ext = editorFile.getFileExtension();
            if (!JAVA_EXT.equalsIgnoreCase(ext)) {
                return;
            }
            if (CDICorePlugin.getCDI((IProject)editorFile.getProject(), (boolean)true) == null) {
                return;
            }
            MenuManager mm = new MenuManager(CDIUIMessages.CDI_REFACTOR_CONTRIBUTOR_MENU_NAME);
            mm.setVisible(true);
            if (JAVA_EXT.equalsIgnoreCase(ext) && (bean = this.getBean(editorFile, selection = (TextSelection)editor.getEditorSite().getSelectionProvider().getSelection())) != null) {
                mm.add((IAction)new RenameNamedBeanAction(bean));
                additions.addContributionItem((IContributionItem)new Separator(), null);
                additions.addContributionItem((IContributionItem)mm, null);
            }
        }
    }

    private IBean getBean(IFile file, TextSelection selection) {
        CDICoreNature cdiNature = CDICorePlugin.getCDI((IProject)file.getProject(), (boolean)true);
        if (cdiNature == null) {
            return null;
        }
        ICDIProject cdiProject = cdiNature.getDelegate();
        if (cdiProject == null) {
            return null;
        }
        Collection beans = cdiProject.getBeans(file.getFullPath());
        for (IBean bean : beans) {
            ITextSourceReference location;
            if (bean.getName() == null || (location = bean.getNameLocation(true)) == null || selection.getOffset() < location.getStartPosition() || selection.getOffset() + selection.getLength() > location.getStartPosition() + location.getLength()) continue;
            return bean;
        }
        return null;
    }

    private static void saveAndBuild() {
        if (!CDIUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().saveAllEditors(true)) {
            return;
        }
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void invokeRenameNamedBeanWizard(IBean bean, Shell activeShell) {
        CDIRefactorContributionFactory.saveAndBuild();
        RenameNamedBeanProcessor processor = new RenameNamedBeanProcessor(bean);
        RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
        RenameNamedBeanWizard wizard = new RenameNamedBeanWizard((Refactoring)refactoring, bean);
        RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
        try {
            String titleForFailedChecks = CDIUIMessages.CDI_REFACTOR_CONTRIBUTOR_ERROR;
            op.run(activeShell, titleForFailedChecks);
        }
        catch (InterruptedException interruptedException) {}
    }

    class RenameNamedBeanAction
    extends Action {
        IBean bean;

        public RenameNamedBeanAction(IBean bean) {
            super(NLS.bind((String)CDIUIMessages.CDI_REFACTOR_CONTRIBUTOR_RENAME_NAMED_BEAN_ACTION_NAME, (Object)bean.getName()));
            this.bean = bean;
        }

        public void run() {
            CDIRefactorContributionFactory.saveAndBuild();
            CDIRefactorContributionFactory.invokeRenameNamedBeanWizard(this.bean, CDIRefactorContributionFactory.this.shell);
        }
    }
}

