/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.views.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionCategory;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionProviderListener;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.core.MBeanFeatureInfoWrapper;
import org.jboss.tools.jmx.core.tree.ErrorRoot;
import org.jboss.tools.jmx.core.tree.Node;
import org.jboss.tools.jmx.core.tree.ObjectNameNode;
import org.jboss.tools.jmx.core.tree.Root;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.internal.actions.RefreshActionState;
import org.jboss.tools.jmx.ui.internal.views.navigator.JMXNavigator;

public class MBeanExplorerContentProvider
implements IConnectionProviderListener,
IStructuredContentProvider,
ITreeContentProvider {
    private Viewer viewer;
    private HashMap<IConnectionWrapper, DelayProxy> loading;
    private HashMap<ObjectNameNode, DelayProxy> loadingObjectNameNode;
    private ProviderCategory[] categories;

    public MBeanExplorerContentProvider() {
        ExtensionManager.addConnectionProviderListener((IConnectionProviderListener)this);
        this.loading = new HashMap();
        this.loadingObjectNameNode = new HashMap();
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.viewer = v;
    }

    public void dispose() {
        ExtensionManager.removeConnectionProviderListener((IConnectionProviderListener)this);
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof Root) {
            return ((Root)child).getConnection();
        }
        if (child instanceof Node) {
            return ((Node)child).getParent();
        }
        if (child instanceof MBeanFeatureInfoWrapper) {
            return ((MBeanFeatureInfoWrapper)child).getMBeanInfoWrapper().getParent();
        }
        return null;
    }

    private synchronized Object[] getTopLevelElements() {
        if (this.categories != null) {
            return this.categories;
        }
        IConnectionProvider[] providers = ExtensionManager.getProviders();
        TreeSet<String> categoryIds = new TreeSet<String>();
        ArrayList<ProviderCategory> categories = new ArrayList<ProviderCategory>();
        ArrayList<IConnectionProvider> unaffiliated = new ArrayList<IConnectionProvider>();
        int i = 0;
        while (i < providers.length) {
            if (providers[i] instanceof IConnectionCategory) {
                String id = ((IConnectionCategory)providers[i]).getCategoryId();
                if (!categoryIds.contains(id)) {
                    categoryIds.add(id);
                    categories.add(new ProviderCategory(id));
                }
            } else {
                unaffiliated.add(providers[i]);
            }
            ++i;
        }
        ArrayList<ProviderCategory> toReturn = new ArrayList<ProviderCategory>();
        this.categories = categories.toArray(new ProviderCategory[categories.size()]);
        toReturn.addAll(categories);
        toReturn.addAll(unaffiliated);
        return toReturn.toArray(new Object[toReturn.size()]);
    }

    private IConnectionWrapper[] findAllConnectionsWithCategory(String id) {
        ArrayList<IConnectionWrapper> ret = new ArrayList<IConnectionWrapper>();
        IConnectionProvider[] providers = ExtensionManager.getProviders();
        int i = 0;
        while (i < providers.length) {
            String id2;
            if (providers[i] instanceof IConnectionCategory && id.equals(id2 = ((IConnectionCategory)providers[i]).getCategoryId())) {
                ret.addAll(Arrays.asList(providers[i].getConnections()));
            }
            ++i;
        }
        return ret.toArray(new IConnectionWrapper[ret.size()]);
    }

    public Object[] getChildren(Object parent) {
        if (parent == null) {
            return new Object[0];
        }
        if (parent instanceof IViewPart) {
            return this.getTopLevelElements();
        }
        if (parent instanceof ProviderCategory) {
            String id = ((ProviderCategory)parent).getId();
            return this.findAllConnectionsWithCategory(id);
        }
        if (parent instanceof IConnectionProvider) {
            return ((IConnectionProvider)parent).getConnections();
        }
        if (parent instanceof IConnectionWrapper && ((IConnectionWrapper)parent).isConnected()) {
            return this.loadAndGetRootChildren(parent);
        }
        if (parent instanceof ObjectNameNode) {
            ObjectNameNode node = (ObjectNameNode)parent;
            if (node.isLoaded()) {
                node.getMbeanInfoWrapper().getMBeanFeatureInfos();
            }
            return this.loadAndGetMbeanInfoWrapper(node);
        }
        if (parent instanceof ErrorRoot) {
            return new Object[0];
        }
        if (parent instanceof Node) {
            Node node = (Node)parent;
            return node.getChildren();
        }
        return new Object[0];
    }

    protected synchronized Object[] loadAndGetRootChildren(final Object parent) {
        final IConnectionWrapper w = (IConnectionWrapper)parent;
        if (w.getRoot() != null) {
            return this.getChildren(w.getRoot());
        }
        if (this.loading.containsKey(parent)) {
            return new Object[]{this.loading.get(parent)};
        }
        Job job = new Job(NLS.bind((String)Messages.LoadingJMXRoot, (Object)w.getProvider().getName(w))){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        w.loadRoot(monitor);
                    }
                    catch (CoreException ce) {
                        IStatus iStatus = ce.getStatus();
                        MBeanExplorerContentProvider.this.loading.remove(w);
                        return iStatus;
                    }
                }
                finally {
                    MBeanExplorerContentProvider.this.loading.remove(w);
                }
                MBeanExplorerContentProvider.this.asyncRefresh(w, parent);
                return Status.OK_STATUS;
            }
        };
        DelayProxy p = new DelayProxy(w);
        this.loading.put(w, p);
        job.schedule();
        return new Object[]{p};
    }

    private void asyncRefresh(final IConnectionWrapper w, final Object parent) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MBeanExplorerContentProvider.this.viewer instanceof StructuredViewer) {
                    ((StructuredViewer)MBeanExplorerContentProvider.this.viewer).refresh(parent);
                } else {
                    MBeanExplorerContentProvider.this.viewer.refresh();
                }
                TreePath[] treePaths = RefreshActionState.getDefault().getExpansion(w);
                ISelection sel = RefreshActionState.getDefault().getSelection(w);
                if (treePaths != null) {
                    ((TreeViewer)MBeanExplorerContentProvider.this.viewer).setExpandedTreePaths(treePaths);
                }
                if (sel != null) {
                    ((TreeViewer)MBeanExplorerContentProvider.this.viewer).setSelection(sel);
                }
            }
        });
    }

    protected synchronized Object[] loadAndGetMbeanInfoWrapper(final ObjectNameNode parent) {
        if (parent.isLoaded()) {
            return parent.getMbeanInfoWrapper().getMBeanFeatureInfos();
        }
        if (this.loadingObjectNameNode.containsKey(parent)) {
            return new Object[]{this.loadingObjectNameNode.get(parent)};
        }
        Job job = new Job(NLS.bind((String)Messages.LoadingJMXObjectName, (Object)parent.getObjectName().getCanonicalName())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    parent.getMbeanInfoWrapper(monitor);
                }
                finally {
                    MBeanExplorerContentProvider.this.loadingObjectNameNode.remove(parent);
                }
                MBeanExplorerContentProvider.this.asyncRefresh(parent.getRoot().getConnection(), parent);
                return Status.OK_STATUS;
            }
        };
        DelayProxy p = new DelayProxy(parent);
        this.loadingObjectNameNode.put(parent, p);
        job.schedule();
        return new Object[]{p};
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof ProviderCategory || parent instanceof IConnectionProvider) {
            return this.getChildren(parent).length > 0;
        }
        if (parent instanceof ObjectNameNode) {
            ObjectNameNode node = (ObjectNameNode)parent;
            if (node.isLoaded()) {
                return node.getMbeanInfoWrapper().getMBeanFeatureInfos().length > 0;
            }
            return true;
        }
        if (parent instanceof Node) {
            Node node = (Node)parent;
            return node.getChildren().length > 0;
        }
        if (parent instanceof MBeanFeatureInfoWrapper) {
            return false;
        }
        if (parent instanceof IConnectionWrapper) {
            return ((IConnectionWrapper)parent).isConnected();
        }
        return !(parent instanceof DelayProxy);
    }

    private synchronized ProviderCategory findCategory(String type) {
        if (this.categories != null) {
            int i = 0;
            while (i < this.categories.length) {
                if (this.categories[i].getId().equals(type)) {
                    return this.categories[i];
                }
                ++i;
            }
        }
        return null;
    }

    public void connectionAdded(IConnectionWrapper connection) {
        IConnectionProvider provider = connection.getProvider();
        if (provider instanceof IConnectionCategory) {
            String type = ((IConnectionCategory)provider).getCategoryId();
            ProviderCategory parent = this.findCategory(type);
            this.addConnection(connection, parent == null ? this.viewer.getInput() : parent);
        }
    }

    public void connectionChanged(IConnectionWrapper connection) {
        this.fireRefresh(connection, false);
    }

    public void connectionRemoved(IConnectionWrapper connection) {
        this.removeConnection(connection);
    }

    private void fireRefresh(final IConnectionWrapper connection, final boolean full) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MBeanExplorerContentProvider.this.viewer != null && !MBeanExplorerContentProvider.this.viewer.getControl().isDisposed()) {
                    if (full || !(MBeanExplorerContentProvider.this.viewer instanceof StructuredViewer)) {
                        MBeanExplorerContentProvider.this.viewer.refresh();
                    } else {
                        ((StructuredViewer)MBeanExplorerContentProvider.this.viewer).refresh((Object)connection);
                    }
                }
            }
        });
    }

    private void addConnection(final IConnectionWrapper connection, final Object parent) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MBeanExplorerContentProvider.this.viewer != null && !MBeanExplorerContentProvider.this.viewer.getControl().isDisposed()) {
                    if (MBeanExplorerContentProvider.this.isJMXView()) {
                        if (parent instanceof ProviderCategory) {
                            ((TreeViewer)MBeanExplorerContentProvider.this.viewer).refresh(parent, true);
                        } else {
                            ((TreeViewer)MBeanExplorerContentProvider.this.viewer).add(parent, (Object)connection);
                        }
                    } else {
                        MBeanExplorerContentProvider.this.viewer.refresh();
                    }
                }
            }
        });
    }

    private boolean isJMXView() {
        JMXNavigator jmxn;
        CommonViewer navigatorViewer;
        IWorkbenchPart nav = MBeanExplorerContentProvider.findView("org.jboss.tools.jmx.ui.internal.views.navigator.MBeanExplorer");
        return nav instanceof JMXNavigator && this.viewer == (navigatorViewer = (jmxn = (JMXNavigator)nav).getCommonViewer()) && navigatorViewer != null;
    }

    private static final IWorkbenchPart findView(String viewId) {
        IWorkbenchPage page;
        IViewPart part = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            part = page.findView(viewId);
        }
        return part;
    }

    private void removeConnection(final IConnectionWrapper connection) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MBeanExplorerContentProvider.this.viewer != null && !MBeanExplorerContentProvider.this.viewer.getControl().isDisposed()) {
                    if (MBeanExplorerContentProvider.this.isJMXView()) {
                        ((TreeViewer)MBeanExplorerContentProvider.this.viewer).remove((Object)connection);
                    } else {
                        MBeanExplorerContentProvider.this.viewer.refresh();
                    }
                }
            }
        });
    }

    public static class DelayProxy {
        public Object wrapped;

        public DelayProxy(Object wrapped) {
            this.wrapped = wrapped;
        }
    }

    public static class ProviderCategory {
        private String id;

        public ProviderCategory(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

