/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.foundation.ui.xpl.taskwizard.IWizardHandle;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.jmx.core.ExtensionManager;
import org.jboss.tools.jmx.core.IConnectionProvider;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.ui.ConnectionWizardPage;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.UIExtensionManager;

public class JMXConnectionTypeFragment
extends WizardFragment {
    private TreeViewer viewer;
    private IWizardHandle handle;
    private Map<String, UIExtensionManager.ConnectionProviderUI> providerMap = UIExtensionManager.getConnectionUIElements();
    private Map<String, WizardFragment> childFragmentMap = new HashMap<String, WizardFragment>();
    private IConnectionProvider selected = null;

    public boolean hasComposite() {
        return true;
    }

    public Composite createComposite(Composite parent, IWizardHandle handle) {
        this.handle = handle;
        this.getPage().setTitle(Messages.NewConnectionWizard_CreateNewConnection);
        this.getPage().setDescription(Messages.NewConnectionWizard_CreateNewConnection);
        return this.createControl(parent);
    }

    public Composite createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(main);
        this.viewer.setContentProvider((IContentProvider)new FirstPageContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FirstPageLabelProvider());
        this.viewer.setInput((Object)this);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JMXConnectionTypeFragment.this.viewerSelectionChanged();
            }
        });
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                TreeItem item = JMXConnectionTypeFragment.this.viewer.getTree().getItems()[0];
                JMXConnectionTypeFragment.this.viewer.setSelection((ISelection)new StructuredSelection(item.getData()));
            }
        });
        return main;
    }

    protected void createChildFragments(List<WizardFragment> list) {
        if (this.selected != null) {
            WizardFragment all = this.childFragmentMap.get(this.selected.getId());
            list.addAll(Arrays.asList(all));
        }
    }

    private void viewerSelectionChanged() {
        String cpId;
        IConnectionProvider cp;
        IStructuredSelection ssel = (IStructuredSelection)this.viewer.getSelection();
        this.selected = cp = (IConnectionProvider)ssel.getFirstElement();
        if (this.selected != null && this.childFragmentMap.get(cpId = cp.getId()) == null) {
            UIExtensionManager.ConnectionProviderUI ui = this.providerMap.get(cpId);
            this.childFragmentMap.put(cpId, ui.createFragments());
        }
        this.handle.update();
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        WizardFragment typeRoot;
        ConnectionWizardPage wp;
        IConnectionWrapper wrap;
        if (this.selected != null && (wrap = (wp = (ConnectionWizardPage)(typeRoot = this.childFragmentMap.get(this.selected.getId()))).getConnection()) != null) {
            wrap.getProvider().addConnection(wrap);
        }
    }

    private class FirstPageContentProvider
    implements ITreeContentProvider {
        private FirstPageContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<IConnectionProvider> providers = new ArrayList<IConnectionProvider>();
            HashMap<String, UIExtensionManager.ConnectionProviderUI> map = UIExtensionManager.getConnectionUIElements();
            Set keys = map.keySet();
            for (String id : keys) {
                if (ExtensionManager.getProvider((String)id) == null || !ExtensionManager.getProvider((String)id).canCreate()) continue;
                providers.add(ExtensionManager.getProvider((String)id));
            }
            return providers.toArray(new IConnectionProvider[providers.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    private class FirstPageLabelProvider
    extends LabelProvider {
        private HashMap<String, Image> images = new HashMap();

        private FirstPageLabelProvider() {
        }

        public void dispose() {
            Iterator<Image> i = this.images.values().iterator();
            while (i.hasNext()) {
                i.next().dispose();
            }
            super.dispose();
        }

        public Image getImage(Object element) {
            UIExtensionManager.ConnectionProviderUI ui;
            if (element instanceof IConnectionProvider && (ui = UIExtensionManager.getConnectionProviderUI(((IConnectionProvider)element).getId())) != null) {
                String id = ui.getId();
                if (this.images.containsKey(id)) {
                    return this.images.get(id);
                }
                this.images.put(id, ui.getImageDescriptor().createImage());
                return this.images.get(id);
            }
            return null;
        }

        public String getText(Object element) {
            UIExtensionManager.ConnectionProviderUI ui;
            if (element instanceof IConnectionProvider && (ui = UIExtensionManager.getConnectionProviderUI(((IConnectionProvider)element).getId())) != null) {
                return ui.getName();
            }
            return element == null ? "" : element.toString();
        }
    }
}

