/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.lang.reflect.Field;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Messages;
import org.eclipse.swt.browser.PlatformUtil;
import org.eclipse.swt.browser.XULRunnerInitializer;

public class BrowserInitializer {
    private static final String PROPERTY_DEFAULTTYPE = "org.eclipse.swt.browser.DefaultType";
    private static final String SWT_GTK3 = "SWT_GTK3";
    static final String XULRUNNER_PATH = "org.eclipse.swt.browser.XULRunnerPath";
    public static final String LOAD_DEFAULT_ENGINE = "org.jboss.tools.vpe.engine.default";

    static {
        String defaultType;
        try {
            BrowserInitializer.createMozillaProfileDirIfNotExist();
        }
        catch (SecurityException e) {
            System.out.println(NLS.bind((String)Messages.XULRunnerInitializer_Cannot_check_mozilla_profile_availability, (Object)BrowserInitializer.getMozillaEclipseProfilePath()));
            e.printStackTrace();
        }
        if ("linux".equals(Platform.getOS()) && (defaultType = System.getProperty(PROPERTY_DEFAULTTYPE)) == null) {
            String mode;
            defaultType = BrowserInitializer.isGTK3() ? "webkit" : ("false".equals(mode = Platform.getPreferencesService().getString("org.jboss.tools.jst.web.ui", "Use visual editor for html5 editing", "true", null)) && XULRunnerInitializer.EMBEDDED_XULRUNNER_ENABLED ? "mozilla" : BrowserInitializer.getHTML5Browser());
            System.setProperty(PROPERTY_DEFAULTTYPE, defaultType);
        }
    }

    public static boolean isGTK3() {
        if ("gtk".equals(Platform.getWS())) {
            try {
                Class<?> clazz = Class.forName("org.eclipse.swt.internal.gtk.OS");
                Field field = clazz.getDeclaredField("GTK3");
                boolean gtk3 = field.getBoolean(field);
                return gtk3;
            }
            catch (ClassNotFoundException e) {
                return BrowserInitializer.isGTK3Env();
            }
            catch (NoSuchFieldException e) {
                return false;
            }
            catch (SecurityException e) {
                return BrowserInitializer.isGTK3Env();
            }
            catch (IllegalArgumentException e) {
                return BrowserInitializer.isGTK3Env();
            }
            catch (IllegalAccessException e) {
                return BrowserInitializer.isGTK3Env();
            }
        }
        return false;
    }

    private static boolean isGTK3Env() {
        String gtk3 = System.getProperty(SWT_GTK3);
        if (gtk3 == null) {
            gtk3 = System.getenv(SWT_GTK3);
        }
        return !"0".equals(gtk3);
    }

    private static String getHTML5Browser() {
        if (Boolean.valueOf(System.getProperty(LOAD_DEFAULT_ENGINE)).booleanValue()) {
            return "webkit";
        }
        return System.getProperty(XULRUNNER_PATH) != null ? "mozilla" : "webkit";
    }

    private static void createMozillaProfileDirIfNotExist() {
        File mozillaProfile;
        File userHome;
        String path = BrowserInitializer.getMozillaEclipseProfilePath();
        if (path != null && (userHome = new File(System.getProperty("user.home"))).exists() && !(mozillaProfile = new File(userHome, path)).exists()) {
            mozillaProfile.mkdir();
        }
    }

    private static String getMozillaEclipseProfilePath() {
        String path = null;
        if (PlatformUtil.isWindows()) {
            path = "AppData/Roaming/Mozilla/eclipse";
        } else if (PlatformUtil.isLinux()) {
            path = ".mozilla/eclipse";
        }
        return path;
    }
}

