
#include "centry.h"


u16 INLINE swpb(u16 val)
{
	union swapstruc
	{
		struct
		{
			u8 hi,lo;
		}	b;
		u16	val;
	}	v;
	u8 tmp;
	
	v.val = val;
	tmp=v.b.hi;
	v.b.hi=v.b.lo;
	v.b.lo=tmp;
	return v.val;
}

/*
	Meat of SRA
*/
u16 INLINE setst_sra_laec(s16 a,u16 c)
{
#ifdef GNU_X86_ASM
	register u16 ans asm ("ax")=a;
	register u8 cnt asm ("cl");
	
	cnt=c;
	status&=~ST_C;
	asm(
		"\t sarw %1,%0\n"
		"\t jnc 2f\n"
		"\t orb $0x10,status+1\n"
		"\t2:\n"
		: "=r" (ans)
		: "r" (cnt), "r" (ans)
		: "cc", "ax"
	);
	lastval=ans;
	lastcmp=0;
	
	return setst_lae(ans);

#else

	u16 mask= c ? (1 << (c-1)) : 0;
	
#if defined(FAST_X86_STATUS) || defined(GNU_X86_ASM)
	if (a & mask)
		status |= ST_C;
	else
		status &= ~ST_C;
#else
	st_c = (a & mask) != 0;
#endif
	
	a >>= c;

	lastval=a;
	lastcmp=0;
	
	return setst_lae(a);
#endif
}


/*
	Meat of SRL
*/
u16 INLINE setst_srl_laec(u16 a,u16 c)
{
#ifdef GNU_X86_ASM
	register u16 ans asm ("ax")=a;
	register u8 cnt asm ("cl");
	
	cnt=c;
	status&=~ST_C;
	asm(
		"\t shrw %1,%0\n"
		"\t jnc 2f\n"
		"\t orb $0x10,status+1\n"
		"\t2:\n"
		: "=r" (ans)
		: "r" (cnt), "r" (ans)
		: "cc", "ax"
	);
	lastval=ans;
	lastcmp=0;
	
	return setst_lae(ans);

#else

	u16 mask = c ? (1 << (c-1)) : 0;

#if defined(FAST_X86_STATUS) || defined(GNU_X86_ASM)
	if (a & mask)
		status |= ST_C;
	else
		status &= ~ST_C;
#else
	st_c = (a & mask) != 0;
#endif	
		
	a >>= c;

	lastval=a;
	lastcmp=0;
	
	return setst_lae(a);

#endif
}


/*
	Meat of SRC
*/
u16 INLINE setst_src_laec(u16 a,u16 c)
{
#ifdef GNU_X86_ASM
	register u16 ans asm ("ax")=a;
	register u8 cnt asm ("cl");
	
	cnt=c;
	status&=~ST_C;
	asm(
		"\t rorw %1,%0\n"
		"\t jnc 2f\n"
		"\t orb $0x10,status+1\n"
		"\t2:\n"
		: "=r" (ans)
		: "r" (cnt), "r" (ans)
		: "cc", "ax"
	);
	lastval=ans;
	lastcmp=0;
	
	return setst_lae(ans);
	
#else

	u16 mask = c ? (1 << (c-1)) : 0;

#if defined(FAST_X86_STATUS) || defined(GNU_X86_ASM)
	if (a & mask)
		status |= ST_C;
	else	
		status &= ~ST_C;
#else
	st_c = (a & mask) != 0;
#endif
		
	a = (a >> c) | (a << (16-c));

	lastval=a;
	lastcmp=0;
	
	return setst_lae(a);

#endif
}


/*
	Meat of SLA
*/
u16 INLINE setst_sla_laeco(u16 a,u16 c)
{
#ifdef GNU_X86_ASM
	register u16 ans asm ("ax")=a;
	register u8 cnt asm ("cl");
	
	cnt=c;
	status&=~(ST_C|ST_O);
	asm(
		"\t salw %1,%0\n"
		"\t pushf\n"
		"\t jno 1f\n"
		"\t orb $0x8,status+1\n"
		"\t1: popf\n"
		"\t jnc 2f\n"
		"\t orb $0x10,status+1\n"
		"\t2:\n"
		: "=r" (ans)
		: "r" (cnt), "r" (ans)
		: "cc", "ax"
	);
	lastval=ans;
	lastcmp=0;
	
	return setst_lae(ans);

#else

	u16 mask = 0x10000 >> c;
	u16 oa;

#if defined(FAST_X86_STATUS) || defined(GNU_X86_ASM)	
	if (a & mask)
		status |= ST_C;
	else
		status &= ~ST_C;
#else
	st_c = (a & mask) != 0;
#endif

	oa = a;
	a <<= c;

#if defined(FAST_X86_STATUS) || defined(GNU_X86_ASM)
	if ((oa ^ a) & 0x8000)
		status |= ST_O;
	else
		status &= ~ST_O;
#else
	st_o = ((oa ^ a) & 0x8000) != 0;
#endif
		
	lastval=a;
	lastcmp=0;
	
	return setst_lae(a);

#endif
}

#include "cexit.h"


