#include <stdio.h>
#include <unistd.h>
#include <limits.h>
#include <errno.h>
#include <fcntl.h>

#include "16bit.h"
#include "oss_error.h"
#include "clisrv.h"

#define MAXPIPE	_POSIX_PIPE_BUF

int
send_packet(int handle, void *packet, int size)
{
	int         ptr;

//  log("send_packet: [%d]  size=%d\n", handle, size);
	ptr = 0;
	while (ptr < size) {
		int         sent = 0;
		int         send =

			size - ptr < MAXPIPE / 2 ? size - ptr : MAXPIPE / 2;

		if (fcntl(handle, F_GETFL) == -1 && errno == EBADF) {
			error("pipe was closed");
			return 0;
		}
//      log("sending %d of %d bytes...\n", send, size);
		sent = write(handle, ((u8 *) packet + ptr), send);
		if (sent < send) {
			if (errno && errno != EINTR) {
				error("packet write (%d/%d bytes): %s",
					  ptr, size, strerror(errno));
				return 0;
			}
//          else
//              error("unexpected short write of %d / %d bytes [%s]\n",
//                   sent, send, strerror(errno));
		}
		if (sent > 0)
			ptr += sent;
	}
	return 1;
}

int
recv_packet(int handle, void *data, int size)
{
	int         ptr;

//  log("recv_packet: [%d]  size=%d\n", handle, size);
	ptr = 0;
	while (ptr < size) {
		int         red = 0;
		int         blk = size - ptr < MAXPIPE / 2 ? size - ptr : MAXPIPE / 2;

		if (fcntl(handle, F_GETFL) == -1 && errno == EBADF) {
			error("pipe was closed");
			return 0;
		}
//      log("awaiting %d of %d bytes...\n", blk, size);
		red = read(handle, ((u8 *) data + ptr), blk);
		if (red < blk) {
			if (errno && errno != EINTR) {
				error("packet read (%d/%d bytes): %s",
					  ptr, size, strerror(errno));
				return 0;
			}
//          else
//              error("unexpected short read of %d / %d bytes [%s]\n", 
//                  red, blk, strerror(errno));
		}
		if (red > 0)
			ptr += red;
	}
	return 1;
}
