
#ifndef __OSS_SERVER_H__
#define __OSS_SERVER_H__

#include "16bit.h"

#define DEVICE "/dev/dsp"

#define PACKET_MAXSIZE 16

enum	
{
	VP_VOICE0, VP_VOICE1, VP_VOICE2, VP_NOISE,
	VP_SPEECH,
	
	VP_SOUNDOFF = 0xfd,
	VP_SOUNDON = 0xfe,
	VP_QUIT = 0xff,
}	packet_type;

/*	for channel==VP_NOISE, hertz < 0 means white noise, else periodic */
typedef struct
{
	u8	channel;		/* VP_VOICE0 through VP_NOISE */
	u8	volume;			/* 0=quiet, 255=loudest */
	s16	hertz;			/* 0=off */
}	voicePacket;

typedef struct
{
	u8	channel;		/* VP_SPEECH... */
	u8	volume;			/* 0=off, 255=loudest */
	u16	hertz;			/* 0=off */
	u16	length;			/* length in u8 bytes */
	/* data follows */
}	dataPacket;


#endif