#include "clstandardheaders.h"
#include <ctype.h>
#include "OSLib.h"


char       *
strcatn(char *d, const char *s, long max)
{
	char       *p = d + strlen(d);

	while (*s && p - d + 1 < max)
		*p++ = *s++;
	*p = 0;
	return d;
}

char       *
strcpyn(char *d, const char *s, long len, long max)
{
	char       *p = d;

	while (len-- && *s && p - d + 1 < max)
		*p++ = *s++;
	*p = 0;
	return d;
}

const char *
stristr(const char *hay, const char *nee)
{
	while (*hay) {
		int         idx = 0;

		while (hay[idx] && nee[idx]
			   && toupper(hay[idx]) == toupper(nee[idx]))
			idx++;
		if (!nee[idx])
			return hay;
		hay++;
	}
	return NULL;
}
