#ifndef __CRU_H__
#define __CRU_H__

#include "v9t9_types.h"

#include "9901.h"

#include "centry.h"

void	cruwrite(u32 addr,u32 val,u32 num);

u32		cruread(u32 addr,u32 num);

typedef	u32	(crufunc)(u32 addr,u32 data,u32 num);

#define	CRU_READ 1
#define	CRU_WRITE 2

/*
	range is in BITS, not address units.  base - base+range*2
*/
int		cruadddevice(int rw, u32 base, u32 range, crufunc *func);
int		crudeldevice(int rw, u32 base, u32 range, crufunc *func);

void	cruinit(void);

#include "cexit.h"

#endif
