#ifndef __DEMO_H__
#define __DEMO_H__

#define DEMO_MAGIC_HEADER	"V910"

typedef enum
{
	demo_type_tick = 0,	/* wait for emulator tick */
	demo_type_video = 1,	/* video addresses and data */
	demo_type_sound = 2,	/* sound bytes */
	demo_type_speech = 3	/* speech commands */
}	demo_type;

typedef enum
{
	demo_speech_starting = 0,		/* new phrase */
	demo_speech_adding_byte = 1,	/* an LPC encoded byte (following) */
	demo_speech_terminating = 2,	/* terminating speech */
	demo_speech_stopping = 3,		/* finished */
	demo_speech_interrupt = 4		/* interrupt to perform work */
}	demo_speech_event;

/*
 *	The demo file format is very rudimentary.
 *
 *	Header:		'V910' bytes
 *
 *	Followed by a list of sections for various demo_types.
 *	Each section starts with one byte (demo_type) and is
 *	followed by nothing (for the timer) or by a buffer length
 *	(little-endian, 16 bits) which is passed to the event handler.
 *
 *	Video has 16-bit little-endian addresses followed (if the
 *	address does not have the 0x8000 bit set, which is a register
 *	write) by a 16-bit little-endian length and data bytes.
 *
 *	Sound has a series of data bytes.
 *
 *	Speech has a series of demo_speech_event bytes, and the
 *	demo_speech_adding_byte event is followed by that byte.
 */

void demo_init(void);
void demo_term(void);
int demo_start_record(OSSpec *spec);
void demo_pause_record(bool pausing);
void demo_stop_record(void);
int demo_record_event(demo_type type, ...);

#endif
