
#ifndef __MODULEDB_H__
#define __MODULEDB_H__

/*	Flags for standard module parts */
enum
{
	MOD_PART_GROM	= 1,	// GROM at >6000 of an indefinite size
	MOD_PART_ROM	= 2,	// ROM at >6000 of size >2000
	MOD_PART_BANKED	= 4,	// like ROM, but two banks switched through 
							// write to >6000 or >6002
	MOD_PART_MINIMEM= 8,	// Mini-Memory RAM at >7000 of size >1000

	MOD_PART_GRAMKRACKER = 16 // all segments are in GRAM KRACKER format
};


typedef struct ModuleEntry {
	char	*name;		/* screen name */
	char    *tag;		/* tag for quick loading */
	char	*commands;	/* commands to define memory */
	struct ModuleEntry *next;	/* next entry in database */
} ModuleEntry;

extern ModuleEntry *moddb, *loaded_module;

int		modules_init(void);
int		modules_init_db(char *dbfilename);
int 	module_load(ModuleEntry *ent);
int		module_load_by_name(const char *tag);

#endif
