
/*


*/

#include "centry.h"

int findbinary(char *path, char *syspath, char *filename, OSSpec *spec);
int loadbinary(char *path, char *syspath, char *filename, char *type,
			   u8 * loadat, int swap, int offset, int imagesize,
			   int maxsize);

/*
 *	Save data to an image found somewhere in 'path' or 'syspath'
 *	(if not existing, placed in first entry of 'path').
 *	Existing file is not overwritten.
 *
 *	path / syspath:	search paths
 *	type:			string emitted in error, i.e., "RAM image"
 *	filename:		name of image
 *	fileoffs:		offset into file to write
 *	saveat:			start of memory to write 
 *	swap:			if true, byteswap word data to TI format
 *	memsize:		size of memory to write
 */
int  
savebinary(char *path, char *syspath, char *type,
		   char *filename, int fileoffs,
		   u8 * saveat, int swap, int memsize);

int	loaddsr(char *path, char *syspath, char *filename, char *name, void *mem);
//int	loadspeech(char *path, char *syspath, char *filename, void *mem);
/*
int	loadconsolerom(char *path, char *filename);
int loadconsolegrom(char *path, char *filename);
int loadmodule(char *path, char *filename, int bank);
*/

/*	GRAM Kracker file segment types */
enum
{
	GK_TYPE_PROGRAM = 0x00,
	GK_TYPE_GROM_0	= 0x01,
	GK_TYPE_GROM_1	= 0x02,
	GK_TYPE_GROM_2	= 0x03,
	GK_TYPE_GROM_3	= 0x04,
	GK_TYPE_GROM_4	= 0x05,
	GK_TYPE_GROM_5	= 0x06,
	GK_TYPE_GROM_6	= 0x07,
	GK_TYPE_GROM_7	= 0x08,
	GK_TYPE_ROM_1	= 0x09,
	GK_TYPE_ROM_2	= 0x0A
};

typedef struct gram_kracker_header
{
	u8	more_to_load;				/* 0x00 means no */
	u8	gk_type;					/* GK_TYPE_xxx anove */
	u16	length;						/* translated to host-endian */
	u16	address;					/* translated to host-endian */
	int absolute_image_file_offset;	/* offset in containing host file */
}	gram_kracker_header;

/*
 *	Search paths for a file matching 'filename'.
 *	If found, and it is a valid GRAM-Kracker file,
 *	set 'spec' to point to it, and return its header info in 'header'.
 *
 *	Returns non-zero file size for success.
 *	
 */
int roms_find_gram_kracker(char *path, char *systempath, char *filename, 
						   OSSpec *spec, gram_kracker_header *header);

#include "cexit.h"



