#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/time.h>

#include "v9t9_common.h"
#include "system.h"
#include "timer.h"
#include "v9t9.h"

#include "command_rl.h"
#include "moduleconfig.h"
#include "v9t9_module.h"

#include "unixmain.h"

#define _L	 LOG_INTERNAL | LOG_INFO

#if defined(LINUX_SVGA_VIDEO) && defined(LINUX_SVGA_KEYBOARD)

extern	int	console_fd;

int
svga_system_init(void)
{
	return vga_init() == 0;
}

int
svga_system_loop(void)
{
	int ret;

	while (1) {
		while (TM_Ticked) {
			TM_TickHandler(0);
//			TM_Ticked--;
			TM_Ticked = 0;
		}
		ret = v9t9_execute();
		if (ret == em_TooFast)
			unix_system_pause();
		else if (ret == em_Quitting || ret == em_Dying)
			break;
	}
	return ret == em_Dying;
		
}

#endif // defined(LINUX_SVGA_VIDEO) && defined(LINUX_SVGA_KEYBOARD)
