#ifndef __MAIN_H__
#define __MAIN_H__

#include "log.h"

//	Intercept commands from user (Interactive=on)
void	system_getcommands(void);

//	Initialize timer to TM_HZ hertz
void	system_timer_init(void);
void	system_timer_install(void);
void	system_timer_uninstall(void);

//	emit text to log (do not add newline)
void	system_log(u32 srcflags, const char *text);

//	Emit a status item for UI.  
void	system_report_status(status_item item, va_list va);

//	signal to inform frontend that debugger is enabled/disabled
//	or paused/running.  Do not call debugger_enable or execution_pause
//	in here!
void	system_debugger_enabled(bool enabled);
void	system_execution_paused(bool paused);

#endif

