#include <stdarg.h>
#include "16bit.h"
#include "log.h"

//	Set when the timer ticks and we should call TM_TickHandler()
extern unsigned int TM_Ticked;

void
unix_system_pause(void);

void
unix_system_log(u32 srcflags, const char *text);

void
unix_system_getcommands(void);

void
unix_system_report_status(status_item item, va_list va);

void
unix_system_debugger_enabled(bool enabled);

void
unix_system_execution_paused(bool paused);

/*	handlers for GTK frontend */

int
GTK_system_init(void);

int
GTK_system_loop(void);

void
GTK_system_getcommands(void);

void
GTK_system_log(u32 srcflags, const char *text);

void
GTK_system_report_status(status_item item, va_list va);

void
GTK_system_debugger_enabled(bool enabled);

void
GTK_system_execution_paused(bool paused);

/*	handlers for xlib frontend */

int
xlib_system_init(void);

int
xlib_system_loop(void);

/*	handlers for svga frontend */

int
svga_system_init(void);

int
svga_system_loop(void);

