\	Registers

: R0 0 ;	: R1 1 ; 	: R2 2 ; 	: R3 3 ; 	
: R4 4 ;	: R5 5 ;	: R6 6 ;	: R7 7 ;
: R8 8 ;	: R9 9 ;	: R10 A ;	: R11 B ;
: R12 C ;	: R13 D ;	: R14 E ; 	: R15 F ;

\	Stack push/pop masks

: SR0 1 ;		: SR1 2 ;		: SR2 4 ;		: SR3 8 ;
: SR4 10 ;		: SR5 20 ;		: SR6 40 ;		: SR7 80 ;
: SR8 100 ;		: SR9 200 ;		: SR10 400 ;	: SR11 800 ;
: SR12 1000 ;	: SR13 2000 ;	: SR14 4000 ;	: SR15 8000 ;

;
;	Masks for stack push/pop
;

SR0	equ	1
SR1	equ	2
SR2	equ	4
SR3	equ	8
SR4	equ	16
SR5	equ	32
SR6	equ	64
SR7	equ	128
SR8	equ	256
SR9	equ	512
SR10	equ	1024
SR11	equ	2048
SR12	equ	4096
SR13	equ	8192
SR14	equ	16384
SR15	equ	32768

;	
;	Masks in status word.
;

ST_L	equ	1
ST_A	equ	2
ST_E	equ	4
ST_C	equ	8
ST_OV	equ	16
ST_OP	equ	32
ST_X	equ	64


;
;	FORTH GROM offsets
;

grom_kbdlist		equ	>0000
grom_fonts		equ	>0130


;
;	Low RAM setup.
;

@TIB	equ	>2000				; TIB  = >2000
@S0	equ	>2800				; stack= >2000 - >2800
@R0	equ	>2FF0				; rstak= >2800 - >2FF0

@First	equ	>2FF0				; 4 buffers (1k + 4 bytes)
@Limit	equ	>4000

