\ Compiler
\

\ \\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\

\	Words required by cross-compiler, not in standard.

\	noop lit :dodoes :docol :dovar :douser :docon ;s branch ?branch

[IFUNDEF] noop
: noop ;
[THEN]

[IFUNDEF] lit
error" need prim lit"
[THEN]

[IFUNDEF] :dodoes
error" need prim :dodoes"
[THEN]

[IFUNDEF] :docol
error" need prim :docol"
[THEN]

[IFUNDEF] :dovar
error" need prim :dovar"
[THEN]

[IFUNDEF] :douser
error" need prim :douser"
[THEN]

[IFUNDEF] :docon
error" need prim :docon"
[THEN]

[IFUNDEF] :dodefer
error" need prim :dodefer"
[THEN]

[IFUNDEF] ;s
error" need prim ;s"
[THEN]

[IFUNDEF] branch
error" need prim branch"
[THEN]

[IFUNDEF] ?branch
error" need prim ?branch"
[THEN]

[IFUNDEF] (.")
: (.")	( PFA: cstring -- )
\	Warning: this assumes that the IP is stored on the return stack,
\	due to this being a colon definition.
\
	r@ 
	dup c@ $80 >= if 
		dup @ $7fff and >r
		2+
	else
		dup c@ >r
		1+
	then
	r@ type r> r> + 1+ aligned >r
;
[THEN]

\ \\\\\\\\\\\\\\\\\\\

: lastxt
	latest lfa>nfa nfa>xt
;

1 include common.fs

has? standard-threading [if]

\	For a word pushing pfa
: does,	( code -- addr )
	,
;

\	For a code word
: code,	( -- )
	here ,
;

: docol!  ( cfa -- )
	['] :docol swap ! 
;

: xt!	( addr cfa -- )
	!
;

: docol,
	['] :docol ,
	0  ,		\ mysterious blank
;

[else]

: does!	( addr cfa -- )
	bl-dodoes over !
	cell+ !
;

\	For a word which pushes the PFA
: does,	( code -- )
	here does! 2 cells allot
;

\	For a code word
: code, ( addr -- )
	,
;

: docol!	( cfa -- )
	bl-docol swap !
	-2 dp +!			\ lose extra CFA word
;

: xt! ( addr cfa -- )
	cell+ !
;

: docol,	( addr -- )
	bl-docol ,
;

: dodefer!	( cfa -- )
	BL-@ swap !
	-2 dp +!
	['] :dodefer ,
;

[THEN]

[IFUNDEF] (compile)
\	compile the following word in the IP stream
\	(needed cross compiler)
: (compile)
	r> dup cell+ >r @ ,	
;
[THEN]


\ \\\\\\\\\\\\\\\\\\\\\\\\

: message		( flag # -- )
	dup -&13 = if ." undefined" else
\	dup 4 = if ." already defined" else
\	dup 9 = if ." interpreting mode only" else
	dup -&14 = if ." compilation mode only" else
	dup -&16 = if ." using a zero-length name" else
	dup -&22 = if ." control structures mismatched" else
	." ?" dup .
	then then then then \ then
	drop
	cr
;

: ?error
	swap if
		message quit
	else
		drop
	then
;

\ : ?exec
\ 	state @ -14 ?error
\ ;

: ?comp
	state @ 0= -&14 ?error
;

\	Differs from old version:
\	set $80 for visible definition.
\	Note: this affects xt>nfa, since it stops when
\	the LFA's length byte has $80.  
\	If we for some reason to "latest xt>nfa" while compiling
\	a word, it will fail...  ;)
: smudge
	latest lfa>nfa dict-name-smudge toggle
;

\	Given an address inside the current bank the desired
\	gap space, return 0 if there is enough room, else
\	return start address of new bank.

0 [if]

: (bank+)	  ( addr gap -- 0 | bank )
	>r
	dup (dp0  dp0) 1fff or  within if
		dp0) r@ -  >= if 
		   	(dp1
		else
			0
		then
	else
		drop 0
	then
	rdrop
;

\	Adjust DP to the next bank if necessary
: (bank?)
	.s
	here $180 (bank+) dup .s if					\ $80 word, $100 tib
		." Switching RAM banks to " dup u. cr
		dp ! .s
	else
		drop
	then
	\ here ." [" u. ." ]"
;

[then]

: CREATE
\	(bank?)

	align

[ has? profiling [if] ]
	\ Space for profiling 
	here  >r 0 ,
[ [then] ]

	\ Put LFA --> ptr to previous LFA
	here latest ,

	\ Get name
	bl parse 
	?dup 0= if
		-&16 message quit
	then

	(lookup)
	if
		id.
		space ." already defined" cr
	then 

	\ Get space for name
	here c@ width min
	1+ aligned allot			

[ has? profiling [if] ]
	\ Add profiling point
	r> ,
[ [then] ]

	\ current @ !		\ !!!
	>latest !
	smudge

	\ lay down CFA
	['] :dovar does,
;

\ \\\\\\\\\\\\\

8 constant per-line

: 2u.
	0 <# # # #> type
;

: 4u.
	0 <# # # # # #> type
;

: (dump) ( addr cnt xt -- )
	base @ >r hex cr
	>r					\ outer loop executes once with k==xt
	over + swap ?do
		i 4u. space [char] = emit space
		i' i per-line + min dup i ?do 
			i k execute 2u. space
		loop	
		i - 
		dup
			per-line swap - 0 ?do 3 spaces loop
		dup
			0 ?do j i + k execute dup $20 $7f within 0= 
				if drop [char] . then emit 
			loop
		cr
		(pause?) if drop unloop leave then
	+loop
	rdrop
	r> base !
;

: dump
	['] c@ (dump)
;

: vdump
	['] vc@ (dump)
;

\ \\\\\\\\\\\\\\\\\\\\\\

[IFUNDEF] STATE
User STATE
[THEN]

[IFUNDEF] [
: [
	0 state !
; immediate
[THEN]


[IFUNDEF] [COMPILE]
: [COMPILE]
	bl word find
	if
		postpone literal compile,
	else
		huh?
	then
; immediate
[THEN]

[IFUNDEF] POSTPONE
: POSTPONE
	bl word find
	if
		compile,
	else
		huh?
	then		
; immediate
[THEN]

[IFUNDEF] COMPILE,
: COMPILE,
	,
;
[THEN]



User csp

User leave-list		\ pointer to linked list of leaves, 
					\ @ branch pos of last leave

: !csp
	sp@ csp !
	0 leave-list !
;

: ?csp
	sp@ csp @ - -&22 ?error
;

: :
	\ ?exec 
	!csp
	create smudge ]
	lastxt docol!
;

: ;
	?csp
	[compile] ;s
	smudge postpone [
; immediate

\	change the cfa of the newly created word to
\	jump to the code inside the creating word after does>
: (does>)
	r> lastxt xt!		\ drops a level, so code following dodoes> 
						\ is not executed during create stage
;

: DOES>
	[compile] (does>)
	docol,
; immediate

: ?pairs	( i*x tag tag' -- )
	- -&22 ?error
;

\ is there an official name for this?
[IFUNDEF] BACK
: BACK 
	here - ,
;
[THEN]

[IFUNDEF] BEGIN
: BEGIN
	?comp here 1 
; immediate
[THEN]

[IFUNDEF] IF
: IF
	?comp
	[compile] ?branch
	here 0 ,
	2
; immediate
[THEN]

[IFUNDEF] ELSE
: ELSE
	?comp
	2 ?pairs
	[compile] branch
	here 0 ,
	swap 2
	postpone then 2
; immediate
[THEN]

[IFUNDEF] THEN
: THEN
	?comp 
	2 ?pairs
	here over - swap !
; immediate
[THEN]

[IFUNDEF] DO
: DO
	?comp
	[compile] (do)
	here 3
; immediate
[THEN]

[IFUNDEF] LOOP
: leave-resolve
\	handle LEAVE references 

	leave-list @
	begin		
	 	dup			\ ( pos pos )
	while
		dup @ swap			\ ( new-pos pos )
		here over - 	 	\ ( new-pos pos jmp )
		swap !
	repeat
	leave-list !
;

: loop-compile
\	normal loop part

	swap 3 ?pairs 
	compile,
	back
\	[compile] unloop

	leave-resolve
;

: LOOP
	?comp
	['] (loop) loop-compile
; immediate

: +LOOP
	?comp
	['] (+loop) loop-compile
; immediate
[THEN]

[IFUNDEF] UNLOOP
: UNLOOP
	r> rdrop rdrop >r
;
[THEN]
test" unloop 3 >r 2 1 do loop r> 3 ="


[IFUNDEF] LEAVE
: LEAVE
	?comp

	[compile] unloop
	[compile] branch

	here
	leave-list @ ,		\ store last fixup addr
	leave-list !		\ store new addr

; immediate
[THEN]

[IFUNDEF] BEGIN
: BEGIN
	?comp
	here 1
; immediate
[THEN]

[IFUNDEF] UNTIL
: UNTIL
	?comp
	1 ?pairs
	[compile] ?branch
	back
; immediate
[THEN]

[IFUNDEF] AGAIN
: AGAIN
	?comp
	1 ?pairs
	[compile] branch
	back
; immediate
[THEN]

[IFUNDEF] WHILE
: WHILE
	postpone if
	2+
; immediate
[THEN]

[IFUNDEF] REPEAT
: REPEAT
	?comp
	>r >r postpone again
	r> r> 2- 
	postpone then
; immediate
[THEN]

[IFUNDEF] CASE
: CASE
	?comp
	csp @ 		\ save old params
	!csp 
	4
; immediate
[THEN]

[IFUNDEF] OF
: OF
	?comp
	4 ?pairs
	[compile] (of)
	here 0 , 
	5
; immediate
[THEN]

[IFUNDEF] ENDOF
: ENDOF
	?comp
	5 ?pairs
	[compile] branch
	here 0 , 
	swap 2 postpone then
	4
; immediate
[THEN]

[IFUNDEF] ENDCASE
: ENDCASE
	?comp
	4 ?pairs
	[compile] drop
	begin
		sp@ csp @ = 0= 
	while
		2 postpone then
	repeat
	csp !
; immediate
[THEN]

[IFUNDEF] RECURSE
: RECURSE
	lastxt compile,
; immediate
[THEN]

[IFUNDEF] EXIT
: EXIT
	?comp
	[compile] ;s
; immediate
[THEN]

[IFUNDEF] DEFER
: DEFER
	create lastxt dodefer!
	['] noop ,
;
[THEN]

[IFUNDEF] IS
: isrom?
	dup $2000 <
	over $6000 >=
	over $8000 < and
	or
;
: (IS)
	cell+ 
	isrom? if @ then
	!
;
: IS
	' cell+ (IS)
;
[THEN]

[IFUNDEF] CONSTANT
: CONSTANT
	create ,
	['] :docon lastxt xt!
;
[THEN]

[IFUNDEF] VARIABLE
: VARIABLE
	create 0 ,
	['] :dovar lastxt xt!
;
[THEN]

[IFUNDEF] :NONAME
: :NONAME
	align

	\ LFA
	here latest ,

	\ NFA
	$0000 ,

	\ link
	>latest !

	]
   
	\ CFA
	here docol,

	!csp
;
[THEN]


