#include "lvgl/lvgl.h"

/*******************************************************************************
 * Size: 64 px
 * Bpp: 3
 * Opts: --font ../font/Morganite-Bold.ttf -r 0x20-0x7F --size 64 --format lvgl --bpp 3 --lv-include lvgl/lvgl.h -o morgnite_bold_64.c
 ******************************************************************************/

#ifndef MORGNITE_BOLD_64
#define MORGNITE_BOLD_64 1
#endif

#if MORGNITE_BOLD_64

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x5f, 0xea, 0x7, 0xff, 0xfc, 0xf, 0xfe, 0xa1,
    0x3, 0xcc, 0xf, 0xfe, 0x27, 0x3, 0xc4, 0xf,
    0xfe, 0x21, 0x3, 0xff, 0x8a, 0xc0, 0xff, 0xe0,
    0x90, 0x3f, 0x88, 0x1f, 0x30, 0x3b, 0x25, 0x0,
    0x76, 0xc0, 0x12, 0xc5, 0x5b, 0xb8, 0x1f, 0xfd,
    0x20,

    /* U+22 "\"" */
    0x1f, 0xf0, 0x3, 0xff, 0x1, 0xff, 0xfb, 0xb4,
    0x40, 0xc6, 0xd0, 0x2, 0x12, 0x10, 0xc0, 0x93,
    0x1, 0x40, 0x10, 0x14, 0xc, 0x80, 0x30, 0x8,
    0x12, 0x3, 0x60, 0xc0, 0x95, 0xe0, 0x74, 0xb0,
    0x0,

    /* U+23 "#" */
    0x3, 0xdf, 0xe8, 0x0, 0xff, 0x98, 0x1f, 0xfc,
    0xe, 0x7, 0xc4, 0xf, 0xfe, 0x1, 0x0, 0xc0,
    0xcc, 0xf, 0x88, 0x1f, 0x10, 0x3f, 0xf8, 0xc,
    0xc, 0xc0, 0xf8, 0x81, 0xf1, 0x3, 0x10, 0x1c,
    0xf, 0xfe, 0x41, 0x2, 0x20, 0x7e, 0xe0, 0x7c,
    0xc0, 0xff, 0xe0, 0x10, 0x22, 0x7, 0xcc, 0xf,
    0xfe, 0x3, 0x2, 0x20, 0x44, 0xf, 0xcc, 0xf,
    0xfe, 0x41, 0x2, 0x20, 0x7d, 0xc0, 0xff, 0xe0,
    0x70, 0x4, 0xc, 0x40, 0xcb, 0xf8, 0xd, 0x3f,
    0x60, 0x35, 0xfd, 0x1, 0x3, 0xff, 0x8d, 0xc7,
    0x3, 0xff, 0x8c, 0x41, 0x3, 0xff, 0x8c, 0xc5,
    0xfc, 0xc0, 0xdf, 0xc8, 0xd, 0xfc, 0x40, 0xff,
    0xe2, 0x10, 0x3f, 0xf8, 0x4, 0x9, 0x81, 0x30,
    0x3f, 0x10, 0x3e, 0x20, 0x7f, 0xf0, 0x18, 0x13,
    0x3, 0xe2, 0x7, 0xff, 0x44, 0x81, 0x10, 0x3e,
    0xe0, 0x7f, 0xf0, 0x38, 0x2, 0x6, 0x20, 0x7f,
    0xf0, 0xd8, 0x1f, 0xfc, 0x2, 0x6, 0x20, 0x7c,
    0xc0, 0xf9, 0x81, 0xf1, 0x3, 0xfa, 0xfe, 0xa0,
    0x6b, 0xfa, 0x1, 0xb7, 0xe2, 0x7, 0xff, 0x20,
    0x86, 0x7, 0xff, 0x20, 0x81, 0xff, 0xc8, 0xfe,
    0x60, 0x47, 0xf8, 0x81, 0x2f, 0xe0, 0x38, 0x81,
    0xf1, 0x3, 0xff, 0x80, 0xc0, 0x98, 0x1f, 0x10,
    0x3f, 0x10, 0x22, 0x7, 0xdc, 0xf, 0xfe, 0x7,
    0x0, 0x40, 0xc4, 0xf, 0xfe, 0x1b, 0x3, 0xff,
    0x80, 0x40, 0xc4, 0xf, 0x98, 0x1f, 0xfc, 0x6,
    0x0, 0x81, 0x88, 0x1f, 0x30, 0x3e, 0xe0, 0x7f,
    0xf0, 0x8, 0x18, 0x81, 0xff, 0xc3, 0xe0, 0x7c,
    0x40, 0x88, 0x1f, 0xfc, 0x46, 0x4, 0xc0, 0xfc,
    0x40, 0x88, 0x11, 0x3, 0xfc,

    /* U+24 "$" */
    0x3, 0xdf, 0xc4, 0xf, 0xfe, 0xd9, 0x80, 0x48,
    0xf, 0xd3, 0x30, 0x29, 0xd8, 0x1d, 0x58, 0x1f,
    0x46, 0x4, 0xd0, 0x1f, 0xd0, 0xa, 0x81, 0xcc,
    0x81, 0x98, 0x2, 0x6, 0xd3, 0x1, 0xb8, 0x1f,
    0x10, 0x3c, 0x40, 0xff, 0x10, 0x3f, 0xff, 0xe0,
    0x7f, 0xf7, 0x48, 0x1f, 0xc8, 0xc, 0x80, 0xfe,
    0xc0, 0x6a, 0x7, 0xf3, 0x3, 0x16, 0x12, 0xd8,
    0x9, 0x81, 0xa0, 0x96, 0xcc, 0xa, 0x10, 0x35,
    0x3, 0xfb, 0x81, 0x92, 0x1, 0xf8, 0xb0, 0x35,
    0x3, 0xfa, 0x10, 0x35, 0x3, 0xfb, 0x81, 0x92,
    0x1, 0xf8, 0xb0, 0x35, 0x3, 0xfa, 0x10, 0x34,
    0x2, 0xb7, 0x21, 0x0, 0xcc, 0x80, 0x4b, 0x60,
    0x88, 0x1a, 0x81, 0xfd, 0x40, 0xc8, 0xf, 0xe6,
    0x6, 0x20, 0x7f, 0xf4, 0x88, 0x1f, 0xc4, 0xf,
    0xff, 0xf8, 0x1f, 0xfc, 0x22, 0x6, 0x20, 0x72,
    0x0, 0x40, 0xf8, 0x81, 0x1d, 0x30, 0x18, 0x80,
    0xa0, 0x62, 0xc0, 0xe4, 0x1, 0xa0, 0x3f, 0x8c,
    0x2, 0xac, 0xf, 0x8e, 0x3, 0xa6, 0x60, 0x4a,
    0xe0, 0x3e, 0x30, 0xa, 0x20, 0x3f, 0xfa, 0xc0,

    /* U+25 "%" */
    0x0, 0xf7, 0xf4, 0x3, 0xfc, 0x64, 0x88, 0x1d,
    0x61, 0x2, 0x78, 0xf, 0xea, 0xdc, 0x40, 0xcd,
    0x1, 0xe3, 0x40, 0xfc, 0x80, 0x10, 0x3a, 0x81,
    0x4c, 0x4, 0x80, 0xf8, 0x90, 0xa, 0x7, 0x10,
    0x26, 0x50, 0x11, 0x3, 0xd4, 0x9, 0x81, 0xf8,
    0x80, 0x20, 0x7f, 0x98, 0x4, 0x7, 0xff, 0x28,
    0x81, 0x60, 0x3f, 0xf9, 0x54, 0x9, 0x81, 0xff,
    0xca, 0x60, 0x10, 0x1f, 0xfc, 0xa4, 0x5, 0xc0,
    0xff, 0xe5, 0x60, 0x24, 0x7, 0xff, 0x29, 0x80,
    0x40, 0x7f, 0xf2, 0x90, 0x17, 0x3, 0xff, 0x95,
    0x80, 0x90, 0x1f, 0xfc, 0xa6, 0x1, 0x1, 0xff,
    0xca, 0x40, 0x5c, 0xf, 0xfe, 0x57, 0x2, 0x40,
    0x7f, 0xf2, 0x90, 0x4, 0x7, 0xff, 0x29, 0x1,
    0x70, 0x3f, 0xf9, 0x5c, 0x9, 0x5, 0xbf, 0xa9,
    0x3, 0xf1, 0x3, 0x90, 0x6, 0x1d, 0x20, 0x4b,
    0x10, 0x40, 0x12, 0x8, 0x8, 0xa0, 0x2c, 0x60,
    0x1f, 0x70, 0x80, 0xb7, 0x2, 0x43, 0x81, 0x2a,
    0x4, 0xf1, 0x0, 0x4a, 0x10, 0x3e, 0x81, 0x0,
    0x60, 0x81, 0x43, 0x40, 0x90, 0xc8, 0xc, 0xb1,
    0x40, 0x58, 0xf, 0x88, 0x1e, 0xbf, 0x67, 0xa4,
    0x70, 0x24, 0x7, 0xff, 0x10, 0x90, 0x19, 0x0,
    0x60, 0x7f, 0xf2, 0x98, 0x15, 0x3, 0xff, 0x95,
    0x80, 0x88, 0x1f, 0xfc, 0xa4, 0x1, 0x81, 0xff,
    0xca, 0x60, 0x54, 0xf, 0xfe, 0x56, 0x0, 0x48,
    0xf, 0xfe, 0x52, 0x0, 0x80, 0xff, 0xe5, 0x30,
    0x2a, 0x7, 0xff, 0x2a, 0x80, 0x24, 0x7, 0xff,
    0x28, 0x80, 0xa0, 0x7f, 0xf2, 0x98, 0x12, 0x3,
    0xff, 0x95, 0x40, 0x12, 0x3, 0xff, 0x92, 0x48,
    0x5, 0x3, 0xff, 0x94, 0x80, 0x90, 0x1f, 0xfc,
    0xaa, 0x0, 0x90, 0x1f, 0xfc, 0x2, 0x7, 0xe2,
    0x40, 0x28, 0x1f, 0x60, 0x28, 0x68, 0x12, 0x3,
    0x20, 0x26, 0x7, 0xc8, 0x9, 0xe2, 0x0, 0x90,
    0x1a, 0x80, 0x20, 0x7e, 0x30, 0xf, 0xb8, 0x1c,
    0x9b, 0x40, 0x3f, 0x9d, 0x20, 0x4b, 0x10,

    /* U+26 "&" */
    0x3, 0x8f, 0xf1, 0x3, 0xff, 0xb6, 0x68, 0x15,
    0x20, 0x7d, 0x73, 0x2, 0x7a, 0x81, 0xd5, 0x1,
    0xf2, 0xc0, 0x4d, 0x1, 0xfc, 0x60, 0xa, 0x7,
    0x32, 0x6, 0x40, 0x8, 0x1b, 0x4c, 0x6, 0x20,
    0x7c, 0x40, 0xff, 0xe2, 0x90, 0x31, 0x3, 0xff,
    0xfe, 0x7, 0xff, 0xfc, 0x10, 0x3e, 0xad, 0xe2,
    0x28, 0x19, 0x80, 0x72, 0x60, 0xd, 0x1, 0x4d,
    0x50, 0x1f, 0x58, 0x40, 0x14, 0x40, 0xfc, 0x98,
    0x1f, 0xfc, 0x9, 0x90, 0x1f, 0xf2, 0x60, 0x4b,
    0xf3, 0x3, 0xd0, 0xd, 0x0, 0xfe, 0x20, 0x62,
    0x7, 0xff, 0x16, 0xed, 0x80, 0xff, 0x32, 0x78,
    0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0x88,
    0x18, 0x81, 0xe2, 0x7, 0xf1, 0x3, 0x77, 0x80,
    0xc4, 0x5, 0x3, 0x18, 0x40, 0xc8, 0x3, 0x20,
    0x7f, 0x18, 0x5, 0x90, 0x1f, 0x2c, 0x7, 0x5c,
    0xc0, 0x9e, 0xa0, 0x7c, 0x68, 0x15, 0x20, 0x7f,
    0xf5, 0x80,

    /* U+27 "'" */
    0x1f, 0xf0, 0x1f, 0xfd, 0x9b, 0x44, 0xc, 0x90,
    0x86, 0x4, 0x40, 0x50, 0x24, 0x9, 0x1, 0x2b,
    0xc0, 0x0,

    /* U+28 "(" */
    0x3, 0xe2, 0x70, 0x1d, 0x3f, 0x6d, 0x88, 0x16,
    0x60, 0x7f, 0x62, 0x7, 0xf2, 0x20, 0x7f, 0xb0,
    0x1c, 0xf7, 0xe2, 0x10, 0x19, 0x42, 0x6, 0x20,
    0x6e, 0x7, 0xfc, 0xc0, 0xff, 0x88, 0x1f, 0xff,
    0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff,
    0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0x90, 0x40,
    0xff, 0x90, 0x1e, 0x20, 0x6a, 0x7, 0x90, 0x18,
    0xe6, 0x88, 0xa, 0x7, 0x19, 0x71, 0x5, 0x81,
    0xff, 0x44, 0x7, 0xfd, 0x69, 0x1, 0xe0,

    /* U+29 ")" */
    0x4, 0xe0, 0x3c, 0xb6, 0xdf, 0x98, 0x1f, 0xe9,
    0x80, 0xff, 0x1a, 0x7, 0xf9, 0x15, 0xfb, 0x20,
    0x39, 0x1, 0x1a, 0x40, 0xd8, 0xe, 0xa0, 0x66,
    0x7, 0x10, 0x31, 0x3, 0x98, 0x1f, 0xe2, 0x7,
    0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0,
    0x3f, 0xff, 0xe0, 0x7f, 0xf7, 0x8, 0x1f, 0xe6,
    0x7, 0xfb, 0x1, 0x88, 0x1c, 0xc0, 0xcc, 0x14,
    0xf0, 0x1d, 0x96, 0xb0, 0x81, 0xcc, 0xf, 0xe8,
    0x7, 0xf3, 0x60, 0x3c, 0x55, 0x80, 0x0,

    /* U+2A "*" */
    0x3, 0x1f, 0xcc, 0xf, 0xc4, 0xf, 0xc5, 0x1,
    0xe2, 0x80, 0x5a, 0xcc, 0x6, 0xba, 0x80, 0x60,
    0xc0, 0x9, 0x0, 0x21, 0xe2, 0x3, 0x17, 0x90,
    0x7, 0x0, 0xca, 0x10, 0x37, 0x0, 0x83, 0x40,
    0x68, 0x45, 0xa0, 0x14, 0xd, 0x49, 0x21, 0x4,
    0x3, 0x1d, 0x80, 0x1f, 0x60, 0x0,

    /* U+2B "+" */
    0x3, 0xd3, 0xf9, 0x1, 0xff, 0xff, 0x3, 0xff,
    0xcd, 0xff, 0x98, 0x15, 0xff, 0xb0, 0x1f, 0xfd,
    0x69, 0x3c, 0x80, 0x9c, 0x9e, 0x6f, 0xc4, 0xb,
    0x37, 0xc8, 0xf, 0xff, 0xf8, 0x1f, 0xfd, 0x59,
    0xfc, 0x80, 0xf0,

    /* U+2C "," */
    0x29, 0x63, 0x2d, 0xc8, 0xf, 0xfe, 0x95, 0xf0,
    0x1, 0x1, 0x81, 0x40, 0x10, 0xa0, 0x8, 0x6,
    0x0,

    /* U+2D "-" */
    0x6f, 0xff, 0x82, 0xa4, 0xff, 0xe1, 0x1, 0xff,
    0xd0,

    /* U+2E "." */
    0x9, 0x62, 0xad, 0xdc, 0xf, 0xfe, 0x90,

    /* U+2F "/" */
    0x3, 0xfd, 0xfe, 0x20, 0x7f, 0x10, 0x31, 0x3,
    0xf9, 0x1, 0x10, 0x3f, 0xd8, 0x9, 0x1, 0xfe,
    0x40, 0x58, 0xf, 0xfe, 0x12, 0x3, 0xf9, 0x1,
    0xff, 0xc2, 0xc0, 0x48, 0xf, 0xf2, 0x2, 0xc0,
    0x7f, 0x88, 0x12, 0x3, 0xf8, 0x81, 0x88, 0x1f,
    0xc8, 0x8, 0x81, 0xfe, 0xc0, 0x48, 0xf, 0xf3,
    0x2, 0xc0, 0x7f, 0x88, 0x13, 0x3, 0xf9, 0x1,
    0x88, 0x1f, 0xd8, 0x9, 0x1, 0xfe, 0x40, 0x58,
    0xf, 0xf1, 0x2, 0x40, 0x7f, 0x10, 0x31, 0x3,
    0xf9, 0x1, 0x10, 0x3f, 0xd8, 0x9, 0x1, 0xfe,
    0x60, 0x58, 0xf, 0xf1, 0x2, 0x60, 0x7f, 0x20,
    0x31, 0x3, 0xfb, 0x1, 0x20, 0x3f, 0xc4, 0xb,
    0x1, 0xfe, 0x40, 0x48, 0xf, 0xe2, 0x6, 0x20,
    0x7f, 0x20, 0x22, 0x7, 0xfb, 0x81, 0x20, 0x3f,
    0xc8, 0xb, 0x1, 0xfe, 0x20, 0x4c, 0xf, 0xe4,
    0x6, 0x20, 0x7f, 0x60, 0x24, 0x7, 0xf8, 0x81,
    0x60, 0x3f, 0xc8, 0x9, 0x1, 0xfc, 0x40, 0xc4,
    0xf, 0xe4, 0x4, 0x40, 0xff, 0x70, 0x24, 0x7,
    0xf9, 0x1, 0x60, 0x3f, 0xc4, 0x9, 0x81, 0xfc,
    0x80, 0xc4, 0xf, 0xe2, 0x4, 0x80, 0xff, 0x60,
    0x2c, 0x7, 0xf8,

    /* U+30 "0" */
    0x3, 0x3d, 0xfd, 0xa0, 0x1e, 0x3e, 0x10, 0x22,
    0xf9, 0x3, 0x60, 0x3f, 0xb0, 0x14, 0x3, 0xfe,
    0x80, 0x10, 0x19, 0x54, 0x6, 0x60, 0x8, 0x1a,
    0x2a, 0x7, 0xff, 0x0, 0x81, 0xf1, 0x3, 0xf8,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f,
    0xff, 0xe0, 0x7f, 0xf0, 0x88, 0x1f, 0xf1, 0x3,
    0xe2, 0x8, 0x1a, 0x2a, 0x7, 0xc8, 0xc, 0xaa,
    0x3, 0x30, 0x10, 0xf, 0xfa, 0x1, 0x60, 0x3f,
    0xb0, 0x18, 0xf8, 0x40, 0x8b, 0xe4, 0x0,

    /* U+31 "1" */
    0x3, 0xa7, 0xf5, 0x3, 0x98, 0x1f, 0xa8, 0x1f,
    0x2c, 0x80, 0xe5, 0xe9, 0x3, 0xff, 0xa0, 0x52,
    0x1, 0xcb, 0xeb, 0xc0, 0xff, 0xff, 0x81, 0xff,
    0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xa8,

    /* U+32 "2" */
    0x3, 0x3d, 0xfd, 0x50, 0x1e, 0x3e, 0x10, 0x25,
    0x68, 0xe, 0xc0, 0x7e, 0x50, 0x9, 0x81, 0xfe,
    0x64, 0x5, 0x3, 0x4a, 0x7, 0x20, 0x4, 0x9,
    0x34, 0xc0, 0xd8, 0xf, 0x10, 0x18, 0xf, 0xff,
    0xf8, 0x1f, 0xfe, 0x2, 0x6, 0x20, 0x7f, 0x60,
    0x3f, 0xf8, 0x48, 0xd, 0x80, 0xfc, 0x80, 0xe4,
    0x2, 0xde, 0x1c, 0xc, 0x80, 0x92, 0xc4, 0x90,
    0x1b, 0x81, 0xfa, 0x81, 0x8a, 0x3, 0xe2, 0xc0,
    0xd0, 0xf, 0xd0, 0xc, 0x50, 0x1f, 0x14, 0x6,
    0x80, 0x7e, 0x80, 0x62, 0x80, 0xfc, 0x80, 0xd4,
    0xf, 0xcc, 0xe, 0x60, 0x7e, 0x80, 0x66, 0x7,
    0xe2, 0x7, 0x50, 0x3f, 0x50, 0x31, 0x20, 0x3f,
    0x20, 0x35, 0x3, 0xf8, 0x81, 0x90, 0x1f, 0x90,
    0x1c, 0x40, 0xfc, 0x40, 0xc8, 0xf, 0xec, 0x6,
    0xc0, 0x7f, 0x30, 0x31, 0x3, 0xff, 0x84, 0xc0,
    0xfe, 0x20, 0x62, 0x7, 0xff, 0x80, 0x9f, 0xc0,
    0x7d, 0xb7, 0xe2, 0x7, 0xff, 0x84,

    /* U+33 "3" */
    0x3, 0x3d, 0xfd, 0xa0, 0x1e, 0x3e, 0x10, 0x22,
    0xf9, 0x3, 0x60, 0x3f, 0xb0, 0x14, 0x3, 0xfe,
    0x80, 0x10, 0x19, 0x54, 0x6, 0x60, 0x8, 0x1a,
    0xaa, 0x7, 0xff, 0x20, 0x81, 0xfc, 0x40, 0xff,
    0xff, 0x81, 0xff, 0xf4, 0x20, 0x7f, 0x10, 0x3d,
    0xb7, 0x1, 0xf1, 0x0, 0x4f, 0x0, 0xa0, 0x68,
    0x7, 0x9f, 0xe4, 0x5, 0x50, 0x1f, 0xf3, 0xc8,
    0xf, 0xfe, 0x3, 0xa0, 0x7e, 0x4a, 0x2, 0x78,
    0xf, 0x8d, 0xa8, 0x4, 0x68, 0x1f, 0xcc, 0xc,
    0x80, 0x25, 0xc0, 0x7f, 0xad, 0xe0, 0x22, 0x6,
    0x20, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81, 0xfc,
    0x40, 0xff, 0x88, 0x1f, 0x10, 0x40, 0xd0, 0xc0,
    0x3e, 0x40, 0x65, 0x98, 0x19, 0x80, 0x80, 0x7f,
    0xd4, 0xb, 0x1, 0xfd, 0x48, 0x11, 0xec, 0x81,
    0x17, 0xd0, 0x0,

    /* U+34 "4" */
    0x3, 0xe5, 0xff, 0x50, 0x3f, 0xb0, 0x1f, 0xfc,
    0x34, 0x7, 0xff, 0xc, 0x81, 0xff, 0xc2, 0x20,
    0x7f, 0xf0, 0xd0, 0x1f, 0xfc, 0x3e, 0x7, 0xff,
    0xd, 0x1, 0xff, 0xc3, 0x20, 0x7f, 0xf0, 0x88,
    0x1f, 0xfc, 0x34, 0x7, 0xff, 0xf, 0x81, 0xff,
    0xc3, 0x40, 0x7f, 0xf0, 0xc8, 0x1f, 0xfc, 0x22,
    0x6, 0x20, 0x7f, 0x90, 0x19, 0x81, 0xfe, 0xe0,
    0x44, 0xf, 0xf9, 0x1, 0x30, 0x3f, 0xe2, 0x5,
    0x80, 0xff, 0x10, 0x31, 0x3, 0xfc, 0x80, 0xc8,
    0xf, 0xf6, 0x3, 0xff, 0x86, 0xc0, 0x90, 0x1f,
    0xf1, 0x2, 0x20, 0x7f, 0x90, 0x1b, 0x1, 0xfe,
    0x20, 0x66, 0x7, 0xfb, 0x1, 0x88, 0x1f, 0xe6,
    0x4, 0x40, 0xff, 0x88, 0x12, 0x3, 0xfc, 0x80,
    0xdc, 0xf, 0xf1, 0x3, 0x20, 0x3f, 0xd8, 0xc,
    0x40, 0xff, 0x20, 0x22, 0x7, 0xff, 0xd, 0x81,
    0xfe, 0x40, 0x62, 0x70, 0x1c, 0x48, 0xe, 0x7b,
    0x48, 0x9, 0x6c, 0x3, 0xff, 0xc8, 0xbf, 0xfc,
    0x80, 0x97, 0xe0, 0x3f, 0xff, 0xe0, 0x70,

    /* U+35 "5" */
    0x1f, 0xff, 0xf0, 0x40, 0xff, 0xe8, 0x90, 0x3f,
    0xf8, 0x4c, 0xf, 0xb6, 0xfa, 0x1, 0xf1, 0x3f,
    0x80, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3, 0xf9,
    0xc8, 0x20, 0x7f, 0x1f, 0x1b, 0x64, 0x7, 0xee,
    0x7, 0x52, 0x7, 0xc4, 0xf, 0x40, 0x3f, 0x20,
    0x39, 0x1, 0xf5, 0xac, 0x7, 0xff, 0x1, 0x2,
    0x7, 0xff, 0xc, 0x81, 0x88, 0xff, 0x80, 0xff,
    0xe6, 0xed, 0xc0, 0x7f, 0x89, 0xe0, 0x3f, 0xff,
    0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xe3, 0x10, 0x3f,
    0xe2, 0x7, 0xc4, 0x10, 0x34, 0x54, 0xf, 0xa8,
    0x19, 0x54, 0x6, 0x60, 0x18, 0x1f, 0xf4, 0x2,
    0xc0, 0x7f, 0x60, 0x31, 0xf0, 0x81, 0x17, 0xc8,
    0x0,

    /* U+36 "6" */
    0x3, 0x3d, 0xfd, 0x98, 0x1e, 0x3e, 0x10, 0x23,
    0x30, 0x1d, 0x80, 0xfc, 0x70, 0x14, 0x3, 0xfc,
    0x50, 0x4, 0x6, 0x55, 0x1, 0xb8, 0x2, 0x6,
    0x8a, 0x81, 0x98, 0x1f, 0x10, 0x3c, 0x40, 0xff,
    0x10, 0x3f, 0xff, 0xe0, 0x7f, 0xf4, 0x6b, 0x74,
    0x3, 0xfc, 0xe4, 0x98, 0x1f, 0xc5, 0x20, 0x1f,
    0xf5, 0xd6, 0xb1, 0x3, 0xf5, 0x40, 0x47, 0x1,
    0xf9, 0x1, 0xe8, 0x7, 0xe2, 0x7, 0x20, 0x3e,
    0x9a, 0x81, 0x88, 0x1f, 0x30, 0x80, 0xff, 0xe1,
    0x90, 0x31, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc,
    0xf, 0xff, 0xc9, 0x3, 0xfe, 0x20, 0x7c, 0x41,
    0x3, 0x45, 0x40, 0xf9, 0x1, 0x95, 0x40, 0x66,
    0x2, 0x1, 0xff, 0x40, 0x2c, 0x7, 0xf6, 0x3,
    0x1f, 0x8, 0x11, 0x7c, 0x80,

    /* U+37 "7" */
    0x7f, 0xff, 0xc0, 0x7f, 0xf4, 0x9, 0xf0, 0x1e,
    0x7b, 0x78, 0xf, 0xfe, 0x1, 0x3, 0x10, 0x3e,
    0x60, 0x66, 0x7, 0xd8, 0xc, 0x40, 0xf8, 0x81,
    0xb0, 0x1f, 0x30, 0x33, 0x3, 0xe2, 0x6, 0x20,
    0x78, 0x81, 0xff, 0xc0, 0x60, 0x62, 0x7, 0xc4,
    0xc, 0x80, 0xfb, 0x81, 0xb8, 0x1f, 0x20, 0x31,
    0x3, 0xe2, 0x6, 0x60, 0x7f, 0xf0, 0x8, 0x1e,
    0x20, 0x62, 0x7, 0xc8, 0xc, 0xc0, 0xfb, 0x81,
    0x88, 0x1f, 0x10, 0x36, 0x3, 0xe6, 0x6, 0x60,
    0x7c, 0x40, 0xc4, 0xf, 0x10, 0x3f, 0xf8, 0xc,
    0xc, 0x40, 0xf8, 0x81, 0x90, 0x1f, 0x70, 0x37,
    0x3, 0xe4, 0x6, 0x20, 0x7c, 0x40, 0xcc, 0xf,
    0xfe, 0x1, 0x3, 0xc4, 0xc, 0x40, 0xf9, 0x1,
    0x98, 0x1f, 0x70, 0x31, 0x3, 0xe2, 0x6, 0xe0,
    0x7c, 0xc0, 0xc8, 0xf, 0x88, 0x18, 0x81, 0xe2,
    0x7, 0xff, 0x1, 0x81, 0x88, 0x1f, 0x10, 0x32,
    0x3, 0xee, 0x6, 0xe0, 0x7c, 0x80, 0xc4, 0xf,
    0x88, 0x19, 0x81, 0xff, 0xc0, 0x20, 0x78, 0x81,
    0x88, 0x1f, 0x0,

    /* U+38 "8" */
    0x3, 0x3d, 0xfd, 0xa0, 0x1e, 0x3e, 0x10, 0x22,
    0xfa, 0x3, 0x60, 0x3f, 0xa9, 0x1, 0x0, 0xff,
    0xa8, 0x4, 0x6, 0x55, 0x1, 0x98, 0x2, 0x6,
    0x8a, 0x81, 0xff, 0xc0, 0x20, 0x7c, 0x40, 0xfe,
    0x20, 0x7f, 0xff, 0xc0, 0xff, 0xfa, 0x10, 0x3f,
    0xf8, 0x88, 0xf, 0x88, 0x11, 0x1, 0xc0, 0xd0,
    0x30, 0x34, 0x0, 0x98, 0x13, 0xf0, 0x9, 0xa0,
    0x28, 0xc0, 0xf9, 0x40, 0x32, 0x60, 0x7c, 0x98,
    0x11, 0xa0, 0x4b, 0x30, 0x28, 0x40, 0x50, 0x34,
    0x30, 0xd, 0x0, 0x20, 0x31, 0x3, 0xc8, 0x1,
    0x3, 0xe2, 0x7, 0xff, 0x1c, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xfe, 0x7, 0xf1, 0x3, 0xfe, 0x20,
    0x7c, 0x41, 0x3, 0x45, 0x40, 0xfa, 0x81, 0x95,
    0x40, 0x66, 0x1, 0x81, 0xff, 0x40, 0x2c, 0x40,
    0xfd, 0x80, 0xc7, 0x42, 0x4, 0x5f, 0x20, 0x0,

    /* U+39 "9" */
    0x3, 0x3d, 0xfd, 0xa0, 0x1e, 0x3e, 0x10, 0x22,
    0xf9, 0x3, 0x60, 0x3f, 0xb0, 0x14, 0x3, 0xfe,
    0x80, 0x10, 0x19, 0x54, 0x6, 0x60, 0x8, 0x1a,
    0x2a, 0x7, 0xff, 0x0, 0x81, 0xf1, 0x3, 0xf8,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0x8, 0x81, 0xff, 0x10, 0x40, 0xf8, 0x81, 0xb4,
    0xe0, 0x7c, 0x80, 0xe6, 0x40, 0xfa, 0x81, 0xff,
    0xc2, 0x34, 0xe, 0xa4, 0xf, 0x96, 0x6d, 0x3a,
    0x3, 0xf8, 0xc8, 0x60, 0x7f, 0x14, 0xa2, 0x7,
    0xfb, 0xdb, 0x60, 0x3f, 0xff, 0xe0, 0x7f, 0xff,
    0xc0, 0xff, 0xe3, 0x10, 0x3c, 0xc0, 0xff, 0xe0,
    0x10, 0x40, 0xd5, 0x50, 0x3e, 0xc0, 0x65, 0x50,
    0x19, 0x80, 0x48, 0x7, 0xfa, 0x1, 0x52, 0x7,
    0xec, 0x7, 0x6a, 0x80, 0x8b, 0xe4, 0x0,

    /* U+3A ":" */
    0x5f, 0xec, 0x7, 0xff, 0x49, 0x5b, 0xb8, 0x4b,
    0x10, 0x3f, 0xff, 0xa9, 0x62, 0xad, 0xdc, 0xf,
    0xfe, 0x90,

    /* U+3B ";" */
    0x1f, 0xf0, 0x1f, 0xfd, 0x9b, 0x78, 0x2, 0x5c,
    0x7, 0xff, 0xfc, 0xf, 0xf9, 0x2e, 0x1, 0x6f,
    0x1, 0xff, 0xd9, 0xfc, 0x40, 0xf1, 0xc, 0x8,
    0x80, 0x80, 0x48, 0x20, 0x0,

    /* U+3C "<" */
    0x3, 0xff, 0x82, 0x40, 0xff, 0xe0, 0x66, 0x7,
    0xfd, 0x48, 0x1f, 0xf4, 0x40, 0x7f, 0xd1, 0x81,
    0xff, 0x36, 0x3, 0xfe, 0x50, 0x9, 0x20, 0x1e,
    0x34, 0x8, 0xd0, 0x3c, 0x70, 0x11, 0xc0, 0x7d,
    0x80, 0xdc, 0xf, 0xb0, 0x1b, 0x10, 0x3d, 0x88,
    0x15, 0x20, 0x7a, 0x90, 0x28, 0x80, 0xf4, 0x40,
    0x4d, 0x80, 0xf3, 0x60, 0x25, 0x0, 0xfa, 0x1,
    0x2a, 0x7, 0xff, 0x0, 0x81, 0xfc, 0x40, 0x9b,
    0x1, 0xfb, 0x1, 0xa2, 0x3, 0xf6, 0x3, 0x52,
    0x7, 0xc7, 0x1, 0xb1, 0x3, 0xe3, 0x40, 0xd8,
    0xf, 0xca, 0x81, 0xb0, 0x1f, 0x94, 0x2, 0x34,
    0xf, 0xce, 0x1, 0x2a, 0x7, 0xe6, 0xc0, 0x4a,
    0x1, 0xfa, 0x20, 0x26, 0x80, 0xfd, 0x50, 0x1f,
    0xfc, 0x1a, 0x40, 0xff, 0xe0, 0xe2, 0x8, 0x1f,
    0xf6, 0x3, 0xff, 0x85, 0x88,

    /* U+3D "=" */
    0xff, 0xff, 0x8a, 0xc0, 0xff, 0xec, 0x49, 0xff,
    0xc5, 0x4d, 0xff, 0xf1, 0x48, 0x1f, 0xfd, 0x86,
    0xff, 0xf8, 0xa6, 0x4f, 0xfe, 0x2a, 0x3, 0xff,
    0xb0,

    /* U+3E ">" */
    0x20, 0x7f, 0xf0, 0x79, 0x3, 0xff, 0x80, 0x71,
    0x3, 0xff, 0x83, 0xc0, 0xff, 0xe0, 0x9c, 0x7,
    0xff, 0x4, 0xe0, 0x3f, 0xa8, 0x11, 0xa0, 0x7e,
    0x50, 0x9, 0x40, 0x3f, 0x36, 0x2, 0x6c, 0x7,
    0xe8, 0x80, 0xa3, 0x3, 0xf5, 0x20, 0x51, 0x1,
    0xfb, 0x10, 0x2a, 0x40, 0xfd, 0xc0, 0xd8, 0x81,
    0xf1, 0xc0, 0x6c, 0x7, 0xe3, 0x40, 0xd8, 0xf,
    0xca, 0x1, 0x16, 0x7, 0xe4, 0x7, 0xff, 0x0,
    0xe0, 0x31, 0x3, 0xee, 0x6, 0x88, 0xf, 0x62,
    0x4, 0xd8, 0xf, 0x52, 0x4, 0xe0, 0x1e, 0x88,
    0x9, 0x40, 0x3c, 0xd8, 0x9, 0x50, 0x3c, 0xe0,
    0x11, 0xa0, 0x79, 0x40, 0x23, 0x80, 0xf1, 0xa0,
    0x6e, 0x7, 0xdc, 0xd, 0x88, 0x1f, 0x10, 0x2c,
    0x40, 0xff, 0xa9, 0x3, 0xfe, 0x88, 0xf, 0xfa,
    0x30, 0x3f, 0xe8, 0xc0, 0xff, 0xe0, 0x0,

    /* U+3F "?" */
    0x3, 0x3d, 0xfd, 0x50, 0x1c, 0x7c, 0x20, 0x4a,
    0xd0, 0x1b, 0x1, 0xf9, 0x40, 0xc, 0xf, 0xf3,
    0x22, 0x81, 0xa5, 0x3, 0x90, 0x20, 0x49, 0xa6,
    0x6, 0xc0, 0x71, 0x1, 0x80, 0xff, 0xff, 0x81,
    0xff, 0xd8, 0x20, 0x7f, 0xf0, 0x78, 0x18, 0x81,
    0xf9, 0x1, 0xb0, 0x1f, 0x12, 0x3, 0x21, 0x6f,
    0xa, 0x6, 0x40, 0x12, 0xc4, 0x30, 0x37, 0x3,
    0xe6, 0x7, 0x20, 0x3e, 0x80, 0x66, 0x7, 0xcc,
    0xe, 0x80, 0x7d, 0x40, 0xcc, 0xf, 0x91, 0x3,
    0x50, 0x3e, 0xc0, 0x62, 0x40, 0x7c, 0xc0, 0xd4,
    0xf, 0x88, 0x1c, 0xc0, 0xf9, 0x81, 0x88, 0x1f,
    0x88, 0x19, 0x81, 0xfb, 0x81, 0xb0, 0x1f, 0xfc,
    0xf2, 0x7, 0xff, 0x3c, 0x81, 0xfb, 0x81, 0xb8,
    0x1f, 0x92, 0xee, 0x7, 0xe3, 0x6e, 0x60, 0x7f,
    0x25, 0x88, 0x1f, 0x95, 0xbb, 0x81, 0xff, 0xff,

    /* U+40 "@" */
    0x3, 0xf2, 0x96, 0xb6, 0xad, 0x44, 0x7, 0xff,
    0x6, 0x7a, 0xd2, 0x13, 0x24, 0x77, 0xc0, 0x3f,
    0x9f, 0x60, 0x7f, 0xf0, 0x5f, 0x40, 0x79, 0xc0,
    0x3f, 0xf8, 0xb5, 0x1, 0x94, 0x3, 0x19, 0xbf,
    0xed, 0x8, 0x1a, 0x90, 0x28, 0x6, 0x99, 0x90,
    0x38, 0xbd, 0x0, 0xd0, 0x2, 0x20, 0x4d, 0x80,
    0xff, 0x9b, 0x1, 0x22, 0x38, 0x1a, 0x0, 0x57,
    0xe6, 0xf, 0xf1, 0x80, 0x6a, 0x10, 0x12, 0x0,
    0xaa, 0x6, 0x68, 0x7, 0x10, 0x24, 0x7, 0x10,
    0x10, 0xe, 0x28, 0xe, 0x60, 0x7f, 0xf0, 0x8,
    0x1f, 0xfc, 0x42, 0x7, 0xc4, 0xc, 0xbb, 0x3,
    0xff, 0x8c, 0xc0, 0xdc, 0x40, 0x3f, 0xff, 0xe0,
    0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xf0, 0xc3, 0x3, 0xfe, 0x60, 0x6e,
    0x20, 0x1a, 0xe2, 0x7, 0xfc, 0x40, 0xcb, 0xb0,
    0x38, 0x81, 0xff, 0xc1, 0x20, 0x7f, 0xf1, 0x18,
    0x1c, 0x40, 0x50, 0x38, 0xf2, 0x7, 0xc6, 0x4,
    0x4, 0x80, 0x38, 0x40, 0x4c, 0x34, 0x40, 0x4a,
    0xe0, 0x18, 0xc, 0xc0, 0x3d, 0xf9, 0x81, 0x3b,
    0xfd, 0x50, 0x13, 0x3, 0x44, 0x7, 0xfc, 0xa8,
    0x1f, 0x40, 0x35, 0x84, 0xf, 0x8c, 0xab, 0x90,
    0x39, 0xa0, 0x33, 0xdf, 0x6e, 0xf9, 0x81, 0x64,
    0x7, 0x56, 0x7, 0x89, 0xe0, 0x3c, 0xd0, 0x1e,
    0x94, 0x81, 0xff, 0xc1, 0x3a, 0x1, 0xf9, 0x6c,
    0x64, 0x80, 0xf1, 0x77, 0x10, 0x30,

    /* U+41 "A" */
    0x3, 0x7f, 0xe8, 0x7, 0xff, 0x8, 0x81, 0xff,
    0xc2, 0x60, 0x7c, 0x40, 0xf1, 0x3, 0xff, 0x94,
    0xc0, 0xff, 0xe1, 0x10, 0x3e, 0x20, 0x7b, 0x81,
    0xf3, 0x3, 0xff, 0x92, 0x40, 0xf8, 0x81, 0xe6,
    0x7, 0xdc, 0xf, 0xfe, 0x11, 0x3, 0xc4, 0xf,
    0xfe, 0x53, 0x3, 0x88, 0x19, 0x1, 0x10, 0x3f,
    0xc4, 0xf, 0xe6, 0x6, 0xe0, 0x7f, 0x10, 0x22,
    0x7, 0x10, 0x3f, 0x32, 0x6, 0x60, 0x6e, 0x4,
    0x58, 0x18, 0x81, 0x88, 0x1f, 0xfc, 0x6e, 0x40,
    0xdc, 0xc, 0xc0, 0x88, 0x1c, 0x40, 0xc4, 0xe,
    0x20, 0x4c, 0xf, 0xcc, 0xf, 0xfe, 0x11, 0xc,
    0x8, 0x81, 0x10, 0x3c, 0x40, 0xf9, 0x81, 0xff,
    0x10, 0x3c, 0x40, 0x70, 0x3e, 0x20, 0x46, 0xd8,
    0xc, 0xc0, 0x70, 0x32, 0x42, 0x6, 0x20, 0x7f,
    0xf0, 0xb8, 0x2, 0x7, 0xff, 0x9, 0x81, 0x4f,
    0xe0, 0x31, 0x0, 0x40, 0x88, 0x1f, 0x30, 0x3c,
    0xc0, 0x88, 0x11, 0x3, 0xfc, 0xc0, 0xe2, 0x6,
    0x20, 0x7f, 0xf1, 0x88, 0x18, 0xb0, 0x3f, 0x70,
    0x33, 0x20, 0x44, 0xf, 0xf7, 0x3, 0xf1, 0x3,
    0x10, 0x33, 0x3, 0x30, 0x37, 0x20, 0x44, 0xf,
    0xe2, 0xc0, 0xfc, 0x40, 0xe0,

    /* U+42 "B" */
    0xff, 0xf6, 0x80, 0x7f, 0xf0, 0xb, 0xe8, 0xf,
    0xfe, 0xd, 0x20, 0x7f, 0xf0, 0x60, 0x1e, 0xd8,
    0xc0, 0xc8, 0xf, 0x12, 0x80, 0x71, 0x3, 0xf1,
    0x3, 0x30, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0,
    0xff, 0xe0, 0x10, 0x33, 0x3, 0xe4, 0x7, 0x10,
    0x3b, 0xf5, 0x3, 0x30, 0x3f, 0xf8, 0xe, 0x1,
    0xff, 0xc0, 0x64, 0xf, 0x24, 0x3, 0xb8, 0x1e,
    0xb5, 0x80, 0xc4, 0xf, 0xc4, 0x80, 0xc4, 0xf,
    0xfe, 0xb, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc,
    0xf, 0xfe, 0x71, 0x3, 0x30, 0x38, 0x94, 0x3,
    0x88, 0x1d, 0xb1, 0x81, 0x88, 0x1f, 0xfc, 0x1e,
    0x7, 0xff, 0x2, 0x10, 0x3f, 0x8b, 0xcc, 0x0,

    /* U+43 "C" */
    0x3, 0x3d, 0xfd, 0xa0, 0x1e, 0x3e, 0x10, 0x22,
    0xf9, 0x3, 0x60, 0x3f, 0xb0, 0x14, 0x3, 0xfe,
    0x80, 0x10, 0x19, 0x54, 0x6, 0x60, 0x8, 0x1a,
    0x2a, 0x7, 0xff, 0x0, 0x80, 0x20, 0x62, 0x7,
    0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xfc, 0xcf,
    0xb6, 0x20, 0x7f, 0x13, 0xc0, 0x7f, 0xff, 0xc0,
    0xff, 0xe6, 0xa5, 0xc0, 0x7f, 0xa5, 0xb8, 0x81,
    0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xf1, 0x3,
    0xfe, 0x20, 0x7c, 0x41, 0x3, 0x45, 0x40, 0xf9,
    0x1, 0x95, 0x40, 0x66, 0x2, 0x1, 0xff, 0x40,
    0x2c, 0x7, 0xf6, 0x3, 0x1f, 0x8, 0x11, 0x7c,
    0x80,

    /* U+44 "D" */
    0xff, 0xf6, 0x84, 0xf, 0xf8, 0xbc, 0x80, 0xff,
    0xe0, 0xd2, 0x7, 0xff, 0x6, 0x1, 0xed, 0x8c,
    0xc, 0x80, 0xf1, 0x28, 0x7, 0x10, 0x3f, 0x10,
    0x33, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf,
    0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0,
    0x7f, 0xff, 0xc0, 0xf1, 0x3, 0x30, 0x38, 0x94,
    0x3, 0x88, 0x1d, 0xb1, 0x81, 0x90, 0x1f, 0xfc,
    0x18, 0x7, 0xff, 0x2, 0x10, 0x3f, 0x8b, 0xcc,
    0x0,

    /* U+45 "E" */
    0xff, 0xfd, 0x0, 0xff, 0xed, 0x6d, 0xd4, 0xe,
    0x27, 0xc0, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xc8, 0xff, 0x30, 0x3f, 0xfa, 0x4, 0xf0,
    0x1e, 0xdb, 0x20, 0x3f, 0xff, 0xe0, 0x7f, 0xff,
    0xc0, 0xff, 0x13, 0xe0, 0x3b, 0x6f, 0x1, 0xff,
    0xd5,

    /* U+46 "F" */
    0xff, 0xfd, 0x0, 0xff, 0xed, 0x6d, 0xd4, 0xe,
    0x27, 0xc0, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xc8, 0xff, 0x30, 0x3f, 0xfa, 0x4, 0xf0,
    0x1e, 0xdb, 0x20, 0x3f, 0xff, 0xe0, 0x7f, 0xff,
    0xc0, 0xff, 0xf8, 0x0,

    /* U+47 "G" */
    0x3, 0x3d, 0xfd, 0xa0, 0x1e, 0x3e, 0x10, 0x22,
    0xf9, 0x3, 0x60, 0x3f, 0xb0, 0x14, 0x3, 0xfe,
    0x80, 0x10, 0x19, 0x54, 0x6, 0x60, 0x8, 0x1a,
    0x2a, 0x7, 0xff, 0x0, 0x81, 0xf1, 0x3, 0xf8,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0xb, 0xdb, 0x88, 0x1f, 0xc5, 0x2c, 0x7, 0xff,
    0xfc, 0xf, 0xfe, 0x59, 0x4b, 0xc0, 0x7e, 0xb7,
    0xe2, 0x7, 0xff, 0xa2, 0x72, 0x7, 0xff, 0xfc,
    0xf, 0xfe, 0x89, 0x3, 0xfe, 0x20, 0x7f, 0x10,
    0x34, 0x54, 0xf, 0x90, 0x19, 0x54, 0x7, 0xd0,
    0xf, 0xfe, 0x1e, 0x3, 0xe2, 0x40, 0x71, 0xf0,
    0x80, 0x33, 0x50, 0x20,

    /* U+48 "H" */
    0xff, 0x80, 0xbf, 0xe0, 0x3f, 0xff, 0xe0, 0x7f,
    0xff, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xf1, 0xfe,
    0x3, 0xff, 0xb6, 0x94, 0x7, 0xfd, 0x6c, 0x7,
    0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0,
    0x3f, 0xfc, 0x60,

    /* U+49 "I" */
    0xff, 0x80, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0x70,

    /* U+4A "J" */
    0x3, 0xfb, 0x7f, 0x88, 0x1f, 0xff, 0xf0, 0x3f,
    0xff, 0xe0, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xff, 0x9, 0x70, 0x1f, 0xeb, 0x78, 0xf,
    0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xf8, 0xc4,
    0xf, 0xf8, 0x81, 0xf1, 0x4, 0xd, 0x15, 0x3,
    0xea, 0x6, 0x55, 0x1, 0x98, 0x6, 0x40, 0xff,
    0x40, 0x2e, 0x40, 0xfd, 0x80, 0xc7, 0x42, 0x4,
    0x5f, 0x20, 0x0,

    /* U+4B "K" */
    0xff, 0x80, 0xdb, 0xfb, 0x1, 0xfc, 0x40, 0x90,
    0x1f, 0x90, 0x1b, 0x1, 0xfb, 0x1, 0x90, 0x1f,
    0x88, 0x11, 0x3, 0xf9, 0x1, 0x20, 0x3f, 0x10,
    0x36, 0x3, 0xf2, 0x3, 0x20, 0x3f, 0x60, 0x22,
    0x7, 0xf2, 0x2, 0x40, 0x7e, 0x20, 0x6c, 0x7,
    0xe4, 0x6, 0x40, 0x7e, 0xc0, 0x44, 0xf, 0xe4,
    0x4, 0x80, 0xfc, 0x80, 0xd8, 0xf, 0xd8, 0xc,
    0xc0, 0xfc, 0x80, 0xc4, 0xf, 0xc4, 0x9, 0x1,
    0xff, 0xc1, 0xc0, 0x7f, 0xf0, 0x50, 0x1f, 0xfc,
    0x12, 0x7, 0xff, 0x1, 0x1, 0xff, 0xc1, 0x60,
    0x7f, 0xf0, 0x48, 0x1f, 0xfc, 0x22, 0x7, 0xff,
    0x5, 0x1, 0xff, 0xc1, 0xc0, 0x7f, 0xf0, 0x50,
    0x1f, 0xfc, 0x22, 0x7, 0xe6, 0x6, 0x60, 0x7e,
    0xc0, 0x6c, 0x7, 0xe4, 0x6, 0x40, 0x7f, 0x10,
    0x22, 0x7, 0xf2, 0x3, 0x20, 0x3f, 0x60, 0x31,
    0x3, 0xf2, 0x3, 0x60, 0x3f, 0x88, 0x12, 0x3,
    0xf9, 0x1, 0x88, 0x1f, 0xb8, 0x19, 0x1, 0xf9,
    0x1, 0xb8, 0x1f, 0x88, 0x19, 0x1, 0xfc, 0x80,
    0x88, 0x1f, 0xd8, 0xc, 0x80, 0xfc, 0x80, 0xd8,
    0xf, 0xc4, 0xc, 0x40,

    /* U+4C "L" */
    0xff, 0x80, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8,
    0x1f, 0xff, 0xf1, 0xb7, 0x20, 0x38, 0x9e, 0x3,
    0xff, 0x96,

    /* U+4D "M" */
    0x1f, 0xf9, 0x81, 0xdf, 0xf9, 0x81, 0xf7, 0x3,
    0xff, 0x8e, 0x40, 0xc4, 0xf, 0xfe, 0x13, 0x3,
    0x30, 0x3f, 0xf8, 0x44, 0xc, 0x40, 0xff, 0xe3,
    0xf0, 0x3f, 0xf8, 0xe4, 0xf, 0xfe, 0x19, 0x2,
    0x60, 0x7f, 0xf0, 0xd8, 0x11, 0x3, 0xff, 0x86,
    0x40, 0xff, 0xe3, 0xf0, 0x3f, 0xf9, 0x44, 0xf,
    0xfe, 0x21, 0x0, 0xc0, 0xff, 0xe2, 0x30, 0x4,
    0xf, 0xfe, 0x21, 0x1, 0xc0, 0xff, 0xe3, 0x90,
    0x3f, 0xf8, 0x24, 0x8, 0x86, 0x4, 0x40, 0xfe,
    0x60, 0x4c, 0xe, 0x60, 0x7f, 0x10, 0x38, 0x81,
    0xff, 0xc1, 0xe0, 0x44, 0xc, 0x40, 0xff, 0x10,
    0x2e, 0x40, 0x98, 0x1f, 0xe6, 0x4, 0x58, 0x11,
    0x3, 0xff, 0x84, 0xc8, 0x17, 0x3, 0xff, 0x84,
    0x78, 0x11, 0x3, 0xfe, 0x20, 0x44, 0xf, 0xfe,
    0x1b, 0x2, 0x60, 0x4c, 0xf, 0xf8, 0x81, 0x10,
    0x22, 0x7, 0xfd, 0xc0, 0xff, 0xe3, 0x90, 0x3c,
    0x40, 0xff, 0xe3, 0xb0, 0x3f, 0xf8, 0xc, 0xf,
    0x10, 0x3f, 0xf8, 0x4, 0xf, 0xfe, 0x77, 0x3,
    0xff, 0x82, 0x40, 0xe2, 0x7, 0xff, 0x5, 0x81,
    0xcc, 0xf, 0xfe, 0x39, 0x3, 0xff, 0x82, 0x40,
    0xff, 0xe3, 0xf0, 0x31, 0x3, 0xff, 0x84, 0x40,
    0xcc, 0xf, 0xfe, 0x13, 0x3, 0xff, 0x8e, 0x40,
    0xc4, 0xf, 0xfe, 0x3f, 0x3, 0xff, 0x8e, 0x40,
    0xff, 0xe1, 0x90, 0x26, 0x7, 0xff, 0xd, 0x81,
    0x10, 0x3e,

    /* U+4E "N" */
    0x1f, 0xf5, 0x3, 0x3f, 0xf1, 0x3, 0xcc, 0xf,
    0xfe, 0x21, 0x3, 0xff, 0x8a, 0x40, 0xff, 0xe2,
    0x30, 0x3f, 0xf8, 0x98, 0xf, 0xfe, 0x21, 0x3,
    0xff, 0x88, 0x80, 0xff, 0xeb, 0x10, 0x3f, 0xf8,
    0x88, 0xf, 0xfe, 0x27, 0x3, 0xff, 0x88, 0x80,
    0xff, 0xe2, 0x10, 0x3f, 0xfa, 0xc8, 0xf, 0xfe,
    0x2, 0x2, 0x20, 0x7f, 0xf0, 0x8, 0x17, 0x3,
    0xff, 0x81, 0x80, 0x90, 0x1f, 0xfc, 0x6, 0x4,
    0x40, 0xff, 0xe0, 0x90, 0x22, 0x7, 0xff, 0x1,
    0x81, 0x30, 0x3f, 0xf8, 0x4, 0x8, 0x81, 0xff,
    0xc0, 0xc0, 0x58, 0xf, 0xfe, 0x3, 0x2, 0x60,
    0x7f, 0xf0, 0x8, 0x11, 0x3, 0xff, 0x82, 0x40,
    0xb8, 0x1f, 0xfc, 0x4, 0x4, 0x80, 0xff, 0xe0,
    0x70, 0x22, 0x7, 0xff, 0x1, 0x1, 0xff, 0xc4,
    0x20, 0x7f, 0xf5, 0x90, 0x1f, 0xfc, 0x42, 0x7,
    0xff, 0x13, 0x1, 0xff, 0xc4, 0x60, 0x7f, 0xf1,
    0x8, 0x1f, 0xfc, 0x52, 0x7, 0xff, 0x11, 0x1,
    0xff, 0xc4, 0xe0, 0x7f, 0xf1, 0x8, 0x1f, 0xfc,
    0x44, 0x7, 0xff, 0x59, 0x1, 0xff, 0xc4, 0x20,
    0x78,

    /* U+4F "O" */
    0x3, 0x3d, 0xfd, 0xa0, 0x1e, 0x3e, 0x10, 0x22,
    0xf9, 0x3, 0x60, 0x3f, 0xb0, 0x14, 0x3, 0xfe,
    0x80, 0x10, 0x19, 0x54, 0x6, 0x60, 0x8, 0x1a,
    0x2a, 0x7, 0xff, 0x0, 0x81, 0xf1, 0x3, 0xf8,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f,
    0xff, 0xe0, 0x7f, 0xf0, 0x88, 0x1f, 0xf1, 0x3,
    0xe2, 0x8, 0x1a, 0x2a, 0x7, 0xc8, 0xc, 0xaa,
    0x3, 0x30, 0x10, 0xf, 0xfa, 0x1, 0x60, 0x3f,
    0xb0, 0x18, 0xf8, 0x40, 0x8b, 0xe4, 0x0,

    /* U+50 "P" */
    0xff, 0xf6, 0x80, 0x7f, 0xf0, 0xb, 0xe8, 0xf,
    0xfe, 0xd, 0x20, 0x7f, 0xf0, 0x60, 0x1e, 0xd8,
    0xc0, 0xc8, 0xf, 0x12, 0x80, 0x71, 0x3, 0xf1,
    0x3, 0x30, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0,
    0xff, 0xf5, 0x10, 0x3f, 0xc4, 0x98, 0x1c, 0xc0,
    0xed, 0x90, 0xe, 0x20, 0x7f, 0xf0, 0x18, 0x1f,
    0xfc, 0x3, 0x0, 0xff, 0x2b, 0x80, 0xfb, 0xfd,
    0x50, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f,
    0xff, 0xc0, 0xff, 0xe2, 0x0,

    /* U+51 "Q" */
    0x3, 0x3d, 0xfd, 0xa0, 0x1e, 0x3e, 0x10, 0x22,
    0xf9, 0x3, 0x60, 0x3f, 0xb0, 0x14, 0x3, 0xfe,
    0x80, 0x10, 0x19, 0x54, 0x6, 0x60, 0x8, 0x1a,
    0x2a, 0x7, 0xff, 0x0, 0x81, 0xf1, 0x3, 0xf8,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f,
    0xff, 0xe0, 0x7f, 0xf0, 0x88, 0x1f, 0xf1, 0x3,
    0xe2, 0x8, 0x1a, 0x2a, 0x7, 0xc8, 0xc, 0xaa,
    0x3, 0x30, 0x10, 0xf, 0xfa, 0x1, 0x60, 0x3f,
    0xa0, 0x18, 0xf8, 0x40, 0xf4, 0x20, 0x73, 0xdf,
    0xc4, 0xb, 0x81, 0xfe, 0xc4, 0x7, 0x3, 0xfe,
    0xcb, 0x10,

    /* U+52 "R" */
    0xff, 0xf6, 0x80, 0x7f, 0xf0, 0x4b, 0xe8, 0xf,
    0xfe, 0x15, 0x20, 0x7f, 0xf0, 0xa0, 0x1f, 0x6c,
    0x60, 0x64, 0x7, 0xc4, 0xa0, 0x1c, 0x40, 0xfe,
    0x20, 0x66, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8,
    0x1f, 0xfd, 0xb2, 0x6, 0x60, 0x7e, 0x40, 0x71,
    0x3, 0xdf, 0xa8, 0x19, 0x81, 0xff, 0xc1, 0x70,
    0xf, 0xfe, 0xb, 0x20, 0x7c, 0x90, 0xe, 0xe0,
    0x7d, 0x6b, 0x1, 0x88, 0x1f, 0xc4, 0x80, 0xc4,
    0xf, 0xfe, 0x13, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0xfc, 0xf, 0xfe, 0xdb, 0x3, 0xff, 0x8e, 0x40,
    0xfe, 0x20, 0x6e, 0x7, 0xf7, 0x3, 0x10, 0x3f,
    0x90, 0x19, 0x80,

    /* U+53 "S" */
    0x3, 0x3d, 0xfd, 0x50, 0x1e, 0x3a, 0x10, 0x25,
    0x68, 0xe, 0xe4, 0xf, 0x94, 0x2, 0x64, 0xf,
    0xe6, 0x40, 0x50, 0x32, 0xa8, 0xc, 0x80, 0x10,
    0x34, 0x54, 0xd, 0x80, 0xf8, 0x80, 0x20, 0x7f,
    0xff, 0xc0, 0xff, 0xf3, 0x90, 0x32, 0x3, 0xf9,
    0x1, 0xb8, 0x1f, 0xd8, 0xc, 0x80, 0xfe, 0x44,
    0xd, 0x47, 0xda, 0xa0, 0x5c, 0xc, 0x90, 0x9c,
    0x6, 0x2c, 0xd, 0x40, 0xfe, 0x84, 0xd, 0x40,
    0xfe, 0xe0, 0x64, 0x80, 0x7e, 0x2c, 0xd, 0x40,
    0xfe, 0x84, 0xd, 0x0, 0xfe, 0xe0, 0x66, 0x80,
    0x92, 0xc4, 0x98, 0x1a, 0x1, 0x5b, 0xc2, 0x1,
    0x8a, 0x3, 0xf9, 0x81, 0xb8, 0x1f, 0xd4, 0xc,
    0x80, 0xfe, 0x20, 0x7f, 0xf4, 0x88, 0x18, 0x81,
    0xff, 0xff, 0x3, 0xf8, 0x81, 0xfe, 0x40, 0x7e,
    0x20, 0x81, 0x18, 0xa8, 0x1f, 0x50, 0x33, 0xa8,
    0xc, 0xc0, 0x32, 0x7, 0xfa, 0x1, 0x72, 0x7,
    0xea, 0x6, 0x3a, 0x10, 0x22, 0xfa, 0x0,

    /* U+54 "T" */
    0xdf, 0xff, 0xf0, 0x30, 0x1f, 0xfd, 0xef, 0xb4,
    0xc0, 0xcb, 0x6b, 0x93, 0xb8, 0x18, 0x9e, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8,
    0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff,
    0xc0, 0xff, 0xff, 0x81, 0xff, 0xc9,

    /* U+55 "U" */
    0xff, 0x80, 0xb7, 0xf9, 0x1, 0xff, 0xff, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8,
    0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xff,
    0xc0, 0xff, 0xe0, 0x10, 0x4, 0xc, 0xd0, 0x1b,
    0xa8, 0x7, 0x1c, 0x6, 0x35, 0x81, 0x90, 0x64,
    0xf, 0xf4, 0x1, 0x88, 0x1f, 0xa9, 0x2, 0xd0,
    0x81, 0x17, 0xd0, 0x0,

    /* U+56 "V" */
    0xdf, 0xe0, 0x3a, 0x7f, 0x56, 0x7, 0xf1, 0x3,
    0x10, 0x31, 0x3, 0x30, 0x23, 0xc0, 0xcc, 0xf,
    0xdc, 0xf, 0xf1, 0x3, 0x10, 0x31, 0x3, 0xf1,
    0x60, 0x6e, 0x7, 0xe6, 0x40, 0xfc, 0x40, 0xc4,
    0xe, 0x20, 0x4c, 0xf, 0xf3, 0x3, 0xfc, 0x40,
    0xf8, 0x81, 0x10, 0xc, 0x8, 0x81, 0x70, 0x26,
    0x7, 0xff, 0x14, 0x81, 0xf1, 0x2, 0x20, 0x38,
    0x18, 0x80, 0x60, 0x5c, 0xf, 0x98, 0x1f, 0xc4,
    0xf, 0x88, 0x11, 0x0, 0xc0, 0xc4, 0xf, 0x30,
    0x4, 0xd, 0xc0, 0xf1, 0x3, 0xe2, 0x8, 0x1f,
    0xfc, 0x26, 0x7, 0xe2, 0x4, 0xc1, 0x2, 0x20,
    0x66, 0x4, 0x40, 0xff, 0xe2, 0x70, 0x26, 0x6,
    0x20, 0x71, 0x2, 0x20, 0x6e, 0x6, 0x20, 0x6e,
    0x6, 0x20, 0x73, 0x3, 0xff, 0x82, 0xc8, 0x11,
    0x3, 0x30, 0x31, 0x3, 0x30, 0x31, 0x3, 0x70,
    0x3f, 0xf8, 0x44, 0xc, 0x40, 0xfe, 0x40, 0x7f,
    0x88, 0x1f, 0x10, 0x3c, 0xc0, 0xff, 0xe1, 0x10,
    0x3e, 0x60, 0x7f, 0xf0, 0x88, 0x1e, 0xe0, 0x7f,
    0xf0, 0x88, 0x1f, 0x70, 0x3c, 0xc0, 0xf8, 0x81,
    0xff, 0xc2, 0x60, 0x78, 0x81, 0xff, 0xca, 0x20,
    0x7f, 0xf2, 0x88, 0x1f, 0xfc, 0x26, 0x7, 0x10,
    0x30,

    /* U+57 "W" */
    0xdf, 0xe0, 0x34, 0xfe, 0x60, 0x6d, 0xfc, 0xd8,
    0xf, 0xc4, 0xb, 0x81, 0x88, 0x1f, 0xc4, 0x9,
    0x81, 0x10, 0x3f, 0x12, 0x3, 0xff, 0x80, 0xc0,
    0xfe, 0xe0, 0x66, 0x4, 0x40, 0x88, 0x11, 0x3,
    0x30, 0x3f, 0xf9, 0x44, 0x80, 0xc4, 0x1, 0x3,
    0xf3, 0x3, 0xff, 0x8e, 0x40, 0xfc, 0xc0, 0xdc,
    0x3, 0x3, 0x98, 0x2, 0x7, 0x10, 0x31, 0x0,
    0x40, 0xff, 0xe0, 0x10, 0x3f, 0xf8, 0x64, 0x7,
    0x3, 0xfc, 0xc0, 0x70, 0x3b, 0x80, 0x20, 0x4c,
    0xf, 0xe2, 0x7, 0x10, 0x3c, 0x40, 0x10, 0x22,
    0x1, 0x81, 0xcc, 0x3, 0x3, 0xcc, 0xf, 0xfe,
    0x3f, 0x3, 0xf8, 0x81, 0xc4, 0x1, 0x3, 0xc4,
    0xf, 0xfe, 0x39, 0x3, 0xe2, 0x40, 0x7c, 0x40,
    0xe6, 0x3, 0x81, 0xff, 0xc2, 0x20, 0x7c, 0x40,
    0xcd, 0x80, 0xf9, 0x81, 0xc4, 0xf, 0xc4, 0x8,
    0x81, 0x16, 0x7, 0xcc, 0xc, 0x40, 0xcc, 0xb,
    0x81, 0xff, 0xc1, 0xfc, 0x5, 0x80, 0x89, 0x1,
    0x10, 0x22, 0x7, 0x10, 0x24, 0x7, 0xff, 0x14,
    0xb0, 0x22, 0x4, 0xf8, 0x13, 0x3, 0xff, 0x84,
    0x40, 0x10, 0x3f, 0x88, 0x13, 0x20, 0x8, 0x1c,
    0x40, 0x88, 0x1f, 0x88, 0x13, 0xc, 0x9, 0x1,
    0x70, 0x33, 0x3, 0xf8, 0x81, 0xff, 0xc8, 0x23,
    0x81, 0xf1, 0x3, 0x10, 0x3e, 0xe0, 0x81, 0xff,
    0xc0, 0xe0, 0x7c, 0x43, 0x3, 0xe6, 0x7, 0xff,
    0x1, 0x82, 0x7, 0xff, 0x0, 0x81, 0xff, 0xc5,
    0x20, 0x7f, 0xf0, 0x8, 0x2, 0x7, 0xfc, 0xc0,
    0xff, 0x30, 0x3f, 0xe2, 0x7, 0x88, 0x11, 0x3,
    0x88, 0x1f, 0xfd, 0x76, 0x5, 0xc0, 0xe6, 0x7,
    0xff, 0x0, 0x81, 0x10, 0x38, 0x81, 0xe2, 0x7,
    0x70, 0x26, 0x7, 0xff, 0x1, 0x81, 0xc4, 0x8,
    0x81, 0xdc, 0xf, 0xfe, 0x89, 0x3, 0x98, 0x18,
    0x81, 0x88, 0x1f, 0xfc, 0x2, 0x6, 0x60, 0x66,
    0x4,

    /* U+58 "X" */
    0xbf, 0xe2, 0x4, 0xff, 0xd3, 0x1, 0x90, 0x16,
    0x3, 0x62, 0x6, 0xc0, 0x4c, 0xc, 0xd0, 0x19,
    0x1, 0x10, 0x31, 0x4, 0xc, 0x41, 0x3, 0x20,
    0x8, 0xc, 0xc2, 0x3, 0x10, 0x18, 0xd, 0x86,
    0x3, 0x60, 0xc, 0xc, 0x83, 0x3, 0x30, 0x4,
    0xc, 0x41, 0x3, 0x10, 0x24, 0x6, 0x60, 0x64,
    0x6, 0xc0, 0x68, 0x6, 0x20, 0x64, 0x7, 0xf6,
    0x3, 0x10, 0x3f, 0x98, 0x1c, 0x40, 0xfc, 0x40,
    0xe4, 0x7, 0xc8, 0xf, 0x60, 0x3e, 0x20, 0x79,
    0x81, 0xf6, 0x3, 0xc4, 0xf, 0x90, 0x1f, 0x20,
    0x3f, 0xf8, 0x58, 0xe, 0x40, 0x7e, 0x40, 0x71,
    0x3, 0xf3, 0x3, 0xb0, 0x1f, 0x88, 0x1c, 0xc0,
    0xfd, 0x80, 0xe6, 0x7, 0xe6, 0x7, 0x60, 0x3f,
    0x10, 0x38, 0x81, 0xf1, 0x3, 0xc8, 0xf, 0x90,
    0x1f, 0x10, 0x3d, 0xc0, 0xf9, 0x1, 0xe4, 0x7,
    0xdc, 0xf, 0x10, 0x3e, 0x40, 0x71, 0x3, 0xf1,
    0x3, 0x90, 0x1f, 0xc4, 0xd, 0xc0, 0xc8, 0xc,
    0x80, 0xc8, 0xd, 0x80, 0xd8, 0xc, 0x40, 0x92,
    0x1, 0x98, 0x11, 0x3, 0x12, 0x3, 0x10, 0x26,
    0x6, 0xc0, 0x81, 0x90, 0xc, 0x6, 0x61, 0x1,
    0x88, 0x2, 0x6, 0x23, 0x81, 0xb0, 0x4, 0x4,
    0x40, 0x20, 0x32, 0x4, 0xc, 0x80, 0x10, 0x3c,
    0xc0, 0xdc, 0x8, 0x81, 0x96, 0x3, 0x10, 0x24,
    0x6, 0xc4, 0xc, 0x80, 0xb0, 0x18, 0x80,

    /* U+59 "Y" */
    0xbf, 0xe4, 0x4, 0x7f, 0xd8, 0x81, 0x88, 0x13,
    0x3, 0x2e, 0x6, 0xe0, 0x44, 0xd, 0xd0, 0x18,
    0x81, 0x70, 0x31, 0x20, 0x33, 0x2, 0x20, 0x64,
    0x7, 0x10, 0x24, 0x7, 0x90, 0x1f, 0xf2, 0x0,
    0x40, 0xc4, 0x10, 0x31, 0x1, 0xc0, 0xcc, 0x30,
    0x37, 0x0, 0x80, 0xc4, 0x10, 0x32, 0x0, 0x40,
    0xdc, 0x70, 0x31, 0x2, 0x20, 0x44, 0x10, 0x3f,
    0x30, 0x26, 0x18, 0x12, 0x3, 0x10, 0x22, 0x8,
    0x11, 0x3, 0x60, 0x31, 0x3, 0x70, 0x33, 0x3,
    0x20, 0x32, 0x3, 0x10, 0x36, 0x3, 0x10, 0x38,
    0x81, 0x20, 0x3f, 0xcc, 0xf, 0x90, 0x1e, 0x20,
    0x7c, 0x40, 0xf6, 0x3, 0xee, 0x7, 0x98, 0x1f,
    0x20, 0x3c, 0x40, 0xf8, 0x81, 0xf1, 0x3, 0x88,
    0x1f, 0x98, 0x1c, 0xc0, 0xfc, 0x40, 0xe2, 0x7,
    0xec, 0x7, 0x60, 0x3f, 0x30, 0x39, 0x81, 0xf8,
    0x81, 0xc4, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0,
    0x3f, 0xff, 0xe0, 0x7f, 0xf1, 0xc0,

    /* U+5A "Z" */
    0xb, 0xff, 0xf9, 0x1, 0xff, 0xd1, 0x64, 0xf8,
    0xe, 0x60, 0xed, 0xe0, 0x38, 0x81, 0xff, 0xc0,
    0x20, 0x7e, 0x40, 0x66, 0x7, 0xec, 0x6, 0xc0,
    0x7e, 0x20, 0x64, 0x7, 0xe4, 0x6, 0x20, 0x7c,
    0x40, 0xc4, 0xf, 0xcc, 0xc, 0xc0, 0xfd, 0x80,
    0xd8, 0xf, 0xc8, 0xc, 0x80, 0xfc, 0x40, 0xc4,
    0xf, 0x88, 0x18, 0x81, 0xf9, 0x81, 0x90, 0x1f,
    0xb0, 0x1b, 0x81, 0xf9, 0x1, 0x90, 0x1f, 0x88,
    0x18, 0x81, 0xf1, 0x3, 0x10, 0x3f, 0x20, 0x32,
    0x3, 0xf7, 0x3, 0x60, 0x3f, 0x20, 0x33, 0x3,
    0xf1, 0x3, 0x10, 0x3e, 0x20, 0x64, 0x7, 0xe4,
    0x6, 0x20, 0x7e, 0xc0, 0x6c, 0x7, 0xe6, 0x6,
    0x40, 0x7e, 0x20, 0x7f, 0xf0, 0x10, 0x19, 0x1,
    0xf8, 0x81, 0x88, 0x1f, 0xb0, 0x1b, 0x1, 0xf9,
    0x81, 0x90, 0x1f, 0x88, 0x1f, 0xfc, 0x4, 0x6,
    0x40, 0x7e, 0x20, 0x6c, 0x7, 0xec, 0x6, 0x20,
    0x7e, 0x40, 0x64, 0x7, 0xff, 0x0, 0x81, 0xf9,
    0x1, 0x98, 0x1f, 0x88, 0x19, 0x6d, 0xf5, 0x3,
    0xc4, 0xfc, 0x80, 0xff, 0xe8, 0x0,

    /* U+5B "[" */
    0x1f, 0xff, 0x1, 0xff, 0xd8, 0xb6, 0xc0, 0x79,
    0x28, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0,
    0x3f, 0xfb, 0xa4, 0xe0, 0x3d, 0xb6, 0x3, 0xff,
    0xa4,

    /* U+5C "\\" */
    0xbf, 0xcc, 0xf, 0xf6, 0x2, 0xc0, 0x7f, 0x88,
    0x12, 0x3, 0xfc, 0x80, 0xc4, 0xf, 0xf1, 0x2,
    0x60, 0x7f, 0x90, 0x16, 0x3, 0xfd, 0xc0, 0x90,
    0x1f, 0xe4, 0x4, 0x40, 0xff, 0x10, 0x31, 0x3,
    0xfc, 0x80, 0x90, 0x1f, 0xe2, 0x5, 0x80, 0xff,
    0x60, 0x24, 0x7, 0xf9, 0x1, 0x88, 0x1f, 0xe2,
    0x4, 0xc0, 0xff, 0x20, 0x2c, 0x7, 0xfb, 0x81,
    0x20, 0x3f, 0xc8, 0x8, 0x81, 0xfe, 0x20, 0x62,
    0x7, 0xf9, 0x1, 0x20, 0x3f, 0xc4, 0xb, 0x1,
    0xfe, 0xc0, 0x48, 0xf, 0xf2, 0x3, 0x10, 0x3f,
    0xc4, 0x9, 0x81, 0xfe, 0x60, 0x58, 0xf, 0xf6,
    0x2, 0x40, 0x7f, 0x90, 0x11, 0x3, 0xfc, 0x40,
    0xc4, 0xf, 0xf1, 0x2, 0x40, 0x7f, 0x90, 0x16,
    0x3, 0xfd, 0x80, 0x90, 0x1f, 0xe4, 0x6, 0x20,
    0x7f, 0x88, 0x13, 0x3, 0xfc, 0xc0, 0xb0, 0x1f,
    0xec, 0x4, 0x80, 0xff, 0x20, 0x22, 0x7, 0xf8,
    0x81, 0x88, 0x1f, 0xe2, 0x4, 0x80, 0xff, 0x20,
    0x2c, 0x7, 0xfb, 0x1, 0x20, 0x3f, 0xc8, 0xf,
    0xfe, 0x3a, 0x3, 0xfc, 0x80, 0xb0, 0x1f, 0xec,
    0x4, 0x80, 0xff, 0x20, 0x22, 0x7, 0xf8, 0x81,
    0x88,

    /* U+5D "]" */
    0x5f, 0xfe, 0xc0, 0x7f, 0xf4, 0x95, 0xb4, 0x3,
    0xc9, 0x60, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0,
    0xff, 0xff, 0x81, 0xff, 0xff, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0x74, 0x99, 0x1, 0xcb, 0x6a, 0x1,
    0xff, 0xd7,

    /* U+5E "^" */
    0x3, 0xa4, 0xe2, 0x7, 0xf2, 0x6f, 0xa0, 0x1f,
    0xd8, 0xe, 0x40, 0x7f, 0x20, 0x3c, 0x40, 0xfc,
    0x40, 0xf2, 0x3, 0xe6, 0x7, 0xd8, 0xf, 0xb0,
    0x1f, 0x20, 0x3e, 0x40, 0x7e, 0x40, 0x71, 0x3,
    0x20, 0x36, 0x3, 0x90, 0x1b, 0x81, 0x90, 0x1d,
    0x80, 0xc9, 0x0, 0x88, 0x1c, 0x80, 0x90, 0xe0,
    0x64, 0x4, 0x80, 0xd8, 0x20, 0x36, 0x2, 0xc0,
    0x64, 0x0, 0x81, 0x20, 0x24, 0x6, 0x20, 0x10,
    0x11, 0x2, 0x20, 0x48, 0xb, 0x1, 0x98, 0x40,
    0x6c, 0x4, 0x80, 0xd8, 0x60, 0x32, 0x3, 0x20,
    0x24, 0x10, 0x18, 0x81, 0xb0, 0x18, 0x80,

    /* U+5F "_" */
    0x6f, 0xff, 0x8c, 0xa4, 0xff, 0xe3, 0x81, 0xff,
    0xda,

    /* U+60 "`" */
    0x12, 0x60, 0x31, 0x6e, 0x80, 0x54, 0x9, 0x81,
    0xa8, 0x13, 0x2, 0x4c, 0x5, 0x3, 0x42, 0xa,

    /* U+61 "a" */
    0x2, 0x37, 0xfd, 0x0, 0xe7, 0x90, 0x19, 0xf2,
    0x1, 0x40, 0x3f, 0x60, 0x1c, 0xf, 0xf3, 0x8,
    0x8, 0xfc, 0x6, 0xc4, 0xc, 0x81, 0x3, 0x30,
    0x3f, 0x10, 0x3f, 0xff, 0xe0, 0x7c, 0x7f, 0xd0,
    0xf, 0xe5, 0xbf, 0x52, 0x7, 0x8d, 0x20, 0x16,
    0x20, 0x74, 0x3, 0xff, 0x80, 0x80, 0xcd, 0x80,
    0xff, 0x29, 0x4, 0xc, 0x40, 0xc4, 0xf, 0xff,
    0xf8, 0x1f, 0xfc, 0xb2, 0x6, 0x20, 0x8, 0x1f,
    0xca, 0x60, 0x3c, 0x40, 0xcc, 0x81, 0xea, 0x7,
    0xff, 0x1, 0xc2, 0x1, 0xe2, 0x6,

    /* U+62 "b" */
    0x1f, 0xe8, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8,
    0x1f, 0xfc, 0x73, 0x7f, 0x52, 0x7, 0x96, 0x40,
    0x16, 0x3, 0xc4, 0xf, 0x30, 0x3f, 0xf8, 0x18,
    0xf, 0x7c, 0x6, 0x60, 0x72, 0x4, 0x80, 0x88,
    0x1c, 0x40, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3,
    0xff, 0xfe, 0x7, 0xff, 0x58, 0x81, 0xff, 0xc0,
    0x40, 0x90, 0x11, 0x3, 0xdf, 0x1, 0x98, 0x1f,
    0xfc, 0xc, 0x7, 0x40, 0x38, 0xb0, 0x31, 0x74,
    0x80, 0x5c, 0x0,

    /* U+63 "c" */
    0x2, 0x37, 0xfb, 0x40, 0x39, 0xe4, 0x4, 0x5f,
    0x20, 0x14, 0x3, 0xf6, 0x1, 0xc0, 0xff, 0x30,
    0x80, 0x8f, 0xc0, 0x6c, 0x40, 0xc8, 0x10, 0x33,
    0x3, 0xf1, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xf,
    0xed, 0x70, 0x3f, 0x13, 0xc0, 0x7f, 0xf8, 0xd2,
    0xe0, 0x3f, 0x4b, 0x68, 0x7, 0xff, 0xfc, 0xf,
    0xf8, 0x81, 0x88, 0x19, 0x2, 0x6, 0x61, 0x1,
    0x1f, 0x80, 0xd8, 0x40, 0x3f, 0xcc, 0x18, 0x7,
    0xec, 0x4, 0xf2, 0x2, 0x2f, 0x90,

    /* U+64 "d" */
    0x3, 0xf6, 0xfe, 0xc0, 0x7f, 0xff, 0xc0, 0xff,
    0xff, 0x81, 0xf9, 0x6f, 0xd0, 0xf, 0x8d, 0x20,
    0x1e, 0x20, 0x74, 0x3, 0x88, 0x1e, 0x40, 0x7f,
    0xf1, 0xf, 0xa0, 0x71, 0x3, 0x20, 0x80, 0xff,
    0xe0, 0x90, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0,
    0xff, 0xff, 0x81, 0xff, 0xd6, 0x20, 0x62, 0x6,
    0x41, 0x1, 0xfe, 0x3e, 0x81, 0xe4, 0x7, 0xff,
    0x2, 0x1, 0xe6, 0x7, 0x1a, 0x40, 0x2d, 0x0,
    0xc0,

    /* U+65 "e" */
    0x2, 0x37, 0xfb, 0x40, 0x39, 0xe4, 0x4, 0x5f,
    0x20, 0x14, 0x3, 0xf6, 0x1, 0xc0, 0xff, 0x30,
    0x80, 0x8f, 0xc0, 0x6c, 0x40, 0xc8, 0x12, 0x2,
    0x60, 0x7f, 0xff, 0xc0, 0xff, 0xe5, 0x12, 0x3,
    0xfc, 0xf6, 0x10, 0x3f, 0xfa, 0xef, 0xff, 0x60,
    0x3f, 0x26, 0xf0, 0x1f, 0xa4, 0xd4, 0xf, 0xff,
    0xf8, 0x1f, 0xf1, 0x3, 0x10, 0x32, 0x4, 0xc,
    0xc2, 0x2, 0x3f, 0x1, 0xb0, 0x80, 0x7f, 0x98,
    0x30, 0xf, 0xd8, 0x9, 0xe4, 0x4, 0x5f, 0x20,

    /* U+66 "f" */
    0x3, 0xc5, 0xb9, 0x1, 0xc7, 0x64, 0x95, 0x3,
    0x2c, 0x40, 0xfe, 0x80, 0x7f, 0x91, 0x3, 0x17,
    0x0, 0xb0, 0x19, 0x68, 0xc0, 0xfd, 0x40, 0xf1,
    0x3, 0xff, 0xfe, 0x7, 0x8f, 0x40, 0x6f, 0xf0,
    0x1f, 0xfd, 0x93, 0xd0, 0x1b, 0xfc, 0x7, 0xff,
    0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xff, 0xf0, 0x3f,
    0xff, 0xe0, 0x7f, 0xf3, 0x40,

    /* U+67 "g" */
    0x0, 0xb7, 0xea, 0x47, 0xf6, 0x6, 0x90, 0xb,
    0x50, 0x3a, 0x1, 0xe4, 0x7, 0x20, 0x3f, 0xf8,
    0x87, 0xd0, 0x38, 0x81, 0x90, 0x40, 0x7f, 0xf0,
    0x48, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f,
    0xff, 0xc0, 0xff, 0xeb, 0x10, 0x31, 0x3, 0x20,
    0x80, 0xff, 0x1f, 0x40, 0xf2, 0x3, 0xff, 0x81,
    0x0, 0xff, 0xe0, 0x1a, 0x40, 0x2c, 0x40, 0xf2,
    0xdf, 0xa9, 0x3, 0xc4, 0xe0, 0x3f, 0x1d, 0xb4,
    0x3, 0xff, 0xaa, 0x40, 0xf8, 0x81, 0xfc, 0x81,
    0x3, 0x30, 0x80, 0x8f, 0xc0, 0x6c, 0x20, 0x1f,
    0xc5, 0x83, 0x0, 0xfd, 0xc0, 0x9e, 0x40, 0x67,
    0xc8,

    /* U+68 "h" */
    0xff, 0x50, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0,
    0xff, 0xe4, 0x4f, 0xd9, 0x1, 0xe7, 0xd8, 0x3,
    0x48, 0x1c, 0x40, 0xf4, 0x3, 0xff, 0x80, 0x80,
    0xf5, 0xe4, 0xf, 0xe2, 0x82, 0x3, 0xf9, 0x81,
    0xff, 0xc8, 0x20, 0x7f, 0xff, 0xc0, 0xff, 0xff,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff,
    0x0,

    /* U+69 "i" */
    0xff, 0x50, 0x3f, 0xf9, 0x4, 0xf6, 0xda, 0x1,
    0xdf, 0xea, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8,
    0x1c,

    /* U+6A "j" */
    0x2, 0x9f, 0xe0, 0x3f, 0xfc, 0xb3, 0xfc, 0x7,
    0xff, 0x6, 0x7f, 0x80, 0xff, 0xff, 0x81, 0xff,
    0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc, 0xf,
    0xfe, 0x81, 0x3, 0xe4, 0x80, 0x44, 0x7, 0xa0,
    0x64, 0x7, 0xe8, 0x7, 0xd4, 0xe, 0x53, 0xa0,
    0x0,

    /* U+6B "k" */
    0xff, 0x50, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0,
    0xff, 0xe5, 0x6f, 0xea, 0x7, 0xc4, 0x80, 0xb8,
    0x1f, 0x20, 0x32, 0x3, 0xea, 0x4, 0x80, 0xf8,
    0x90, 0x17, 0x3, 0xea, 0x6, 0x40, 0x7c, 0xc0,
    0x98, 0x1f, 0x20, 0x35, 0x3, 0xee, 0x4, 0x48,
    0xf, 0x90, 0x12, 0x3, 0xe4, 0x6, 0xa0, 0x7f,
    0xc4, 0x80, 0xff, 0xa8, 0x1f, 0xfc, 0x6, 0x7,
    0xfc, 0x80, 0xff, 0xe0, 0x10, 0x3f, 0xf8, 0x8,
    0xf, 0xfe, 0x1, 0x20, 0x3f, 0xf8, 0x8, 0xf,
    0xfe, 0x5, 0x3, 0xff, 0x80, 0x48, 0xf, 0x88,
    0x19, 0x1, 0xf3, 0x20, 0x54, 0xf, 0xd4, 0x8,
    0x81, 0xf9, 0x1, 0x98, 0x1f, 0x12, 0x2, 0xa0,
    0x7e, 0x40, 0x44, 0xf, 0xd4, 0xc, 0xc0, 0xf8,
    0x81, 0xb0, 0x1f, 0x98, 0x12, 0x3, 0xf6, 0x3,
    0x30, 0x3e, 0x40, 0x6c,

    /* U+6C "l" */
    0xff, 0x50, 0x3f, 0xff, 0xe0, 0x7f, 0xff, 0xc0,
    0xff, 0xfd, 0x0,

    /* U+6D "m" */
    0x1f, 0xe8, 0x6f, 0xea, 0x40, 0x3d, 0xfa, 0x1,
    0xf2, 0xc8, 0x2, 0xc7, 0x42, 0x1, 0xc0, 0x3c,
    0x40, 0xf6, 0x20, 0x73, 0x3, 0xf1, 0x3, 0xc4,
    0xe, 0x20, 0x7b, 0xe2, 0x6, 0x9a, 0x1, 0x90,
    0x1c, 0x80, 0x30, 0x33, 0x8, 0xf, 0xf1, 0x0,
    0x40, 0xff, 0xff, 0x81, 0xff, 0xff, 0x3, 0xff,
    0xfe, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f,
    0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f, 0xf0, 0x0,

    /* U+6E "n" */
    0x1f, 0xe8, 0x6f, 0xec, 0x40, 0xf2, 0xc8, 0x1,
    0xc0, 0x78, 0x81, 0xe8, 0x7, 0xc4, 0xc, 0x80,
    0xf7, 0xc4, 0x8, 0x81, 0xc8, 0x3, 0x3, 0xf8,
    0x80, 0x20, 0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81,
    0xff, 0xff, 0x3, 0xff, 0xfe, 0x7, 0xff, 0x44,

    /* U+6F "o" */
    0x2, 0x37, 0xfb, 0x40, 0x39, 0xe4, 0x4, 0x5f,
    0x20, 0xc, 0x3, 0xf6, 0x1, 0x0, 0xff, 0x30,
    0x80, 0x8f, 0xc0, 0x6c, 0x7, 0x20, 0x40, 0xcc,
    0x81, 0xf1, 0x3, 0xff, 0xfe, 0x7, 0xff, 0xfc,
    0xf, 0xff, 0xf8, 0x1f, 0xfd, 0x62, 0x6, 0x20,
    0x64, 0x8, 0x19, 0x84, 0x4, 0x7e, 0x3, 0x61,
    0xc0, 0xff, 0x30, 0xa0, 0x1f, 0xb0, 0x13, 0xa8,
    0x8, 0xbe, 0x40,

    /* U+70 "p" */
    0xff, 0x3, 0x7f, 0x52, 0x7, 0x9e, 0x40, 0x16,
    0x3, 0xd0, 0xf, 0x40, 0x3f, 0xf8, 0x8, 0xf,
    0x6e, 0x6, 0x20, 0x71, 0x20, 0x80, 0xfe, 0x60,
    0x8, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f,
    0xff, 0xc0, 0xff, 0xe9, 0xb0, 0x4, 0xf, 0xe2,
    0x41, 0x1, 0xfe, 0xdc, 0xc, 0x40, 0xff, 0xe0,
    0x20, 0x38, 0x81, 0xea, 0x7, 0x3c, 0x80, 0x1a,
    0x40, 0xf1, 0xbf, 0xb2, 0x3, 0xff, 0xfe, 0x7,
    0xff, 0xb4,

    /* U+71 "q" */
    0x0, 0xb7, 0xea, 0x47, 0xf6, 0x6, 0x90, 0xb,
    0x40, 0x3a, 0x1, 0xe6, 0x7, 0x20, 0x3f, 0xf8,
    0x87, 0xd0, 0x38, 0x81, 0x90, 0x40, 0x7f, 0xf0,
    0x48, 0x1f, 0xff, 0xf0, 0x3f, 0xff, 0xe0, 0x7f,
    0xff, 0xc0, 0xff, 0xeb, 0x10, 0x31, 0x3, 0x20,
    0x80, 0xff, 0x1f, 0x40, 0xf2, 0x3, 0xff, 0x81,
    0x0, 0xff, 0xe0, 0x1a, 0x40, 0x3e, 0x40, 0xf2,
    0xdf, 0xa0, 0x1f, 0xff, 0xf0, 0x3f, 0xfe, 0x20,

    /* U+72 "r" */
    0x1f, 0xe8, 0x6f, 0xec, 0x40, 0xf2, 0xc8, 0x1,
    0xc4, 0xe, 0x20, 0x7a, 0x81, 0xf1, 0x3, 0x20,
    0x3d, 0xf1, 0x2, 0x20, 0x72, 0x0, 0xc0, 0xfe,
    0x20, 0x8, 0x1f, 0xff, 0xf0, 0x3f, 0xf8, 0x73,
    0x6c, 0x7, 0xf1, 0x38, 0xf, 0xff, 0xf8, 0x1f,
    0xff, 0xf0, 0x3f, 0xff, 0x60,

    /* U+73 "s" */
    0x2, 0x37, 0xfb, 0x20, 0x39, 0xe4, 0x4, 0x6d,
    0x1, 0x28, 0x7, 0xc9, 0x80, 0xe0, 0x7f, 0x40,
    0x8, 0x8, 0xfc, 0x6, 0x24, 0x6, 0x40, 0x81,
    0x98, 0x1f, 0x88, 0x11, 0x3, 0xff, 0xb6, 0x40,
    0xc4, 0xf, 0xfe, 0x2, 0x3, 0xf2, 0x3, 0x40,
    0x96, 0x22, 0x1, 0x9a, 0x96, 0xc8, 0x1a, 0x6,
    0xa8, 0xf, 0x28, 0x6, 0xa4, 0xf, 0x36, 0x3,
    0x62, 0x7, 0xa2, 0x3, 0x60, 0x3e, 0xa8, 0xd,
    0x40, 0x5b, 0x85, 0x20, 0x49, 0xa, 0x58, 0x4,
    0x3, 0x60, 0x3e, 0x40, 0x64, 0x7, 0xe2, 0x7,
    0xff, 0x90, 0x80, 0x20, 0x62, 0x6, 0xa0, 0x81,
    0x98, 0x40, 0x4f, 0xe0, 0x36, 0x1c, 0xf, 0xf3,
    0xa, 0x1, 0xfb, 0x1, 0x3c, 0x80, 0x8b, 0xe4,
    0x0,

    /* U+74 "t" */
    0x3, 0x14, 0x80, 0x77, 0xed, 0x78, 0x1f, 0xff,
    0xf0, 0x3f, 0xf8, 0xcf, 0x81, 0x97, 0xe2, 0x7,
    0xff, 0x49, 0xf0, 0x32, 0xfc, 0x40, 0xff, 0xff,
    0x81, 0xff, 0xff, 0x3, 0xff, 0xec, 0xc0, 0xe2,
    0x4, 0x48, 0xc, 0x80, 0xdb, 0x8, 0x8, 0x7,
    0x10, 0x35, 0x3, 0xf9, 0x66, 0x40, 0xf8, 0xcd,
    0xf8, 0x80,

    /* U+75 "u" */
    0x3f, 0xe6, 0x3, 0x7f, 0x60, 0x3f, 0xff, 0xe0,
    0x7f, 0xff, 0xc0, 0xff, 0xff, 0x81, 0xff, 0xff,
    0x3, 0xff, 0xbf, 0x81, 0x20, 0x31, 0x3, 0x2d,
    0x80, 0x78, 0x81, 0x88, 0x1f, 0x40, 0x3f, 0xf8,
    0xa, 0x10, 0xb, 0x10, 0x30,

    /* U+76 "v" */
    0xdf, 0xcc, 0xa, 0x7f, 0x26, 0x5, 0xc0, 0x88,
    0x13, 0x20, 0x44, 0x9, 0x81, 0x10, 0x3f, 0xf8,
    0x3c, 0x9, 0x81, 0x10, 0x31, 0x2, 0x20, 0x78,
    0x86, 0x7, 0xf9, 0x82, 0x7, 0x88, 0x11, 0x3,
    0xc4, 0x30, 0x3f, 0xf8, 0x9c, 0x1, 0x2, 0x60,
    0x81, 0x10, 0xc, 0x8, 0x8e, 0x4, 0xc0, 0x10,
    0x2e, 0x8, 0x11, 0x1, 0xc0, 0xff, 0xe0, 0x10,
    0x22, 0x18, 0x1f, 0xe6, 0x8, 0x2, 0x4, 0xc0,
    0xfc, 0xc0, 0x88, 0x11, 0x3, 0x10, 0x3f, 0x10,
    0x3f, 0x10, 0x26, 0x5, 0xc0, 0xcc, 0xb, 0x1,
    0x10, 0x3f, 0x10, 0x26, 0x6, 0x20, 0x48, 0x8,
    0x81, 0xb8, 0x1f, 0xfc, 0x2, 0x7, 0xff, 0x1,
    0x81, 0xe2, 0x7, 0x10, 0x3c, 0xc0, 0xff, 0xe0,
    0x10, 0x3f, 0xf8, 0xe4, 0xe, 0xe0, 0x79, 0x81,
    0xc4, 0xf, 0x10, 0x39, 0x81, 0x0,

    /* U+77 "w" */
    0xdf, 0xd0, 0x8, 0xff, 0x60, 0x36, 0xfe, 0x2c,
    0xf, 0x98, 0x11, 0x3, 0xf1, 0x3, 0x10, 0x22,
    0x7, 0xe2, 0x6, 0x20, 0x4c, 0xb, 0x81, 0x88,
    0x1e, 0x23, 0x81, 0x10, 0x22, 0x6, 0x60, 0x8,
    0x13, 0x4, 0xf, 0x98, 0x18, 0x81, 0xf9, 0x81,
    0xf1, 0x3, 0x70, 0xc, 0x8, 0x81, 0xe2, 0x7,
    0xc8, 0x1, 0x2, 0xe0, 0x81, 0x98, 0x20, 0x71,
    0x1, 0xc0, 0x88, 0x1f, 0x98, 0x1f, 0xfc, 0x6,
    0x0, 0x81, 0x10, 0x40, 0x10, 0x22, 0x8, 0x11,
    0x0, 0xc0, 0xb8, 0xe0, 0x18, 0x13, 0xc, 0xf,
    0xfe, 0x1, 0x1, 0x80, 0x88, 0x20, 0x78, 0x81,
    0x10, 0xc0, 0x20, 0x2e, 0x6, 0x20, 0x5c, 0x9,
    0x82, 0x0, 0x81, 0x10, 0x33, 0x2, 0x20, 0x44,
    0x8, 0x81, 0x99, 0x2, 0x20, 0x4c, 0xc, 0x40,
    0xf8, 0xb0, 0x3f, 0xf8, 0x8, 0x3, 0x4, 0x8,
    0x81, 0x70, 0x22, 0x6, 0xc0, 0x8, 0x60, 0x58,
    0x8, 0x81, 0xf9, 0x0, 0xe0, 0x81, 0x20, 0x26,
    0x6, 0x20, 0x7e, 0xe0, 0x7c, 0x40, 0xcc, 0xf,
    0x10, 0x40, 0xff, 0xe3, 0xb0, 0xc0, 0xff, 0xe0,
    0x10, 0x3f, 0x10, 0x3c, 0x40, 0xee, 0x7, 0x88,
    0x1f, 0x98, 0x1c, 0x40, 0xfe, 0x20, 0x71, 0x3,
    0x98, 0x1c, 0x40, 0xfe, 0xe0, 0x7f, 0xf0, 0xd8,
    0x1f, 0xf1, 0x3, 0x98, 0x11, 0x3, 0x88, 0x1f,
    0xf1, 0x2, 0xe0, 0x73, 0x3, 0xc4, 0xf, 0xc4,
    0xe, 0x20, 0x79, 0x81, 0xb8, 0x13, 0x3, 0xf8,

    /* U+78 "x" */
    0xbf, 0xe0, 0x36, 0xfe, 0x63, 0x1, 0x88, 0x11,
    0x2, 0x41, 0x81, 0x90, 0x4, 0x4, 0x48, 0x1,
    0x2, 0xc0, 0x30, 0x12, 0x2, 0x40, 0x48, 0x3,
    0x2, 0xc0, 0x54, 0xc, 0x88, 0x19, 0x1, 0x10,
    0x36, 0x40, 0x48, 0xe, 0x40, 0x4b, 0x1, 0x60,
    0x3b, 0x81, 0x14, 0x4, 0xc0, 0xe4, 0x7, 0xc4,
    0xf, 0x88, 0x1e, 0x40, 0x7c, 0x80, 0xf6, 0x3,
    0xea, 0x7, 0x90, 0x1f, 0x10, 0x39, 0x1, 0xfc,
    0x80, 0xd8, 0xf, 0xee, 0x6, 0x40, 0x7f, 0x10,
    0x35, 0x3, 0xfa, 0x81, 0x90, 0x1f, 0xc4, 0xc,
    0x40, 0xfc, 0x80, 0xf3, 0x3, 0xec, 0x7, 0xb0,
    0x1f, 0x30, 0x3c, 0x80, 0xf1, 0x3, 0xf2, 0x3,
    0x90, 0x12, 0x20, 0x58, 0xe, 0xc0, 0x59, 0x1,
    0x20, 0x39, 0x1, 0x3c, 0x4, 0x48, 0x9, 0x1,
    0x10, 0x80, 0xc8, 0xb, 0x1, 0x20, 0x4, 0xb,
    0x1, 0x30, 0x2c, 0x2, 0x81, 0x20, 0x4, 0xc,
    0x80, 0x20, 0x32, 0x8, 0x8, 0x81, 0x10, 0x37,
    0x18, 0xa, 0x81, 0x90, 0x12, 0x0,

    /* U+79 "y" */
    0xdf, 0xcc, 0x9, 0xff, 0x26, 0x5, 0xc0, 0xb8,
    0x13, 0x20, 0x44, 0x8, 0x81, 0x1c, 0x7, 0xcc,
    0xc, 0xc0, 0x98, 0x11, 0x3, 0x10, 0x22, 0x7,
    0x88, 0x1f, 0xfc, 0x6, 0x0, 0x81, 0x10, 0x40,
    0xf2, 0x2, 0x61, 0x81, 0x10, 0x1c, 0x8, 0x82,
    0x5, 0xc0, 0x10, 0x2e, 0x7, 0x10, 0xc, 0x8,
    0x8e, 0x7, 0x88, 0x1c, 0x40, 0x98, 0x11, 0x0,
    0xc3, 0x2, 0x20, 0x4c, 0x1, 0x4, 0xf, 0x88,
    0x1f, 0xfc, 0xe, 0x4, 0x80, 0x88, 0x18, 0x81,
    0x10, 0x26, 0x6, 0x60, 0x58, 0x8, 0x81, 0x88,
    0x12, 0x2, 0xe0, 0x71, 0x3, 0xff, 0x80, 0xc0,
    0xf1, 0x3, 0x88, 0x1e, 0x60, 0x77, 0x3, 0xc4,
    0xe, 0x40, 0x7f, 0xf0, 0x8, 0x1f, 0xfc, 0x62,
    0x7, 0xc4, 0xc, 0xc0, 0xf9, 0x81, 0xff, 0xc0,
    0xc0, 0x62, 0x7, 0xc4, 0xd, 0xc0, 0xf9, 0x81,
    0x88, 0x1f, 0x10, 0x3f, 0xf8, 0x4, 0xc, 0xc0,
    0xf9, 0x81, 0x88, 0x1f, 0x10, 0x3f, 0xf8, 0x1c,
    0x8, 0x81, 0xf8, 0x81, 0xff, 0xc0, 0x60, 0x4c,
    0xf, 0xc4, 0x8, 0x81, 0xff, 0xc0, 0xe0, 0x7c,
    0x40, 0xff, 0xe0, 0x30, 0x31, 0x3, 0x0,

    /* U+7A "z" */
    0x3f, 0xff, 0xc0, 0x7f, 0xf3, 0x49, 0xf0, 0x1c,
    0x76, 0xf1, 0x2, 0x40, 0x7c, 0x40, 0xb0, 0x1e,
    0x60, 0x64, 0x7, 0xb0, 0x11, 0x20, 0x3c, 0x80,
    0x90, 0x1e, 0x40, 0x6a, 0x7, 0xb0, 0x18, 0x81,
    0xe6, 0x4, 0x80, 0xf1, 0x3, 0x70, 0x3c, 0x80,
    0xc8, 0xf, 0x50, 0x22, 0x7, 0xc4, 0xa, 0x81,
    0xe6, 0x6, 0x40, 0x7b, 0x1, 0x12, 0x3, 0xc8,
    0x9, 0x1, 0xe4, 0x6, 0xc0, 0x7b, 0x1, 0x90,
    0x1e, 0x40, 0x48, 0xf, 0x12, 0x2, 0xe0, 0x79,
    0x1, 0x90, 0x1e, 0xa0, 0x44, 0xf, 0x88, 0x15,
    0x3, 0xc8, 0xc, 0x80, 0xf7, 0x3, 0x10, 0x3c,
    0xc0, 0xdb, 0x7c, 0x40, 0xc4, 0xfc, 0x7, 0xff,
    0x30,

    /* U+7B "{" */
    0x3, 0xf8, 0x92, 0x3, 0xf4, 0xfb, 0x29, 0x3,
    0xd9, 0x81, 0xfe, 0xa4, 0xf, 0xf1, 0x40, 0x7f,
    0xd4, 0xe, 0xbc, 0x81, 0x88, 0x19, 0xa0, 0x3c,
    0xc0, 0xd8, 0xf, 0xfe, 0x3, 0x3, 0xff, 0xfe,
    0x7, 0xff, 0xfc, 0xf, 0xfe, 0x9, 0x3, 0x10,
    0x3f, 0xf8, 0xe8, 0xc, 0x80, 0xf1, 0x80, 0x68,
    0x6, 0x5f, 0x10, 0x28, 0x40, 0xfc, 0x5e, 0x60,
    0x7f, 0x12, 0x60, 0x7f, 0xca, 0xb0, 0x39, 0x7c,
    0x40, 0xa2, 0x3, 0xc6, 0x1, 0xb8, 0x1f, 0x20,
    0x32, 0x3, 0xff, 0x92, 0x40, 0xc4, 0xf, 0xff,
    0xf8, 0x1f, 0xff, 0xf0, 0x3f, 0xf8, 0xcc, 0xf,
    0x98, 0x1b, 0x81, 0xf6, 0x3, 0x28, 0x80, 0xe4,
    0x7, 0x3a, 0x40, 0xc5, 0x81, 0xff, 0xc0, 0x88,
    0xf, 0xfe, 0x5, 0xa4, 0x6,

    /* U+7C "|" */
    0x9f, 0xe2, 0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8,
    0x1f, 0xff, 0xf0, 0x3f, 0xfe, 0x60,

    /* U+7D "}" */
    0x8, 0x90, 0x1f, 0xce, 0xec, 0xec, 0xf, 0xfe,
    0x4, 0xa0, 0x7f, 0xf0, 0x14, 0x3, 0xff, 0x80,
    0xc0, 0xe7, 0xd8, 0x1c, 0x80, 0xf4, 0x20, 0x6c,
    0x7, 0xc8, 0xf, 0xfe, 0x7, 0x3, 0xff, 0x8a,
    0x40, 0xff, 0xff, 0x81, 0xff, 0xff, 0x20, 0x7f,
    0xf0, 0x18, 0x19, 0x81, 0xf1, 0x3, 0x10, 0x3f,
    0x30, 0x35, 0x20, 0x7a, 0x20, 0x25, 0xb9, 0x3,
    0xac, 0x20, 0x7f, 0xc5, 0x81, 0xfe, 0xb4, 0x80,
    0xfe, 0x68, 0x9, 0x7e, 0x20, 0x68, 0x6, 0xa0,
    0x78, 0x81, 0x88, 0x1f, 0x30, 0x33, 0x3, 0xe2,
    0x7, 0xff, 0xfc, 0xf, 0xff, 0xf8, 0x1f, 0xe2,
    0x7, 0xdc, 0xf, 0xfe, 0x2, 0x3, 0x70, 0x39,
    0x52, 0x6, 0x20, 0x67, 0x50, 0x1c, 0x80, 0xff,
    0xa8, 0x1f, 0xf3, 0x40, 0x7f, 0x2d, 0x0, 0xf0,

    /* U+7E "~" */
    0x3, 0xff, 0x90, 0xb7, 0xec, 0x80, 0xe5, 0x88,
    0x13, 0xa4, 0x1, 0xbe, 0x12, 0x94, 0xe6, 0x14,
    0x3, 0xe7, 0xb1, 0x81, 0x41, 0x0, 0xff, 0xe1,
    0xb1, 0x88, 0xb, 0xfa, 0x10, 0x3c, 0x60, 0xc,
    0xb2, 0x0, 0xf5, 0x40, 0xc, 0xc0, 0x0
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 111, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 135, .box_w = 6, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 41, .adv_w = 265, .box_w = 14, .box_h = 11, .ofs_x = 1, .ofs_y = 34},
    {.bitmap_index = 74, .adv_w = 361, .box_w = 21, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 303, .adv_w = 242, .box_w = 15, .box_h = 52, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 455, .adv_w = 456, .box_w = 27, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 726, .adv_w = 242, .box_w = 15, .box_h = 52, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 856, .adv_w = 139, .box_w = 7, .box_h = 11, .ofs_x = 1, .ofs_y = 34},
    {.bitmap_index = 874, .adv_w = 222, .box_w = 12, .box_h = 50, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 945, .adv_w = 222, .box_w = 11, .box_h = 50, .ofs_x = 2, .ofs_y = -2},
    {.bitmap_index = 1016, .adv_w = 198, .box_w = 12, .box_h = 11, .ofs_x = 0, .ofs_y = 34},
    {.bitmap_index = 1062, .adv_w = 301, .box_w = 17, .box_h = 20, .ofs_x = 1, .ofs_y = 12},
    {.bitmap_index = 1097, .adv_w = 126, .box_w = 6, .box_h = 11, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 1114, .adv_w = 253, .box_w = 14, .box_h = 4, .ofs_x = 1, .ofs_y = 21},
    {.bitmap_index = 1123, .adv_w = 135, .box_w = 6, .box_h = 7, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1130, .adv_w = 231, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1293, .adv_w = 242, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1372, .adv_w = 178, .box_w = 10, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1406, .adv_w = 242, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1540, .adv_w = 242, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1655, .adv_w = 271, .box_w = 16, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1798, .adv_w = 242, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1895, .adv_w = 242, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2004, .adv_w = 210, .box_w = 13, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2151, .adv_w = 242, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2271, .adv_w = 242, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2382, .adv_w = 135, .box_w = 6, .box_h = 27, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2400, .adv_w = 140, .box_w = 7, .box_h = 31, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 2429, .adv_w = 247, .box_w = 14, .box_h = 32, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2546, .adv_w = 311, .box_w = 18, .box_h = 11, .ofs_x = 1, .ofs_y = 17},
    {.bitmap_index = 2571, .adv_w = 247, .box_w = 14, .box_h = 32, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2690, .adv_w = 234, .box_w = 14, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2810, .adv_w = 430, .box_w = 26, .box_h = 39, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3008, .adv_w = 239, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3173, .adv_w = 242, .box_w = 14, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3269, .adv_w = 242, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3358, .adv_w = 243, .box_w = 14, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3423, .adv_w = 200, .box_w = 11, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3464, .adv_w = 194, .box_w = 11, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3500, .adv_w = 242, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3592, .adv_w = 242, .box_w = 14, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3627, .adv_w = 113, .box_w = 6, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3640, .adv_w = 242, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 3699, .adv_w = 242, .box_w = 14, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3855, .adv_w = 184, .box_w = 11, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 3881, .adv_w = 328, .box_w = 20, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4075, .adv_w = 273, .box_w = 17, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4228, .adv_w = 242, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4307, .adv_w = 243, .box_w = 14, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4376, .adv_w = 244, .box_w = 15, .box_h = 48, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 4466, .adv_w = 250, .box_w = 15, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4557, .adv_w = 242, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4692, .adv_w = 224, .box_w = 14, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4730, .adv_w = 243, .box_w = 14, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 4782, .adv_w = 239, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 4951, .adv_w = 365, .box_w = 23, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5208, .adv_w = 240, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5399, .adv_w = 241, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5533, .adv_w = 230, .box_w = 14, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5683, .adv_w = 204, .box_w = 10, .box_h = 52, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 5716, .adv_w = 231, .box_w = 15, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 5877, .adv_w = 204, .box_w = 10, .box_h = 52, .ofs_x = 2, .ofs_y = -4},
    {.bitmap_index = 5911, .adv_w = 278, .box_w = 16, .box_h = 19, .ofs_x = 1, .ofs_y = 27},
    {.bitmap_index = 5998, .adv_w = 333, .box_w = 19, .box_h = 4, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6007, .adv_w = 163, .box_w = 8, .box_h = 6, .ofs_x = 1, .ofs_y = 38},
    {.bitmap_index = 6023, .adv_w = 217, .box_w = 13, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6101, .adv_w = 218, .box_w = 13, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6168, .adv_w = 217, .box_w = 13, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6238, .adv_w = 220, .box_w = 13, .box_h = 45, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6303, .adv_w = 217, .box_w = 13, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6375, .adv_w = 178, .box_w = 12, .box_h = 46, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6428, .adv_w = 219, .box_w = 13, .box_h = 43, .ofs_x = 0, .ofs_y = -11},
    {.bitmap_index = 6517, .adv_w = 222, .box_w = 13, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6566, .adv_w = 103, .box_w = 5, .box_h = 40, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6583, .adv_w = 143, .box_w = 9, .box_h = 51, .ofs_x = 0, .ofs_y = -11},
    {.bitmap_index = 6624, .adv_w = 224, .box_w = 13, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6740, .adv_w = 103, .box_w = 5, .box_h = 45, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 6751, .adv_w = 340, .box_w = 21, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6815, .adv_w = 220, .box_w = 13, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6855, .adv_w = 217, .box_w = 13, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 6914, .adv_w = 220, .box_w = 13, .box_h = 43, .ofs_x = 1, .ofs_y = -11},
    {.bitmap_index = 6980, .adv_w = 220, .box_w = 13, .box_h = 43, .ofs_x = 0, .ofs_y = -11},
    {.bitmap_index = 7044, .adv_w = 220, .box_w = 13, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7089, .adv_w = 217, .box_w = 13, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7194, .adv_w = 156, .box_w = 10, .box_h = 44, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 7244, .adv_w = 220, .box_w = 13, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7281, .adv_w = 200, .box_w = 13, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7399, .adv_w = 341, .box_w = 22, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7599, .adv_w = 227, .box_w = 15, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7741, .adv_w = 200, .box_w = 13, .box_h = 43, .ofs_x = 0, .ofs_y = -11},
    {.bitmap_index = 7900, .adv_w = 196, .box_w = 12, .box_h = 32, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 7997, .adv_w = 237, .box_w = 13, .box_h = 53, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 8106, .adv_w = 122, .box_w = 6, .box_h = 49, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 8120, .adv_w = 237, .box_w = 13, .box_h = 53, .ofs_x = 2, .ofs_y = -3},
    {.bitmap_index = 8232, .adv_w = 309, .box_w = 18, .box_h = 7, .ofs_x = 1, .ofs_y = 13}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Pair left and right glyphs for kerning*/
static const uint8_t kern_pair_glyph_ids[] =
{
    8, 52,
    34, 3,
    34, 8,
    34, 53,
    34, 55,
    34, 56,
    34, 58,
    34, 87,
    34, 88,
    34, 90,
    38, 87,
    39, 13,
    39, 15,
    39, 34,
    39, 66,
    39, 70,
    39, 71,
    39, 74,
    39, 80,
    39, 83,
    39, 85,
    39, 86,
    39, 90,
    45, 3,
    45, 8,
    45, 53,
    45, 55,
    45, 56,
    45, 58,
    45, 90,
    48, 57,
    48, 58,
    49, 13,
    49, 15,
    49, 34,
    53, 13,
    53, 14,
    53, 15,
    53, 28,
    53, 34,
    53, 66,
    53, 68,
    53, 70,
    53, 74,
    53, 80,
    53, 83,
    53, 84,
    53, 86,
    53, 88,
    53, 90,
    55, 13,
    55, 15,
    55, 34,
    55, 66,
    55, 70,
    55, 80,
    55, 83,
    55, 86,
    56, 13,
    56, 15,
    56, 34,
    56, 66,
    56, 69,
    56, 70,
    56, 78,
    56, 80,
    56, 83,
    56, 86,
    58, 13,
    58, 14,
    58, 15,
    58, 28,
    58, 34,
    58, 69,
    58, 70,
    58, 80,
    58, 81,
    58, 86,
    66, 71,
    66, 75,
    70, 15,
    71, 13,
    71, 15,
    71, 71,
    74, 75,
    76, 75,
    79, 75,
    80, 71,
    80, 75,
    83, 13,
    83, 15,
    83, 85,
    84, 75,
    85, 66,
    85, 69,
    85, 70,
    85, 80,
    87, 13,
    87, 15,
    88, 13,
    88, 15,
    90, 13,
    90, 15,
    90, 77
};

/* Kerning between the respective left and right glyphs
 * 4.4 format which needs to scaled with `kern_scale`*/
static const int8_t kern_pair_values[] =
{
    -23, -59, -46, -36, -18, -18, -27, -9,
    -9, -14, -23, -68, -68, -27, -27, -27,
    -32, -23, -27, -27, -23, -27, -18, -77,
    -73, -23, -23, -18, -27, -27, -5, -5,
    -100, -118, -18, -27, -32, -27, -32, -18,
    -32, -27, -27, -23, -32, -32, -32, -32,
    -32, -32, -27, -36, -23, -9, -9, -9,
    -9, -9, -27, -27, -23, -9, -9, -9,
    -9, -9, -9, -9, -27, -18, -46, -27,
    -27, -23, -23, -14, -9, -14, -18, -46,
    -9, -32, -27, -27, -41, -27, -32, -14,
    -41, -77, -66, -5, -46, -9, -9, -9,
    -9, -14, -18, -14, -18, -14, -32, 5
};

/*Collect the kern pair's data in one place*/
static const lv_font_fmt_txt_kern_pair_t kern_pairs =
{
    .glyph_ids = kern_pair_glyph_ids,
    .values = kern_pair_values,
    .pair_cnt = 104,
    .glyph_ids_size = 0
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_pairs,
    .kern_scale = 18,
    .cmap_num = 1,
    .bpp = 3,
    .kern_classes = 0,
    .bitmap_format = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t morgnite_bold_64 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 61,          /*The maximum line height required by the font*/
    .base_line = 11,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if MORGNITE_BOLD_64*/

