#include <lvgl/lvgl.h>

/*******************************************************************************
 * Size: 24 px
 * Bpp: 3
 * Opts: --font ../font/liquid_crystal/LiquidCrystal-Normal.ttf -r 0x20-0x7F --size 24 --format lvgl --bpp 3 --lv-include lvgl/lvgl.h  -o liquidCrystal_nor_24.c
 ******************************************************************************/

#ifndef LIQUIDCRYSTAL_NOR_24
#define LIQUIDCRYSTAL_NOR_24 1
#endif

#if LIQUIDCRYSTAL_NOR_24

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0x34, 0x44, 0xc0, 0xff, 0xe3, 0x60, 0x9e, 0x2f,
    0x1e, 0x10, 0x1f, 0xf1, 0x90, 0x8e, 0x3, 0x0,

    /* U+22 "\"" */
    0xc, 0x14, 0x91, 0xfa, 0x7, 0x30, 0x59, 0x2c,
    0xae,

    /* U+24 "$" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x48, 0x80, 0xcc,
    0x45, 0x7d, 0x4f, 0xf2, 0x80, 0x7f, 0x9a, 0x3,
    0xfd, 0x28, 0x1f, 0xfd, 0x98, 0xa7, 0xa8, 0x7e,
    0x60, 0x54, 0x81, 0xec, 0xc0, 0xb7, 0xa8, 0x7e,
    0x50, 0xf, 0xfe, 0xd1, 0x3, 0xfc, 0xf1, 0x3,
    0xfb, 0x86, 0x7, 0xf4, 0x53, 0xd4, 0x3f, 0x28,
    0x2, 0x81, 0x24, 0x1, 0x98,

    /* U+27 "'" */
    0xc, 0x38, 0xc0, 0xf3, 0xac,

    /* U+28 "(" */
    0x1, 0x7c, 0x1, 0x18, 0x12, 0x6b, 0xc0, 0x22,
    0x7, 0xff, 0x47, 0x1, 0x9b, 0x1, 0x9b, 0x1,
    0xd8, 0xf, 0xfe, 0xaa, 0x6d, 0xe0, 0x8, 0xc0,
    0x80,

    /* U+29 ")" */
    0x1b, 0xa0, 0x3b, 0xa0, 0x1b, 0xaa, 0x7, 0xff,
    0x58, 0x81, 0xd8, 0x81, 0xb1, 0x3, 0x10, 0x3f,
    0xfa, 0xbb, 0xaa, 0x6, 0xe8, 0x0,

    /* U+2A "*" */
    0xbd, 0xf5, 0x86, 0xc, 0x80, 0x25, 0xc6, 0x28,

    /* U+2B "+" */
    0x3, 0x42, 0x7, 0x93, 0x80, 0x7f, 0xf0, 0x67,
    0x88, 0x7c, 0x41, 0x4, 0x8, 0x80, 0xbf, 0x21,
    0xf8, 0x81, 0x30, 0x3f, 0x24, 0xe0, 0x40,

    /* U+2C "," */
    0x14, 0xb5, 0x40, 0x53, 0x88,

    /* U+2E "." */
    0x14, 0xc5, 0x62, 0x80,

    /* U+2F "/" */
    0x3, 0xfb, 0x60, 0x1f, 0x91, 0x3, 0xfa, 0xa,
    0x7, 0xc8, 0x93, 0x3, 0xe8, 0x20, 0x1f, 0x32,
    0x48, 0xf, 0xa0, 0x80, 0x7c, 0x81, 0x40, 0x7f,
    0x70, 0x3e, 0x22, 0x90, 0x3e, 0xc5, 0x1, 0xf4,
    0x3, 0xfc, 0xc2, 0x3, 0xe8, 0x19, 0x3, 0xc5,
    0x88, 0x7, 0xd0, 0x30, 0x3e, 0x28, 0x40, 0x3e,
    0xa1, 0x81, 0xfe, 0x80, 0x7e,

    /* U+30 "0" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0xff, 0xe7, 0x0, 0xff, 0xe0, 0x10, 0x3f, 0xf9,
    0x24, 0xf, 0xfe, 0x76, 0x8, 0xf, 0x22, 0x4b,
    0x10, 0x3d, 0x78, 0x58, 0x81, 0xeb, 0xc6, 0x8,
    0xf, 0x22, 0x40, 0x7f, 0xf5, 0x48, 0x1f, 0xfc,
    0xe8, 0xaf, 0xfe, 0x70, 0x8a, 0x7, 0xd9, 0x80,

    /* U+31 "1" */
    0x2, 0x8c, 0x2, 0x70, 0x4e, 0x1, 0x30, 0x26,
    0x38, 0x3, 0xd0, 0x1f, 0xfc, 0x32, 0x80, 0xbd,
    0x2, 0xf4, 0x8, 0xa0, 0x3f, 0xfa, 0xae, 0x0,

    /* U+32 "2" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0xff, 0xe7, 0x5, 0x28, 0xf, 0xc4, 0xb1, 0x3,
    0xff, 0x8c, 0x40, 0xff, 0xe6, 0x90, 0x1b, 0xff,
    0x28, 0x2, 0x81, 0xf6, 0x62, 0x2b, 0xff, 0x98,
    0x1f, 0xff, 0xf3, 0x7f, 0xf3, 0x1, 0x81, 0x3,
    0xd1, 0x80,

    /* U+33 "3" */
    0x1b, 0xff, 0x90, 0x1f, 0xee, 0x86, 0xff, 0xe5,
    0x40, 0xff, 0xf6, 0xbf, 0xfc, 0xa8, 0x1f, 0xe6,
    0x1, 0xff, 0xe5, 0x80, 0xff, 0xfb, 0xdf, 0xfe,
    0x54, 0x30, 0x3e, 0xe8,

    /* U+34 "4" */
    0x3, 0xfc, 0x40, 0x10, 0x3e, 0xb8, 0x3c, 0x80,
    0xf3, 0x7, 0x82, 0x7, 0xff, 0x48, 0x81, 0xff,
    0xd9, 0x31, 0x5f, 0xfc, 0xa0, 0xa, 0x7, 0xff,
    0x3, 0x7f, 0xe5, 0x0, 0xff, 0xe0, 0x10, 0x3f,
    0xfa, 0xa4, 0xf, 0xfe, 0xbb, 0x4, 0xf, 0xeb,
    0x80,

    /* U+35 "5" */
    0x5b, 0xff, 0xcc, 0x60, 0x40, 0xf4, 0x60, 0xd,
    0xff, 0xcc, 0xf, 0xff, 0x97, 0x37, 0xff, 0x30,
    0xf, 0x1, 0xf6, 0x60, 0x5b, 0xff, 0x38, 0x40,
    0xff, 0xec, 0x90, 0x3f, 0xcb, 0x10, 0x3f, 0xb0,
    0x40, 0x7f, 0x45, 0x7f, 0xf3, 0x84, 0x50, 0x3e,
    0xcc, 0x0,

    /* U+36 "6" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7f, 0xa2, 0xbf,
    0xf9, 0x81, 0xff, 0xf2, 0xe6, 0xff, 0xe6, 0x7,
    0xfd, 0x98, 0xe6, 0xff, 0xe5, 0x0, 0xff, 0xe0,
    0x10, 0x3f, 0xfa, 0xa4, 0xf, 0xfe, 0x74, 0x57,
    0xff, 0x38, 0x45, 0x3, 0xec, 0xc0,

    /* U+37 "7" */
    0x17, 0xff, 0xc8, 0xf, 0xfe, 0x5, 0xff, 0xea,
    0x80, 0xfc, 0x60, 0x1f, 0xd0, 0xf, 0xe2, 0x80,
    0xfe, 0x82, 0x81, 0xf1, 0x45, 0x81, 0xfd, 0x0,
    0xf8, 0xba, 0x80, 0xfb, 0x62, 0x3, 0xe6, 0x7,
    0xfa, 0xa, 0x7, 0xd0, 0x22, 0x7, 0xcc, 0x40,
    0x3e, 0x81, 0x90, 0x3c, 0x58, 0x80, 0x7d, 0x43,
    0x3, 0xfd, 0x0, 0xf8,

    /* U+38 "8" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0xff, 0xe7, 0x0, 0xff, 0xe0, 0x10, 0x3f, 0xf9,
    0x24, 0xf, 0xfe, 0x69, 0x8a, 0xff, 0xe5, 0x0,
    0xff, 0xe0, 0xc5, 0x7f, 0xf2, 0x80, 0x7f, 0xf0,
    0x8, 0x1f, 0xfd, 0x52, 0x7, 0xff, 0x3a, 0x2b,
    0xff, 0x9c, 0x22, 0x81, 0xf6, 0x60,

    /* U+39 "9" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0xff, 0xe7, 0x0, 0xff, 0xe0, 0x10, 0x3f, 0xf9,
    0x24, 0xf, 0xfe, 0x74, 0x57, 0xff, 0x22, 0x2,
    0x81, 0xfc, 0x40, 0x6f, 0xfc, 0x89, 0x1, 0xff,
    0xe1, 0x20, 0x7f, 0xf4, 0x37, 0xfe, 0x70, 0x81,
    0xfd, 0x98,

    /* U+3A ":" */
    0x70, 0x46, 0x23, 0xe, 0x1, 0xf3, 0x82, 0x31,
    0x18,

    /* U+3B ";" */
    0x50, 0x46, 0x6a, 0x2e, 0x81, 0xf2, 0x82, 0x32,
    0x19, 0xb0, 0x0,

    /* U+3C "<" */
    0x3, 0xe8, 0x2, 0x0, 0x2c, 0x4, 0x1c, 0xa0,
    0xe8, 0x80, 0x4c, 0x78, 0x3, 0x40, 0x4, 0x41,
    0x43, 0x5, 0x86, 0x20, 0xe0, 0x18, 0x14, 0xe0,

    /* U+3D "=" */
    0x9f, 0xfb, 0x1, 0xfe, 0x9f, 0xfb, 0x1, 0xff,
    0xe2, 0x9f, 0xfb, 0xe, 0x7, 0xe0,

    /* U+3E ">" */
    0x3, 0x40, 0x34, 0x2, 0x60, 0x38, 0x81, 0x86,
    0x44, 0x14, 0x30, 0x33, 0xe0, 0x1f, 0x10, 0x9,
    0x89, 0x1, 0x82, 0x20, 0x8, 0x3, 0x30, 0x0,

    /* U+3F "?" */
    0x3f, 0xfc, 0x40, 0xfe, 0x88, 0xff, 0xec, 0xa0,
    0x1f, 0x30, 0x3f, 0xfb, 0x6c, 0xf, 0xaf, 0xca,
    0x1, 0xa3, 0x1, 0xd0, 0x13, 0x65, 0xf9, 0x1,
    0xff, 0xe0, 0x43, 0x1, 0xf1, 0xc8, 0xf, 0x8e,
    0x40, 0x7c, 0x6a, 0x3, 0x0,

    /* U+41 "A" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0xff, 0xe5, 0x0, 0xff, 0xe0, 0x10, 0x3f, 0xfc,
    0xa6, 0xff, 0xe4, 0x4, 0xc0, 0xfc, 0x48, 0x29,
    0xff, 0x99, 0x20, 0x4, 0xf, 0xff, 0xcf, 0x4,
    0xf, 0x30, 0x5e, 0x40, 0x7a, 0xe0,

    /* U+42 "B" */
    0x7b, 0xff, 0x98, 0xe, 0x8, 0x1e, 0xcc, 0x1,
    0x9f, 0xf9, 0x40, 0x22, 0x7, 0xff, 0x8c, 0x81,
    0xfe, 0x37, 0xff, 0x28, 0x7, 0xff, 0x4, 0x95,
    0xff, 0xca, 0x1, 0x10, 0x3f, 0xfd, 0xe4, 0xf,
    0xf1, 0x9f, 0xf9, 0x41, 0x81, 0x3, 0xd9, 0x80,

    /* U+43 "C" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0x7f, 0xe5, 0x0, 0x88, 0x1e, 0x48, 0x7, 0xfa,
    0xd0, 0x1f, 0xfd, 0xb4, 0x7, 0xf7, 0x84, 0xf,
    0xef, 0x8, 0x1f, 0xf2, 0x3, 0xff, 0xd5, 0x68,
    0x8, 0x81, 0xe4, 0x82, 0x29, 0xff, 0x94, 0x1,
    0x40, 0xfb, 0x30,

    /* U+44 "D" */
    0x7b, 0xff, 0x98, 0xe, 0x8, 0x1e, 0xcc, 0x1,
    0x9f, 0xf9, 0x40, 0x22, 0x7, 0xff, 0xbd, 0x1,
    0xe4, 0x3, 0xc2, 0x7, 0xaa, 0x1a, 0x10, 0x3d,
    0x50, 0x12, 0x3, 0xc8, 0xf, 0xff, 0x41, 0x3,
    0xfc, 0x67, 0xfe, 0x50, 0x60, 0x40, 0xf6, 0x60,

    /* U+45 "E" */
    0x1, 0xbf, 0xf3, 0x14, 0xf, 0xd1, 0x4f, 0xfc,
    0xc0, 0x10, 0x3f, 0xfb, 0x64, 0xf, 0xc6, 0xff,
    0xb0, 0x1f, 0xfc, 0x13, 0x7f, 0xd8, 0xc, 0x40,
    0xff, 0xf2, 0x90, 0x3e, 0x8a, 0x7f, 0xe6, 0x28,
    0x1f, 0x80,

    /* U+46 "F" */
    0x1, 0xbf, 0xf3, 0x14, 0xf, 0xd1, 0x4f, 0xfc,
    0xc0, 0x10, 0x3f, 0xfb, 0x64, 0xf, 0xc6, 0xff,
    0xb0, 0x1f, 0xfc, 0x13, 0x7f, 0xd8, 0xc, 0x40,
    0xff, 0xf6, 0xf0, 0x40, 0xf9, 0xe4, 0x7, 0xc0,

    /* U+47 "G" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7f, 0xa2, 0x9f,
    0xf9, 0x81, 0x88, 0x1f, 0xfe, 0x32, 0x7, 0xf9,
    0x20, 0x14, 0xfe, 0xa0, 0x7f, 0x92, 0x0, 0x48,
    0x5, 0x3f, 0x20, 0x31, 0x3, 0xff, 0xde, 0x40,
    0xfe, 0x8a, 0x7f, 0xe5, 0x0, 0x50, 0x3e, 0xcc,
    0x0,

    /* U+48 "H" */
    0x4, 0xf, 0xc4, 0x4c, 0x80, 0xf6, 0xc0, 0x22,
    0x7, 0x88, 0x1f, 0xff, 0x42, 0x7, 0xf8, 0xdf,
    0xfc, 0x80, 0xff, 0xe0, 0x10, 0x6, 0xff, 0xe4,
    0x40, 0x88, 0x1f, 0xff, 0x9e, 0x8, 0x1e, 0x20,
    0x1e, 0x40, 0x7b, 0x60,

    /* U+49 "I" */
    0x34, 0x44, 0xc0, 0xff, 0xe3, 0x60, 0x9e, 0x2f,
    0x1e, 0x10, 0x1f, 0xfc, 0x6a, 0x98,

    /* U+4A "J" */
    0x3, 0xd3, 0xf3, 0x3, 0xfe, 0xcc, 0xf, 0xa7,
    0xe5, 0x0, 0xff, 0xfd, 0x20, 0x3f, 0xea, 0x80,
    0xff, 0x54, 0x7, 0xf9, 0x1, 0xff, 0xda, 0x5c,
    0x81, 0xfd, 0x83, 0x3, 0xfa, 0x29, 0xff, 0x94,
    0x1, 0x40, 0xfb, 0x30,

    /* U+4B "K" */
    0x34, 0xf, 0xa7, 0xa9, 0x81, 0xc5, 0x81, 0xfd,
    0xc4, 0x3, 0xe4, 0x49, 0x81, 0xf5, 0x10, 0xf,
    0xa0, 0x48, 0x7, 0x8b, 0x10, 0xc, 0x40, 0x40,
    0xc8, 0x11, 0xbf, 0x99, 0x80, 0x7e, 0x60, 0x78,
    0xdf, 0xcc, 0xb0, 0x38, 0x80, 0xe2, 0x1, 0xf8,
    0xa1, 0x0, 0xfd, 0x3, 0x3, 0xf1, 0x42, 0x1,
    0xfa, 0x6, 0x7, 0xe2, 0xc4, 0x0, 0x40, 0xe8,
    0x1d, 0x48, 0x7, 0x98,

    /* U+4C "L" */
    0x30, 0xf, 0xd5, 0xa0, 0x3f, 0x88, 0x1f, 0xfe,
    0xf4, 0x7, 0xe6, 0x40, 0xfc, 0xc8, 0x1f, 0xc8,
    0xf, 0xff, 0x29, 0x3, 0xe8, 0xa7, 0xfe, 0x62,
    0x81, 0xf8,

    /* U+4D "M" */
    0x1, 0xbf, 0xf3, 0x5f, 0xfc, 0x40, 0x50, 0x3e,
    0xdc, 0xf, 0xa1, 0x8a, 0x7f, 0xe4, 0x9f, 0xfa,
    0xa8, 0x0, 0x81, 0xff, 0xc4, 0x60, 0x7f, 0xff,
    0xc0, 0xf9, 0x1, 0xe4, 0x80, 0x79, 0x11, 0xe1,
    0x3, 0xd6, 0x1, 0xf4, 0x5e, 0x10, 0x3d, 0xb0,
    0xf, 0x1a, 0x80, 0x20, 0x3c, 0x40, 0xf9, 0x81,
    0xff, 0xff, 0x3, 0xff, 0xa2, 0x40, 0xff, 0xe2,
    0x38, 0xd0, 0x1e, 0xb0, 0xf, 0x27, 0x0,

    /* U+4E "N" */
    0x8, 0xf, 0xc4, 0x4a, 0x80, 0xf6, 0xc0, 0x29,
    0xc8, 0x18, 0x81, 0xec, 0x40, 0xfd, 0x50, 0xc4,
    0xf, 0xd5, 0xc, 0x80, 0xfd, 0x58, 0xa8, 0xf,
    0xd1, 0x88, 0x7, 0x10, 0x29, 0x14, 0xc, 0x90,
    0xc, 0xda, 0x80, 0x2c, 0xf, 0x88, 0x2, 0x48,
    0xf, 0x40, 0x31, 0x3, 0xff, 0xf3, 0xc2, 0x3,
    0xc8, 0x87, 0x88, 0x1e, 0xb8, 0x0,

    /* U+4F "O" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0x7f, 0xe5, 0x0, 0x88, 0x1f, 0xfe, 0xf4, 0x7,
    0x90, 0xf, 0x8, 0x1e, 0xa4, 0x78, 0x40, 0xf5,
    0x20, 0x48, 0xf, 0x20, 0x3f, 0xfd, 0x4, 0xf,
    0xe8, 0xa7, 0xfe, 0x50, 0x5, 0x3, 0xec, 0xc0,

    /* U+50 "P" */
    0x7b, 0xff, 0x98, 0xe, 0x8, 0x1e, 0xcc, 0x1,
    0xbf, 0xf9, 0x40, 0x3f, 0xfe, 0x46, 0xff, 0xe5,
    0x0, 0x30, 0x3e, 0xcc, 0x2, 0x9f, 0xf9, 0x81,
    0x88, 0x1f, 0xff, 0x9e, 0x8, 0x1f, 0xcf, 0x20,
    0x3f, 0x80,

    /* U+51 "Q" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0x7f, 0xe5, 0x0, 0x88, 0x1f, 0xfe, 0xf4, 0x7,
    0x90, 0xf, 0x8, 0x1e, 0xa4, 0x78, 0x40, 0x88,
    0xa, 0x40, 0x90, 0x13, 0x81, 0x1, 0xfc, 0xc8,
    0x1f, 0xcc, 0x40, 0x3f, 0x8a, 0x3, 0xfe, 0xa0,
    0x78, 0x81, 0xd0, 0xa, 0x29, 0xff, 0x65, 0x0,
    0x50, 0x3e, 0xcc, 0x0,

    /* U+52 "R" */
    0x7b, 0xff, 0x98, 0xe, 0x8, 0x1e, 0xcc, 0x1,
    0xbf, 0xf9, 0x40, 0x3f, 0xfe, 0x46, 0xff, 0xe5,
    0x0, 0x30, 0x3e, 0xcc, 0x2, 0x54, 0xff, 0x30,
    0x39, 0x44, 0x7, 0xef, 0x5, 0x40, 0x7e, 0x6c,
    0x29, 0x3, 0xf4, 0x43, 0x10, 0x3f, 0x54, 0x38,
    0x1f, 0xd4, 0x96, 0x3, 0x10, 0x36, 0x25, 0x45,
    0x48, 0x7, 0x70, 0x80,

    /* U+53 "S" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0xff, 0xe5, 0x0, 0xff, 0x34, 0x7, 0xfa, 0x50,
    0x3f, 0xfb, 0x31, 0x4f, 0xfc, 0xc0, 0xa9, 0x3,
    0xd9, 0x81, 0x6f, 0xfc, 0xa0, 0x1f, 0xfd, 0xa2,
    0x7, 0xf9, 0xe2, 0x7, 0xf7, 0xc, 0xf, 0xe8,
    0xa7, 0xfe, 0x50, 0x5, 0x3, 0xec, 0xc0,

    /* U+54 "T" */
    0x3f, 0xff, 0x10, 0x31, 0x44, 0xc, 0x7f, 0x92,
    0x5f, 0xe2, 0x7, 0xff, 0xbf, 0x2, 0x7, 0xe5,
    0x90, 0x1f, 0x96, 0x20, 0x7e, 0xc1, 0x1, 0xff,
    0xfe, 0xa5, 0x81, 0x80,

    /* U+55 "U" */
    0x30, 0xf, 0x93, 0x15, 0xa0, 0x3d, 0x60, 0x11,
    0x3, 0xff, 0xf6, 0x80, 0xf1, 0x2, 0x64, 0xf,
    0x70, 0x26, 0x40, 0xf7, 0x3, 0x20, 0x3c, 0x40,
    0xff, 0xf4, 0x10, 0x3f, 0xa2, 0x9f, 0xf9, 0x40,
    0x14, 0xf, 0xb3, 0x0,

    /* U+56 "V" */
    0x14, 0xf, 0x93, 0x11, 0x30, 0x3d, 0x60, 0x1f,
    0xff, 0xf2, 0x7, 0xfc, 0xc0, 0xf2, 0x3, 0x50,
    0x38, 0xa0, 0x14, 0x30, 0x3a, 0x4, 0xa, 0x10,
    0x8, 0xa1, 0x0, 0x40, 0xc0, 0xa0, 0x44, 0x1,
    0x42, 0x2, 0x84, 0x3, 0x40, 0xc4, 0xc, 0x81,
    0x8a, 0x15, 0x8, 0x7, 0xa0, 0x61, 0x81, 0xf1,
    0x6c, 0x20, 0x18,

    /* U+57 "W" */
    0x30, 0xf, 0x93, 0x3, 0xe8, 0x6b, 0x40, 0x7a,
    0xc0, 0x3c, 0x9c, 0x0, 0x40, 0xff, 0xe2, 0x30,
    0x3f, 0xff, 0xe0, 0x7f, 0xf3, 0xd0, 0x1e, 0x24,
    0x7, 0x98, 0x13, 0x20, 0x7b, 0xf0, 0x1e, 0x30,
    0x3, 0x20, 0x7b, 0xf0, 0x1e, 0x30, 0x9, 0x1,
    0xe2, 0x40, 0x79, 0x81, 0xff, 0xff, 0x3, 0xf8,
    0x81, 0xff, 0xc4, 0x71, 0x4f, 0xfc, 0x93, 0xff,
    0x55, 0x5, 0x3, 0xed, 0xc0, 0xfa, 0x10,

    /* U+58 "X" */
    0xbc, 0xf, 0xb6, 0x10, 0xc0, 0xe4, 0x45, 0x10,
    0xe, 0x82, 0x94, 0x20, 0x12, 0x21, 0x88, 0x18,
    0x14, 0x10, 0x1, 0x42, 0x4, 0x43, 0x2, 0x81,
    0x98, 0x20, 0x18, 0xa1, 0x9, 0x30, 0x3a, 0x1,
    0x40, 0x3c, 0x59, 0x48, 0x7, 0x8b, 0x29, 0x0,
    0xf4, 0x2, 0x80, 0x71, 0x42, 0x12, 0x40, 0x68,
    0x19, 0x82, 0x1, 0x14, 0x20, 0x44, 0x98, 0x8,
    0x18, 0x14, 0x10, 0x14, 0x20, 0x12, 0x21, 0xd1,
    0x0, 0xe8, 0x29, 0xc, 0xe, 0x44, 0x0,

    /* U+59 "Y" */
    0x4, 0xf, 0xc4, 0x4c, 0x80, 0xf6, 0xc0, 0x41,
    0x3, 0xc4, 0xf, 0xff, 0x91, 0x4, 0xf, 0xe8,
    0xaf, 0xfe, 0x54, 0x5, 0x20, 0x7c, 0x40, 0xb7,
    0xfe, 0x50, 0xf, 0xff, 0xf7, 0xff, 0x94, 0x0,
    0x40, 0xfb, 0x30,

    /* U+5A "Z" */
    0x1b, 0xff, 0x50, 0x3f, 0xf8, 0x1b, 0xfe, 0xb0,
    0xf, 0xd4, 0xf, 0xd0, 0xf, 0xc5, 0x81, 0xfa,
    0x6, 0x40, 0xf2, 0x10, 0xf, 0xd0, 0xf, 0x15,
    0x18, 0x1e, 0xdd, 0x81, 0xe6, 0x8, 0x1f, 0x41,
    0x40, 0xf4, 0x8, 0x81, 0xe2, 0x28, 0x1f, 0x98,
    0x1f, 0xb4, 0x3, 0xe3, 0x3f, 0xf3, 0x3, 0xfe,

    /* U+5B "[" */
    0x7b, 0xfb, 0x70, 0x37, 0x6, 0xfe, 0x20, 0x7f,
    0xf5, 0x18, 0x17, 0x84, 0xb, 0x42, 0x7, 0x30,
    0x3f, 0xfa, 0xc6, 0x7e, 0x38, 0x10, 0x1c,

    /* U+5C "\\" */
    0xbc, 0xf, 0xe2, 0x18, 0x1f, 0xa8, 0x80, 0x7e,
    0x28, 0x40, 0x3f, 0x40, 0xc0, 0xfc, 0x58, 0x80,
    0x7e, 0x81, 0x90, 0x3f, 0x30, 0x80, 0xfd, 0x0,
    0xff, 0xa9, 0x40, 0x7e, 0x42, 0x90, 0x3f, 0xdc,
    0xf, 0xc8, 0x14, 0x7, 0xe8, 0x20, 0x1f, 0x99,
    0x24, 0x7, 0xe8, 0x20, 0x1f, 0x91, 0x26, 0x7,
    0xe8, 0x28, 0x1f, 0x91, 0x0,

    /* U+5D "]" */
    0x9f, 0xe9, 0x4, 0x2, 0x41, 0xbe, 0x40, 0x7f,
    0xf5, 0x88, 0x1e, 0xcc, 0xd, 0x98, 0x11, 0x3,
    0xff, 0xab, 0xbe, 0x42, 0x10, 0x9, 0x0,

    /* U+5F "_" */
    0x1b, 0xff, 0x30, 0x3f, 0x80,

    /* U+61 "a" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0xff, 0xe5, 0x0, 0xff, 0xe0, 0x10, 0x3f, 0xfc,
    0xa6, 0xff, 0xe4, 0x4, 0xc0, 0xfc, 0x48, 0x29,
    0xff, 0x99, 0x20, 0x4, 0xf, 0xff, 0xcf, 0x4,
    0xf, 0x30, 0x5e, 0x40, 0x7a, 0xe0,

    /* U+62 "b" */
    0x7b, 0xff, 0x98, 0xe, 0x8, 0x1e, 0xcc, 0x1,
    0x9f, 0xf9, 0x40, 0x22, 0x7, 0xff, 0x8c, 0x81,
    0xfe, 0x37, 0xff, 0x28, 0x7, 0xff, 0x4, 0x95,
    0xff, 0xca, 0x1, 0x10, 0x3f, 0xfd, 0xe4, 0xf,
    0xf1, 0x9f, 0xf9, 0x41, 0x81, 0x3, 0xd9, 0x80,

    /* U+63 "c" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0x7f, 0xe5, 0x0, 0x88, 0x1e, 0x48, 0x7, 0xfa,
    0xd0, 0x1f, 0xfd, 0xb4, 0x7, 0xf7, 0x84, 0xf,
    0xef, 0x8, 0x1f, 0xf2, 0x3, 0xff, 0xd5, 0x68,
    0x8, 0x81, 0xe4, 0x82, 0x29, 0xff, 0x94, 0x1,
    0x40, 0xfb, 0x30,

    /* U+64 "d" */
    0x7b, 0xff, 0x98, 0xe, 0x8, 0x1e, 0xcc, 0x1,
    0x9f, 0xf9, 0x40, 0x22, 0x7, 0xff, 0xbd, 0x1,
    0xe4, 0x3, 0xc2, 0x7, 0xaa, 0x1a, 0x10, 0x3d,
    0x50, 0x12, 0x3, 0xc8, 0xf, 0xff, 0x41, 0x3,
    0xfc, 0x67, 0xfe, 0x50, 0x60, 0x40, 0xf6, 0x60,

    /* U+65 "e" */
    0x1, 0xbf, 0xf3, 0x14, 0xf, 0xd1, 0x4f, 0xfc,
    0xc0, 0x10, 0x3f, 0xfb, 0x64, 0xf, 0xc6, 0xff,
    0xb0, 0x1f, 0xfc, 0x13, 0x7f, 0xd8, 0xc, 0x40,
    0xff, 0xf2, 0x90, 0x3e, 0x8a, 0x7f, 0xe6, 0x28,
    0x1f, 0x80,

    /* U+66 "f" */
    0x1, 0xbf, 0xf3, 0x14, 0xf, 0xd1, 0x4f, 0xfc,
    0xc0, 0x10, 0x3f, 0xfb, 0x64, 0xf, 0xc6, 0xff,
    0xb0, 0x1f, 0xfc, 0x13, 0x7f, 0xd8, 0xc, 0x40,
    0xff, 0xf6, 0xf0, 0x40, 0xf9, 0xe4, 0x7, 0xc0,

    /* U+67 "g" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7f, 0xa2, 0x9f,
    0xf9, 0x81, 0x88, 0x1f, 0xfe, 0x32, 0x7, 0xf9,
    0x20, 0x14, 0xfe, 0xa0, 0x7f, 0x92, 0x0, 0x48,
    0x5, 0x3f, 0x20, 0x31, 0x3, 0xff, 0xde, 0x40,
    0xfe, 0x8a, 0x7f, 0xe5, 0x0, 0x50, 0x3e, 0xcc,
    0x0,

    /* U+68 "h" */
    0x4, 0xf, 0xc4, 0x4c, 0x80, 0xf6, 0xc0, 0x22,
    0x7, 0x88, 0x1f, 0xff, 0x42, 0x7, 0xf8, 0xdf,
    0xfc, 0x80, 0xff, 0xe0, 0x10, 0x6, 0xff, 0xe4,
    0x40, 0x88, 0x1f, 0xff, 0x9e, 0x8, 0x1e, 0x20,
    0x1e, 0x40, 0x7b, 0x60,

    /* U+69 "i" */
    0x34, 0x44, 0xc0, 0xff, 0xe3, 0x60, 0x9e, 0x2f,
    0x1e, 0x10, 0x1f, 0xfc, 0x6a, 0x98,

    /* U+6A "j" */
    0x3, 0xf9, 0x30, 0x3f, 0xd6, 0x1, 0xff, 0xff,
    0x3, 0xe2, 0x7, 0xfd, 0xc0, 0xff, 0xb8, 0x1f,
    0xf1, 0x3, 0xff, 0xb4, 0xb9, 0x3, 0xfb, 0x6,
    0x7, 0xf4, 0x53, 0xff, 0x28, 0x2, 0x81, 0xf6,
    0x60,

    /* U+6B "k" */
    0x34, 0xf, 0xa7, 0xa9, 0x81, 0xc5, 0x81, 0xfd,
    0xc4, 0x3, 0xe4, 0x49, 0x81, 0xf5, 0x10, 0xf,
    0xa0, 0x48, 0x7, 0x8b, 0x10, 0xc, 0x40, 0x40,
    0xc8, 0x11, 0xbf, 0x99, 0x80, 0x7e, 0x60, 0x78,
    0xdf, 0xcc, 0xb0, 0x38, 0x80, 0xe2, 0x1, 0xf8,
    0xa1, 0x0, 0xfd, 0x3, 0x3, 0xf1, 0x42, 0x1,
    0xfa, 0x6, 0x7, 0xe2, 0xc4, 0x0, 0x40, 0xe8,
    0x1d, 0x48, 0x7, 0x98,

    /* U+6C "l" */
    0x30, 0xf, 0xd5, 0xa0, 0x3f, 0x88, 0x1f, 0xfe,
    0xf4, 0x7, 0xe6, 0x40, 0xfc, 0xc8, 0x1f, 0xc8,
    0xf, 0xff, 0x29, 0x3, 0xe8, 0xa7, 0xfe, 0x62,
    0x81, 0xf8,

    /* U+6D "m" */
    0x8, 0xf, 0x89, 0x9, 0x50, 0x1e, 0xd8, 0x5,
    0x80, 0xe2, 0x7, 0x24, 0x3, 0x40, 0x3d, 0x0,
    0x9b, 0x1, 0xe2, 0xc0, 0x40, 0x3c, 0x85, 0x10,
    0x20, 0x3b, 0xa2, 0xd8, 0x40, 0x38, 0xc1, 0x83,
    0x3, 0x8a, 0x28, 0x4, 0x10, 0x1, 0x2, 0xb5,
    0xc0, 0xe2, 0x48, 0xf, 0x40, 0x31, 0x3, 0xff,
    0xf3, 0xc2, 0x3, 0xc8, 0x87, 0x88, 0x1e, 0xb8,
    0x0,

    /* U+6E "n" */
    0x8, 0xf, 0xc4, 0x4a, 0x80, 0xf6, 0xc0, 0x29,
    0xc8, 0x18, 0x81, 0xec, 0x40, 0xfd, 0x50, 0xc4,
    0xf, 0xd5, 0xc, 0x80, 0xfd, 0x58, 0xa8, 0xf,
    0xd1, 0x88, 0x7, 0x10, 0x29, 0x14, 0xc, 0x90,
    0xc, 0xda, 0x80, 0x2c, 0xf, 0x88, 0x2, 0x48,
    0xf, 0x40, 0x31, 0x3, 0xff, 0xf3, 0xc2, 0x3,
    0xc8, 0x87, 0x88, 0x1e, 0xb8, 0x0,

    /* U+6F "o" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0x7f, 0xe5, 0x0, 0x88, 0x1f, 0xfe, 0xf4, 0x7,
    0x90, 0xf, 0x8, 0x1e, 0xa4, 0x78, 0x40, 0xf5,
    0x20, 0x48, 0xf, 0x20, 0x3f, 0xfd, 0x4, 0xf,
    0xe8, 0xa7, 0xfe, 0x50, 0x5, 0x3, 0xec, 0xc0,

    /* U+70 "p" */
    0x7b, 0xff, 0x98, 0xe, 0x8, 0x1e, 0xcc, 0x1,
    0xbf, 0xf9, 0x40, 0x3f, 0xfe, 0x46, 0xff, 0xe5,
    0x0, 0x30, 0x3e, 0xcc, 0x2, 0x9f, 0xf9, 0x81,
    0x88, 0x1f, 0xff, 0x9e, 0x8, 0x1f, 0xcf, 0x20,
    0x3f, 0x80,

    /* U+71 "q" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0x7f, 0xe5, 0x0, 0x88, 0x1f, 0xfe, 0xf4, 0x7,
    0x90, 0xf, 0x8, 0x1e, 0xa4, 0x78, 0x40, 0x88,
    0xa, 0x40, 0x90, 0x13, 0x81, 0x1, 0xfc, 0xc8,
    0x1f, 0xcc, 0x40, 0x3f, 0x8a, 0x3, 0xfe, 0xa0,
    0x78, 0x81, 0xd0, 0xa, 0x29, 0xff, 0x65, 0x0,
    0x50, 0x3e, 0xcc, 0x0,

    /* U+72 "r" */
    0x7b, 0xff, 0x98, 0xe, 0x8, 0x1e, 0xcc, 0x1,
    0xbf, 0xf9, 0x40, 0x3f, 0xfe, 0x46, 0xff, 0xe5,
    0x0, 0x30, 0x3e, 0xcc, 0x2, 0x54, 0xff, 0x30,
    0x39, 0x44, 0x7, 0xef, 0x5, 0x40, 0x7e, 0x6c,
    0x29, 0x3, 0xf4, 0x43, 0x10, 0x3f, 0x54, 0x38,
    0x1f, 0xd4, 0x96, 0x3, 0x10, 0x36, 0x25, 0x45,
    0x48, 0x7, 0x70, 0x80,

    /* U+73 "s" */
    0x1, 0xbf, 0xf3, 0x2, 0xa0, 0x7d, 0x98, 0x8a,
    0xff, 0xe5, 0x0, 0xff, 0x34, 0x7, 0xfa, 0x50,
    0x3f, 0xfb, 0x31, 0x4f, 0xfc, 0xc0, 0xa9, 0x3,
    0xd9, 0x81, 0x6f, 0xfc, 0xa0, 0x1f, 0xfd, 0xa2,
    0x7, 0xf9, 0xe2, 0x7, 0xf7, 0xc, 0xf, 0xe8,
    0xa7, 0xfe, 0x50, 0x5, 0x3, 0xec, 0xc0,

    /* U+74 "t" */
    0x3f, 0xff, 0x10, 0x31, 0x44, 0xc, 0x7f, 0x92,
    0x5f, 0xe2, 0x7, 0xff, 0xbf, 0x2, 0x7, 0xe5,
    0x90, 0x1f, 0x96, 0x20, 0x7e, 0xc1, 0x1, 0xff,
    0xfe, 0xa5, 0x81, 0x80,

    /* U+75 "u" */
    0x30, 0xf, 0x93, 0x15, 0xa0, 0x3d, 0x60, 0x11,
    0x3, 0xff, 0xf6, 0x80, 0xf1, 0x2, 0x64, 0xf,
    0x70, 0x26, 0x40, 0xf7, 0x3, 0x20, 0x3c, 0x40,
    0xff, 0xf4, 0x10, 0x3f, 0xa2, 0x9f, 0xf9, 0x40,
    0x14, 0xf, 0xb3, 0x0,

    /* U+76 "v" */
    0x14, 0xf, 0x93, 0x11, 0x30, 0x3d, 0x60, 0x1f,
    0xff, 0xf2, 0x7, 0xfc, 0xc0, 0xf2, 0x3, 0x50,
    0x38, 0xa0, 0x14, 0x30, 0x3a, 0x4, 0xa, 0x10,
    0x8, 0xa1, 0x0, 0x40, 0xc0, 0xa0, 0x44, 0x1,
    0x42, 0x2, 0x84, 0x3, 0x40, 0xc4, 0xc, 0x81,
    0x8a, 0x15, 0x8, 0x7, 0xa0, 0x61, 0x81, 0xf1,
    0x6c, 0x20, 0x18,

    /* U+77 "w" */
    0x30, 0xf, 0x93, 0x15, 0xa0, 0x3d, 0x60, 0x11,
    0x3, 0xff, 0xf6, 0x80, 0xf1, 0x2, 0x64, 0x14,
    0xc0, 0x70, 0x26, 0x47, 0xe8, 0x87, 0x3, 0x26,
    0x40, 0x40, 0x40, 0xe8, 0x21, 0x24, 0x7, 0x60,
    0x8c, 0x10, 0xe, 0x62, 0x4, 0x80, 0x7c, 0xc8,
    0x8, 0x7, 0xd0, 0x8, 0xa0, 0x3a, 0x81, 0xd0,
    0xa, 0x96, 0x7, 0x9a, 0x7, 0x1, 0xf4, 0xa0,

    /* U+78 "x" */
    0xbc, 0xf, 0xb6, 0x10, 0xc0, 0xe4, 0x45, 0x10,
    0xe, 0x82, 0x94, 0x20, 0x12, 0x21, 0x88, 0x18,
    0x14, 0x10, 0x1, 0x42, 0x4, 0x43, 0x2, 0x81,
    0x98, 0x20, 0x18, 0xa1, 0x9, 0x30, 0x3a, 0x1,
    0x40, 0x3c, 0x59, 0x48, 0x7, 0x8b, 0x29, 0x0,
    0xf4, 0x2, 0x80, 0x71, 0x42, 0x12, 0x40, 0x68,
    0x19, 0x82, 0x1, 0x14, 0x20, 0x44, 0x98, 0x8,
    0x18, 0x14, 0x10, 0x14, 0x20, 0x12, 0x21, 0xd1,
    0x0, 0xe8, 0x29, 0xc, 0xe, 0x44, 0x0,

    /* U+79 "y" */
    0xbc, 0x81, 0xeb, 0xc1, 0x10, 0xe, 0x28, 0x4,
    0x8, 0x81, 0xa0, 0x60, 0x18, 0x80, 0x45, 0x8,
    0x2, 0x84, 0x40, 0x40, 0xc0, 0x8b, 0x10, 0x14,
    0x20, 0x1a, 0x84, 0x60, 0x60, 0x71, 0x42, 0x21,
    0x0, 0xf4, 0xc, 0x30, 0x3e, 0x32, 0xb8, 0x7,
    0xe7, 0x78, 0x1f, 0xc8, 0xe0, 0x3f, 0xff, 0xe0,
    0x79, 0x1e, 0x7, 0xfb, 0x20, 0x38,

    /* U+7A "z" */
    0x1b, 0xff, 0x50, 0x3f, 0xf8, 0x1b, 0xfe, 0xb0,
    0xf, 0xd4, 0xf, 0xd0, 0xf, 0xc5, 0x81, 0xfa,
    0x6, 0x40, 0xf2, 0x10, 0xf, 0xd0, 0xf, 0x15,
    0x18, 0x1e, 0xdd, 0x81, 0xe6, 0x8, 0x1f, 0x41,
    0x40, 0xf4, 0x8, 0x81, 0xe2, 0x28, 0x1f, 0x98,
    0x1f, 0xb4, 0x3, 0xe3, 0x3f, 0xf3, 0x3, 0xfe,

    /* U+7C "|" */
    0x34, 0x44, 0xc0, 0xff, 0xe4, 0xe0, 0x9e, 0x2f,
    0x1c, 0x10, 0x1f, 0xfc, 0x98, 0x98
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 115, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 55, .box_w = 3, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 16, .adv_w = 98, .box_w = 5, .box_h = 5, .ofs_x = -2, .ofs_y = 13},
    {.bitmap_index = 25, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 78, .adv_w = 55, .box_w = 3, .box_h = 5, .ofs_x = -2, .ofs_y = 13},
    {.bitmap_index = 83, .adv_w = 102, .box_w = 6, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 108, .adv_w = 102, .box_w = 6, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 130, .adv_w = 87, .box_w = 5, .box_h = 4, .ofs_x = -1, .ofs_y = 8},
    {.bitmap_index = 138, .adv_w = 163, .box_w = 9, .box_h = 8, .ofs_x = -1, .ofs_y = 6},
    {.bitmap_index = 161, .adv_w = 55, .box_w = 3, .box_h = 4, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 166, .adv_w = 55, .box_w = 3, .box_h = 3, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 170, .adv_w = 191, .box_w = 11, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 223, .adv_w = 197, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 271, .adv_w = 197, .box_w = 5, .box_h = 19, .ofs_x = 2, .ofs_y = 0},
    {.bitmap_index = 295, .adv_w = 197, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 337, .adv_w = 197, .box_w = 11, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 365, .adv_w = 197, .box_w = 12, .box_h = 20, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 406, .adv_w = 197, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 448, .adv_w = 197, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 486, .adv_w = 197, .box_w = 11, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 538, .adv_w = 197, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 584, .adv_w = 197, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 626, .adv_w = 55, .box_w = 3, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 635, .adv_w = 55, .box_w = 3, .box_h = 10, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 646, .adv_w = 74, .box_w = 4, .box_h = 16, .ofs_x = -1, .ofs_y = 2},
    {.bitmap_index = 670, .adv_w = 157, .box_w = 9, .box_h = 10, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 684, .adv_w = 74, .box_w = 4, .box_h = 16, .ofs_x = -1, .ofs_y = 2},
    {.bitmap_index = 708, .adv_w = 175, .box_w = 10, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 745, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 783, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 823, .adv_w = 194, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 866, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 906, .adv_w = 175, .box_w = 10, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 940, .adv_w = 175, .box_w = 10, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 972, .adv_w = 194, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1013, .adv_w = 194, .box_w = 12, .box_h = 20, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1049, .adv_w = 55, .box_w = 3, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1063, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1099, .adv_w = 192, .box_w = 11, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1159, .adv_w = 175, .box_w = 10, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1185, .adv_w = 333, .box_w = 20, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1248, .adv_w = 194, .box_w = 12, .box_h = 20, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 1302, .adv_w = 194, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1342, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1376, .adv_w = 194, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1428, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1480, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1527, .adv_w = 186, .box_w = 11, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1555, .adv_w = 194, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1591, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1642, .adv_w = 333, .box_w = 20, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1705, .adv_w = 191, .box_w = 11, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1776, .adv_w = 194, .box_w = 12, .box_h = 20, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1811, .adv_w = 164, .box_w = 10, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1859, .adv_w = 110, .box_w = 6, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1882, .adv_w = 191, .box_w = 11, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1935, .adv_w = 110, .box_w = 6, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 1958, .adv_w = 156, .box_w = 9, .box_h = 2, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1963, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2001, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2041, .adv_w = 194, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2084, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2124, .adv_w = 175, .box_w = 10, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2158, .adv_w = 175, .box_w = 10, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2190, .adv_w = 194, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2231, .adv_w = 194, .box_w = 12, .box_h = 20, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2267, .adv_w = 55, .box_w = 3, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2281, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2314, .adv_w = 192, .box_w = 11, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2374, .adv_w = 175, .box_w = 10, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2400, .adv_w = 194, .box_w = 12, .box_h = 20, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 2457, .adv_w = 194, .box_w = 12, .box_h = 20, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 2511, .adv_w = 194, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2551, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2585, .adv_w = 194, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2637, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2689, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2736, .adv_w = 186, .box_w = 11, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2764, .adv_w = 194, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2800, .adv_w = 195, .box_w = 12, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2851, .adv_w = 194, .box_w = 12, .box_h = 20, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 2907, .adv_w = 191, .box_w = 11, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 2978, .adv_w = 195, .box_w = 12, .box_h = 20, .ofs_x = -1, .ofs_y = -1},
    {.bitmap_index = 3032, .adv_w = 164, .box_w = 10, .box_h = 19, .ofs_x = -1, .ofs_y = 0},
    {.bitmap_index = 3080, .adv_w = 55, .box_w = 3, .box_h = 21, .ofs_x = -1, .ofs_y = -1}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/

static const uint8_t glyph_id_ofs_list_0[] = {
    0, 1, 2, 0, 3, 0, 0, 4,
    5, 6, 7, 8, 9
};

static const uint8_t glyph_id_ofs_list_3[] = {
    0, 0, 1, 2, 3, 4, 5, 6,
    7, 8, 9, 10, 11, 12, 13, 14,
    15, 16, 17, 18, 19, 20, 21, 22,
    23, 24, 25, 26, 0, 27
};

/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 13, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = glyph_id_ofs_list_0, .list_length = 13, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_FULL
    },
    {
        .range_start = 46, .range_length = 18, .glyph_id_start = 11,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 65, .range_length = 29, .glyph_id_start = 29,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    },
    {
        .range_start = 95, .range_length = 30, .glyph_id_start = 58,
        .unicode_list = NULL, .glyph_id_ofs_list = glyph_id_ofs_list_3, .list_length = 30, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_FULL
    }
};



/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = NULL,
    .kern_scale = 0,
    .cmap_num = 4,
    .bpp = 3,
    .kern_classes = 0,
    .bitmap_format = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t liquidCrystal_nor_24 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 21,          /*The maximum line height required by the font*/
    .base_line = 1,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if LIQUIDCRYSTAL_NOR_24*/

