#include <lvgl/lvgl.h>

/*******************************************************************************
 * Size: 16 px
 * Bpp: 3
 * Opts: --font ../font/Roboto/Roboto-Light.ttf -r 0x20-0x7F --size 16 --format lvgl --bpp 3 --lv-include lvgl/lvgl.h  -o robot_light_16.c
 ******************************************************************************/

#ifndef ROBOT_LIGHT_16
#define ROBOT_LIGHT_16 1
#endif

#if ROBOT_LIGHT_16

/*-----------------
 *    BITMAPS
 *----------------*/

/*Store the image of the glyphs*/
static LV_ATTRIBUTE_LARGE_CONST const uint8_t gylph_bitmap[] = {
    /* U+20 " " */

    /* U+21 "!" */
    0xa8, 0xf, 0x98, 0x1e, 0xe1, 0x12, 0x11, 0x0,

    /* U+22 "\"" */
    0xc3, 0x0, 0x6c, 0x3, 0xc,

    /* U+23 "#" */
    0x3, 0x60, 0x14, 0xf, 0x30, 0xc, 0xe, 0x58,
    0x3, 0x2, 0x9a, 0xd6, 0xc5, 0x90, 0x99, 0x6c,
    0xb5, 0x90, 0x13, 0x1, 0xd8, 0x1f, 0x89, 0x1,
    0xcc, 0x3, 0x2, 0x3b, 0x1e, 0xc3, 0xa0, 0x3a,
    0xcd, 0xde, 0x80, 0x59, 0x5, 0x80, 0xe6, 0x3,
    0xb0, 0x20,

    /* U+24 "$" */
    0x3, 0x60, 0x3c, 0x41, 0x3, 0x5e, 0xa6, 0x0,
    0xc6, 0x95, 0x41, 0xb8, 0x15, 0x40, 0x81, 0x8c,
    0x16, 0x10, 0x24, 0xc, 0xd5, 0x1, 0x97, 0xe9,
    0x80, 0xe5, 0x95, 0xc, 0xd, 0x10, 0x80, 0x7c,
    0xe8, 0x15, 0x62, 0x1d, 0xa3, 0x0, 0x4c, 0x34,
    0x3, 0xa8, 0x10,

    /* U+25 "%" */
    0xa, 0xd3, 0x3, 0xf4, 0xb5, 0x88, 0x6, 0x4,
    0x50, 0xc, 0xc3, 0x3, 0x14, 0x3, 0x31, 0x98,
    0x1b, 0xda, 0xe6, 0x70, 0x38, 0xda, 0x44, 0x90,
    0x1f, 0xd2, 0xab, 0x40, 0x79, 0x63, 0xec, 0xa0,
    0x77, 0x6b, 0x82, 0x7, 0x4e, 0x7, 0xfc, 0x82,
    0xc0, 0x7d, 0x0, 0x1f, 0x6a, 0x0,

    /* U+26 "&" */
    0x0, 0x76, 0x88, 0x1d, 0xfb, 0x48, 0x3, 0xc4,
    0x26, 0x7, 0x10, 0xd, 0x1, 0xce, 0x46, 0x80,
    0x74, 0x66, 0x81, 0xed, 0x19, 0x0, 0x80, 0x68,
    0xff, 0x0, 0x80, 0x48, 0x19, 0x88, 0x11, 0x2,
    0x57, 0x40, 0xa, 0x1, 0x60, 0x40, 0x51, 0xb6,
    0xf4, 0x80,

    /* U+27 "'" */
    0x18, 0x30, 0x2c,

    /* U+28 "(" */
    0x3, 0xca, 0x0, 0xf0, 0x48, 0x0, 0x88, 0x68,
    0x7, 0xc0, 0x13, 0x2, 0x20, 0x8, 0x11, 0x2,
    0x64, 0x1, 0x40, 0x2e, 0x0, 0x58, 0x15, 0x60,
    0x1e, 0x20, 0x2a,

    /* U+29 ")" */
    0x3, 0x9b, 0x1, 0x3c, 0x40, 0xa4, 0x1, 0x10,
    0x40, 0xb2, 0x2, 0x58, 0x8, 0xa0, 0x3f, 0xf8,
    0xe4, 0x9, 0x30, 0x2d, 0xc0, 0x92, 0x0, 0x74,
    0x1, 0xcc, 0x2, 0xa0, 0x40,

    /* U+2A "*" */
    0x2, 0xc0, 0x7f, 0xa4, 0x16, 0x6b, 0x9a, 0x2b,
    0x18, 0x41, 0x82, 0x1, 0x98, 0x48, 0xa, 0xa,
    0xc0,

    /* U+2B "+" */
    0x3, 0x40, 0x3f, 0x30, 0x3f, 0xf9, 0x4b, 0xf8,
    0x7f, 0x24, 0xfe, 0x1f, 0xc8, 0xf, 0xfe, 0x78,

    /* U+2C "," */
    0x18, 0x80, 0x20, 0x4a, 0x0,

    /* U+2D "-" */
    0x9b, 0x40,

    /* U+2E "." */
    0x22, 0x20,

    /* U+2F "/" */
    0x3, 0x1a, 0x6, 0xbc, 0xc, 0x90, 0x9, 0x20,
    0x1b, 0xd0, 0x33, 0x20, 0x4e, 0x81, 0xb3, 0x2,
    0x20, 0x72, 0xe0, 0x6a, 0x80, 0x8b, 0x3, 0x5e,
    0x6,

    /* U+30 "0" */
    0x0, 0xf6, 0x90, 0x5, 0x76, 0xa1, 0x1e, 0x1,
    0x5a, 0x9, 0x0, 0x92, 0x1, 0xe2, 0x40, 0x7f,
    0xf4, 0x89, 0x4, 0x80, 0x49, 0x7, 0x80, 0x56,
    0x82, 0x9b, 0x50, 0x80,

    /* U+31 "1" */
    0x0, 0xab, 0x5b, 0x0, 0x3d, 0x8, 0x20, 0x7f,
    0xf8, 0x0,

    /* U+32 "2" */
    0x0, 0xf6, 0x90, 0x14, 0xfb, 0x3c, 0x20, 0x1c,
    0x0, 0x6d, 0x0, 0x80, 0x62, 0x4, 0xc0, 0xdb,
    0x0, 0xf1, 0x48, 0x7, 0xbf, 0x1, 0xeb, 0x8,
    0x1d, 0x32, 0x3, 0x99, 0x60, 0x72, 0xb4, 0x7,
    0xa9, 0xdb, 0x88,

    /* U+33 "3" */
    0x1, 0x36, 0x90, 0x8, 0x36, 0xa2, 0xe, 0x1,
    0x4c, 0x38, 0x1f, 0xf1, 0x94, 0xa, 0xfd, 0x8,
    0x15, 0xfa, 0x10, 0x38, 0xf8, 0x18, 0x18, 0xb1,
    0x0, 0xc5, 0x87, 0x0, 0xa7, 0x13, 0xed, 0x74,

    /* U+34 "4" */
    0x3, 0xa6, 0x3, 0xc5, 0x1, 0xf7, 0x80, 0x79,
    0xa6, 0x7, 0xac, 0x3, 0xd6, 0x1, 0xe4, 0x10,
    0x1e, 0x94, 0xf, 0x33, 0xb5, 0xce, 0x6d, 0xf6,
    0xb9, 0xcc, 0xf, 0xfe, 0x30,

    /* U+35 "5" */
    0x1b, 0xfd, 0x80, 0xbf, 0xd8, 0x1, 0x3, 0xe2,
    0x7, 0x88, 0xbb, 0x18, 0x13, 0x9b, 0xd6, 0xd,
    0x20, 0xe8, 0x7, 0xc4, 0x10, 0x3e, 0x4c, 0xc,
    0x43, 0xa4, 0x4, 0x60, 0x3c, 0xd8, 0x20,

    /* U+36 "6" */
    0x0, 0x6e, 0x80, 0x4b, 0xcd, 0x0, 0xa6, 0x20,
    0x69, 0x40, 0xf2, 0x4b, 0xb1, 0x80, 0x3e, 0x6f,
    0x50, 0xe, 0x41, 0xf0, 0x1, 0x2, 0x24, 0x7,
    0xf2, 0x40, 0x22, 0x42, 0x41, 0x1, 0xe0, 0x3f,
    0xb6, 0x54, 0x0,

    /* U+37 "7" */
    0x5b, 0x7b, 0x85, 0xb7, 0x74, 0x7, 0xd3, 0x81,
    0xf3, 0x40, 0x7a, 0x50, 0x3e, 0x4c, 0xf, 0x34,
    0x7, 0xd6, 0x80, 0xf1, 0x64, 0xf, 0x4e, 0x7,
    0xcd, 0x1, 0xe9, 0x40, 0xe0,

    /* U+38 "8" */
    0x0, 0xf6, 0x98, 0x13, 0xdb, 0x54, 0x2, 0xc0,
    0x29, 0xc0, 0xff, 0xa4, 0x0, 0x32, 0x0, 0x2d,
    0xfb, 0x52, 0x1, 0xef, 0xda, 0xa0, 0x12, 0x80,
    0x3e, 0x2, 0x40, 0x62, 0x40, 0x90, 0x1f, 0x9c,
    0x2, 0xb0, 0x4, 0xfb, 0x66, 0x0,

    /* U+39 "9" */
    0x0, 0xf6, 0x88, 0x7, 0xb5, 0xf8, 0x4, 0xa0,
    0xd, 0x84, 0x80, 0xc8, 0x81, 0xe2, 0xc9, 0x1,
    0x90, 0x9, 0x40, 0x28, 0x1, 0xed, 0xa3, 0x0,
    0xf6, 0x43, 0x80, 0xf5, 0x60, 0x63, 0xa8, 0x14,
    0xd2, 0x18,

    /* U+3A ":" */
    0xc7, 0x92, 0x3, 0xf8, 0x8e, 0x40,

    /* U+3B ";" */
    0x1c, 0x8c, 0x41, 0x3, 0xff, 0x85, 0x0, 0x20,
    0x4, 0x28, 0x13, 0x0,

    /* U+3C "<" */
    0x3, 0xd0, 0xc, 0x66, 0xe0, 0xd, 0xfb, 0x18,
    0x5b, 0xe4, 0x4, 0xa4, 0x80, 0xe7, 0xbe, 0x84,
    0xc, 0xf7, 0xe0, 0x3c, 0xf0,

    /* U+3D "=" */
    0xbf, 0xf4, 0xbf, 0xf4, 0x3, 0xeb, 0xff, 0x40,

    /* U+3E ">" */
    0x10, 0x81, 0xef, 0xd4, 0x81, 0x9e, 0xf2, 0xa0,
    0x32, 0xb2, 0x40, 0x67, 0xd4, 0x6, 0x61, 0xa0,
    0xf, 0xd9, 0x81, 0xb3, 0x3, 0x80,

    /* U+3F "?" */
    0x6, 0xec, 0x60, 0x3c, 0xd9, 0x49, 0x22, 0x2,
    0xd1, 0x80, 0x7f, 0xad, 0x1, 0xa2, 0x20, 0x4c,
    0xc0, 0x34, 0xa0, 0x73, 0x3, 0xd0, 0xf, 0x10,
    0x3d, 0x80, 0x80,

    /* U+40 "@" */
    0x3, 0x19, 0xad, 0x90, 0x1e, 0x7e, 0xeb, 0x63,
    0x40, 0xcb, 0x61, 0x3, 0x3f, 0x0, 0xa5, 0x0,
    0xed, 0x20, 0x88, 0x7, 0x40, 0x3f, 0x6a, 0x0,
    0xec, 0x66, 0x2, 0xc0, 0x39, 0x70, 0xc0, 0x24,
    0x2, 0x60, 0x44, 0xc, 0x70, 0x2, 0x7, 0xf7,
    0x3, 0x10, 0x4, 0x80, 0xfc, 0x80, 0x9e, 0xc,
    0x6, 0xc0, 0x18, 0x80, 0xe8, 0x68, 0x11, 0xb6,
    0x36, 0xa0, 0x6, 0x88, 0xb6, 0x12, 0xd1, 0x2,
    0xfc, 0xc0, 0xff, 0x8e, 0x16, 0xe6, 0x6,

    /* U+41 "A" */
    0x3, 0x5a, 0x3, 0xf3, 0x60, 0x3e, 0x4b, 0x1,
    0xef, 0xb3, 0x81, 0xe4, 0xb0, 0x1c, 0xd8, 0x3,
    0x60, 0x35, 0xa0, 0x1a, 0x81, 0x13, 0x0, 0x44,
    0x80, 0x51, 0xb6, 0x14, 0x2, 0xdb, 0xc8, 0x10,
    0x40, 0xc4, 0x1b, 0x40, 0x7a, 0xd0,

    /* U+42 "B" */
    0x9f, 0x6a, 0x90, 0x13, 0x6a, 0x62, 0x7, 0x16,
    0x80, 0xff, 0xe0, 0xa4, 0x62, 0x6c, 0xf6, 0x0,
    0x9b, 0x3e, 0x88, 0xe, 0x3f, 0x80, 0xf1, 0x40,
    0x78, 0x90, 0x1c, 0x7c, 0x13, 0x6b, 0xc4,

    /* U+43 "C" */
    0x1, 0x36, 0x98, 0x16, 0xfb, 0x5e, 0x6, 0xe0,
    0x28, 0x8e, 0xe0, 0x75, 0x69, 0x0, 0xe6, 0x80,
    0xff, 0xe7, 0xa4, 0x3, 0x9a, 0xdc, 0xe, 0xad,
    0xe0, 0x28, 0x88, 0xdf, 0x6b, 0xc0,

    /* U+44 "D" */
    0x9f, 0x6a, 0x1, 0xa6, 0xdc, 0x40, 0xf2, 0x9c,
    0xf, 0x90, 0x20, 0x7c, 0x90, 0xf, 0xb8, 0x1f,
    0xfc, 0x5e, 0x7, 0xe4, 0x80, 0x79, 0x2, 0x7,
    0x29, 0xc0, 0x4d, 0xb8, 0x80,

    /* U+45 "E" */
    0x9f, 0x6e, 0x62, 0x6d, 0xcc, 0xf, 0xfe, 0x6c,
    0xdb, 0x40, 0x13, 0x6d, 0x0, 0xff, 0xeb, 0x4d,
    0xb9, 0x80,

    /* U+46 "F" */
    0x9f, 0x6e, 0x62, 0x6d, 0xcc, 0xf, 0xfe, 0xac,
    0xdb, 0x40, 0x13, 0x6d, 0x0, 0xff, 0xea, 0x80,

    /* U+47 "G" */
    0x0, 0xf6, 0xa0, 0x15, 0xfb, 0x5f, 0x4, 0xe0,
    0x13, 0x4f, 0xc0, 0x3a, 0xa6, 0xc0, 0x71, 0x20,
    0x40, 0xff, 0x96, 0xd4, 0x4, 0x2, 0xd9, 0xa,
    0x40, 0x3e, 0xd4, 0xf, 0x92, 0x50, 0x23, 0xf0,
    0x9b, 0x69, 0xd8,

    /* U+48 "H" */
    0x8c, 0xf, 0x70, 0x3f, 0xfb, 0x33, 0x6f, 0x0,
    0x9b, 0x78, 0xf, 0xff, 0x10,

    /* U+49 "I" */
    0x50, 0xf, 0xfe, 0x50,

    /* U+4A "J" */
    0x3, 0xd1, 0x81, 0xff, 0xec, 0x24, 0x7, 0x9c,
    0x3, 0x25, 0x34, 0x1, 0x82, 0x3f, 0x6d, 0x80,

    /* U+4B "K" */
    0x8c, 0xc, 0x70, 0x1e, 0x3f, 0x80, 0xf7, 0xe2,
    0x7, 0x68, 0x40, 0xed, 0x50, 0x1d, 0x43, 0x3,
    0xa1, 0x70, 0xe, 0x52, 0xa4, 0x3, 0x60, 0x1e,
    0x90, 0x3c, 0x6f, 0x3, 0xe4, 0x94, 0xf, 0xa0,
    0x60,

    /* U+4C "L" */
    0x8c, 0xf, 0xff, 0xf8, 0x1f, 0xfc, 0x9, 0xb7,
    0x0,

    /* U+4D "M" */
    0x9c, 0xf, 0xdd, 0x80, 0x40, 0x79, 0x81, 0x3e,
    0x7, 0xab, 0x1, 0x98, 0x1c, 0x98, 0x1a, 0xb0,
    0x37, 0xe0, 0x22, 0xe8, 0x19, 0xa0, 0x39, 0xa0,
    0xe, 0x81, 0xef, 0xc0, 0x2b, 0x3, 0xc9, 0x84,
    0xc0, 0xfd, 0x5f, 0xe0, 0x3f, 0x3a, 0xd0, 0x1f,
    0xce, 0x81, 0xc0,

    /* U+4E "N" */
    0x94, 0xf, 0x70, 0x90, 0xf, 0x9d, 0x3, 0xef,
    0x28, 0x1f, 0x36, 0x40, 0x7d, 0xe0, 0x1f, 0x15,
    0x0, 0xfa, 0x22, 0x7, 0xd3, 0x81, 0xf2, 0x70,
    0xf, 0xab, 0x3, 0xf5, 0x0,

    /* U+4F "O" */
    0x2, 0x9b, 0x4c, 0xd, 0x86, 0xda, 0x0, 0x6d,
    0x0, 0xaa, 0x22, 0xc0, 0x3a, 0xd0, 0x24, 0x7,
    0x24, 0x3, 0xf1, 0x3, 0xff, 0x8e, 0x40, 0x12,
    0x3, 0x92, 0xb, 0x0, 0xeb, 0x41, 0xb8, 0xa,
    0x22, 0x3, 0x7d, 0xaf, 0x0,

    /* U+50 "P" */
    0x9f, 0x6c, 0xc0, 0xa6, 0xdd, 0x0, 0xfa, 0xb0,
    0x3f, 0x10, 0x3f, 0x10, 0x3e, 0xac, 0x4, 0xdb,
    0xa0, 0x9, 0xb6, 0x60, 0x7f, 0xf6, 0x80,

    /* U+51 "Q" */
    0x2, 0x9b, 0x4c, 0xd, 0xbe, 0xda, 0x0, 0x6e,
    0x2, 0xa8, 0x8b, 0x0, 0xeb, 0x40, 0x90, 0x1c,
    0x48, 0xf, 0xcd, 0x80, 0xff, 0xe3, 0x36, 0x4,
    0x80, 0xe2, 0x42, 0xc0, 0x3a, 0xd0, 0x6e, 0x2,
    0xa8, 0x80, 0xdf, 0x69, 0xc0, 0x34, 0xda, 0x54,
    0xf, 0xd3, 0x20,

    /* U+52 "R" */
    0x9f, 0x6c, 0x80, 0xa6, 0xd7, 0x8c, 0xf, 0x1f,
    0x40, 0xf8, 0x90, 0x1f, 0x12, 0x3, 0xc7, 0xc0,
    0x13, 0x67, 0xd1, 0x0, 0x9b, 0x38, 0x40, 0x7d,
    0x20, 0xf, 0x9a, 0x20, 0x7d, 0x60, 0x1f, 0x36,
    0x20,

    /* U+53 "S" */
    0x0, 0xb6, 0xa9, 0x0, 0xfe, 0xd7, 0xc4, 0x48,
    0x2, 0x52, 0x81, 0xf3, 0xc2, 0x70, 0x39, 0x7,
    0x75, 0x40, 0x73, 0xdf, 0x76, 0x7, 0x29, 0xeb,
    0x28, 0xe, 0xf4, 0x50, 0x39, 0x82, 0xe8, 0x11,
    0x90, 0x26, 0xdb, 0xc4,

    /* U+54 "T" */
    0x9b, 0x5f, 0xb6, 0x8c, 0xda, 0x57, 0x68, 0x81,
    0xff, 0xff, 0x3, 0xff, 0x9a,

    /* U+55 "U" */
    0xa4, 0xe, 0xa8, 0xf, 0xff, 0xa3, 0x3, 0x9b,
    0x1c, 0x7, 0x12, 0x8d, 0x1, 0x56, 0x3, 0x7e,
    0xda, 0x80,

    /* U+56 "V" */
    0x8c, 0xf, 0x47, 0x68, 0xf, 0x36, 0x20, 0x81,
    0x91, 0x0, 0x90, 0xd, 0xe8, 0xb, 0x40, 0x64,
    0xc0, 0x10, 0x40, 0x24, 0x3, 0x5a, 0x1, 0xf8,
    0xc, 0xd0, 0x4, 0x80, 0x78, 0xa4, 0x3, 0xd6,
    0xbf, 0x1, 0xe6, 0xc9, 0x0, 0xf9, 0x30, 0x30,

    /* U+57 "W" */
    0x70, 0xc, 0xb0, 0x18, 0xe4, 0x80, 0x6c, 0x40,
    0xc9, 0x9, 0x1, 0x93, 0x40, 0x5b, 0x2, 0x40,
    0x5, 0xdc, 0x4, 0xd0, 0xd8, 0x1, 0x62, 0x80,
    0xf2, 0x40, 0x19, 0x6, 0x42, 0x40, 0x4, 0x80,
    0x32, 0x32, 0x1b, 0x0, 0x91, 0x48, 0x1, 0x60,
    0x90, 0xb, 0x2d, 0x80, 0xb, 0x3, 0xcb, 0x24,
    0x2, 0x51, 0x1, 0x8b, 0x60, 0x36, 0x7c, 0xe,
    0x78, 0xc, 0x82, 0x0,

    /* U+58 "X" */
    0x3c, 0xe, 0x38, 0x19, 0x40, 0xde, 0x0, 0x6c,
    0x80, 0x36, 0x40, 0x5e, 0x3, 0x28, 0x18, 0xa9,
    0xe0, 0x1e, 0x8c, 0x30, 0x3f, 0xf8, 0x96, 0x36,
    0x3, 0x93, 0x6b, 0x8, 0x1a, 0xf0, 0x17, 0x81,
    0x46, 0x40, 0x26, 0xc0, 0xa8, 0x6, 0x90, 0x0,

    /* U+59 "Y" */
    0x90, 0x7, 0xb8, 0x8c, 0x81, 0xa3, 0x1, 0x20,
    0xc, 0xe0, 0x6, 0xc4, 0x4, 0x80, 0x34, 0x80,
    0x53, 0x3, 0x26, 0xa4, 0x1, 0xef, 0x1a, 0x3,
    0xc4, 0x40, 0x3f, 0x30, 0x3f, 0xfa, 0xe0,

    /* U+5A "Z" */
    0x1b, 0x7b, 0xc1, 0xb7, 0x8d, 0x3, 0xd2, 0x90,
    0x39, 0x23, 0x3, 0xd3, 0x81, 0xe8, 0x88, 0x1c,
    0x54, 0x3, 0xdf, 0x80, 0xf4, 0x44, 0xe, 0x2a,
    0x1, 0xef, 0x0, 0xf2, 0x33, 0x6f, 0x0,

    /* U+5B "[" */
    0xba, 0x8f, 0x40, 0xff, 0xee, 0x7a,

    /* U+5C "\\" */
    0x6c, 0x7, 0x3a, 0x7, 0x99, 0x3, 0xbd, 0x3,
    0x92, 0x1, 0xe4, 0x80, 0x76, 0xe0, 0x72, 0x60,
    0x79, 0x30, 0x3a, 0xd0, 0x1c, 0x41, 0x3, 0xaa,
    0x3, 0x9d, 0x0,

    /* U+5D "]" */
    0xd9, 0x34, 0x3, 0xff, 0xb9, 0xa0,

    /* U+5E "^" */
    0x0, 0xb0, 0x1b, 0x82, 0x4, 0xe5, 0x0, 0xea,
    0x40, 0x15, 0x84, 0xcb, 0x1, 0x68,

    /* U+5F "_" */
    0xdb, 0xd4,

    /* U+60 "`" */
    0xc, 0xd, 0x0, 0x32, 0x40,

    /* U+61 "a" */
    0x1, 0x36, 0x88, 0x8, 0x36, 0x7c, 0x0, 0xc0,
    0x5, 0x11, 0x40, 0xe6, 0x1, 0xda, 0xc8, 0x6,
    0x16, 0xb2, 0x4, 0x30, 0x38, 0x98, 0x3, 0x40,
    0x2f, 0xd8, 0x21,

    /* U+62 "b" */
    0xc4, 0xf, 0xfe, 0x5b, 0xbb, 0xb0, 0x29, 0x77,
    0xa8, 0x7, 0x2, 0xfc, 0x7, 0x8a, 0x3, 0xff,
    0x94, 0x90, 0x4, 0x2, 0x9c, 0x7, 0xbb, 0xd4,
    0x0,

    /* U+63 "c" */
    0x0, 0xf6, 0x88, 0x7, 0xb5, 0xf8, 0x89, 0x40,
    0x1a, 0x89, 0x1, 0x9b, 0xc0, 0x79, 0xb0, 0x1e,
    0x24, 0x6, 0x4c, 0x4a, 0x0, 0xc4, 0x1e, 0xd7,
    0xe2,

    /* U+64 "d" */
    0x3, 0xca, 0x81, 0xff, 0xc6, 0x9f, 0x50, 0x26,
    0x7e, 0x90, 0x2, 0xc0, 0x6, 0x0, 0x24, 0x7,
    0x12, 0x3, 0xc4, 0x80, 0xf8, 0x90, 0x1e, 0xb0,
    0x1, 0x80, 0x1e, 0xfa, 0x40,

    /* U+65 "e" */
    0x0, 0xb6, 0x88, 0x7, 0x36, 0x4e, 0x2, 0x70,
    0x9, 0x19, 0x30, 0x16, 0xec, 0xed, 0xa0, 0x6b,
    0x6e, 0x85, 0x81, 0xf5, 0xa0, 0x28, 0x43, 0xfb,
    0x5c, 0x80,

    /* U+66 "f" */
    0x0, 0x6e, 0x40, 0x3f, 0x64, 0x0, 0xa0, 0x31,
    0x2, 0x78, 0xea, 0x1e, 0x3a, 0x81, 0xff, 0xdf,

    /* U+67 "g" */
    0x1, 0x3e, 0xaa, 0x86, 0x7e, 0x90, 0x2, 0xc0,
    0x6, 0x0, 0x24, 0x7, 0x12, 0x3, 0xc4, 0x80,
    0xf8, 0x90, 0x1e, 0xb0, 0x1, 0x80, 0x19, 0xfa,
    0x50, 0x29, 0xf5, 0x18, 0x36, 0x0, 0x6b, 0xf,
    0xec, 0xfc, 0x0,

    /* U+68 "h" */
    0xc4, 0xf, 0xfe, 0x4c, 0xd8, 0xc0, 0x7b, 0xb2,
    0xa1, 0x8, 0xb, 0x83, 0x2, 0x20, 0x7f, 0xf6,
    0x0,

    /* U+69 "i" */
    0xaa, 0x22, 0x2a, 0x3, 0xff, 0x88,

    /* U+6A "j" */
    0x1, 0x50, 0x8, 0x80, 0x10, 0x2a, 0x40, 0xff,
    0xed, 0x23, 0x74, 0x0,

    /* U+6B "k" */
    0xc4, 0xf, 0xfe, 0x59, 0xc0, 0x63, 0xf8, 0x8,
    0xfe, 0x20, 0x1e, 0xe4, 0xa, 0x94, 0x6, 0xba,
    0x90, 0x26, 0x27, 0x3, 0x95, 0xa0, 0x39, 0x86,

    /* U+6C "l" */
    0xa8, 0xf, 0xfe, 0x50,

    /* U+6D "m" */
    0xc6, 0xee, 0xc3, 0xde, 0x81, 0x48, 0xde, 0xd0,
    0xdf, 0x50, 0x1c, 0x80, 0xad, 0x80, 0x34, 0x1,
    0x1, 0x90, 0x1f, 0xff, 0xb0,

    /* U+6E "n" */
    0xc6, 0x6c, 0x60, 0x25, 0xd9, 0x50, 0xe4, 0x5,
    0xc1, 0x81, 0x10, 0x3f, 0xfb, 0x0,

    /* U+6F "o" */
    0x0, 0xb6, 0x90, 0x13, 0xfb, 0x51, 0x80, 0x94,
    0xb, 0x40, 0x48, 0xe, 0x24, 0xd8, 0xe, 0x61,
    0xb0, 0x1c, 0xc1, 0x20, 0x31, 0x30, 0x94, 0xb,
    0xc0, 0xf, 0x6d, 0x18,

    /* U+70 "p" */
    0xc6, 0xee, 0xc0, 0xa5, 0xde, 0xa0, 0x10, 0xa,
    0x70, 0x3c, 0x90, 0xf, 0xfe, 0x52, 0x40, 0x10,
    0xa, 0x70, 0x1e, 0xec, 0xa8, 0x3, 0xbb, 0x18,
    0x1f, 0xfc, 0x60,

    /* U+71 "q" */
    0x1, 0x3e, 0xaa, 0x86, 0x7e, 0x90, 0x2, 0xc0,
    0x6, 0x0, 0x24, 0x7, 0x12, 0x3, 0xc4, 0x80,
    0xf8, 0x90, 0x1e, 0xb0, 0xa, 0x0, 0x67, 0xeb,
    0x40, 0x53, 0xea, 0x40, 0xff, 0xe2, 0x80,

    /* U+72 "r" */
    0xcb, 0x72, 0x27, 0xe2, 0x21, 0x2, 0x60, 0x7f,
    0xf4, 0x0,

    /* U+73 "s" */
    0x1, 0x76, 0x52, 0x2, 0xed, 0x7e, 0x0, 0x98,
    0x5, 0x40, 0x3a, 0x40, 0x30, 0x13, 0xcd, 0x0,
    0xca, 0xef, 0x80, 0x30, 0x26, 0x8, 0xa8, 0x1,
    0x30, 0xfd, 0xb2, 0x60,

    /* U+74 "t" */
    0x5, 0x1, 0x3e, 0x7, 0xd6, 0x2c, 0xac, 0x59,
    0x1, 0xff, 0xce, 0x6c, 0x4, 0x5e, 0x60,

    /* U+75 "u" */
    0xc4, 0x9, 0x40, 0x3f, 0xfa, 0xec, 0xc, 0x46,
    0x80, 0xd, 0xc, 0xec, 0x94, 0x0,

    /* U+76 "v" */
    0x8c, 0xd, 0x8d, 0xa0, 0x38, 0x90, 0x20, 0x1a,
    0x1, 0x50, 0xb, 0x40, 0x1d, 0x2, 0x20, 0x62,
    0xe8, 0x1a, 0xd9, 0x81, 0x9b, 0x1, 0xf2, 0xa0,
    0x40,

    /* U+77 "w" */
    0x50, 0xa, 0x40, 0x14, 0x69, 0x0, 0x92, 0x1,
    0x26, 0x6, 0x2d, 0x88, 0x1c, 0x90, 0x2d, 0x88,
    0x24, 0x1, 0xb0, 0x66, 0xb0, 0xd8, 0x1, 0x20,
    0x60, 0xb0, 0x90, 0x9, 0xb5, 0x0, 0x9b, 0x1,
    0xb4, 0x40, 0x2d, 0x60, 0x32, 0x4, 0x1, 0x24,
    0x0,

    /* U+78 "x" */
    0x38, 0x8, 0xe0, 0x54, 0x1, 0xe0, 0x8, 0x8b,
    0x64, 0x5, 0xfa, 0xd0, 0x18, 0x84, 0x7, 0x26,
    0x88, 0x1a, 0x59, 0xc0, 0xad, 0x4, 0xd8, 0x26,
    0xc0, 0x2c, 0x0,

    /* U+79 "y" */
    0x8c, 0xd, 0x8d, 0xa0, 0x22, 0x9, 0x2, 0x1,
    0x50, 0x16, 0x80, 0x56, 0x1, 0xa0, 0xc, 0xc,
    0xcb, 0xc0, 0x6f, 0x69, 0x81, 0x92, 0x30, 0x3c,
    0xf8, 0x1e, 0x68, 0xe, 0x68, 0xc, 0x7e, 0x80,
    0x60,

    /* U+7A "z" */
    0x3b, 0x6f, 0xc0, 0xed, 0x94, 0x3, 0x93, 0x60,
    0x3a, 0x70, 0x3a, 0xd1, 0x3, 0x30, 0xc0, 0xc6,
    0xd0, 0x1d, 0xe0, 0x1c, 0x8c, 0xdb, 0x20,

    /* U+7B "{" */
    0x3, 0x30, 0x36, 0x20, 0x4d, 0x20, 0x17, 0xc0,
    0x62, 0x7, 0xff, 0x1, 0x81, 0x16, 0x40, 0x3d,
    0x0, 0x9e, 0x80, 0x62, 0xc8, 0x1c, 0xc0, 0xff,
    0x10, 0x3b, 0x60, 0x19, 0x23, 0x3, 0x60, 0x0,

    /* U+7C "|" */
    0x84, 0xf, 0xfe, 0x70,

    /* U+7D "}" */
    0x60, 0x65, 0x88, 0x3, 0x20, 0x9, 0x30, 0x31,
    0x3, 0xff, 0x84, 0xd8, 0xa, 0x5a, 0x1, 0x2d,
    0x0, 0x6c, 0x7, 0xff, 0x4, 0x81, 0x26, 0x0,
    0xc8, 0x0, 0xb1, 0x0,

    /* U+7E "~" */
    0x17, 0x50, 0x34, 0x8d, 0x9f, 0x20, 0xc0, 0x30,
    0xbf, 0x6c, 0x80
};


/*---------------------
 *  GLYPH DESCRIPTION
 *--------------------*/

static const lv_font_fmt_txt_glyph_dsc_t glyph_dsc[] = {
    {.bitmap_index = 0, .adv_w = 0, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0} /* id = 0 reserved */,
    {.bitmap_index = 0, .adv_w = 62, .box_w = 0, .box_h = 0, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 0, .adv_w = 58, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 8, .adv_w = 74, .box_w = 3, .box_h = 4, .ofs_x = 1, .ofs_y = 8},
    {.bitmap_index = 13, .adv_w = 149, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 55, .adv_w = 142, .box_w = 8, .box_h = 16, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 98, .adv_w = 189, .box_w = 12, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 144, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 186, .adv_w = 44, .box_w = 2, .box_h = 4, .ofs_x = 0, .ofs_y = 8},
    {.bitmap_index = 189, .adv_w = 82, .box_w = 4, .box_h = 18, .ofs_x = 1, .ofs_y = -4},
    {.bitmap_index = 216, .adv_w = 83, .box_w = 5, .box_h = 18, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 245, .adv_w = 109, .box_w = 7, .box_h = 7, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 262, .adv_w = 145, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 278, .adv_w = 49, .box_w = 3, .box_h = 4, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 283, .adv_w = 73, .box_w = 5, .box_h = 1, .ofs_x = 0, .ofs_y = 5},
    {.bitmap_index = 285, .adv_w = 61, .box_w = 2, .box_h = 2, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 287, .adv_w = 102, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 312, .adv_w = 142, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 340, .adv_w = 142, .box_w = 5, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 350, .adv_w = 142, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 385, .adv_w = 142, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 417, .adv_w = 142, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 446, .adv_w = 142, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 477, .adv_w = 142, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 512, .adv_w = 142, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 541, .adv_w = 142, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 579, .adv_w = 142, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 613, .adv_w = 54, .box_w = 2, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 619, .adv_w = 50, .box_w = 3, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 631, .adv_w = 131, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 652, .adv_w = 142, .box_w = 7, .box_h = 4, .ofs_x = 1, .ofs_y = 3},
    {.bitmap_index = 660, .adv_w = 133, .box_w = 8, .box_h = 8, .ofs_x = 0, .ofs_y = 1},
    {.bitmap_index = 682, .adv_w = 116, .box_w = 7, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 709, .adv_w = 234, .box_w = 14, .box_h = 15, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 780, .adv_w = 160, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 818, .adv_w = 157, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 849, .adv_w = 166, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 879, .adv_w = 168, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 908, .adv_w = 146, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 926, .adv_w = 144, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 942, .adv_w = 175, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 977, .adv_w = 181, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 990, .adv_w = 68, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 994, .adv_w = 141, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1010, .adv_w = 162, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1043, .adv_w = 135, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1052, .adv_w = 222, .box_w = 12, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1095, .adv_w = 182, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1124, .adv_w = 173, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1161, .adv_w = 158, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1184, .adv_w = 173, .box_w = 10, .box_h = 14, .ofs_x = 0, .ofs_y = -2},
    {.bitmap_index = 1227, .adv_w = 163, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1260, .adv_w = 152, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1296, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1309, .adv_w = 168, .box_w = 9, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1327, .adv_w = 158, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1367, .adv_w = 230, .box_w = 14, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1427, .adv_w = 157, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1467, .adv_w = 153, .box_w = 10, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1498, .adv_w = 153, .box_w = 9, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1529, .adv_w = 61, .box_w = 3, .box_h = 16, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 1535, .adv_w = 101, .box_w = 7, .box_h = 13, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1562, .adv_w = 61, .box_w = 3, .box_h = 16, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1568, .adv_w = 107, .box_w = 6, .box_h = 6, .ofs_x = 0, .ofs_y = 6},
    {.bitmap_index = 1582, .adv_w = 111, .box_w = 7, .box_h = 1, .ofs_x = 0, .ofs_y = -1},
    {.bitmap_index = 1584, .adv_w = 73, .box_w = 4, .box_h = 3, .ofs_x = 0, .ofs_y = 10},
    {.bitmap_index = 1589, .adv_w = 137, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1616, .adv_w = 142, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1641, .adv_w = 132, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1666, .adv_w = 142, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1695, .adv_w = 132, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1721, .adv_w = 85, .box_w = 6, .box_h = 13, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1737, .adv_w = 142, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1772, .adv_w = 141, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1789, .adv_w = 57, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1795, .adv_w = 58, .box_w = 4, .box_h = 15, .ofs_x = -1, .ofs_y = -3},
    {.bitmap_index = 1807, .adv_w = 125, .box_w = 7, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1831, .adv_w = 57, .box_w = 2, .box_h = 12, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1835, .adv_w = 227, .box_w = 13, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1856, .adv_w = 141, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1870, .adv_w = 143, .box_w = 9, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1898, .adv_w = 142, .box_w = 8, .box_h = 12, .ofs_x = 1, .ofs_y = -3},
    {.bitmap_index = 1925, .adv_w = 143, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 1956, .adv_w = 86, .box_w = 5, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 1966, .adv_w = 130, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 1994, .adv_w = 82, .box_w = 5, .box_h = 12, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2009, .adv_w = 141, .box_w = 7, .box_h = 9, .ofs_x = 1, .ofs_y = 0},
    {.bitmap_index = 2023, .adv_w = 123, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2048, .adv_w = 193, .box_w = 12, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2089, .adv_w = 125, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2116, .adv_w = 122, .box_w = 8, .box_h = 12, .ofs_x = 0, .ofs_y = -3},
    {.bitmap_index = 2149, .adv_w = 125, .box_w = 8, .box_h = 9, .ofs_x = 0, .ofs_y = 0},
    {.bitmap_index = 2172, .adv_w = 85, .box_w = 6, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2204, .adv_w = 57, .box_w = 2, .box_h = 14, .ofs_x = 1, .ofs_y = -2},
    {.bitmap_index = 2208, .adv_w = 85, .box_w = 5, .box_h = 17, .ofs_x = 0, .ofs_y = -4},
    {.bitmap_index = 2236, .adv_w = 175, .box_w = 9, .box_h = 3, .ofs_x = 1, .ofs_y = 3}
};

/*---------------------
 *  CHARACTER MAPPING
 *--------------------*/



/*Collect the unicode lists and glyph_id offsets*/
static const lv_font_fmt_txt_cmap_t cmaps[] =
{
    {
        .range_start = 32, .range_length = 95, .glyph_id_start = 1,
        .unicode_list = NULL, .glyph_id_ofs_list = NULL, .list_length = 0, .type = LV_FONT_FMT_TXT_CMAP_FORMAT0_TINY
    }
};

/*-----------------
 *    KERNING
 *----------------*/


/*Pair left and right glyphs for kerning*/
static const uint8_t kern_pair_glyph_ids[] =
{
    1, 53,
    3, 3,
    3, 8,
    3, 34,
    3, 66,
    3, 68,
    3, 69,
    3, 70,
    3, 72,
    3, 78,
    3, 79,
    3, 80,
    3, 81,
    3, 82,
    3, 84,
    3, 88,
    8, 3,
    8, 8,
    8, 34,
    8, 66,
    8, 68,
    8, 69,
    8, 70,
    8, 72,
    8, 78,
    8, 79,
    8, 80,
    8, 81,
    8, 82,
    8, 84,
    8, 88,
    9, 55,
    9, 56,
    9, 58,
    13, 3,
    13, 8,
    15, 3,
    15, 8,
    16, 16,
    34, 3,
    34, 8,
    34, 32,
    34, 36,
    34, 40,
    34, 48,
    34, 50,
    34, 53,
    34, 54,
    34, 55,
    34, 56,
    34, 58,
    34, 80,
    34, 85,
    34, 86,
    34, 87,
    34, 88,
    34, 90,
    34, 91,
    35, 53,
    35, 55,
    35, 58,
    36, 10,
    36, 53,
    36, 62,
    36, 94,
    37, 13,
    37, 15,
    37, 34,
    37, 53,
    37, 55,
    37, 57,
    37, 58,
    37, 59,
    38, 53,
    38, 68,
    38, 69,
    38, 70,
    38, 71,
    38, 72,
    38, 80,
    38, 82,
    38, 86,
    38, 87,
    38, 88,
    38, 90,
    39, 13,
    39, 15,
    39, 34,
    39, 43,
    39, 53,
    39, 66,
    39, 68,
    39, 69,
    39, 70,
    39, 72,
    39, 80,
    39, 82,
    39, 83,
    39, 86,
    39, 87,
    39, 90,
    41, 34,
    41, 53,
    41, 57,
    41, 58,
    42, 34,
    42, 53,
    42, 57,
    42, 58,
    43, 34,
    44, 14,
    44, 36,
    44, 40,
    44, 48,
    44, 50,
    44, 68,
    44, 69,
    44, 70,
    44, 72,
    44, 78,
    44, 79,
    44, 80,
    44, 81,
    44, 82,
    44, 86,
    44, 87,
    44, 88,
    44, 90,
    45, 3,
    45, 8,
    45, 34,
    45, 36,
    45, 40,
    45, 48,
    45, 50,
    45, 53,
    45, 54,
    45, 55,
    45, 56,
    45, 58,
    45, 86,
    45, 87,
    45, 88,
    45, 90,
    46, 34,
    46, 53,
    46, 57,
    46, 58,
    47, 34,
    47, 53,
    47, 57,
    47, 58,
    48, 13,
    48, 15,
    48, 34,
    48, 53,
    48, 55,
    48, 57,
    48, 58,
    48, 59,
    49, 13,
    49, 15,
    49, 34,
    49, 43,
    49, 57,
    49, 59,
    49, 66,
    49, 68,
    49, 69,
    49, 70,
    49, 72,
    49, 80,
    49, 82,
    49, 85,
    49, 87,
    49, 90,
    50, 53,
    50, 55,
    50, 56,
    50, 58,
    51, 53,
    51, 55,
    51, 58,
    53, 1,
    53, 13,
    53, 14,
    53, 15,
    53, 34,
    53, 36,
    53, 40,
    53, 43,
    53, 48,
    53, 50,
    53, 52,
    53, 53,
    53, 55,
    53, 56,
    53, 58,
    53, 66,
    53, 68,
    53, 69,
    53, 70,
    53, 72,
    53, 78,
    53, 79,
    53, 80,
    53, 81,
    53, 82,
    53, 83,
    53, 84,
    53, 86,
    53, 87,
    53, 88,
    53, 89,
    53, 90,
    53, 91,
    54, 34,
    55, 10,
    55, 13,
    55, 14,
    55, 15,
    55, 34,
    55, 36,
    55, 40,
    55, 48,
    55, 50,
    55, 62,
    55, 66,
    55, 68,
    55, 69,
    55, 70,
    55, 72,
    55, 80,
    55, 82,
    55, 83,
    55, 86,
    55, 87,
    55, 90,
    55, 94,
    56, 10,
    56, 13,
    56, 14,
    56, 15,
    56, 34,
    56, 53,
    56, 62,
    56, 66,
    56, 68,
    56, 69,
    56, 70,
    56, 72,
    56, 80,
    56, 82,
    56, 83,
    56, 86,
    56, 94,
    57, 14,
    57, 36,
    57, 40,
    57, 48,
    57, 50,
    57, 55,
    57, 68,
    57, 69,
    57, 70,
    57, 72,
    57, 80,
    57, 82,
    57, 86,
    57, 87,
    57, 90,
    58, 7,
    58, 10,
    58, 11,
    58, 13,
    58, 14,
    58, 15,
    58, 34,
    58, 36,
    58, 40,
    58, 43,
    58, 48,
    58, 50,
    58, 52,
    58, 53,
    58, 54,
    58, 55,
    58, 56,
    58, 57,
    58, 58,
    58, 62,
    58, 66,
    58, 68,
    58, 69,
    58, 70,
    58, 71,
    58, 72,
    58, 78,
    58, 79,
    58, 80,
    58, 81,
    58, 82,
    58, 83,
    58, 84,
    58, 85,
    58, 86,
    58, 87,
    58, 89,
    58, 90,
    58, 91,
    58, 94,
    59, 34,
    59, 36,
    59, 40,
    59, 48,
    59, 50,
    59, 68,
    59, 69,
    59, 70,
    59, 72,
    59, 80,
    59, 82,
    59, 86,
    59, 87,
    59, 88,
    59, 90,
    60, 43,
    60, 54,
    66, 3,
    66, 8,
    66, 87,
    66, 90,
    67, 3,
    67, 8,
    67, 87,
    67, 89,
    67, 90,
    67, 91,
    68, 3,
    68, 8,
    70, 3,
    70, 8,
    70, 87,
    70, 90,
    71, 3,
    71, 8,
    71, 10,
    71, 62,
    71, 68,
    71, 69,
    71, 70,
    71, 72,
    71, 82,
    71, 94,
    73, 3,
    73, 8,
    76, 68,
    76, 69,
    76, 70,
    76, 72,
    76, 82,
    78, 3,
    78, 8,
    79, 3,
    79, 8,
    80, 3,
    80, 8,
    80, 87,
    80, 89,
    80, 90,
    80, 91,
    81, 3,
    81, 8,
    81, 87,
    81, 89,
    81, 90,
    81, 91,
    83, 3,
    83, 8,
    83, 13,
    83, 15,
    83, 66,
    83, 68,
    83, 69,
    83, 70,
    83, 71,
    83, 72,
    83, 80,
    83, 82,
    83, 85,
    83, 87,
    83, 88,
    83, 90,
    85, 80,
    87, 3,
    87, 8,
    87, 13,
    87, 15,
    87, 66,
    87, 68,
    87, 69,
    87, 70,
    87, 71,
    87, 72,
    87, 80,
    87, 82,
    88, 13,
    88, 15,
    89, 68,
    89, 69,
    89, 70,
    89, 72,
    89, 80,
    89, 82,
    90, 3,
    90, 8,
    90, 13,
    90, 15,
    90, 66,
    90, 68,
    90, 69,
    90, 70,
    90, 71,
    90, 72,
    90, 80,
    90, 82,
    91, 68,
    91, 69,
    91, 70,
    91, 72,
    91, 80,
    91, 82,
    92, 43,
    92, 54
};

/* Kerning between the respective left and right glyphs
 * 4.4 format which needs to scaled with `kern_scale`*/
static const int8_t kern_pair_values[] =
{
    -5, -13, -13, -15, -6, -7, -7, -7,
    -7, -2, -2, -8, -2, -7, -10, 1,
    -13, -13, -15, -6, -7, -7, -7, -7,
    -2, -2, -8, -2, -7, -10, 1, 3,
    2, 3, -21, -21, -21, -21, -28, -15,
    -15, -8, -1, -1, -1, -1, -16, -2,
    -11, -9, -12, -1, -2, -1, -6, -4,
    -6, 2, -3, -3, -7, -3, -4, -1,
    -2, -13, -13, -3, -3, -3, -3, -5,
    -3, 3, -2, -2, -2, -2, -2, -2,
    -2, -2, -3, -3, -3, -29, -29, -21,
    -33, 3, -4, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, 2, -4, 2,
    -3, 2, -4, 2, -3, -3, -8, -4,
    -4, -4, -4, -3, -3, -3, -3, -3,
    -3, -3, -3, -3, -3, -5, -8, -5,
    -42, -42, 2, -8, -8, -8, -8, -34,
    -7, -22, -18, -30, -5, -17, -11, -17,
    2, -4, 2, -3, 2, -4, 2, -3,
    -13, -13, -3, -3, -3, -3, -5, -3,
    -40, -40, -17, -25, -4, -3, -1, -2,
    -2, -2, -2, -2, -2, 2, 2, 2,
    -5, -3, -2, -4, -10, -2, -6, -5,
    -27, -29, -27, -10, -3, -3, -30, -3,
    -3, -2, 2, 2, 2, 2, -14, -12,
    -12, -12, -12, -14, -14, -12, -14, -12,
    -9, -14, -12, -9, -7, -10, -9, -7,
    -3, 3, -28, -5, -28, -9, -2, -2,
    -2, -2, 2, -6, -5, -5, -5, -5,
    -6, -5, -4, -3, -1, -1, 2, 2,
    -15, -7, -15, -5, 2, 2, -4, -4,
    -4, -4, -4, -4, -4, -3, -2, 2,
    -6, -3, -3, -3, -3, 2, -3, -3,
    -3, -3, -3, -3, -3, -4, -4, -4,
    3, -6, -26, -6, -26, -12, -4, -4,
    -12, -4, -4, -2, 2, -12, 2, 2,
    2, 2, 2, -9, -8, -8, -8, -3,
    -8, -5, -5, -8, -5, -8, -5, -7,
    -3, -5, -2, -3, -2, -4, 2, 2,
    -3, -3, -3, -3, -3, -3, -3, -3,
    -3, -3, -2, -3, -3, -3, -2, -2,
    -8, -8, -2, -2, -4, -4, -1, -2,
    -1, -2, -1, -1, -2, -2, -2, -2,
    2, 2, 3, 2, -3, -3, -3, -3,
    -3, 2, -13, -13, -2, -2, -2, -2,
    -2, -13, -13, -13, -13, -17, -17, -2,
    -3, -2, -2, -4, -4, -1, -2, -1,
    -2, 2, 2, -15, -15, -5, -2, -2,
    -2, 2, -2, -2, -2, 6, 2, 2,
    2, -2, 2, 2, -13, -13, -2, -2,
    -2, -2, 2, -2, -2, -2, -15, -15,
    -2, -2, -2, -2, -2, -2, 2, 2,
    -13, -13, -2, -2, -2, -2, 2, -2,
    -2, -2, -2, -2, -2, -2, -2, -2,
    -2, -2
};

/*Collect the kern pair's data in one place*/
static const lv_font_fmt_txt_kern_pair_t kern_pairs =
{
    .glyph_ids = kern_pair_glyph_ids,
    .values = kern_pair_values,
    .pair_cnt = 434,
    .glyph_ids_size = 0
};

/*--------------------
 *  ALL CUSTOM DATA
 *--------------------*/

/*Store all the custom data of the font*/
static lv_font_fmt_txt_dsc_t font_dsc = {
    .glyph_bitmap = gylph_bitmap,
    .glyph_dsc = glyph_dsc,
    .cmaps = cmaps,
    .kern_dsc = &kern_pairs,
    .kern_scale = 16,
    .cmap_num = 1,
    .bpp = 3,
    .kern_classes = 0,
    .bitmap_format = 1
};


/*-----------------
 *  PUBLIC FONT
 *----------------*/

/*Initialize a public general font descriptor*/
lv_font_t robot_light_16 = {
    .get_glyph_dsc = lv_font_get_glyph_dsc_fmt_txt,    /*Function pointer to get glyph's data*/
    .get_glyph_bitmap = lv_font_get_bitmap_fmt_txt,    /*Function pointer to get glyph's bitmap*/
    .line_height = 18,          /*The maximum line height required by the font*/
    .base_line = 4,             /*Baseline measured from the bottom of the line*/
#if !(LVGL_VERSION_MAJOR == 6 && LVGL_VERSION_MINOR == 0)
    .subpx = LV_FONT_SUBPX_NONE,
#endif
    .dsc = &font_dsc           /*The custom font data. Will be accessed by `get_glyph_bitmap/dsc` */
};

#endif /*#if ROBOT_LIGHT_16*/

