/**\mainpage
*
****************************************************************************
* Copyright (C) 2017 - 2018 Bosch Sensortec GmbH
*
* File : bma423.c
*
* Date: 12 Oct 2017
*
* Revision : 1.1.4 $
*
* Usage: Sensor Driver for BMA423 sensor
*
****************************************************************************
*
* \section Disclaimer
*
* Common:
* Bosch Sensortec products are developed for the consumer goods industry.
* They may only be used within the parameters of the respective valid
* product data sheet.  Bosch Sensortec products are provided with the
* express understanding that there is no warranty of fitness for a
* particular purpose.They are not fit for use in life-sustaining,
* safety or security sensitive systems or any system or device
* that may lead to bodily harm or property damage if the system
* or device malfunctions. In addition,Bosch Sensortec products are
* not fit for use in products which interact with motor vehicle systems.
* The resale and or use of products are at the purchasers own risk and
* his own responsibility. The examination of fitness for the intended use
* is the sole responsibility of the Purchaser.
*
* The purchaser shall indemnify Bosch Sensortec from all third party
* claims, including any claims for incidental, or consequential damages,
* arising from any product use not covered by the parameters of
* the respective valid product data sheet or not approved by
* Bosch Sensortec and reimburse Bosch Sensortec for all costs in
* connection with such claims.
*
* The purchaser must monitor the market for the purchased products,
* particularly with regard to product safety and inform Bosch Sensortec
* without delay of all security relevant incidents.
*
* Engineering Samples are marked with an asterisk (*) or (e).
* Samples may vary from the valid technical specifications of the product
* series. They are therefore not intended or fit for resale to third
* parties or for use in end products. Their sole purpose is internal
* client testing. The testing of an engineering sample may in no way
* replace the testing of a product series. Bosch Sensortec assumes
* no liability for the use of engineering samples.
* By accepting the engineering samples, the Purchaser agrees to indemnify
* Bosch Sensortec from all claims arising from the use of engineering
* samples.
*
* Special:
* This software module (hereinafter called "Software") and any information
* on application-sheets (hereinafter called "Information") is provided
* free of charge for the sole purpose to support your application work.
* The Software and Information is subject to the following
* terms and conditions:
*
* The Software is specifically designed for the exclusive use for
* Bosch Sensortec products by personnel who have special experience
* and training. Do not use this Software if you do not have the
* proper experience or training.
*
* This Software package is provided `` as is `` and without any expressed
* or implied warranties,including without limitation, the implied warranties
* of merchantability and fitness for a particular purpose.
*
* Bosch Sensortec and their representatives and agents deny any liability
* for the functional impairment
* of this Software in terms of fitness, performance and safety.
* Bosch Sensortec and their representatives and agents shall not be liable
* for any direct or indirect damages or injury, except as
* otherwise stipulated in mandatory applicable law.
*
* The Information provided is believed to be accurate and reliable.
* Bosch Sensortec assumes no responsibility for the consequences of use
* of such Information nor for any infringement of patents or
* other rights of third parties which may result from its use.
* No license is granted by implication or otherwise under any patent or
* patent rights of Bosch. Specifications mentioned in the Information are
* subject to change without notice.
**************************************************************************/
/*! \file bma423.c
    \brief Sensor Driver for BMA423 sensor */

#include "bma423.h"

/**\name Feature configuration file */
const uint8_t bma423_config_file[] = {
		0x80, 0x2e, 0xfc, 0x00, 0x80, 0x2e, 0xfe, 0x00, 0xc8, 0x2e, 0x00, 0x2e,
		0x80, 0x2e, 0xfa, 0x00, 0x80, 0x2e, 0x23, 0xb1, 0x80, 0x2e, 0xfd, 0x00,
		0x80, 0x2e, 0xfb, 0x00, 0x80, 0x2e, 0x5a, 0xb1, 0x50, 0x39, 0x21, 0x2e,
		0xb0, 0xf0, 0x10, 0x30, 0x21, 0x2e, 0x16, 0xf0, 0x80, 0x2e, 0xfc, 0x01,
		0x5d, 0x50, 0x45, 0x52, 0x01, 0x42, 0x3b, 0x80, 0x41, 0x30, 0x01, 0x42,
		0x3c, 0x80, 0x00, 0x2e, 0x01, 0x40, 0x01, 0x42, 0x21, 0x2e, 0xff, 0xaf,
		0xb8, 0x2e, 0xb6, 0xd6, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0xfd, 0x2d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x02, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0xf8, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x49, 0x00, 0x24, 0x01, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x98, 0x2e,
		0x99, 0x01, 0x20, 0x26, 0x98, 0x2e, 0xf6, 0x00, 0x98, 0x2e, 0xe9, 0x01,
		0x10, 0x30, 0x21, 0x2e, 0x59, 0xf0, 0x98, 0x2e, 0xd8, 0x00, 0x00, 0x2e,
		0x00, 0x2e, 0xd0, 0x2e, 0x98, 0x2e, 0xdd, 0x00, 0x01, 0x2e, 0x56, 0x00,
		0x00, 0xb2, 0x11, 0x2f, 0x00, 0x30, 0x21, 0x2e, 0x56, 0x00, 0x41, 0x50,
		0x98, 0x2e, 0xcc, 0xb0, 0x41, 0x50, 0x98, 0x2e, 0x8f, 0xb4, 0x01, 0x2e,
		0x03, 0xf0, 0x0d, 0xbc, 0x0f, 0xb8, 0x00, 0x90, 0x02, 0x2f, 0x45, 0x50,
		0x21, 0x2e, 0xbc, 0xf0, 0x01, 0x2e, 0x55, 0x00, 0x00, 0xb2, 0x1a, 0x2f,
		0x00, 0x30, 0x21, 0x2e, 0x55, 0x00, 0x43, 0x50, 0x98, 0x2e, 0xcc, 0xb0,
		0x43, 0x50, 0x98, 0x2e, 0xdc, 0xb1, 0x43, 0x50, 0x98, 0x2e, 0x92, 0xb5,
		0x43, 0x50, 0x98, 0x2e, 0x00, 0xb0, 0x01, 0x2e, 0x1c, 0x01, 0x0f, 0xbc,
		0x0f, 0xb8, 0x00, 0x90, 0x45, 0x50, 0x02, 0x2f, 0x21, 0x2e, 0xbc, 0xf0,
		0x02, 0x2d, 0x21, 0x2e, 0xba, 0xf0, 0x98, 0x2e, 0xd8, 0x00, 0xc3, 0x2d,
		0x01, 0x2e, 0x55, 0xf0, 0xc0, 0x2e, 0x21, 0x2e, 0x55, 0xf0, 0x03, 0x2e,
		0x00, 0xf0, 0x45, 0x54, 0x01, 0x2e, 0x59, 0xf0, 0x4a, 0x0e, 0x02, 0x2f,
		0xf1, 0x33, 0x0d, 0x2c, 0x01, 0x08, 0xf2, 0x30, 0x4a, 0x08, 0x79, 0x84,
		0x82, 0xa2, 0x04, 0x2f, 0x02, 0x34, 0x82, 0x0a, 0x47, 0xa2, 0x03, 0x2c,
		0x10, 0x22, 0x45, 0x52, 0x01, 0x0a, 0xc0, 0x2e, 0x21, 0x2e, 0x59, 0xf0,
		0x00, 0x31, 0xc0, 0x2e, 0x21, 0x2e, 0xba, 0xf0, 0xc8, 0x2e, 0xc8, 0x2e,
		0xc8, 0x2e, 0xc8, 0x2e, 0xc8, 0x2e, 0x44, 0x47, 0xaa, 0x00, 0x05, 0x00,
		0x2d, 0x01, 0xd4, 0x7b, 0x3b, 0x01, 0xdb, 0x7a, 0x04, 0x00, 0x3f, 0x7b,
		0xcd, 0x6c, 0xc3, 0x04, 0x85, 0x09, 0xc3, 0x04, 0xec, 0xe6, 0x0c, 0x46,
		0x01, 0x00, 0x27, 0x00, 0x19, 0x00, 0x96, 0x00, 0xa0, 0x00, 0x01, 0x00,
		0x0c, 0x00, 0xf0, 0x3c, 0x00, 0x01, 0x01, 0x00, 0x03, 0x00, 0x01, 0x00,
		0x0e, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x43, 0x28, 0x88, 0x00,
		0x52, 0x00, 0x4f, 0x00, 0x80, 0x00, 0x5b, 0x00, 0x00, 0x40, 0xaf, 0x00,
		0xff, 0x00, 0xff, 0xb7, 0x00, 0x02, 0x00, 0xb0, 0x05, 0x80, 0xb1, 0xf0,
		0xc0, 0x00, 0x00, 0x01, 0x5e, 0xf0, 0x39, 0xf0, 0x89, 0xf0, 0x00, 0x20,
		0xff, 0x7f, 0x7d, 0x00, 0x5e, 0x00, 0x62, 0x00, 0x7c, 0x00, 0xff, 0xfb,
		0x52, 0xf0, 0x56, 0xf0, 0x33, 0x09, 0x33, 0x07, 0x00, 0x08, 0x90, 0x01,
		0x00, 0xf8, 0x67, 0x00, 0x4c, 0x04, 0xa0, 0x00, 0xe8, 0x03, 0x81, 0x00,
		0x82, 0x00, 0x6a, 0x00, 0x6d, 0x00, 0x6c, 0x00, 0xeb, 0x07, 0xae, 0x07,
		0x72, 0x00, 0x6f, 0x00, 0xa1, 0x01, 0x1e, 0x05, 0x47, 0xfd, 0x73, 0x00,
		0x77, 0x00, 0x79, 0x00, 0x76, 0x00, 0xcc, 0x00, 0x30, 0x50, 0x50, 0x40,
		0x00, 0x18, 0x50, 0x40, 0x56, 0x25, 0x47, 0x25, 0x00, 0x18, 0x2e, 0x00,
		0x41, 0x40, 0xa7, 0x02, 0x09, 0x18, 0xc6, 0x00, 0xfb, 0x7f, 0x00, 0x30,
		0x49, 0x52, 0x05, 0x30, 0x05, 0x2c, 0x17, 0x03, 0x1e, 0xbd, 0xd2, 0xba,
		0x92, 0xb8, 0x6a, 0x0b, 0x61, 0x0e, 0xf9, 0x2f, 0x61, 0x1a, 0x01, 0x2f,
		0x5d, 0x0e, 0xf5, 0x2f, 0xd4, 0x7f, 0x02, 0x30, 0x1f, 0x2c, 0xe3, 0x7f,
		0x85, 0x01, 0xd1, 0x03, 0x7c, 0x0e, 0x03, 0x2f, 0x7c, 0x1a, 0x0f, 0x2f,
		0x73, 0x0f, 0x0d, 0x2f, 0xe3, 0x6f, 0xde, 0x04, 0x5f, 0xba, 0x11, 0xbf,
		0xb4, 0x0b, 0xd4, 0x6f, 0x27, 0x07, 0xb3, 0x25, 0xd1, 0xbf, 0xeb, 0x7f,
		0x07, 0x00, 0xb4, 0x25, 0x96, 0x02, 0xdb, 0x7f, 0x2f, 0xbf, 0x9e, 0xbf,
		0x01, 0xb8, 0xd2, 0xba, 0x21, 0xb9, 0x92, 0xb8, 0x06, 0x0a, 0x6f, 0x0b,
		0x40, 0x90, 0xdf, 0x2f, 0x40, 0x91, 0xdd, 0x2f, 0xfb, 0x6f, 0xd0, 0x5f,
		0xb8, 0x2e, 0x57, 0x50, 0x41, 0x30, 0x02, 0x40, 0x51, 0x0a, 0x01, 0x42,
		0x18, 0x82, 0x4b, 0x50, 0x60, 0x42, 0x70, 0x3c, 0x4d, 0x54, 0x42, 0x42,
		0x69, 0x82, 0x82, 0x32, 0x43, 0x40, 0x18, 0x08, 0x02, 0x0a, 0x40, 0x42,
		0x42, 0x80, 0x02, 0x3f, 0x01, 0x40, 0x10, 0x50, 0x4a, 0x08, 0xfb, 0x7f,
		0x11, 0x42, 0x0b, 0x31, 0x0b, 0x42, 0x3e, 0x80, 0x01, 0x32, 0x01, 0x42,
		0x00, 0x2e, 0x01, 0x2e, 0x40, 0xf0, 0x13, 0x90, 0x20, 0x2f, 0x03, 0x30,
		0x51, 0x50, 0x4f, 0x54, 0xf4, 0x34, 0x06, 0x30, 0x55, 0x52, 0x55, 0x32,
		0x1d, 0x1a, 0xe3, 0x22, 0x18, 0x1a, 0x53, 0x58, 0xe3, 0x22, 0x04, 0x30,
		0xd5, 0x40, 0xb5, 0x0d, 0xe1, 0xbe, 0x6f, 0xbb, 0x80, 0x91, 0xa9, 0x0d,
		0x01, 0x89, 0xb5, 0x23, 0x10, 0xa1, 0xf7, 0x2f, 0xda, 0x0e, 0xf4, 0x34,
		0xeb, 0x2f, 0x01, 0x2e, 0x25, 0x00, 0x70, 0x1a, 0x00, 0x30, 0x21, 0x30,
		0x02, 0x2c, 0x08, 0x22, 0x30, 0x30, 0x00, 0xb2, 0x06, 0x2f, 0x21, 0x2e,
		0x59, 0xf0, 0x98, 0x2e, 0xd8, 0x00, 0x00, 0x2e, 0x00, 0x2e, 0xd0, 0x2e,
		0xfb, 0x6f, 0xf0, 0x5f, 0xb8, 0x2e, 0x01, 0x2e, 0xb1, 0xf0, 0x59, 0x52,
		0x01, 0x0a, 0x21, 0x2e, 0xb1, 0xf0, 0x01, 0x2e, 0x1c, 0x01, 0x0f, 0xbc,
		0x0f, 0xb8, 0x00, 0x90, 0x45, 0x50, 0x02, 0x2f, 0xc0, 0x2e, 0x21, 0x2e,
		0xbc, 0xf0, 0xc0, 0x2e, 0x21, 0x2e, 0xba, 0xf0, 0x1a, 0x24, 0x26, 0x00,
		0x80, 0x2e, 0x8f, 0x00, 0x03, 0x2e, 0x01, 0x01, 0x05, 0x2e, 0x01, 0x01,
		0x92, 0xbd, 0x20, 0x50, 0x03, 0x2e, 0x01, 0x01, 0xbf, 0xba, 0x21, 0xbd,
		0x2f, 0xbb, 0x1f, 0xba, 0x40, 0x91, 0xf0, 0x7f, 0x04, 0x2f, 0x80, 0x91,
		0x02, 0x2f, 0x00, 0xb3, 0x90, 0x2e, 0xc7, 0xb0, 0x03, 0x2e, 0x7b, 0x00,
		0x01, 0x80, 0x40, 0x90, 0x14, 0x2f, 0x41, 0x84, 0xf1, 0x6f, 0x25, 0x2e,
		0x7b, 0x00, 0x41, 0x40, 0x23, 0x2e, 0x5a, 0x00, 0x47, 0x52, 0x12, 0x40,
		0x52, 0x42, 0x02, 0x30, 0x00, 0x40, 0x40, 0x42, 0xe0, 0x5f, 0x25, 0x2e,
		0x57, 0x00, 0x25, 0x2e, 0x58, 0x00, 0x25, 0x2e, 0x5d, 0x00, 0xb8, 0x2e,
		0x07, 0x2e, 0x00, 0x01, 0x03, 0x2e, 0x01, 0x01, 0x05, 0x2e, 0x00, 0x01,
		0x24, 0xbd, 0x0f, 0x2e, 0x59, 0x00, 0xb5, 0xbd, 0x93, 0xbc, 0x2f, 0xb9,
		0xb5, 0xb9, 0x93, 0xb8, 0x3a, 0x1a, 0x06, 0x2f, 0x07, 0x30, 0x25, 0x2e,
		0x59, 0x00, 0x2f, 0x2e, 0x57, 0x00, 0x2f, 0x2e, 0x58, 0x00, 0x40, 0xb3,
		0x05, 0x30, 0x07, 0x30, 0x0a, 0x2f, 0xf7, 0x6f, 0xe6, 0x7f, 0x00, 0x2e,
		0xc6, 0x41, 0x0f, 0x2e, 0x5a, 0x00, 0xb7, 0x05, 0x80, 0xa9, 0xee, 0x05,
		0xf7, 0x23, 0xe6, 0x6f, 0x80, 0xb3, 0x06, 0x30, 0x09, 0x2f, 0xe7, 0x7f,
		0x00, 0x2e, 0x06, 0x40, 0x0f, 0x2e, 0x5b, 0x00, 0xb7, 0x05, 0x80, 0xa9,
		0xee, 0x05, 0xb7, 0x23, 0xe7, 0x6f, 0x00, 0xb3, 0x04, 0x30, 0x0b, 0x2f,
		0xf4, 0x6f, 0x02, 0x89, 0xe7, 0x7f, 0x00, 0x2e, 0x04, 0x41, 0x0f, 0x2e,
		0x5c, 0x00, 0x27, 0x05, 0x00, 0xa9, 0xec, 0x05, 0x27, 0x23, 0xe7, 0x6f,
		0x7b, 0x0f, 0x17, 0x30, 0x0b, 0x2f, 0x73, 0x0f, 0x05, 0x30, 0x17, 0x30,
		0x07, 0x2f, 0x63, 0x0f, 0x15, 0x30, 0x17, 0x30, 0x00, 0x2f, 0x07, 0x30,
		0xe3, 0x0e, 0x00, 0x2f, 0x05, 0x30, 0x80, 0x90, 0x05, 0x2e, 0x57, 0x00,
		0x13, 0x30, 0x13, 0x29, 0xf2, 0x6f, 0x47, 0x5c, 0x17, 0x2f, 0xc0, 0x91,
		0x05, 0x30, 0x0b, 0x2f, 0x07, 0x2e, 0x58, 0x00, 0xc1, 0x86, 0x2b, 0x2e,
		0x57, 0x00, 0x59, 0x0e, 0x27, 0x2e, 0x58, 0x00, 0x24, 0x2f, 0x2b, 0x2e,
		0x5d, 0x00, 0x22, 0x2d, 0x61, 0x0e, 0x29, 0x2e, 0x57, 0x00, 0x2b, 0x2e,
		0x58, 0x00, 0x1b, 0x2f, 0x27, 0x2e, 0x5d, 0x00, 0x19, 0x2d, 0x40, 0x91,
		0x05, 0x2f, 0x01, 0x30, 0x23, 0x2e, 0x57, 0x00, 0x23, 0x2e, 0x5d, 0x00,
		0x06, 0x2d, 0x29, 0x2e, 0x57, 0x00, 0x61, 0x0e, 0x01, 0x2f, 0x27, 0x2e,
		0x5d, 0x00, 0x81, 0x40, 0x23, 0x2e, 0x5a, 0x00, 0x30, 0x25, 0x47, 0x52,
		0xd4, 0x40, 0x54, 0x42, 0x00, 0x2e, 0xc3, 0x40, 0x43, 0x42, 0x00, 0x2e,
		0x03, 0x2e, 0x5d, 0x00, 0x40, 0xb2, 0x0d, 0x2f, 0x81, 0x40, 0x23, 0x2e,
		0x5a, 0x00, 0x11, 0x40, 0x91, 0x43, 0x01, 0x34, 0x00, 0x40, 0x80, 0x43,
		0x23, 0x2e, 0x5e, 0xf0, 0x03, 0x2d, 0x00, 0x30, 0x21, 0x2e, 0x7b, 0x00,
		0xe0, 0x5f, 0xb8, 0x2e, 0x50, 0x50, 0xf0, 0x7f, 0x1a, 0x25, 0x13, 0x40,
		0x7b, 0x84, 0xe0, 0x7f, 0x83, 0x42, 0x35, 0x30, 0x11, 0x40, 0x04, 0x40,
		0xc1, 0x7f, 0xd4, 0x7f, 0x86, 0x31, 0x07, 0x2e, 0x59, 0xf0, 0x03, 0x2e,
		0x1f, 0x01, 0x0d, 0x09, 0x02, 0xab, 0x05, 0x30, 0x8e, 0x09, 0x2c, 0x23,
		0xe3, 0xba, 0x42, 0xab, 0x16, 0x30, 0x75, 0x23, 0x59, 0x5c, 0x8e, 0x09,
		0x66, 0xbb, 0x82, 0xab, 0x27, 0x30, 0xbe, 0x23, 0x3e, 0x80, 0x25, 0x1a,
		0x06, 0x2f, 0x2e, 0x1a, 0x04, 0x2f, 0x26, 0x1a, 0x02, 0x2f, 0xf7, 0x3d,
		0x03, 0x2c, 0xdf, 0x08, 0x07, 0x32, 0xdf, 0x0a, 0x14, 0x01, 0x55, 0x01,
		0x04, 0x41, 0x14, 0x42, 0x16, 0x01, 0x42, 0x41, 0x45, 0x30, 0x4d, 0x09,
		0x04, 0x41, 0x12, 0x42, 0x04, 0x42, 0x40, 0xb3, 0x04, 0x2f, 0xf0, 0x6f,
		0x02, 0x30, 0x04, 0x40, 0x94, 0x04, 0x02, 0x42, 0x00, 0x32, 0x08, 0x08,
		0x00, 0xb2, 0x00, 0x30, 0x05, 0x2f, 0xe2, 0x6f, 0x00, 0x2e, 0x84, 0x40,
		0x04, 0x05, 0x84, 0x42, 0x00, 0x2e, 0x5b, 0x54, 0x4a, 0x08, 0x40, 0xb2,
		0xf1, 0x6f, 0x04, 0x2f, 0x42, 0x82, 0x00, 0x2e, 0x42, 0x40, 0x02, 0x04,
		0x40, 0x42, 0xb0, 0x5f, 0x27, 0x2e, 0x59, 0xf0, 0xb8, 0x2e, 0x50, 0x50,
		0xf7, 0x7f, 0x00, 0x2e, 0x0f, 0x2e, 0xb8, 0xf0, 0xf8, 0xbf, 0xff, 0xbb,
		0xc0, 0xb3, 0x2a, 0x2f, 0x0f, 0x2e, 0x01, 0xf0, 0xfe, 0xbf, 0xe6, 0x7f,
		0x7e, 0xbb, 0xd5, 0x7f, 0x37, 0x30, 0x5f, 0x5a, 0xbe, 0x05, 0x67, 0x41,
		0xc4, 0x7f, 0x78, 0xbe, 0x47, 0x41, 0x27, 0x0b, 0xb3, 0x7f, 0xe6, 0x11,
		0x41, 0x56, 0x43, 0x89, 0xd7, 0x42, 0x00, 0x2e, 0x27, 0x41, 0x05, 0x41,
		0xf8, 0xbf, 0x7d, 0x0b, 0x6e, 0x11, 0x03, 0x8f, 0xd5, 0x42, 0x14, 0x30,
		0xe5, 0x41, 0xc7, 0x41, 0xd8, 0xbe, 0x6f, 0x0b, 0x6e, 0x11, 0xc5, 0x42,
		0x29, 0x2e, 0x56, 0x00, 0x45, 0x56, 0x27, 0x2e, 0xb8, 0xf0, 0xe6, 0x6f,
		0xd5, 0x6f, 0xc4, 0x6f, 0xb3, 0x6f, 0xf7, 0x6f, 0xb0, 0x5f, 0xc8, 0x2e,
		0x50, 0x50, 0xe5, 0x7f, 0xd7, 0x7f, 0xf6, 0x7f, 0x36, 0x30, 0x0b, 0x2e,
		0x01, 0xf0, 0xde, 0xbe, 0xde, 0xbb, 0x61, 0x5a, 0xb7, 0x05, 0x67, 0x41,
		0xc4, 0x7f, 0x78, 0xbe, 0x47, 0x41, 0x27, 0x0b, 0xb3, 0x7f, 0xe6, 0x11,
		0x43, 0x56, 0x43, 0x89, 0xd7, 0x42, 0x00, 0x2e, 0x27, 0x41, 0x05, 0x41,
		0xf8, 0xbf, 0x7d, 0x0b, 0x6e, 0x11, 0x03, 0x8f, 0xd5, 0x42, 0x14, 0x30,
		0xe5, 0x41, 0xc7, 0x41, 0xd8, 0xbe, 0x6f, 0x0b, 0x6e, 0x11, 0xc5, 0x42,
		0x29, 0x2e, 0x55, 0x00, 0x03, 0x31, 0x27, 0x2e, 0xb8, 0xf0, 0xf6, 0x6f,
		0xe5, 0x6f, 0xd7, 0x6f, 0xc4, 0x6f, 0xb3, 0x6f, 0xb0, 0x5f, 0xc8, 0x2e,
		0x40, 0x50, 0xf6, 0x7f, 0x1a, 0x18, 0x63, 0x56, 0x33, 0x00, 0x06, 0x30,
		0xfe, 0x03, 0x0e, 0xb8, 0xf2, 0xbf, 0x07, 0x0a, 0x2a, 0x18, 0x63, 0x5a,
		0xb5, 0x01, 0x03, 0x30, 0xfb, 0x03, 0x6e, 0xbb, 0xf2, 0xbf, 0xe1, 0x7f,
		0xf7, 0x0b, 0x56, 0x40, 0x36, 0x25, 0x46, 0x40, 0x06, 0x28, 0xc7, 0x7f,
		0x22, 0x18, 0xd1, 0x7f, 0xb5, 0x00, 0x01, 0x30, 0x39, 0x03, 0x2e, 0xb9,
		0x42, 0xbe, 0x14, 0x0b, 0xf2, 0x6f, 0x10, 0x18, 0xb5, 0x00, 0xb9, 0x03,
		0x2e, 0xb9, 0x62, 0xbf, 0x96, 0x0a, 0xb6, 0x6f, 0x30, 0x18, 0x75, 0x01,
		0xb9, 0x03, 0x5c, 0x28, 0xe2, 0xbf, 0xde, 0xb9, 0xd6, 0x6f, 0xdf, 0x0a,
		0x8a, 0x28, 0xc4, 0x6f, 0x82, 0x43, 0x23, 0x29, 0xe5, 0x6f, 0xc0, 0x2e,
		0x44, 0x43, 0xc0, 0x5f, 0x40, 0x50, 0xd0, 0x7f, 0x4a, 0x17, 0x00, 0x40,
		0x01, 0x18, 0x46, 0x25, 0x07, 0x25, 0x65, 0x56, 0xd9, 0x04, 0x53, 0x18,
		0xeb, 0x18, 0x05, 0x30, 0x49, 0x16, 0x69, 0x06, 0xca, 0x18, 0xa6, 0x00,
		0xc7, 0x02, 0x65, 0x58, 0xcb, 0x7f, 0x98, 0x2e, 0x7f, 0xb6, 0xcb, 0x6f,
		0xd2, 0x6f, 0xc0, 0x2e, 0x80, 0x42, 0xc0, 0x5f, 0x09, 0x2e, 0x1b, 0x01,
		0x05, 0x2e, 0x1b, 0x01, 0xa3, 0xbc, 0x44, 0xbe, 0x90, 0x50, 0x4f, 0xb9,
		0x07, 0x2e, 0x1b, 0x01, 0x4a, 0x25, 0x9f, 0xb8, 0x39, 0x8f, 0xb2, 0xbd,
		0xf2, 0x7f, 0xbf, 0xb9, 0xeb, 0x7f, 0x8a, 0x0a, 0x37, 0x89, 0x0b, 0x30,
		0x93, 0x0a, 0x8b, 0x7f, 0xcb, 0x43, 0x0b, 0x43, 0x80, 0xb2, 0xd3, 0x7f,
		0xc1, 0x7f, 0x90, 0x2e, 0x87, 0xb2, 0x20, 0x25, 0x01, 0x2e, 0x64, 0x00,
		0x01, 0x90, 0x0e, 0x2f, 0x67, 0x52, 0x01, 0x2e, 0x61, 0x00, 0xb4, 0x7f,
		0xa2, 0x7f, 0x98, 0x2e, 0x8d, 0xb2, 0x00, 0x30, 0x21, 0x2e, 0x64, 0x00,
		0xc1, 0x6f, 0xd3, 0x6f, 0xa2, 0x6f, 0xb4, 0x6f, 0x0b, 0x30, 0x01, 0x2e,
		0x1b, 0x01, 0x06, 0xbc, 0x06, 0xbb, 0x57, 0x25, 0x01, 0x2e, 0x1b, 0x01,
		0x94, 0xb1, 0x05, 0xbc, 0xb6, 0x7f, 0x0f, 0xbb, 0x6b, 0x50, 0x80, 0xb3,
		0x0f, 0x2f, 0x0d, 0x2e, 0x1b, 0x01, 0x6f, 0x5e, 0xb7, 0x09, 0x2d, 0x2e,
		0x1b, 0x01, 0x71, 0x5c, 0x69, 0x5e, 0x9b, 0x43, 0x9b, 0x43, 0xdb, 0x43,
		0x9b, 0x43, 0x1b, 0x42, 0xcb, 0x43, 0x0b, 0x42, 0x8b, 0x43, 0x40, 0xb2,
		0x05, 0x2f, 0x69, 0x50, 0x00, 0x2e, 0x16, 0x40, 0x0b, 0x40, 0x76, 0x7f,
		0x8b, 0x7f, 0xcb, 0x0a, 0x01, 0x2e, 0x61, 0x00, 0x67, 0x52, 0x6d, 0x5c,
		0x98, 0x2e, 0xd3, 0xb2, 0x90, 0x6f, 0x00, 0xb2, 0x0b, 0x2f, 0xf0, 0x6f,
		0x00, 0xb2, 0x08, 0x2f, 0x69, 0x58, 0x6b, 0x50, 0x12, 0x41, 0x12, 0x42,
		0x21, 0x30, 0x04, 0x41, 0x04, 0x42, 0x23, 0x2e, 0x5e, 0xf0, 0xc0, 0x6f,
		0x00, 0xb2, 0x26, 0x2f, 0x74, 0x6f, 0x80, 0x6f, 0x71, 0x54, 0x88, 0xbd,
		0xc8, 0xb8, 0x4b, 0x0a, 0x94, 0x42, 0x91, 0x42, 0x90, 0x42, 0x88, 0xba,
		0x69, 0x52, 0xf3, 0x6f, 0x54, 0x42, 0x85, 0x42, 0xc0, 0x90, 0x40, 0x42,
		0x15, 0x2f, 0x6b, 0x52, 0x00, 0x2e, 0x52, 0x40, 0x41, 0x40, 0xa2, 0x04,
		0x41, 0x06, 0x40, 0xaa, 0x04, 0x2f, 0x40, 0x90, 0x0b, 0x2f, 0xb1, 0x6f,
		0x4a, 0x0f, 0x08, 0x2f, 0xb2, 0x6f, 0x80, 0xb2, 0x05, 0x2f, 0x6b, 0x54,
		0x21, 0x30, 0x94, 0x42, 0x80, 0x42, 0x23, 0x2e, 0x5e, 0xf0, 0xd0, 0x6f,
		0x00, 0xb2, 0x13, 0x2f, 0x01, 0x2e, 0x60, 0x00, 0x09, 0x2e, 0x7c, 0x00,
		0x04, 0x1a, 0x0d, 0x2f, 0x73, 0x50, 0x29, 0x2e, 0x60, 0x00, 0x24, 0x42,
		0x44, 0x30, 0x02, 0x40, 0x02, 0x42, 0x09, 0x80, 0x00, 0x2e, 0x04, 0x42,
		0x03, 0x2d, 0x10, 0x30, 0x21, 0x2e, 0x64, 0x00, 0xeb, 0x6f, 0x70, 0x5f,
		0xb8, 0x2e, 0x09, 0x86, 0x49, 0x54, 0xe4, 0x40, 0xc3, 0x80, 0x94, 0x04,
		0xc3, 0x40, 0x13, 0x05, 0x05, 0x40, 0x25, 0x05, 0x8a, 0x17, 0x73, 0x30,
		0x73, 0x09, 0x8c, 0x17, 0xf3, 0x08, 0xe3, 0x00, 0x4c, 0x82, 0x95, 0x00,
		0xb3, 0xb5, 0x23, 0xb5, 0x53, 0x42, 0x52, 0x42, 0x53, 0x42, 0x42, 0x42,
		0x71, 0x82, 0x75, 0x54, 0x52, 0x42, 0x10, 0x50, 0x77, 0x54, 0x52, 0x42,
		0xfb, 0x7f, 0x22, 0x30, 0x79, 0x56, 0x43, 0x42, 0x44, 0x82, 0x0b, 0x30,
		0x52, 0x42, 0x5b, 0x42, 0x7c, 0x84, 0x4b, 0x42, 0x35, 0x82, 0x8c, 0x80,
		0x8b, 0x42, 0x0b, 0x42, 0x39, 0x80, 0x04, 0x30, 0x0b, 0x42, 0x37, 0x80,
		0x15, 0x30, 0x60, 0x25, 0x98, 0x2e, 0xc6, 0xb2, 0x8b, 0x83, 0xfb, 0x6f,
		0x65, 0x42, 0xc0, 0x2e, 0x44, 0x42, 0xf0, 0x5f, 0x05, 0x80, 0x02, 0x30,
		0x51, 0x82, 0x02, 0x42, 0x13, 0x30, 0x41, 0x40, 0x4b, 0x08, 0x7b, 0x54,
		0x3e, 0x80, 0x51, 0x14, 0xc0, 0x2e, 0x01, 0x42, 0x00, 0x2e, 0x40, 0x51,
		0xd1, 0x7f, 0x12, 0x25, 0x02, 0x30, 0x42, 0x43, 0x32, 0x30, 0x82, 0x43,
		0xc6, 0x7f, 0xe5, 0x7f, 0xb4, 0x7f, 0xa3, 0x7f, 0x90, 0x7f, 0x8b, 0x7f,
		0x98, 0x2e, 0x54, 0x01, 0xc0, 0x7e, 0x00, 0xac, 0x01, 0x2f, 0x65, 0x50,
		0xc0, 0x7e, 0x00, 0x2e, 0x90, 0x6f, 0x09, 0x8a, 0xd1, 0x6f, 0x75, 0x7f,
		0x4c, 0x82, 0x63, 0x41, 0x65, 0x7f, 0x11, 0x7f, 0x00, 0x2e, 0x64, 0x41,
		0x44, 0x85, 0x52, 0x7f, 0x45, 0x7f, 0x00, 0x2e, 0xa6, 0x40, 0x80, 0x40,
		0x32, 0x7f, 0x82, 0x8e, 0xc2, 0x6e, 0x45, 0x41, 0xf0, 0x7f, 0x27, 0x7f,
		0x02, 0x7f, 0x98, 0x2e, 0x8a, 0xb1, 0x23, 0x6f, 0xd1, 0x6f, 0xc2, 0x40,
		0xf9, 0x86, 0x23, 0x7f, 0x80, 0xb2, 0xe0, 0x7e, 0x0f, 0x2f, 0x32, 0x6f,
		0x64, 0x6f, 0x82, 0x40, 0xf2, 0x7f, 0x4e, 0x82, 0x42, 0x6f, 0x50, 0x6f,
		0x73, 0x6f, 0x85, 0x40, 0xc3, 0x40, 0x04, 0x41, 0x06, 0x40, 0xe2, 0x6e,
		0x98, 0x2e, 0x8a, 0xb1, 0xe0, 0x7e, 0xf3, 0x31, 0x10, 0x6f, 0x36, 0x80,
		0xe1, 0x6e, 0x02, 0x40, 0x71, 0x7f, 0x51, 0x04, 0x02, 0x30, 0x40, 0xa8,
		0x91, 0x04, 0x4a, 0x22, 0x89, 0x16, 0x93, 0x08, 0x4a, 0x00, 0x95, 0xb4,
		0x09, 0x18, 0x8e, 0x16, 0x13, 0x30, 0x93, 0x08, 0x21, 0x6f, 0x60, 0x7f,
		0x4d, 0x86, 0x02, 0x80, 0xb2, 0x00, 0x41, 0x40, 0x21, 0xb5, 0x50, 0x7f,
		0x43, 0x7f, 0x98, 0x2e, 0xc2, 0xb1, 0x40, 0x6f, 0x62, 0x6f, 0x55, 0x6f,
		0x13, 0x40, 0x84, 0x40, 0x01, 0x40, 0x45, 0x41, 0x42, 0xbe, 0x1d, 0x18,
		0x4c, 0x04, 0x31, 0x0f, 0x04, 0x8a, 0xc0, 0x6f, 0x11, 0x30, 0x02, 0x2f,
		0x00, 0x2e, 0x03, 0x2c, 0x01, 0x42, 0x23, 0x30, 0x03, 0x42, 0x00, 0x2e,
		0xd6, 0x6f, 0x44, 0x41, 0x8a, 0x87, 0x76, 0x8b, 0x00, 0xb3, 0x53, 0x7f,
		0x15, 0x2f, 0x04, 0x6f, 0x7d, 0x5e, 0x8b, 0x8d, 0xe7, 0x01, 0xc0, 0xa5,
		0x84, 0x41, 0x01, 0x2f, 0x00, 0xa1, 0x03, 0x2f, 0xc0, 0xad, 0x08, 0x2f,
		0x00, 0xa5, 0x06, 0x2f, 0xc6, 0x40, 0x81, 0x8d, 0x07, 0x30, 0x3c, 0x05,
		0xd6, 0x42, 0x04, 0x2c, 0xc4, 0x42, 0x02, 0x2c, 0x07, 0x30, 0x07, 0x30,
		0x86, 0x86, 0x94, 0x6f, 0xd7, 0x7e, 0x0e, 0x8d, 0x00, 0x40, 0x74, 0x89,
		0xc7, 0x40, 0x02, 0xb2, 0xf9, 0x29, 0x45, 0x41, 0x86, 0x41, 0xbe, 0x80,
		0x21, 0x41, 0x75, 0x23, 0x82, 0x40, 0xc7, 0x42, 0x45, 0x7f, 0x34, 0x7f,
		0x20, 0x7f, 0x98, 0x2e, 0xc2, 0xb1, 0x31, 0x6f, 0x60, 0x6f, 0x24, 0x6f,
		0x22, 0x40, 0x05, 0x41, 0x43, 0x40, 0x13, 0x01, 0x43, 0x86, 0xac, 0x0f,
		0xd1, 0x6f, 0x30, 0x7f, 0x00, 0x2f, 0x44, 0x42, 0x48, 0x8a, 0x41, 0x88,
		0xe1, 0x40, 0x13, 0x7f, 0x04, 0x7f, 0xf5, 0x7e, 0x98, 0x2e, 0xc2, 0xb1,
		0x11, 0x6f, 0x60, 0x6f, 0x34, 0x6f, 0x42, 0x40, 0x03, 0x40, 0x9a, 0x04,
		0x04, 0x41, 0x43, 0x82, 0xa2, 0x0e, 0x03, 0x6f, 0x00, 0x2f, 0xc2, 0x42,
		0x00, 0x2e, 0x41, 0x40, 0x72, 0x6f, 0x98, 0x2e, 0xc2, 0xb1, 0x25, 0x6f,
		0x72, 0x6f, 0x53, 0x41, 0x93, 0x0e, 0xd1, 0x6f, 0x46, 0x80, 0x1b, 0x30,
		0x03, 0x30, 0x0c, 0x2f, 0x04, 0x40, 0x00, 0x91, 0x42, 0x42, 0x08, 0x2f,
		0xf6, 0x6e, 0x44, 0x6f, 0x86, 0x41, 0xb4, 0x0e, 0x03, 0x2f, 0x02, 0x88,
		0xdb, 0x7e, 0x03, 0x43, 0x0b, 0x42, 0x46, 0x8d, 0x44, 0x41, 0x47, 0x80,
		0x05, 0x6f, 0x94, 0x0f, 0x76, 0x7f, 0x60, 0x7f, 0x02, 0x2f, 0x45, 0x89,
		0x42, 0x43, 0x03, 0x43, 0x49, 0x88, 0xa5, 0x6f, 0x40, 0x91, 0xa4, 0x7f,
		0x15, 0x30, 0xe2, 0x6f, 0xd3, 0x6e, 0x03, 0x2f, 0x04, 0x30, 0x83, 0x42,
		0x80, 0x2e, 0x77, 0xb4, 0x04, 0x40, 0x25, 0x29, 0x04, 0x42, 0x83, 0x42,
		0x45, 0x82, 0x94, 0x6f, 0x04, 0x85, 0xc0, 0xb2, 0x90, 0x2e, 0x63, 0xb4,
		0x15, 0x87, 0x3c, 0x8c, 0xc4, 0x40, 0x46, 0x7f, 0xc2, 0x86, 0x07, 0x40,
		0x86, 0x41, 0xf4, 0xbf, 0x00, 0xb3, 0x0c, 0x2f, 0x90, 0x6f, 0x16, 0x80,
		0x46, 0x25, 0x00, 0x40, 0x57, 0x25, 0x04, 0x18, 0xae, 0x0e, 0x10, 0x30,
		0x06, 0x30, 0x75, 0x25, 0x46, 0x23, 0x60, 0x6f, 0x64, 0x25, 0xc4, 0x40,
		0xfa, 0x86, 0x00, 0xb3, 0x33, 0x7f, 0x09, 0x2f, 0x93, 0x6f, 0xd8, 0x88,
		0x53, 0x6f, 0x04, 0x41, 0xc3, 0x40, 0xdc, 0x0e, 0x13, 0x30, 0x04, 0x30,
		0xdc, 0x22, 0xb3, 0x25, 0x40, 0xb3, 0x02, 0x2f, 0x3b, 0x25, 0xc0, 0x90,
		0x05, 0x2f, 0x91, 0x6f, 0xd0, 0x6f, 0x98, 0x2e, 0xc6, 0xb2, 0x4d, 0x2c,
		0x04, 0x30, 0x8d, 0x88, 0x43, 0x40, 0x82, 0x40, 0x54, 0x7f, 0xda, 0x0f,
		0x04, 0x30, 0x08, 0x2f, 0xc1, 0x80, 0x40, 0x42, 0xc2, 0x0f, 0x02, 0x2f,
		0x00, 0x30, 0xc0, 0x7e, 0x1b, 0x2d, 0xc0, 0x7e, 0x19, 0x2d, 0xe1, 0xbc,
		0x92, 0x6f, 0x4f, 0x04, 0x90, 0x84, 0x40, 0xa8, 0x21, 0x05, 0x83, 0x40,
		0x4c, 0x22, 0x4b, 0x0e, 0xb6, 0x84, 0x21, 0x30, 0x02, 0x2f, 0x11, 0x30,
		0x04, 0x2c, 0xc1, 0x7e, 0xe3, 0x6f, 0xc1, 0x7e, 0xc1, 0x42, 0x00, 0x2e,
		0x00, 0x40, 0x81, 0x40, 0x04, 0xbd, 0x40, 0x6f, 0x98, 0x2e, 0xc2, 0xb1,
		0x50, 0x6f, 0x11, 0x30, 0x02, 0x40, 0x51, 0x08, 0xc3, 0x6e, 0x03, 0x80,
		0x99, 0x15, 0x0b, 0x40, 0xb1, 0x6f, 0xd0, 0x6f, 0xb6, 0x7f, 0x5b, 0x7f,
		0x04, 0x30, 0x4d, 0x54, 0x03, 0x30, 0x11, 0x2c, 0x10, 0x80, 0x55, 0x6f,
		0x06, 0x40, 0x75, 0x01, 0x58, 0xbb, 0x6a, 0x09, 0x05, 0x42, 0xc1, 0x86,
		0x47, 0x40, 0x51, 0x25, 0xbe, 0x01, 0x56, 0x43, 0x00, 0x2e, 0x46, 0x41,
		0xf4, 0x03, 0xb6, 0x6f, 0x47, 0x43, 0x5e, 0x0e, 0xed, 0x2f, 0x31, 0x6f,
		0x60, 0x6f, 0x42, 0x40, 0x15, 0x30, 0x02, 0x82, 0x95, 0x08, 0x04, 0x42,
		0x52, 0x42, 0x02, 0x2c, 0x44, 0x42, 0x04, 0x30, 0x3e, 0x8e, 0x91, 0x6f,
		0x4f, 0x8c, 0x02, 0x40, 0x83, 0x41, 0xb5, 0x8d, 0x93, 0x0e, 0xd0, 0x6f,
		0x01, 0x2f, 0x98, 0x2e, 0xc6, 0xb2, 0x00, 0x2e, 0xc0, 0x41, 0x81, 0x41,
		0xc1, 0x0f, 0xc0, 0x6f, 0x01, 0x2f, 0x04, 0x42, 0x00, 0x2e, 0x70, 0x6f,
		0x3c, 0x82, 0x00, 0x40, 0x41, 0x40, 0x89, 0x16, 0x95, 0x08, 0x4a, 0x00,
		0x04, 0xbc, 0x91, 0xb4, 0x01, 0x0e, 0xe0, 0x6f, 0x07, 0x2f, 0xa1, 0x6f,
		0x00, 0x2e, 0x41, 0x40, 0x40, 0xb2, 0x02, 0x2f, 0xa1, 0x6f, 0x05, 0x42,
		0x44, 0x42, 0x00, 0x2e, 0x8b, 0x6f, 0xc0, 0x5e, 0xb8, 0x2e, 0x03, 0x2e,
		0x1c, 0x01, 0x9c, 0xbc, 0x1d, 0xb9, 0x02, 0x82, 0x25, 0x2e, 0x8e, 0x00,
		0x83, 0x56, 0x13, 0x18, 0x01, 0x2e, 0x66, 0x00, 0x43, 0x40, 0xd8, 0x04,
		0x05, 0x2e, 0x65, 0x00, 0x40, 0x50, 0x27, 0x2e, 0x65, 0x00, 0xfb, 0x7f,
		0xda, 0x05, 0x8b, 0x50, 0x4b, 0x40, 0x02, 0x40, 0x81, 0x82, 0x01, 0x42,
		0x03, 0x80, 0x81, 0x52, 0xb1, 0x00, 0x03, 0x40, 0x3b, 0x82, 0x85, 0x58,
		0x14, 0x01, 0xc0, 0xb2, 0x37, 0x2e, 0x66, 0x00, 0xd1, 0x7f, 0xe2, 0x7f,
		0x04, 0x2f, 0x05, 0x2e, 0x6b, 0x00, 0x81, 0x84, 0x25, 0x2e, 0x6b, 0x00,
		0x62, 0x40, 0x3a, 0x0f, 0x45, 0x40, 0xc1, 0x7f, 0x21, 0x30, 0x12, 0x30,
		0x42, 0x2f, 0x0d, 0x2e, 0x69, 0x00, 0x3e, 0x0e, 0x33, 0x2f, 0x05, 0x2e,
		0x6a, 0x00, 0x01, 0x35, 0x91, 0x0e, 0x01, 0x30, 0x03, 0x2f, 0x09, 0x2e,
		0x6e, 0x00, 0x00, 0xb3, 0x24, 0x2f, 0xc0, 0x35, 0x90, 0x0e, 0x39, 0x2f,
		0x8f, 0x50, 0x02, 0x30, 0x01, 0x40, 0x7f, 0x82, 0x43, 0xa2, 0x02, 0x2f,
		0x00, 0x2e, 0x0c, 0x2c, 0x01, 0x30, 0xc0, 0xb2, 0x11, 0x30, 0x02, 0x2f,
		0x25, 0x2e, 0x6d, 0x00, 0x03, 0x2d, 0x23, 0x2e, 0x6d, 0x00, 0x21, 0x30,
		0x25, 0x2e, 0x6b, 0x00, 0x42, 0xb2, 0x04, 0x2f, 0x41, 0xb2, 0x02, 0x2f,
		0x25, 0x2e, 0x6d, 0x00, 0x31, 0x30, 0x3e, 0x80, 0x04, 0x86, 0x25, 0x2e,
		0x6c, 0x00, 0x02, 0x42, 0xc2, 0x42, 0x18, 0x2d, 0x02, 0x35, 0x01, 0x42,
		0x25, 0x2e, 0x6a, 0x00, 0x13, 0x2d, 0x2c, 0x04, 0x38, 0x1e, 0x21, 0x2e,
		0x69, 0x00, 0x7f, 0x50, 0x11, 0x30, 0x22, 0x30, 0x98, 0x2e, 0x66, 0xb5,
		0x09, 0x2c, 0x01, 0x30, 0x2c, 0x00, 0x38, 0x1c, 0x21, 0x2e, 0x68, 0x00,
		0x7f, 0x50, 0x98, 0x2e, 0x66, 0xb5, 0x01, 0x30, 0xc0, 0x6f, 0xd4, 0xb1,
		0xf5, 0xbd, 0x6b, 0xba, 0x91, 0x5a, 0x02, 0x40, 0x15, 0x18, 0xf5, 0xbe,
		0xeb, 0xbb, 0xe3, 0x0a, 0x3d, 0x0b, 0xd2, 0x6f, 0xe3, 0x00, 0x84, 0x40,
		0x63, 0x05, 0x93, 0x58, 0x2c, 0x18, 0xf5, 0xbe, 0x03, 0x42, 0xeb, 0xbb,
		0xfd, 0x0b, 0xe0, 0x6f, 0x58, 0x01, 0xdf, 0x01, 0x7d, 0x1f, 0x95, 0x42,
		0x18, 0x04, 0x85, 0x40, 0x5d, 0x05, 0x2c, 0x18, 0x75, 0xbe, 0xeb, 0xba,
		0x2c, 0x0b, 0xdc, 0x04, 0x18, 0x1c, 0x80, 0x42, 0x84, 0x80, 0x02, 0x30,
		0x00, 0x40, 0x00, 0xb2, 0x0c, 0x2f, 0x01, 0x2e, 0x6b, 0x00, 0x03, 0x35,
		0x83, 0x0e, 0x07, 0x2f, 0x8d, 0x50, 0x3e, 0x80, 0x25, 0x2e, 0x6d, 0x00,
		0x02, 0x42, 0x03, 0x80, 0x00, 0x2e, 0x02, 0x42, 0x40, 0xb2, 0x04, 0x2f,
		0x8b, 0x50, 0x04, 0x80, 0x25, 0x2e, 0x6a, 0x00, 0x02, 0x42, 0x42, 0xb2,
		0x89, 0x56, 0x9a, 0x22, 0x41, 0xb2, 0x01, 0x2e, 0x1c, 0x01, 0x87, 0x52,
		0x0b, 0xbc, 0x8a, 0x22, 0x0f, 0xb8, 0x00, 0x90, 0x01, 0x32, 0x06, 0x2f,
		0x10, 0x30, 0x90, 0x08, 0x80, 0xb2, 0x08, 0x2f, 0x23, 0x2e, 0x5e, 0xf0,
		0x06, 0x2d, 0x20, 0x30, 0x90, 0x08, 0x80, 0xb2, 0x01, 0x2f, 0x23, 0x2e,
		0x5e, 0xf0, 0xfb, 0x6f, 0xc0, 0x5f, 0xb8, 0x2e, 0x07, 0x86, 0xfc, 0x88,
		0xc6, 0x40, 0x05, 0x41, 0x31, 0x1a, 0x12, 0x2f, 0x80, 0x91, 0x22, 0x2f,
		0x01, 0x35, 0x29, 0x0f, 0x0a, 0x2f, 0x06, 0x80, 0x00, 0x2e, 0x00, 0x40,
		0x00, 0xb2, 0x01, 0x2f, 0x44, 0xa9, 0x03, 0x2f, 0x00, 0x30, 0xc0, 0x42,
		0x00, 0x43, 0xb8, 0x2e, 0xc2, 0x42, 0x01, 0x43, 0xb8, 0x2e, 0x01, 0x35,
		0xa9, 0x0e, 0x0e, 0x2f, 0x03, 0x3b, 0xeb, 0x00, 0xcc, 0xa8, 0x0a, 0x2f,
		0x05, 0x86, 0xc2, 0x80, 0xc3, 0x40, 0x02, 0x42, 0x3c, 0x84, 0xc1, 0x80,
		0x81, 0x42, 0x82, 0x84, 0xc0, 0x2e, 0x80, 0x42, 0x00, 0x2e, 0xb8, 0x2e,
		0x03, 0x2e, 0x1d, 0x01, 0x9f, 0xbc, 0x9f, 0xb8, 0x90, 0x50, 0x40, 0xb2,
		0x90, 0x2e, 0x71, 0xb6, 0x12, 0x40, 0x03, 0x30, 0x11, 0x40, 0x80, 0xa8,
		0x5a, 0x05, 0x9f, 0x58, 0x55, 0x23, 0x00, 0x40, 0x75, 0x7f, 0x40, 0xa8,
		0x16, 0x41, 0xd9, 0x05, 0xcf, 0x23, 0x56, 0x05, 0x40, 0xa9, 0x9d, 0x05,
		0x87, 0x7f, 0x6e, 0x23, 0x17, 0x41, 0xa5, 0x7f, 0x3e, 0x8b, 0x04, 0x41,
		0x52, 0x43, 0x00, 0xa8, 0x98, 0x05, 0xf2, 0x7f, 0x86, 0x22, 0xcf, 0x05,
		0xc0, 0xa9, 0x9f, 0x05, 0xbe, 0x23, 0x04, 0x05, 0x92, 0x7f, 0x00, 0xa9,
		0xdc, 0x05, 0x51, 0x43, 0xb6, 0x7f, 0x27, 0x23, 0xa7, 0x54, 0xe1, 0x7f,
		0x02, 0x18, 0x7d, 0x83, 0x40, 0x43, 0xeb, 0xba, 0x75, 0xbd, 0xaa, 0x0a,
		0x0b, 0x2e, 0x71, 0x00, 0x77, 0x5c, 0x2e, 0x18, 0xf5, 0xbe, 0x6b, 0xbb,
		0x75, 0x0b, 0xaa, 0x00, 0xc4, 0x7f, 0x25, 0x2e, 0x71, 0x00, 0xb2, 0x6f,
		0xa5, 0x6f, 0xaa, 0x00, 0x54, 0x01, 0x84, 0x6f, 0x72, 0x6f, 0x94, 0x05,
		0x80, 0xa9, 0xde, 0x05, 0xb7, 0x23, 0x99, 0x5e, 0x77, 0x0e, 0x41, 0x40,
		0x97, 0x5c, 0xb1, 0x01, 0xd5, 0x7f, 0x00, 0x2e, 0x85, 0x41, 0x0e, 0x2f,
		0x00, 0xa0, 0x0c, 0x2f, 0x14, 0x0f, 0x04, 0x2f, 0xe0, 0x6f, 0x00, 0xac,
		0x10, 0x30, 0x08, 0x2c, 0x18, 0x22, 0xf0, 0x6f, 0x00, 0xac, 0x30, 0x30,
		0x24, 0x30, 0x02, 0x2c, 0x20, 0x22, 0x40, 0x30, 0x0d, 0x2e, 0x71, 0x00,
		0x80, 0xa1, 0x1e, 0x23, 0x79, 0x5e, 0x37, 0x0f, 0xbc, 0x23, 0x00, 0x90,
		0x14, 0x30, 0x10, 0x30, 0x18, 0x2f, 0x9d, 0x50, 0x30, 0x00, 0x9b, 0x56,
		0x43, 0x0e, 0x02, 0x2f, 0x10, 0x30, 0x0a, 0x2c, 0x03, 0x30, 0x99, 0x50,
		0x10, 0x0e, 0x13, 0x30, 0x00, 0x2f, 0x03, 0x30, 0x90, 0x0f, 0x10, 0x30,
		0x00, 0x2f, 0x00, 0x30, 0x00, 0x90, 0x10, 0x30, 0x00, 0x2f, 0x00, 0x30,
		0xc0, 0x90, 0x13, 0x30, 0x00, 0x2f, 0x03, 0x30, 0x40, 0xb2, 0x87, 0x5c,
		0x22, 0x2f, 0x41, 0x90, 0x4a, 0x2f, 0xa5, 0x50, 0x00, 0x2e, 0x01, 0x40,
		0x41, 0x82, 0x01, 0x42, 0x02, 0x80, 0x4a, 0xa8, 0x01, 0x40, 0x06, 0x2f,
		0xd0, 0x6f, 0x85, 0x0e, 0x3e, 0x2f, 0x41, 0x80, 0x21, 0x2e, 0x78, 0x00,
		0x3b, 0x2d, 0x95, 0x50, 0xfb, 0x7f, 0x4a, 0xa8, 0x06, 0x2f, 0x98, 0x2e,
		0x73, 0xb6, 0xc0, 0x90, 0xfb, 0x6f, 0x32, 0x2f, 0x00, 0x2e, 0x30, 0x2d,
		0x98, 0x2e, 0x73, 0xb6, 0x29, 0x2e, 0x7a, 0x00, 0x2b, 0x2c, 0xfb, 0x6f,
		0xa1, 0x52, 0xd2, 0x6f, 0x95, 0x0e, 0x41, 0x40, 0x05, 0x2f, 0x00, 0x90,
		0x17, 0x2f, 0x05, 0x2e, 0x7a, 0x00, 0x80, 0x90, 0x13, 0x2f, 0x7f, 0x82,
		0x40, 0xac, 0x23, 0x2e, 0x77, 0x00, 0x01, 0x30, 0x18, 0x2f, 0xa1, 0x54,
		0x82, 0x84, 0x23, 0x2e, 0x77, 0x00, 0x82, 0x40, 0x80, 0xb2, 0x11, 0x2f,
		0x00, 0x90, 0x23, 0x2e, 0x79, 0x00, 0x0d, 0x2f, 0x29, 0x2e, 0x72, 0x00,
		0x0b, 0x2d, 0x41, 0x80, 0x21, 0x2e, 0x77, 0x00, 0x0f, 0xa4, 0x05, 0x2f,
		0xa3, 0x50, 0x3e, 0x80, 0xf1, 0x30, 0x29, 0x2e, 0x79, 0x00, 0x01, 0x42,
		0x06, 0x30, 0x34, 0x08, 0x00, 0xb2, 0x02, 0x2f, 0x80, 0x30, 0x21, 0x2e,
		0x5e, 0xf0, 0x70, 0x5f, 0xb8, 0x2e, 0x04, 0x84, 0x01, 0x30, 0x81, 0x42,
		0x82, 0x84, 0x01, 0x42, 0xa1, 0x42, 0x81, 0x42, 0x82, 0x84, 0x00, 0x2e,
		0x91, 0x42, 0x81, 0x42, 0xb8, 0x2e, 0x30, 0x50, 0xf3, 0x7f, 0xc0, 0xac,
		0xe4, 0x7f, 0xd5, 0x7f, 0x03, 0x2f, 0x00, 0x30, 0x82, 0x04, 0xf3, 0x6f,
		0xc3, 0x06, 0x40, 0xad, 0x05, 0x2f, 0xe0, 0x6f, 0x05, 0x30, 0x28, 0x04,
		0xd1, 0x6f, 0x69, 0x07, 0xe0, 0x7f, 0x40, 0xa1, 0x01, 0x30, 0x20, 0x2f,
		0x13, 0x25, 0x02, 0x25, 0x04, 0x32, 0x06, 0x30, 0x02, 0x30, 0x03, 0x30,
		0xaf, 0xbb, 0xb1, 0xbd, 0xdf, 0x0a, 0x9f, 0xbb, 0x21, 0xbd, 0x97, 0x0a,
		0x8f, 0xbb, 0x91, 0xbc, 0x01, 0xbc, 0x4f, 0x0a, 0x6b, 0x0e, 0x04, 0x2f,
		0x6b, 0x1a, 0x07, 0x2f, 0xe7, 0x6f, 0x7a, 0x0f, 0x04, 0x2f, 0xe7, 0x6f,
		0x97, 0x04, 0x17, 0x30, 0x07, 0x0a, 0xdd, 0x06, 0x81, 0x8d, 0x34, 0x0e,
		0xe6, 0x2f, 0x00, 0x2e, 0x0d, 0x2d, 0x6b, 0x0e, 0x00, 0x30, 0x05, 0x2f,
		0x6b, 0x1a, 0x07, 0x2f, 0xe0, 0x6f, 0x42, 0x0f, 0x00, 0x30, 0x03, 0x2f,
		0xe0, 0x6f, 0x90, 0x04, 0xdd, 0x06, 0x10, 0x30, 0xf5, 0x6f, 0xc3, 0x7f,
		0xb2, 0x7f, 0x40, 0xad, 0x06, 0x2f, 0x03, 0x30, 0xb2, 0x6f, 0x9a, 0x04,
		0xc4, 0x6f, 0xdc, 0x06, 0xb2, 0x7f, 0xc3, 0x7f, 0x00, 0x2e, 0xd2, 0x6f,
		0xaa, 0x0c, 0x80, 0xac, 0x02, 0x30, 0x01, 0x2f, 0x10, 0x04, 0x51, 0x06,
		0xd0, 0x5f, 0xb8, 0x2e, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00,
		0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00, 0x80, 0x2e, 0x18, 0x00
};

/***************************************************************************/
/*!	Static Function Declarations
****************************************************************************/
/*!
 *	@brief This API update the length for read and write.
 *
 *	@param[in] len : Length for read and write
 *	@param[in] feature : Variable to specify the features
 *	which are to be set in the sensor.
 *	@param[in] enable : Variable which specifies whether to enable or
 *	disable the features in the bma455 sensor.
 *		enable	|	Macros
 *	----------------|-------------------
 *		0x01	|	BMA4_EN
 *		0x00	|	BMA4_DIS
 *	@param[in] dev : Structure instance of bma4_dev.
 *
 *	@return none
 */
static void update_len(uint8_t *len, uint8_t feature, uint8_t enable);

/*!
 *	@brief This API enables the features of sensor.
 *
 *	@param[in] feature : Variable to specify the features
 *	which are to be set in the sensor.
 *	@param[in] len : length to read and write
 *	@param[in] feature_config : Array address which stores the feature
 *	configuration data
 *	@param[in] dev : Structure instance of bma4_dev.
 *
 *	@return Result of API execution status
 *	@retval 0 -> Success
 *	@retval Any positive value mentioned in ERROR CODES -> Fail
 */
static uint16_t feature_enable(uint8_t feature, uint8_t len, uint8_t *feature_config, struct bma4_dev *dev);

/*!
 *	@brief This API disables the features of sensor.
 *
 *	@param[in] feature : Variable to specify the features
 *	which are to be unset in the sensor.
 *	@param[in] len : length to read and write
 *	@param[in] feature_config : Array address which stores the feature
 *	configuration data
 *	@param[in] dev : Structure instance of bma4_dev.
 *
 *	@return Result of API execution status
 *	@retval 0 -> Success
 *	@retval Any positive value mentioned in ERROR CODES -> Fail
 */
static uint16_t feature_disable(uint8_t feature, uint8_t len, uint8_t *feature_config, struct bma4_dev *dev);

/*!
 *  @brief This API update the settings of step counter into write array.
 *
 *  @param[in] setting : Pointer to structure variable which stores the
 *  settings parameter1 to parameter25.
 *  @param[in] index : value for array traversing.
 *  @param[out] feature_config   : Pointer to store the settings
 *
 *  @return none
 */
static void update_stepcounter_parameter(const struct bma423_stepcounter_settings *setting,
					uint8_t index, uint8_t *feature_config);
/*!
 *  @brief This API copy the settings of step counter into the
 *  structure of bma423_stepcounter_settings, which is read from sensor.
 *
 *  @param[out] setting : Pointer to structure variable which stores the
 *  settings parameter1 to parameter25 read from sensor.
 *  @param[in] data_p : Pointer of array which stores the parameters.
 *
 *  @return none
 */
static void extract_stepcounter_parameter(struct bma423_stepcounter_settings *setting, const uint16_t *data_p);

/***************************************************************************/
/**\name		Function definitions
****************************************************************************/

/*!
 *	@brief This API is the entry point.
 *	Call this API before using all other APIs.
 *	This API reads the chip-id of the sensor and sets the resolution.
 */
#include <stdio.h>
uint16_t bma423_init(struct bma4_dev *dev)
{
	uint16_t rslt;

	rslt = bma4_init(dev);

	if (rslt == BMA4_OK) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			/* Resolution of BMA423 sensor is 12 bit */
			dev->resolution = 12;
			dev->feature_len = BMA423_FEATURE_SIZE;
			dev->variant = BMA42X_VARIANT;
		} else {
			rslt |= BMA4_E_INVALID_SENSOR;
		}
	}

	return rslt;
}

/*!
 *	@brief This API is used to upload the config file to enable
 *	the features of the sensor.
 */
uint16_t bma423_write_config_file(struct bma4_dev *dev)
{
	uint16_t rslt = BMA4_OK;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			/* Config. stream read/write length boundary check */
			if ((dev->read_write_len >= BMA423_RD_WR_MIN_LEN) &&
				(dev->read_write_len <= BMA423_FEATURE_SIZE)) {
				/* Even or odd check */
				if ((dev->read_write_len % 2) != 0)
					dev->read_write_len = dev->read_write_len - 1;
				/*Assign stream data */
				dev->config_file_ptr = bma423_config_file;
				rslt = bma4_write_config_file(dev);
			} else {
				rslt = BMA4_E_RD_WR_LENGTH_INVALID;
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}
	return rslt;
}

/*!
 *	@brief This API is used to get the configuration id of the sensor.
 */
uint16_t bma423_get_config_id(uint16_t *config_id, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0};
	uint8_t index = BMA423_CONFIG_ID_OFFSET;
	uint16_t rslt = BMA4_OK;
	uint16_t config_id_lsb = 0;
	uint16_t config_id_msb = 0;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config, BMA423_FEATURE_SIZE, dev);
			if (rslt == BMA4_OK) {
				config_id_lsb = (uint16_t)feature_config[index];
				config_id_msb = ((uint16_t)feature_config[index + 1]) << 8;
				*config_id = config_id_lsb | config_id_msb;
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API sets/unsets the user provided interrupt to either
 *	interrupt pin1 or pin2 in the sensor.
 */
uint16_t bma423_map_interrupt(uint8_t int_line, uint16_t int_map, uint8_t enable, struct bma4_dev *dev)
{
	uint16_t rslt = BMA4_OK;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			if (int_line <= 1) {
				/* Map/Unmap the interrupt */
				rslt = bma4_map_interrupt(int_line, int_map, enable, dev);
			} else {
				rslt = BMA4_E_INT_LINE_INVALID;
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API reads the bma423 interrupt status from the sensor.
 */
uint16_t bma423_read_int_status(uint16_t *int_status, struct bma4_dev *dev)
{
	uint16_t rslt = BMA4_OK;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			/* Read the interrupt status */
			rslt = bma4_read_int_status(int_status, dev);
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API enables/disables the features of the sensor.
 */
uint16_t bma423_feature_enable(uint8_t feature, uint8_t enable, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0};
	uint16_t rslt = BMA4_OK;
	uint8_t len;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			/* Update the length for read and write */
			update_len(&len, feature, enable);
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config, len, dev);
			if (rslt == BMA4_OK) {
				if (enable == TRUE) {
					/* Enables the feature */
					rslt |= feature_enable(feature, len, feature_config, dev);
				} else {
					/* Disables the feature */
					rslt |= feature_disable(feature, len, feature_config, dev);
				}
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API performs x, y and z axis remapping in the sensor.
 */
uint16_t bma423_set_remap_axes(const struct bma423_axes_remap *remap_data, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0};
	uint8_t index = BMA423_AXES_REMAP_OFFSET;
	uint16_t rslt = BMA4_OK;
	uint8_t x_axis = 0;
	uint8_t x_axis_sign = 0;
	uint8_t y_axis = 0;
	uint8_t y_axis_sign = 0;
	uint8_t z_axis = 0;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config, BMA423_FEATURE_SIZE, dev);
			if (rslt == BMA4_OK) {
				x_axis = remap_data->x_axis & BMA423_X_AXIS_MASK;
				x_axis_sign = (remap_data->x_axis_sign << 2) & BMA423_X_AXIS_SIGN_MASK;
				y_axis = (remap_data->y_axis << 3) & BMA423_Y_AXIS_MASK;
				y_axis_sign = (remap_data->y_axis_sign << 5) & BMA423_Y_AXIS_SIGN_MASK;
				z_axis = (remap_data->z_axis << 6) & BMA423_Z_AXIS_MASK;
				feature_config[index] = x_axis | x_axis_sign | y_axis | y_axis_sign | z_axis;
				feature_config[index + 1] = remap_data->z_axis_sign & BMA423_Z_AXIS_SIGN_MASK;
				rslt |= bma4_write_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
							BMA423_FEATURE_SIZE, dev);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API reads the x, y and z axis remap data from the sensor.
 */
uint16_t bma423_get_remap_axes(struct bma423_axes_remap *remap_data, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0};
	uint8_t index = BMA423_AXES_REMAP_OFFSET;
	uint16_t rslt = BMA4_OK;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config, BMA423_FEATURE_SIZE, dev);
			if (rslt == BMA4_OK) {
				remap_data->x_axis = feature_config[index] & BMA423_X_AXIS_MASK;
				remap_data->x_axis_sign = (feature_config[index] & BMA423_X_AXIS_SIGN_MASK) >> 2;
				remap_data->y_axis = (feature_config[index] & BMA423_Y_AXIS_MASK) >> 3;
				remap_data->y_axis_sign = (feature_config[index] & BMA423_Y_AXIS_SIGN_MASK) >> 5;
				remap_data->z_axis = (feature_config[index] & BMA423_Z_AXIS_MASK) >> 6;
				remap_data->z_axis_sign = (feature_config[index + 1] & BMA423_Z_AXIS_SIGN_MASK);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API enables the any motion feature according to the axis
 *	set by the user in the sensor.
 */
uint16_t bma423_anymotion_enable_axis(uint8_t axis, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_ANYMOTION_EN_LEN + 2] = {0};
	/* Anymotion axis enable bit pos. is 3 byte ahead of the
	  anymotion base address(0x00) */
	uint8_t index = 3;
	uint16_t rslt = BMA4_OK;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
						BMA423_ANYMOTION_EN_LEN + 2, dev);
			if (rslt == BMA4_OK) {
				feature_config[index] = BMA4_SET_BITSLICE(feature_config[index],
							BMA423_ANY_NO_MOTION_AXIS_EN, axis);
				rslt |= bma4_write_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
							BMA423_ANYMOTION_EN_LEN + 2, dev);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!	@brief	This API sets the configuration of Any motion feature in
 *	the sensor.
 */
uint16_t bma423_set_any_motion_config(const struct bma423_anymotion_config *any_motion, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_ANYMOTION_EN_LEN + 2] = {0};
	uint8_t index = BMA423_ANY_NO_MOTION_OFFSET;
	uint16_t duration_lsb = 0;
	uint16_t duration_msb = 0;
	uint16_t duration = 0;
	uint16_t rslt = BMA4_OK;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
						BMA423_ANYMOTION_EN_LEN + 2, dev);
			if (rslt == BMA4_OK) {
				/* Assign threshold value in feature config	array */
				feature_config[index++] = BMA4_GET_LSB(any_motion->threshold);
				feature_config[index] = BMA4_GET_MSB(any_motion->threshold);
				/* Assign no motion selection value in feature config array*/
				feature_config[index++] |= (uint8_t)
					(any_motion->nomotion_sel << BMA423_ANY_NO_MOTION_SEL_POS);

				/* Extract duration */
				duration_lsb = feature_config[index];
				duration_msb = feature_config[index + 1] << 8;
				duration = duration_lsb | duration_msb;
				duration = BMA4_SET_BITS_POS_0(duration,
					BMA423_ANY_NO_MOTION_DUR, any_motion->duration);
				/* Assign duration value in feature config array*/
				feature_config[index++] = BMA4_GET_LSB(duration);
				feature_config[index] = BMA4_GET_MSB(duration);

				/* Write any motion settings to the sensor*/
				rslt |= bma4_write_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
							BMA423_ANYMOTION_EN_LEN + 2, dev);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!	@brief	This API gets the configuration of any motion feature from
 *	the sensor.
 */
uint16_t bma423_get_any_motion_config(struct bma423_anymotion_config *any_motion, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_ANYMOTION_EN_LEN + 2] = {0};
	uint8_t anymotion = 0;
	uint16_t rslt = BMA4_OK;
	uint16_t *data_p = (uint16_t *)feature_config;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
						BMA423_ANYMOTION_EN_LEN + 2, dev);
			if (rslt == BMA4_OK) {
				/* Extract threshold value */
				any_motion->threshold = (*data_p) & BMA423_ANY_NO_MOTION_THRES_MSK;
				/* Extract threshold & nomotion selection
				 * data */
				anymotion = ((uint8_t)(*(data_p++) >> 8)) & BMA423_ANY_NO_MOTION_SEL_MSK;
				/* Extract no motion field */
				any_motion->nomotion_sel = anymotion >>
					BMA423_ANY_NO_MOTION_SEL_POS;
				/* Extract duration value */
				any_motion->duration = (*(data_p)) & BMA423_ANY_NO_MOTION_DUR_MSK;
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API enables or disables the step detector feature in the
 *	sensor.
 */
uint16_t bma423_step_detector_enable(uint8_t enable, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0};
	uint16_t rslt = BMA4_OK;
	/* Step detector enable bit pos. is 1 byte ahead of the base address */
	uint8_t index = BMA423_STEP_CNTR_OFFSET + 1;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
					BMA423_FEATURE_SIZE, dev);
			if (rslt == BMA4_OK) {
				feature_config[index] = BMA4_SET_BITSLICE(feature_config[index],
									BMA423_STEP_DETECTOR_EN, enable);
				rslt |= bma4_write_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
							BMA423_FEATURE_SIZE, dev);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API sets the watermark level for step counter
 *	interrupt in the sensor.
 */
uint16_t bma423_step_counter_set_watermark(uint16_t step_counter_wm, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0};
	uint8_t index = BMA423_STEP_CNTR_OFFSET;
	uint16_t wm_lsb = 0;
	uint16_t wm_msb = 0;
	uint16_t rslt = BMA4_OK;
	uint16_t data = 0;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
					BMA423_FEATURE_SIZE, dev);
			if (rslt == BMA4_OK) {
				wm_lsb = feature_config[index];
				wm_msb = feature_config[index + 1] << 8;
				data = wm_lsb | wm_msb;
				/* Sets only watermark bits in the complete
				16 bits of data */
				data = BMA4_SET_BITS_POS_0(data, BMA423_STEP_CNTR_WM, step_counter_wm);
				/* Splits 16 bits of data to individual
				8 bits data */
				feature_config[index] = BMA4_GET_LSB(data);
				feature_config[index + 1] = BMA4_GET_MSB(data);
				/* Writes stepcounter watermark settings
				in the sensor */
				rslt |= bma4_write_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
							BMA423_FEATURE_SIZE, dev);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API gets the water mark level set for step counter interrupt
 *	in the sensor
 */
uint16_t bma423_step_counter_get_watermark(uint16_t *step_counter_wm, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0};
	uint8_t index = BMA423_STEP_CNTR_OFFSET;
	uint16_t wm_lsb = 0;
	uint16_t wm_msb = 0;
	uint16_t rslt = BMA4_OK;
	uint16_t data = 0;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
					BMA423_FEATURE_SIZE, dev);
			if (rslt == BMA4_OK) {
				wm_lsb = feature_config[index];
				wm_msb = feature_config[index + 1] << 8;
				data = wm_lsb | wm_msb;
				*step_counter_wm = BMA4_GET_BITS_POS_0(data, BMA423_STEP_CNTR_WM);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API resets the counted steps of step counter.
 */
uint16_t bma423_reset_step_counter(struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0};
	/* Reset bit is 1 byte ahead of base address */
	uint8_t index = BMA423_STEP_CNTR_OFFSET + 1;
	uint16_t rslt = BMA4_OK;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
					BMA423_FEATURE_SIZE, dev);

			if (rslt == BMA4_OK) {
				feature_config[index] = BMA4_SET_BITSLICE(feature_config[index],
							BMA423_STEP_CNTR_RST, 1);
				rslt |= bma4_write_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
							BMA423_FEATURE_SIZE, dev);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
			rslt = BMA4_E_NULL_PTR;
	}
	return rslt;
}

/*!
 *	@brief This API gets the number of counted steps of the step counter
 *	feature from the sensor.
 */
uint16_t bma423_step_counter_output(uint32_t *step_count, struct bma4_dev *dev)
{
	uint8_t data[BMA423_STEP_CNTR_DATA_SIZE] = {0};
	uint16_t rslt = BMA4_OK;
	uint32_t step_count_0 = 0;
	uint32_t step_count_1 = 0;
	uint32_t step_count_2 = 0;
	uint32_t step_count_3 = 0;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			/* Reads the step counter output data from the
			gpio register */
			rslt = bma4_read_regs(BMA4_STEP_CNT_OUT_0_ADDR, data,
					BMA423_STEP_CNTR_DATA_SIZE, dev);

			if (rslt == BMA4_OK) {
				step_count_0 = (uint32_t)data[0];
				step_count_1 = (uint32_t)data[1] << 8;
				step_count_2 = (uint32_t)data[2] << 16;
				step_count_3 = (uint32_t)data[3] << 24;
				*step_count = step_count_0 | step_count_1 | step_count_2 | step_count_3;
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *  @brief This API gets the output for activity feature.
 */
uint16_t bma423_activity_output(uint8_t *activity, struct bma4_dev *dev)
{
	uint8_t data = 0;
	uint16_t rslt = BMA4_OK;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			/* Reads the activity output from the gpio register */
			rslt = bma4_read_regs(BMA4_ACTIVITY_OUT_ADDR, &data, 1, dev);
			if (rslt == BMA4_OK)
				*activity = data;
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *  @brief This API select the platform configuration wrist(Default) or phone.
 */
uint16_t bma423_select_platform(uint8_t platform, struct bma4_dev *dev)
{
	uint16_t rslt = BMA4_OK;
	struct bma423_stepcounter_settings sc_settings = {0};

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			switch (platform) {
			case BMA423_PHONE_CONFIG:
				sc_settings.param1  = BMA423_PHONE_SC_PARAM_1;
				sc_settings.param2  = BMA423_PHONE_SC_PARAM_2;
				sc_settings.param3  = BMA423_PHONE_SC_PARAM_3;
				sc_settings.param4  = BMA423_PHONE_SC_PARAM_4;
				sc_settings.param5  = BMA423_PHONE_SC_PARAM_5;
				sc_settings.param6  = BMA423_PHONE_SC_PARAM_6;
				sc_settings.param7  = BMA423_PHONE_SC_PARAM_7;
				sc_settings.param8  = BMA423_PHONE_SC_PARAM_8;
				sc_settings.param9  = BMA423_PHONE_SC_PARAM_9;
				sc_settings.param10 = BMA423_PHONE_SC_PARAM_10;
				sc_settings.param11 = BMA423_PHONE_SC_PARAM_11;
				sc_settings.param12 = BMA423_PHONE_SC_PARAM_12;
				sc_settings.param13 = BMA423_PHONE_SC_PARAM_13;
				sc_settings.param14 = BMA423_PHONE_SC_PARAM_14;
				sc_settings.param15 = BMA423_PHONE_SC_PARAM_15;
				sc_settings.param16 = BMA423_PHONE_SC_PARAM_16;
				sc_settings.param17 = BMA423_PHONE_SC_PARAM_17;
				sc_settings.param18 = BMA423_PHONE_SC_PARAM_18;
				sc_settings.param19 = BMA423_PHONE_SC_PARAM_19;
				sc_settings.param20 = BMA423_PHONE_SC_PARAM_20;
				sc_settings.param21 = BMA423_PHONE_SC_PARAM_21;
				sc_settings.param22 = BMA423_PHONE_SC_PARAM_22;
				sc_settings.param23 = BMA423_PHONE_SC_PARAM_23;
				sc_settings.param24 = BMA423_PHONE_SC_PARAM_24;
				sc_settings.param25 = BMA423_PHONE_SC_PARAM_25;
				break;

			case BMA423_WRIST_CONFIG:
				sc_settings.param1  = BMA423_WRIST_SC_PARAM_1;
				sc_settings.param2  = BMA423_WRIST_SC_PARAM_2;
				sc_settings.param3  = BMA423_WRIST_SC_PARAM_3;
				sc_settings.param4  = BMA423_WRIST_SC_PARAM_4;
				sc_settings.param5  = BMA423_WRIST_SC_PARAM_5;
				sc_settings.param6  = BMA423_WRIST_SC_PARAM_6;
				sc_settings.param7  = BMA423_WRIST_SC_PARAM_7;
				sc_settings.param8  = BMA423_WRIST_SC_PARAM_8;
				sc_settings.param9  = BMA423_WRIST_SC_PARAM_9;
				sc_settings.param10 = BMA423_WRIST_SC_PARAM_10;
				sc_settings.param11 = BMA423_WRIST_SC_PARAM_11;
				sc_settings.param12 = BMA423_WRIST_SC_PARAM_12;
				sc_settings.param13 = BMA423_WRIST_SC_PARAM_13;
				sc_settings.param14 = BMA423_WRIST_SC_PARAM_14;
				sc_settings.param15 = BMA423_WRIST_SC_PARAM_15;
				sc_settings.param16 = BMA423_WRIST_SC_PARAM_16;
				sc_settings.param17 = BMA423_WRIST_SC_PARAM_17;
				sc_settings.param18 = BMA423_WRIST_SC_PARAM_18;
				sc_settings.param19 = BMA423_WRIST_SC_PARAM_19;
				sc_settings.param20 = BMA423_WRIST_SC_PARAM_20;
				sc_settings.param21 = BMA423_WRIST_SC_PARAM_21;
				sc_settings.param22 = BMA423_WRIST_SC_PARAM_22;
				sc_settings.param23 = BMA423_WRIST_SC_PARAM_23;
				sc_settings.param24 = BMA423_WRIST_SC_PARAM_24;
				sc_settings.param25 = BMA423_WRIST_SC_PARAM_25;
				break;

			default:
				rslt = BMA4_E_OUT_OF_RANGE;
				break;
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	if (rslt == BMA4_OK) {
		/* Set the step counter parameter */
		rslt = bma423_stepcounter_set_parameter(&sc_settings, dev);
	}

	return rslt;
}

/*!
 *	@brief This API gets the parameter1 to parameter7 settings of the
 *	step counter feature.
 */
uint16_t bma423_stepcounter_get_parameter(struct bma423_stepcounter_settings *setting, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0};
	uint16_t *data_p = (uint16_t *)feature_config;
	uint16_t rslt = BMA4_OK;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config, BMA423_FEATURE_SIZE, dev);

			if (rslt == BMA4_OK) {
				/* To convert 8bit to 16 bit address */
				data_p = data_p + BMA423_STEP_CNTR_PARAM_OFFSET/2;
				extract_stepcounter_parameter(setting, data_p);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API sets the parameter1 to parameter7 settings of the
 *	step counter feature in the sensor.
 */
uint16_t bma423_stepcounter_set_parameter(const struct bma423_stepcounter_settings *setting, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0};
	uint8_t index = BMA423_STEP_CNTR_PARAM_OFFSET;
	uint16_t rslt = BMA4_OK;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config, BMA423_FEATURE_SIZE, dev);
			if (rslt == BMA4_OK) {
				update_stepcounter_parameter(setting, index, feature_config);
				/* Writes stepcounter parameter settings
				in the sensor */
				rslt = bma4_write_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
							BMA423_FEATURE_SIZE, dev);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API sets the sensitivity of wake up feature in the sensor
 */
uint16_t bma423_wakeup_set_sensitivity(uint8_t sensitivity, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0};
	uint8_t index = BMA423_WAKEUP_OFFSET;
	uint16_t rslt = BMA4_OK;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config, BMA423_FEATURE_SIZE, dev);
			if (rslt == BMA4_OK) {
				feature_config[index] = BMA4_SET_BITSLICE(feature_config[index],
									BMA423_WAKEUP_SENS, sensitivity);
				/* Writes sensitivity settings in the sensor */
				rslt |= bma4_write_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
							BMA423_FEATURE_SIZE, dev);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *  @brief This API gets the sensitivity of wake up feature in the sensor
 */
uint16_t bma423_wakeup_get_sensitivity(uint8_t *sensitivity, struct bma4_dev *dev)
{
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0};
	uint8_t index = BMA423_WAKEUP_OFFSET;
	uint16_t rslt = BMA4_OK;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config, BMA423_FEATURE_SIZE, dev);
			if (rslt == BMA4_OK) {
				/* Extracts sensitivity data */
				*sensitivity = BMA4_GET_BITSLICE(feature_config[index], BMA423_WAKEUP_SENS);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}

/*!
 *	@brief This API is used to select single/double tap
 *	feature in the sensor
 */
uint16_t bma423_tap_selection(const uint8_t tap_select, struct bma4_dev *dev)
{
	uint16_t rslt = BMA4_OK;
	uint8_t feature_config[BMA423_FEATURE_SIZE] = {0,};
	uint8_t index = BMA423_WAKEUP_OFFSET;

	if (dev != NULL) {
		if (dev->chip_id == BMA423_CHIP_ID) {
			rslt = bma4_read_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config, BMA423_FEATURE_SIZE, dev);
			if (rslt == BMA4_OK) {
				feature_config[index] = BMA4_SET_BITSLICE(feature_config[index],
									BMA423_TAP_SEL, tap_select);
				rslt = bma4_write_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config,
							BMA423_FEATURE_SIZE, dev);
			}
		} else {
			rslt = BMA4_E_INVALID_SENSOR;
		}
	} else {
		rslt = BMA4_E_NULL_PTR;
	}

	return rslt;
}
/*!
 *	@brief This API update the length for read and write.
 */
static void update_len(uint8_t *len, uint8_t feature, uint8_t enable)
{
	uint8_t length = BMA423_FEATURE_SIZE;

	if ((feature == BMA423_ANY_MOTION) || (feature == BMA423_NO_MOTION)) {
		/* Change the feature length to 2 for reading and writing of 2 bytes for
		any/no-motion enable */
		length = BMA423_ANYMOTION_EN_LEN;

		/* Read and write 4 byte to disable the any/no motion completely along with
		all axis */
		if (enable == BMA4_DISABLE) {
			/*Change the feature length to 4 for reading and writing
			of 4 bytes for any/no-motion enable */
			length = length + 2;
		}
	}

	*len = length;
}

/*!
 *	@brief This API enables the features of the sensor.
 */
static uint16_t feature_enable(uint8_t feature, uint8_t len, uint8_t *feature_config, struct bma4_dev *dev)
{
	uint8_t index = 0;
	uint16_t rslt;

	/* Enable step counter */
	if ((feature & BMA423_STEP_CNTR) > 0) {
		/* Step counter enable bit pos. is 1 byte ahead of the
		base address */
		index = BMA423_STEP_CNTR_OFFSET + 1;
		feature_config[index] = feature_config[index] | BMA423_STEP_CNTR_EN_MSK;
	}

	/* Enable activity */
	if ((feature & BMA423_ACTIVITY) > 0) {
		/* Activity enable bit pos. is 1 byte ahead of the
		base address */
		index = BMA423_STEP_CNTR_OFFSET + 1;
		feature_config[index] = feature_config[index] | BMA423_ACTIVITY_EN_MSK;
	}
	/* Enable tilt */
	if ((feature & BMA423_TILT) > 0) {
		/* Tilt enable bit pos. is the base address(0x3A) of tilt */
		index = BMA423_TILT_OFFSET;
		feature_config[index] = feature_config[index] | BMA423_TILT_EN_MSK;
	}

	/* Enable wakeup */
	if ((feature & BMA423_WAKEUP) > 0) {
		/* Wakeup enable bit pos. is the base address(0x38) of wakeup */
		index = BMA423_WAKEUP_OFFSET;
		feature_config[index] = feature_config[index] | BMA423_WAKEUP_EN_MSK;
	}

	/* Enable anymotion/nomotion */
	if ((feature & BMA423_ANY_MOTION) > 0 || (feature & BMA423_NO_MOTION) > 0) {
		/* Any/Nomotion enable bit pos. is 1 bytes ahead of the
		any/nomotion base address(0x00) */
		index = 1;

		if ((feature & BMA423_ANY_MOTION) > 0) {
			/* Enable anymotion */
			feature_config[index] = feature_config[index] & (~BMA423_ANY_NO_MOTION_SEL_MSK);
		} else {
			/* Enable nomotion */
			feature_config[index] = feature_config[index] | BMA423_ANY_NO_MOTION_SEL_MSK;
		}
	}

	/* Write the feature enable settings in the sensor */
	rslt = bma4_write_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config, len, dev);

	return rslt;
}

/*!
 *	@brief This API disables the features of the sensor.
 */
static uint16_t feature_disable(uint8_t feature, uint8_t len, uint8_t *feature_config, struct bma4_dev *dev)
{
	uint8_t index = 0;
	uint16_t rslt;

	/* Disable step counter */
	if ((feature & BMA423_STEP_CNTR) > 0) {
		/* Step counter enable bit pos. is 1 byte ahead of the
		base address */
		index = BMA423_STEP_CNTR_OFFSET + 1;
		feature_config[index] = feature_config[index] & (~BMA423_STEP_CNTR_EN_MSK);
	}

	/* Disable activity */
	if ((feature & BMA423_ACTIVITY) > 0) {
		/* Activity enable bit pos. is 1 byte ahead of the
		base address */
		index = BMA423_STEP_CNTR_OFFSET + 1;
		feature_config[index] = feature_config[index] & (~BMA423_ACTIVITY_EN_MSK);
	}
	/* Disable tilt */
	if ((feature & BMA423_TILT) > 0) {
		/* Tilt enable bit pos. is the base address(0x3A) of tilt */
		index = BMA423_TILT_OFFSET;
		feature_config[index] = feature_config[index] & (~BMA423_TILT_EN_MSK);
	}

	/* Disable wakeup */
	if ((feature & BMA423_WAKEUP) > 0) {
		/* Tilt enable bit pos. is the base address(0x38) of wakeup */
		index = BMA423_WAKEUP_OFFSET;
		feature_config[index] = feature_config[index] & (~BMA423_WAKEUP_EN_MSK);
	}

	/* Disable anymotion/nomotion */
	if ((feature & BMA423_ANY_MOTION) > 0 || (feature & BMA423_NO_MOTION) > 0) {
		/* Any/Nomotion enable bit pos. is 1 bytes ahead of the
		any/nomotion base address(0x00) */
		index = 1;

		if ((feature & BMA423_ANY_MOTION) > 0) {
			/* Disable anymotion */
			feature_config[index] = feature_config[index] | BMA423_ANY_NO_MOTION_SEL_MSK;
		} else {
			/* Disable nomotion */
			feature_config[index] = feature_config[index] & (~BMA423_ANY_NO_MOTION_SEL_MSK);
		}
		/* Any/Nomotion axis enable bit pos. is 3 byte ahead of the
		any/nomotion base address(0x00) */
		index = 3;
		feature_config[index] = feature_config[index] & (~BMA423_ANY_NO_MOTION_AXIS_EN_MSK);
	}
	/* Write the configured settings in the sensor */
	rslt = bma4_write_regs(BMA4_FEATURE_CONFIG_ADDR, feature_config, len, dev);

	return rslt;
}

/*!
 *  @brief This API update the settings of step counter.
 */
static void update_stepcounter_parameter(const struct bma423_stepcounter_settings *setting,
					uint8_t index, uint8_t *feature_config)
{
	feature_config[index++] = BMA4_GET_LSB(setting->param1);
	feature_config[index++] = BMA4_GET_MSB(setting->param1);
	feature_config[index++] = BMA4_GET_LSB(setting->param2);
	feature_config[index++] = BMA4_GET_MSB(setting->param2);
	feature_config[index++] = BMA4_GET_LSB(setting->param3);
	feature_config[index++] = BMA4_GET_MSB(setting->param3);
	feature_config[index++] = BMA4_GET_LSB(setting->param4);
	feature_config[index++] = BMA4_GET_MSB(setting->param4);
	feature_config[index++] = BMA4_GET_LSB(setting->param5);
	feature_config[index++] = BMA4_GET_MSB(setting->param5);
	feature_config[index++] = BMA4_GET_LSB(setting->param6);
	feature_config[index++] = BMA4_GET_MSB(setting->param6);
	feature_config[index++] = BMA4_GET_LSB(setting->param7);
	feature_config[index++] = BMA4_GET_MSB(setting->param7);
	feature_config[index++] = BMA4_GET_LSB(setting->param8);
	feature_config[index++] = BMA4_GET_MSB(setting->param8);
	feature_config[index++] = BMA4_GET_LSB(setting->param9);
	feature_config[index++] = BMA4_GET_MSB(setting->param9);
	feature_config[index++] = BMA4_GET_LSB(setting->param10);
	feature_config[index++] = BMA4_GET_MSB(setting->param10);
	feature_config[index++] = BMA4_GET_LSB(setting->param11);
	feature_config[index++] = BMA4_GET_MSB(setting->param11);
	feature_config[index++] = BMA4_GET_LSB(setting->param12);
	feature_config[index++] = BMA4_GET_MSB(setting->param12);
	feature_config[index++] = BMA4_GET_LSB(setting->param13);
	feature_config[index++] = BMA4_GET_MSB(setting->param13);
	feature_config[index++] = BMA4_GET_LSB(setting->param14);
	feature_config[index++] = BMA4_GET_MSB(setting->param14);
	feature_config[index++] = BMA4_GET_LSB(setting->param15);
	feature_config[index++] = BMA4_GET_MSB(setting->param15);
	feature_config[index++] = BMA4_GET_LSB(setting->param16);
	feature_config[index++] = BMA4_GET_MSB(setting->param16);
	feature_config[index++] = BMA4_GET_LSB(setting->param17);
	feature_config[index++] = BMA4_GET_MSB(setting->param17);
	feature_config[index++] = BMA4_GET_LSB(setting->param18);
	feature_config[index++] = BMA4_GET_MSB(setting->param18);
	feature_config[index++] = BMA4_GET_LSB(setting->param19);
	feature_config[index++] = BMA4_GET_MSB(setting->param19);
	feature_config[index++] = BMA4_GET_LSB(setting->param20);
	feature_config[index++] = BMA4_GET_MSB(setting->param20);
	feature_config[index++] = BMA4_GET_LSB(setting->param21);
	feature_config[index++] = BMA4_GET_MSB(setting->param21);
	feature_config[index++] = BMA4_GET_LSB(setting->param22);
	feature_config[index++] = BMA4_GET_MSB(setting->param22);
	feature_config[index++] = BMA4_GET_LSB(setting->param23);
	feature_config[index++] = BMA4_GET_MSB(setting->param23);
	feature_config[index++] = BMA4_GET_LSB(setting->param24);
	feature_config[index++] = BMA4_GET_MSB(setting->param24);
	feature_config[index++] = BMA4_GET_LSB(setting->param25);
	feature_config[index] = BMA4_GET_MSB(setting->param25);
}

/*!
 *  @brief This API copy the settings of step counter into the
 *  structure of bma423_stepcounter_settings, which is read from sensor.
 */
static void extract_stepcounter_parameter(struct bma423_stepcounter_settings *setting, const uint16_t *data_p)
{
	setting->param1 = *(data_p++);
	setting->param2 = *(data_p++);
	setting->param3 = *(data_p++);
	setting->param4 = *(data_p++);
	setting->param5 = *(data_p++);
	setting->param6 = *(data_p++);
	setting->param7 = *(data_p++);
	setting->param8 = *(data_p++);
	setting->param9 = *(data_p++);
	setting->param10 = *(data_p++);
	setting->param11 = *(data_p++);
	setting->param12 = *(data_p++);
	setting->param13 = *(data_p++);
	setting->param14 = *(data_p++);
	setting->param15 = *(data_p++);
	setting->param16 = *(data_p++);
	setting->param17 = *(data_p++);
	setting->param18 = *(data_p++);
	setting->param19 = *(data_p++);
	setting->param20 = *(data_p++);
	setting->param21 = *(data_p++);
	setting->param22 = *(data_p++);
	setting->param23 = *(data_p++);
	setting->param24 = *(data_p++);
	setting->param25 = *data_p;
}
