/* Definitions for VAX running Linux-based GNU systems with ELF format.
   Copyright (C) 1994, 1995, 1996, 1997, 1998, 1999 Free Software Foundation, Inc.
   Contributed by Andy Phillips.
   Based heavily on i386 version by Eric Youngdale,
    with modifications by H.J. Lu.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/* temporary*/
#define inhibit_libc

#define LINUX_DEFAULT_ELF
/* FIXME: check this with the gas sources */
#define LPREFIX			".L"

/* Keeps gcc quiet. This is defined in terms of the vaxc structure
 * alignment flag. Only really applicable to VMS. For this target we
 * will be getting a definition from svr4.h */

#ifdef PCC_BITFIELD_TYPE_MATTERS
#undef PCC_BITFIELD_TYPE_MATTERS
#endif 

#include <linux.h>	/* some common stuff */
			/* This includes svr4, which undefines DBX_REGISTER_NUMBER */
#include <vax/pic.h>	/* pic stuff */

#undef TARGET_VERSION
#define TARGET_VERSION fprintf (stderr, " (VAX Linux/ELF)");

#undef CPP_PREDEFINES
#define CPP_PREDEFINES "-D__ELF__ -Dunix -Dvax -D__vax__ -Dlinux -Asystem(posix)  -Acpu(vax) -Amachine(vax)"

#undef CPP_SPEC
#define CPP_SPEC "%(cpp_cpu) %{fPIC:-D__PIC__ -D__pic__} %{fpic:-D__PIC__ -D__pic__} %{posix:-D_POSIX_SOURCE} %{pthread:-D_REENTRANT}"

#undef CC1_SPEC
#define CC1_SPEC "%(cc1_cpu) %{profile:-p}"

/* Provide a LINK_SPEC appropriate for Linux.  Here we provide support
   for the special GCC options -static and -shared, which allow us to
   link things in one of these three modes by applying the appropriate
   combinations of options at link-time. We like to support here for
   as many of the other GNU linker options as possible. But I don't
   have the time to search for those flags. I am sure how to add
   support for -soname shared_object_name. H.J.

   I took out %{v:%{!V:-V}}. It is too much :-(. They can use
   -Wl,-V.

   When the -shared link option is used a final link is not being
   done.  */

/* If ELF is the default format, we should not use /lib/elf. */
/* we do not support libc5 */

#undef	LINK_SPEC
#define LINK_SPEC "-m elf_vax %{shared:-shared} \
  %{!shared: \
    %{!ibcs: \
      %{!static: \
	%{rdynamic:-export-dynamic} \
	%{!dynamic-linker:-dynamic-linker /lib/ld-linux.so.2}} \
	%{static:-static}}}"


/* Make gcc agree with <machine/ansi.h> */

#undef SIZE_TYPE
#define SIZE_TYPE "unsigned int"

#undef PTRDIFF_TYPE
#define PTRDIFF_TYPE "int"

#undef WCHAR_TYPE
#define WCHAR_TYPE "int"

#undef WCHAR_UNSIGNED
#define WCHAR_UNSIGNED 0

#undef WCHAR_TYPE_SIZE
#define WCHAR_TYPE_SIZE 32

/* Until they use ELF or something that handles dwarf2 unwinds
   and initialization stuff better.  */
/* #undef DWARF2_UNWIND_INFO */

#undef ASM_COMMENT_START
#define ASM_COMMENT_START "#"

/* This is how to output an element of a case-vector that is relative.
   This is only used for PIC code.  See comments by the `casesi' insn in
   i386.md for an explanation of the expression this outputs. 
 
 * FIXME: problem. i386 implements non-pic casesi with tablejmp, 
 * and uses casesi for PIC. vax has a better case instruction,
 * so it is used. At the mo, since PIC is in bits, use the std non
 * GOT casesi relative case vector. Else we get ELT's in a .rodata
 * stuffed in the middle of code.
 * 
 */

/* 
  #define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, BODY, VALUE, REL) \
  fprintf (FILE, "\t.long _GLOBAL_OFFSET_TABLE_+[.-%s%d]\n", LPREFIX, VALUE)
*/
/* FIXME: PIC code in vax.md */

#undef ASM_OUTPUT_ADDR_DIFF_ELT
#define ASM_OUTPUT_ADDR_DIFF_ELT(FILE, BODY, VALUE, REL)  \
  fprintf (FILE, "\t.word %s%d-%s%d\n", LPREFIX, VALUE, LPREFIX, REL)

/* Indicate that jump tables (case instr) go in the text section. */
#define JUMP_TABLES_IN_TEXT_SECTION (1)


/* How to renumber registers for dbx and gdb.
   Vax needs no change in the numeration.  */
/* This is repeated here, because it gets undefined in <svr4.h> */

#define DBX_REGISTER_NUMBER(REGNO) (REGNO)

/* we dont have these in our libc */
#undef UDIVSI3_LIBCALL
#undef UMODSI3_LIBCALL
