/* pic support routines Contributed by Andy Phillips,
   atp at mssl.ucl.ac.uk  March 1999 

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/* 
   Generate the assembly code for function entry.
   FILE is an stdio stream to output the code to.
   SIZE is an int: how many units of temporary storage to allocate.
   This differs from the definition in vax.h in that the 
   VMS issues (STARTING_FRAME_OFFSET to accommodate vms.h)
   are not addressed here. PIC is however. If anyone ever wants
   to implement an ELF pic target for VMS that may need to change. 
  
   Refer to the array regs_ever_live' to determine which registers
   to save; regs_ever_live[I]' is nonzero if register number I
   is ever used in the function.  This macro is responsible for
   knowing which registers should not be saved even if used.  
 */

void
function_prologue (file, size)
     FILE *file;
     int size;
{
   
  register int regno;                                           
  register int mask = 0;                                        

  extern char call_used_regs[];                                 
  
  /* Generate register save mask */
  for (regno = 0; regno < FIRST_PSEUDO_REGISTER; regno++)       
    if (regs_ever_live[regno] && !call_used_regs[regno])        
       mask |= 1 << regno;
   
  fprintf (file, "\t.word 0x%x\n", mask);                      

  /* mess with sp to allocate storage */
  if ((size) >= 64) {
     fprintf (file, "\tmovab %d(sp),sp\n", -size);
  }  else {
     if (size) fprintf (file, "\tsubl2 $%d,sp\n", (size)); 
  }
  
}


/* This function generates the assembly code for function exit.
   FILE is an stdio stream to output the code to.
   SIZE is an int: how many units of temporary storage to deallocate. */

void
function_epilogue (file, size)
     FILE *file ATTRIBUTE_UNUSED;
     int size ATTRIBUTE_UNUSED;
{
    return;
}

