/* pic support routines Contributed by Andy Phillips,
   atp at mssl.ucl.ac.uk  March 1999 
   
   i386 implementation used as template
 
This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.  */

/* Stubs for half-pic support if not OSF/1 reference platform.  */

#ifndef HALF_PIC_P
#define HALF_PIC_P() 0
#define HALF_PIC_NUMBER_PTRS 0
#define HALF_PIC_NUMBER_REFS 0
#define HALF_PIC_ENCODE(DECL)
#define HALF_PIC_DECLARE(NAME)
#define HALF_PIC_INIT()	error ("half-pic init called on systems that don't support it.")
#define HALF_PIC_ADDRESS_P(X) 0
#define HALF_PIC_PTR(X) X
#define HALF_PIC_FINISH(STREAM)
#endif

/* Macro to conditionally modify fixed_regs/call_used_regs.  */
#define CONDITIONAL_REGISTER_USAGE			\
  {							\
    if (flag_pic)					\
      {							\
	fixed_regs[PIC_OFFSET_TABLE_REGNUM] = 1;	\
	call_used_regs[PIC_OFFSET_TABLE_REGNUM] = 1;	\
      }							\
 }

/* Register to hold the addressing base for position independent
 *  code access to data items.  
 *  This is r10 on vaxes. There is no ABI, so its r10 'cos I say so. */
#define PIC_OFFSET_TABLE_REGNUM 10

/* This macro generates the assembly code for function entry.
   FILE is a stdio stream to output the code to.
   SIZE is an int: how many units of temporary storage to allocate.
   Refer to the array `regs_ever_live' to determine which registers
   to save; `regs_ever_live[I]' is nonzero if register number I
   is ever used in the function.  This macro is responsible for
   knowing which registers should not be saved even if used.  */
/* overrides default definition in vax.h */

#undef FUNCTION_PROLOGUE
#define FUNCTION_PROLOGUE(FILE, SIZE)     \
  function_prologue (FILE, SIZE)

/* Output assembler code to FILE to increment profiler label # LABELNO
   for profiling a function entry.  */
/* overrides default definition in vax.h */

#undef FUNCTION_PROFILER
#define FUNCTION_PROFILER(FILE, LABELNO)  \
{									\
  if (flag_pic)								\
    {									\
      fprintf (FILE, "\tmovab %sP%d@GOTOFF(r10),r0\n",			\
	       LPREFIX, (LABELNO));					\
      fprintf (FILE, "\tjsb *mcount@GOT(r10)\n");			\
    }									\
  else									\
    {									\
      fprintf (FILE, "\tmovab %sP%d,r0\n", LPREFIX, (LABELNO));		\
      fprintf (FILE, "\tjsb mcount\n");					\
    }									\
}


/* There are three profiling modes for basic blocks available.
   The modes are selected at compile time by using the options
   -a or -ax of the gnu compiler.
   The variable `profile_block_flag' will be set according to the
   selected option.

   profile_block_flag == 0, no option used:

      No profiling done.

   profile_block_flag == 1, -a option used.

      Count frequency of execution of every basic block.

   profile_block_flag == 2, -ax option used.

      Generate code to allow several different profiling modes at run time. 
      Available modes are:
             Produce a trace of all basic blocks.
             Count frequency of jump instructions executed.
      In every mode it is possible to start profiling upon entering
      certain functions and to disable profiling of some other functions.

    The result of basic-block profiling will be written to a file `bb.out'.
    If the -ax option is used parameters for the profiling will be read
    from file `bb.in'.

*/
/* we dont support profile_block_flag == 2, PIC makes this more complex */

#undef	FUNCTION_BLOCK_PROFILER
#define FUNCTION_BLOCK_PROFILER(FILE, LABELNO)				\
{									\
	/* might be an idea to use RTX expressions here like i386 */	\
	if (!flag_pic) {						\
	     /* contents of function block profiler from vax.h */	\
	     /* not very efficient, but clearer FIXME: later */		\
	     fprintf(FILE, "\ttstl %sPBX0\n",LPREFIX);			\
	     fprintf(FILE, "\tjneq %sPI%d\n",LPREFIX, (LABELNO));	\
	     fprintf(FILE, "\tpushal %sPBX0\n",LPREFIX);		\
	     fprintf(FILE, "\tcalls $1,__bb_init_func\n%sPI%d:\n", LPREFIX, (LABELNO)); \
	} else {							\
	     /* pic version  */						\
	     fprintf(FILE, "\ttstl %sPBX0@GOTOFF(r10)\n",LPREFIX);	\
	     fprintf(FILE, "\tjneq %sPI%d@GOT\n",LPREFIX, (LABELNO));	\
	     fprintf(FILE, "\tpushal %sPBX0@GOTOFF(r10)\n",LPREFIX);	\
	     fprintf(FILE, "\tcalls $1,__bb_init_func@PLT\n%sPI%d:\n", LPREFIX, (LABELNO)); \
	}								\
} 

/* Output assembler code to FILE to increment the entry-count for
   the BLOCKNO'th basic block in this source file.  This is a real pain in the
   sphincter on a VAX, since we do not want to change any of the bits in the
   processor status word.  The way it is done here, it is pushed onto the stack
   before any flags have changed, and then the stack is fixed up to account for
   the fact that the instruction to restore the flags only reads a word.
   It may seem a bit clumsy, but at least it works.
*/
/* no support for profile_block_flag == 2 */

#undef BLOCK_PROFILER
#define BLOCK_PROFILER(FILE, BLOCKNO)	\
{					\
    if (!flag_pic) {			\
       /* as before from vax.h */	\
         fprintf (FILE, "\tmovpsl -(sp)\n\tmovw (sp),2(sp)\n\taddl2 $2,sp\n\taddl2 $1,%sPBX2+%d\n\tbicpsw $255\n\tbispsw (sp)+\n", \
	      LPREFIX, (4 * BLOCKNO));	\
    } else {				\
       /* pic version */		\
       fprintf(FILE,"\tmovpsl -(sp)\n\tmovw (sp),2(sp)\n\taddl2 $2,sp\n"); \
       fprintf(FILE,"\taddl2 $1,%sPBX2@GOTOFF+%d(r10)\n", LPREFIX, (4 * BLOCKNO)); \
       fprintf(FILE,"\tbicpsw $255\n\tbispsw (sp)+\n");		\
    }					\
}	

/* The following macro shall output assembler code to FILE
   to indicate a return from function during basic-block profiling.
	
   we do not support the case of profile_block_flag == 2 
   The macro will not be used. 
*/

#define FUNCTION_BLOCK_PROFILER_EXIT(FILE)  {} 

/* This macro generates the assembly code for function exit,
   on machines that need it.  If FUNCTION_EPILOGUE is not defined
   then individual return instructions are generated for each
   return statement.  Args are same as for FUNCTION_PROLOGUE.

   The function epilogue should not depend on the current stack pointer!
   It should use the frame pointer only.  This is mandatory because
   of alloca; we also take advantage of it to omit stack adjustments
   before returning.

   If the last non-note insn in the function is a BARRIER, then there
   is no need to emit a function prologue, because control does not fall
   off the end.  This happens if the function ends in an "exit" call, or
   if a `return' insn is emitted directly into the function. */

#undef FUNCTION_EPILOGUE
#define FUNCTION_EPILOGUE(FILE, SIZE)     \
  function_epilogue (FILE, SIZE)

#define TARGET_DEBUG_ADDR 0
/* Define this macro if references to a symbol must be treated
   differently depending on something about the variable or
   function named by the symbol (such as what section it is in).

   On i386, if using PIC, mark a SYMBOL_REF for a non-global symbol
   so that we may access it directly in the GOT.  */

#define ENCODE_SECTION_INFO(DECL) \
do									\
  {									\
    if (flag_pic)							\
      {									\
	rtx rtl = (TREE_CODE_CLASS (TREE_CODE (DECL)) != 'd'		\
		   ? TREE_CST_RTL (DECL) : DECL_RTL (DECL));		\
									\
	if (TARGET_DEBUG_ADDR						\
	    && TREE_CODE_CLASS (TREE_CODE (DECL)) == 'd')		\
	  {								\
	    fprintf (stderr, "Encode %s, public = %d\n",		\
		     IDENTIFIER_POINTER (DECL_NAME (DECL)),		\
		     TREE_PUBLIC (DECL));				\
	  }								\
									\
	SYMBOL_REF_FLAG (XEXP (rtl, 0))					\
	  = (TREE_CODE_CLASS (TREE_CODE (DECL)) != 'd'			\
	     || ! TREE_PUBLIC (DECL));					\
      }									\
  }									\
while (0)

/* The `FINALIZE_PIC' macro serves as a hook to emit these special
   codes once the function is being compiled into assembly code, but
   not before.  (It is not done before, because in the case of
   compiling an inline function, it would lead to multiple PIC
   prologues being included in functions which used inline functions
   and were compiled to assembly language.)  */

#define FINALIZE_PIC							\
do									\
  {									\
    extern int current_function_uses_pic_offset_table;			\
									\
    current_function_uses_pic_offset_table |= profile_flag | profile_block_flag; \
  }									\
while (0)

/* these two are overridden by routines in pic.c */
/*#undef PRINT_OPERAND
 *#define PRINT_OPERAND(FILE, X, CODE)  \
 *	 vax_print_operand (FILE, X, CODE)
 *
 *#undef PRINT_OPERAND_ADDRESS
 *#define PRINT_OPERAND_ADDRESS(FILE, ADDR)  \
 *	 vax_print_operand_address (FILE, ADDR)
 */

/* externals */

extern void function_prologue ();
extern void function_epilogue ();

/*extern void print_operand ();
 *extern void print_operand_address ();
 */
