import java.io.FileOutputStream;
import java.io.*;
import java.lang.System;
import java.util.*;

import java.math.BigDecimal;

/*
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.ss.util.*;
import org.apache.poi.xssf.usermodel.*;
*/

import javax.json.*;
import javax.json.stream.*;
import javax.json.stream.JsonParser.*;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.*;

public class GenXLS {  

		public static String indent(int il) {
			StringBuffer res = new StringBuffer("");
			for (int i=0; i<il; i++) {
				res.append("  ");
			}
			return res.toString();
		}	
			
		public static String buildAddress(int row, int column) {
			CellReference ref = new CellReference(row,column);
			return ref.formatAsString();
		}
		
        public static void main(String[] args) throws Exception {
				if (args.length<2) {
					System.err.println("GenXLS: "+args.length+" arguments");
					System.err.println("Usage: GenXLS <json-file-name> <XLS-file-name");
					System.exit(-1);
				}	
				/*
				// Create Json and print
				JsonObject json = Json.createObjectBuilder()
					.add("name", "Falco")
					.add("age", BigDecimal.valueOf(3))
					.add("biteable", Boolean.FALSE).build();
				String result = json.toString();
				System.out.println(result);
				// Read back
				JsonReader jsonReader = Json.createReader(new StringReader("{\"name\":\"Falco\",\"age\":3,\"bitable\":false}"));
				JsonObject jobj = jsonReader.readObject();        
				System.out.println(jobj);
				*/
                /* Read the input file that contains the data in JSON format */

                FileInputStream jstream = new FileInputStream(new File(args[0]));
				JsonReader jsreader = Json.createReader(jstream);
				JsonObject wbobj = jsreader.readObject();
				
				JsonArray  sheetnames = wbobj.getJsonArray("SheetNames");
				JsonObject sheets     = wbobj.getJsonObject("Sheets");
				System.out.println("WB has "+sheetnames.size()+" sheets");

				HSSFWorkbook workbook = new HSSFWorkbook();
				
				for (int i=0; i<sheetnames.size(); i++) {
					String sheetname = sheetnames.getString(i);
					HSSFSheet outsheet = workbook.createSheet(sheetname);
					JsonObject insheet = sheets.getJsonObject(sheetname);
					System.out.println("Sheet Object "+sheetname+": ");
				    System.out.println(insheet);	
					CellRangeAddress inrange = CellRangeAddress.valueOf(insheet.getString("!ref"));
					for (int r = inrange.getFirstRow(); r<=inrange.getLastRow(); r++) {
						for (int c = inrange.getFirstColumn(); c<=inrange.getLastColumn(); c++) {
							String adr = buildAddress(r,c);
							JsonObject cell = insheet.getJsonObject(adr);
							System.out.print("Cell "+adr+": ");
							System.out.println(cell);
							String celltype = cell.getString("t");
							switch (celltype) {
								case "s":	String cellString = cell.getString("v");
											break;
								default: System.err.println("Cell "+adr+", Illegal cell type \""+celltype);
											System.exit(-3);
							}
						}
					}
				}
				/*
				JsonParser parser = Json.createParser(jstream);
				while (parser.hasNext()) {
					Event e = parser.next();
					System.out.println("Event: "+e);
					if (e == Event.KEY_NAME) {
						switch (parser.getString()) {
							case "name":
								parser.next();
								System.out.print(parser.getString());
								System.out.print(": ");
								break;
							case "message":
								parser.next();
								System.out.println(parser.getString());
								System.out.println("---------");
								break;
						}
					}
				}
				*/
		}
}