/****************************************************************
 *	FILE:			ccdb_view.js
 *	DESCRIPTION:	collected browser functions for CCDB views
 */
 
var results = {};													// all results on this page
 
function hide_child_rows(rowid,resultid) {
	var res = results[resultid];
	var elem;
	for (var ri=0; ri<res.rows.length; ri++) {
		if (res.rows[ri].rowid==rowid) {
			res.rows[ri].children_hidden = true;
		}
		if (res.rows[ri].parentid==rowid) {							// hide all children of the row with <rowid> ...
			hide_child_rows(res.rows[ri].rowid,resultid);			// ... and their children, recursively
			elem = document.getElementById(res.rows[ri].rowid);
			elem.style.display = "none";
		}
	}
}

function show_child_rows(rowid,resultid) {
	var res = results[resultid];
	var elem;
	for (var ri=0; ri<res.rows.length; ri++) {
		if (res.rows[ri].rowid==rowid) {
			res.rows[ri].children_hidden = false;
		}
		if (res.rows[ri].parentid==rowid) {							// make all children of the row <rowid> visible again
			elem = document.getElementById(res.rows[ri].rowid);
			elem.style.display = "block";
		}
	}
}

function create_result(resultid) {
	if (!results) {
		results = {};
	}
	results[resultid] = {};
	results[resultid].rows = new Array();
	return results[resultid];
}

function remove_result(resultid) {
	delete results[resultid];
}

function create_result_from_table(resultid) {
	var telem;
	res = create_result(resultid);
	telem = document.getElementById(resultid);
	
}

function add_row_to_result(resultid,row) {
	results[resultid].rows.push(row);
}