/*
 *	IT-Services der Sozialversicherung GmbH
 *	Software Operations
 *	Software Quality Assurance
 *
 *	PRODUCT:	CCDB - Competence Center Database
 *	MODULE:		editform.js
 *	VERSION:	0.8.0.99
 *	AUTHOR:		WSC - Wolfgang Scherer
 *	HISTORY:
 *  Version    | Date       | Description
 * ------------+------------+---------------------------------------------------
 * 00.08.00.99 | 2015-12-04 | cloned from queryparamforms.js
 * ------------+------------+---------------------------------------------------
 *
 */
 
console.log("editform loaded");

var editform_version = '00.08.00.99';

var forms = {};

// synchronization of text input and drop-down select for 'presets' input
// this function is used as onChange()-handler of the select-part of the presets fieldset
function combo(thelist, theinput) {
    theinput = document.getElementById(theinput);
    var idx = thelist.selectedIndex;
    var content = thelist.options[idx].innerHTML;
    theinput.value = content;
}


// make <o> to something displayable
function makeString(o) {
	var ts = typeof o;
	switch (ts) {
		case 'number':
		case 'string':
		case 'boolean':
			return o;
			break;
		default:
			return '['+ts+']';
	}
}

// create a visual presentation of <obj> and insert it into <parent>
function insert_doctable(parent,obj) {
	var ftab;
	var tn;
	if (typeof obj === 'object') {
		ftab = document.createElement('table');
		ftab.style.border = "1px solid black";
		ftab.style.borderCollapse = "collapse";
		var frow = ftab.insertRow(-1);
		var fnc = frow.insertCell(-1);
		var fvc = frow.insertCell(-1);
		tn = document.createTextNode("Name");
		fnc.style.fontWeight = "bold";
		fnc.style.border = "1px solid black";
		fvc.style.border = "1px solid black";
		fnc.appendChild(tn);
		tn = document.createTextNode("Wert");
		fvc.style.fontWeight = "bold";
		fvc.appendChild(tn);
		for (fd in obj) {
			frow = ftab.insertRow(-1);
			fnc  = frow.insertCell(-1);
			fvc  = frow.insertCell(-1);
			fnc.style.border = "1px solid black";
			fvc.style.border = "1px solid black";
			fnc.style.verticalAlign = "top";
			fnc.appendChild(document.createTextNode(fd));
			insert_doctable(fvc,obj[fd]);
		}
	} else {
		ftab = document.createElement('p');
		tn = document.createTextNode(makeString(obj));
		ftab.appendChild(tn);
	}
	parent.appendChild(ftab);
}	

//
// =========================== edit forms handling ==================================================
//

//
// anchor elements provide the link between the DOM and the formdata structure(s)
//
var anchorElements = {};

/* *****************************************************************************
 *	FUNCTION:	createAnchorElement
 *	INPUT:		etyp	-	HTML element type string 
 *				fdo		-	the forms data object in the forms data object tree got from the server
 *							this is a reference to a [paraminfo] object
 *				eid		-	the ID the HTML element created shall receive
 *	RETURNS:	aeo	-	anchor element object:
 *					id	- 	the DOM ID of the created HTML element / anchor element for <fdo>
 *							this is usually equal to <eid>, but should not be depended on
 *					el	-	DOM handle to created element
 *					ael	-	handle to anchor element
 *	DESCRIPTION:	creates an HTML element with its according entry in the <anchorElements> dictionary
 *					this allow to find the forms data entry in element event handling functions
 */
function createAnchorElement(etyp,fdo,eid) {
	var el = document.createElement(etyp);
	el.setAttribute("id",eid);
	if (anchorElements[eid]) {
		console.error("AnchorElementsError: element with ID "+eid+" is an already existing anchor element");
	}
	anchorElements[eid] = {};					// create the anchor element with the name <eid>
	anchorElements[eid].formDataObject = fdo;
	return {id: eid, el: el, ael: anchorElements[eid]};
}

function getAnchorElement(id) {
	if (!anchorElements[id]) {
		console.error("AnchorElementsError: there is no anchor element with id "+id);
		console.log("Present anchor elements are: ",anchorElements);
	}
	return anchorElements[id];
}

//
// atomic inputs 
//
function newArrayLine(inpid) {
	var inp = document.getElementById(inpid);
	var ael = getAnchorElement(inpid);
	if (ael.paraminfo) {
		var nr = createObjectInput(ael.formid,ael.paraminfo,inpid+"."+ael.tablength,{ignorebasename: true});
		ael.atable.appendChild(nr);
		ael.tablength++;
	} else {
		console.error("Element "+inpid+" has no paraminfo");
	}
}

/* *****************************************************************************
 *  FUNCTION:       createNumberInput
 *  INPUT:          formid      -   HTML ID of the encompassing <form> element
 *                  fdo         -   the FormData object input is to be created for
 *                  idprefix    -   prefix to be set before IDs of the created HTML elements
 *  DESCRIPTION:    create an input element to enter data for 'Number' item
 *                  creates a text input for editing value
 */
function createNumberInput(formid,pdo,idprefix) {
	var myid = nameprefix+"."+fdo.name;
	var aeo = createAnchorElement('input',fdo,myid);
	aeo.el.setAttribute("type","number");
	aeo.el.setAttribute("name",myid);
	aeo.ael.formDataObject = fdo;
	aeo.ael.formid = formid;
	aeo.ael.idprefix = idprefix;
	if (fdo.value) {
		if (typeof(fdo.value)==='number') {
			aeo.el.setAttribute("value",fdo.value);
		} else {
			console.error("Illegal value type "+typeof(fdo.value)+" for number input: ",fdo.value);
		}
	}
	return aeo.el;
}

/* *****************************************************************************
 *  FUNCTION:       createStringInput
 *  INPUT:          formid      -   HTML ID of the encompassing <form> element
 *                  fdo         -   the FormData object input is to be created for
 *                  idprefix    -   prefix to be set before IDs of the created HTML elements
 *  DESCRIPTION:    create an input element to enter data for 'String' item
 *                  creates a text input HTML element for arbitrary values
 */
function createStringInput(formid,fdo,idprefix) {
	myid = idprefix+'.'+pdo.name;
	var aeo = createAnchorElement('input',fdo,myid);
	aeo.el.setAttribute("type","text");
	aeo.el.setAttribute("name",myid);
	aeo.ael.formDataObject = fdo;
	aeo.ael.formid = formid;
	aeo.ael.idprefix = idprefix;
	if (fdo.maxlen) aeo.el.setAttribute("size",pdo.maxlen);
	if (fdo.value) {
		if (typeof(pdo.value)==='string') {
			aeo.el.setAttribute("value",fdo.value);
		} else {
			console.error("Illegal value type "+typeof(fdo.value)+" for string input: ",fdo.value);
		}
	}
	return aeo.el;
}

/* *****************************************************************************
 *  FUNCTION:       createEnumInput
 *  INPUT:          formid      -   HTML ID of the encompassing <form> element
 *                  fdo         -   the FormData object input is to be created for
 *                  idprefix    -   prefix to be set before IDs of the created HTML elements
 *  DESCRIPTION:    create an input element to enter data for 'Enum' item
 *                  creates a select input for selection amongst valid values
 */
function createEnumInput(formid,fdo,idprefix) {
	var opt;
	var optxt;
	var myid = idprefix+"."+pdo.name;
	var aeo = createAnchorElement("select",pdo,myid);
	aeo.ael.formDataObject = fdo;
	aeo.ael.formid = formid;
	aeo.ael.idprefix = idprefix;
	aeo.el.setAttribute("name",myid);
	for (vle in pdo.vlist) {
		opt = document.createElement("option");
		optxt = document.createTextNode(fdo.vlist[vle].text);
		opt.setAttribute("value",fdo.vlist[vle].value);
		opt.setAttribute("title",fdo.vlist[vle].desc);
		if (fdo.vlist[vle].selected) opt.setAttribute("selected","");
		opt.appendChild(optxt);
		aeo.el.appendChild(opt);
	}
	return aeo.el;
}

/* *****************************************************************************
 *  FUNCTION:       createPresetsInput
 *  INPUT:          formid      -   HTML ID of the encompassing <form> element
 *                  fdo         -   the FormData object input is to be created for
 *                  idprefix    -   prefix to be set before IDs of the created HTML elements
 *  DESCRIPTION:    create an input element to enter data for 'Presets' item
 *                  creates a text input for arbitrary values and a select input for selection amongst preset values
 */
function createPresetsInput(formid,fdo,idprefix) {
	var opt;
	var optxt;
	var myid = idprefix+'.'+fdo.name;
	var aeo = createAnchorElement("fieldset",fdo,myid);                     // a 'Presets' input consists of more than one HTML elements, the <fieldset> has the reference ID
	aeo.ael.formDataObject = fdo;
	aeo.ael.formid = formid;
	aeo.ael.idprefix = idprefix;
	aeo.el.setAttribute("id",myid+"_set");
	var txi = document.createElement("input");                              // the text input HTML element carries the value of the input
	txi.setAttribute("id",myid);
	txi.setAttribute("name",myid);
	var sel = document.createElement("select");                             // the select input HTML element allows the selection of preset values (hence the name 'Presets')
	sel.setAttribute("id",myid+"_sel");
	for (vle in fdo.vlist) {                                                // a 'Presets' input has to have a <.vlist> attribute
		opt = document.createElement("option");
		optxt = document.createTextNode(pdo.vlist[vle].text);
		opt.setAttribute("value",fdo.vlist[vle].value);
		opt.setAttribute("title",fdo.vlist[vle].desc);
		opt.setAttribute("id",myid+"_opt_"+fdo.vlist[vle].value);
		if (fdo.vlist[vle].selected) opt.setAttribute("selected","");
		opt.appendChild(optxt);
		sel.appendChild(opt);
	}
	sel.setAttribute("onChange","combo(this,\""+myid+"\")");
	return aeo.el;
}

/* *****************************************************************************
 *  FUNCTION:       createArrayInput
 *  INPUT:          formid      -   HTML ID of the encompassing <form> element
 *                  fdo         -   the FormData object input is to be created for
 *                  idprefix    -   prefix to be set before IDs of the created HTML elements
 *  DESCRIPTION:    create an input element to enter data for an array
 *                  creates one FormInput for each of the arrays' elements/rows
 */
function createArrayInput(formid,fdo,idprefix) {
	var myid = idprefix+"."+fdo.name;								// myid is the ID of the whole array input, which is no input in its own right (contains only other inputs)	
	var aeo = createAnchorElement('fieldset',fdo,myid);				// ... instead, myid identifies the fieldset encompassing all inputs for the array
	aeo.ael.formDataObject = fdo;
	aeo.ael.formid = formid;
	aeo.ael.idprefix = idprefix;
	var atab = document.createElement('table');						// atab is a table having one row for each row in the array ...
	aeo.ael.atable = atab;
	aeo.ael.tablength = 0;
	atab.setAttribute("id",myid+"_table");
	var r = atab.insertRow(0);										// ... plus one header row with an "Add new row" button
	var c = r.insertCell(0);
	var newbut = document.createElement('button');
	newbut.appendChild(document.createTextNode("Neue Zeile"));
	newbut.setAttribute("id",myid+"_newbutton");
	newbut.setAttribute("OnClick","newArrayLine(\""+myid+"\")");
	newbut.setAttribute("type","button");
	c.appendChild(newbut);
	aeo.el.appendChild(atab);
	if (fdo.value) {
		console.log("Array Input has value assigned in fdata, although representation is not yet defined: ",fdo.value);
	// TODO: fill in pre-set value(s). 
	// NB: in principle, each entry in <fdo.value> has its own value attribute.
	//		However, this could carry only one value, but we'd need one per row !
	}
	return aeo.el;
}

/* *****************************************************************************
 *  FUNCTION:       createObjectInput
 *  INPUT:          formid      -   HTML ID of the encompassing <form> element
 *                  fdo         -   the FormData object input is to be created for
 *                  idprefix    -   prefix to be set before IDs of the created HTML elements
 *  DESCRIPTION:    create an input element to enter data for an object
 *                  creates one FormInput for each of the objects' attributes
 */
function createObjectInput(formid,fdo,idprefix,options) {
	var myid;
	if (options && options.ignorebasename) {
		myid = idprefix;	// special case: if caller requests, the base name is not included in the name hierarchy (e.g. if this object is entry in an array
	} else {
		myid = (fdo.name)?(idprefix+"."+fdo.name):(idprefix);	// myid is the ID of the whole object input, which is no input in its own right (contains only other inputs)
						// special situation: if fdo.name does not exist, this is the top level form and does not need deeper level in ids
	}
	console.log("createObjectInput.ID="+myid);
	var aeo = createAnchorElement('fieldset',fdo,myid);			// ... instead, myid identifies the fieldset encompassing all inputs for the object
	aeo.ael.formDataObject = fdo;
	aeo.ael.formid = formid;
	aeo.ael.idprefix = idprefix;
	var atab = document.createElement('table');
	aeo.el.appendChild(atab);
	aeo.ael.atable = atab;
	var nr;
	for (var oai=0; oai<fdo.subitems.length; oai++) {
		nr = createFormInput(formid,fdo.subitems[oai],myid);
		atab.appendChild(nr);
	}
	if (pdo.value) {
		console.warn("Object Input has value, which is not defined (each field shall have its value)!");
	}
	return aeo.el;
}	
	
/* *****************************************************************************
 *  FUNCTION:   createFormInput
 *  INPUT:      formid      -   HTML ID of the encompassing form
 *              fdo         -   FormData object input is to be created for
 *              idprefix    -   prefix to be set before created IDs for input elements
 *  RETURNS:    a <tr> element to be appended to a table
 *  DESCRIPTION:    create the input elements for one data object <fdo>
 *                  each input is created as a row to a containing table
 *                  each row has 2 cells: 
 *                      the label cell, containing the label for the input
 *                      the value cell, containing the input element(s) for the item <fdo>
 */ 
function createFormInput(formid,fdo,idprefix) {
	console.log("createFormInput.name="+idprefix+'.'+fdo.name);
	var tr = document.createElement('tr');
	// first the label
	var lab = document.createElement('label');
	var ltx = document.createTextNode(fdo.attributes?fdo.attributes.labeltext:null || fdo.labeltext || fdo.typetext || fdo.name);
	lab.setAttribute("title",pdo.attributes?pdo.attributes.typedesc:null || pdo.typedesc);
	lab.appendChild(ltx);
	// then the input(s) for the value
	var inp = null;
	if (fdo.inputString) {
		inp = createStringInput(formid,fdo,idprefix);
	} else if (fdo.inputNumber) {
		inp = createNumberInput(formid,fdo,idprefix);
	} else if (fdo.inputEnum) {
		inp = createEnumInput(formid,fdo,idprefix);
	} else if (fdo.inputPresets) {
		inp = createPresetsInput(formid,fdo,idprefix);
	} else if (fdo.inputArray) {
		inp = createArrayInput(formid,fdo,idprefix);
	} else if (fdo.inputObject) {
		inp = createObjectInput(formid,fdo,idprefix);
	} else {
		throw new Error("undefined input type of "+fdo.name+":",fdo);
	}
	var lc = tr.insertCell(0);  // the "label cell"
	lc.appendChild(lab);
	var vc = tr.insertCell(-1); // the "value cell"
	vc.appendChild(inp);
	return tr;
}

/* *****************************************************************************
 *  FUNCTION:   build_edit_form
 *  INPUT:          fdata   -   [FormData] object
 *                  formid  -   ID of <form> element into which all the inputs are to be placed
 *  DESCRIPTION:    build up the html for the edit form
 *                  the <form> element is created with ID <formid>
 *                  ATTENTION: as of Version 0.8.1 and below, only one form with the same dataname may exist on one page !!
 */
function build_edit_form(fdata,formid) {
	var f = document.getElementById(formid);
	forms[formid] = {};
	forms[formid].fdata = fdata;
	var dt = document.getElementById(doctableid);
	console.log("build_form.fdata: ",fdata);
	// insert_doctable(dt,fdata);
	var form = document.createElement('form');
	form.setAttribute("enctype","multipart/form-data");
	form.setAttribute("action",fdata.url);
	form.setAttribute("method","POST");
	form.setAttribute("id",formid);
	var submitbutton = document.createElement("input");
	submitbutton.setAttribute("type","submit");
	submitbutton.setAttribute("id",formid+"_submit");
	submitbutton.setAttribute("value",(fdata.reqtype?fdata.reqtype:"Aktion")+" starten");
	form.appendChild(submitbutton);
	if (fdata.dataname) {
		var dnf = document.createElement("input");
		dnf.setAttribute("type","hidden");
		dnf.setAttribute("id","dataname");
		dnf.setAttribute("name",formid+".dataname");
		dnf.setAttribute("value",fdata.dataname);
		form.appendChild(dnf);
	}
	// console.log("fdata: ",fdata);
	var fp = createObjectInput(formid,fdata,formid);
	form.appendChild(fp);
	f.appendChild(form);
}