#include <stdint.h>
#include <stdio.h>

#include "devices.h"
#include "instruments.h"
#include "drv_instrument.h"
#include "drv_dac.h"

#define DAC_CHAN_X 0
#define DAC_CHAN_Y 1

dac_t *dac;
instrument_t *ctlpanel;

void init() {
    dac = dac_open(DAC_1);
    ctlpanel = instrument_open(CTLPANEL);
}

void main() {
    init();
    printf("NOS031002 started.\n");
    uint32_t xv,yv,lastx,lasty;
    bool upd;
    lastx = 999;
    lasty = 999;
    unit8_t gen1x,gen1y,gen2x,gen2y;
    uint32_t tim;
    gen1x = 0;
    gen1y = 0;
    gen2x = 0;
    gen2y = 0;
    tim = 0;
    for (;;) {
        tim++;
        tim %= 1000000000;
        gen1x = (gen1x+1) % 256;
        gen1y = (gen2x+2) % 256;
        xv = gen1x + gen2x;
        yv = gen1y + gen2y;
        upd = false;
        /* xv = instrument_get_value(ctlpanel,CTLPANEL_XIN); */
        /* yv = instrument_get_value(ctlpanel,CTLPANEL_YIN); */
        if ((xv!=lastx) || (yv!=lasty) {
            upd = true;
            lastx = xv;
            lasty = yv;
        }
        if (upd) {
           printf("X=%d Y=%d\n",xv,yv);
           instrument_set_value(ctlpanel,CTLPANEL_XOUT,xv);
           dac_write(dac,DAC_CHAN_X,xv,false);
           instrument_set_value(ctlpanel,CTLPANEL_YOUT,yv);
           dac_write(dac,DAC_CHAN_Y,yv,true);
        }
    }
}

