1 REM This software cannot be run in IBM basic. It has been written to be
2 REM to be compiled. The DECL.BAS file could be merged with each software
3 REM package to have a file that will run in basic.
4 REM This would allow the user to modify the routines to fit a particular
5 REM application. The basic source code has been provided for this purpose.
6 REM
7 REM
8 REM
9 REM
10 REM ******************************************************************
11 REM *                                                                *
12 REM *      7854 to IBM PC UTILITY COMMUNICATIONS SOFTWARE            *
13 REM *                       for the                                  *
14 REM *             Tektronix 7854 Oscilloscope                        *
15 REM *                         and                                    *
16 REM *         IBM-PC, IBM-PC XT and IBM portable PC                  *
17 REM *           Copyright 1985 by TEKTRONIX Inc.                     *
18 REM *                All rights reserved                             *
19 REM *                   Version 1.00                                 *
20 REM *                                                                *
21 REM *   This software is provided on an 'as is' basis without        *
22 REM *       warranty of any kind. It is not supported.               *
23 REM *                                                                *
24 REM ******************************************************************
25 REM *
26 REM *   REQUIRED EQUIPMENT:
27 REM *
28 REM *   IBM-PC or IBM-XT with graphics adapter (color monitor is optional)
29 REM *   or IBM-PC PORTABLE
30 REM *   GPIB-PC card from -
32 REM *     National Instruments Inc.   part number 776043-01
33 REM *     Tektronix Inc.              part number 118-4200-00
34 REM *
35 REM *   PURPOSE:
36 REM *    To provide customers with 7854's, utility software that can
37 REM *    give them immediate aid in their applications.
38 REM *
39 REM *   CALLING FORMAT:
40 REM *    This is a stand-alone program. It is also part of a group of
41 REM *    five software programs that make up a utility software
42 REM *    package. This is the main routine that calls other routines
43 REM *    and the routine that the other routines return to.
44 REM *
45 REM *   VARIABLES:
46 REM *
47 REM *    DSO%   Device descriptor altered by IBCONF
48 REM *    DEV$   Specific device (7854) from IBCONF (address 1)
49 REM *    FILE$  Name of file to write to or read from
50 REM *    A$     Name or name and extension to search media for
51 REM *    D$     Drive name where waveforms are stored
52 REM *    E$     Input to continue on error
53 REM *    L$     Points per waveform from waveform file
54 REM *    LL$    Points per waveform with spaces between characters
55 REM *    PRE$   Waveform preamble from file
56 REM *    Q$     String input for INKEY$ selection
57 REM *    RD$    String read from 7854
58 REM *    S$     7854 status read from IBRSP()
59 REM *    SS$    String to send to 7854 X register
60 REM *    T$     Text string to send to 7854
61 REM *    W$     Waveform array to send to 7854
62 REM *    WFM$   Individual cells of W$ read from file
63 REM *    WRT$   String to write to 7854
64 REM *    A      Number of characters in P/W
65 REM *    I,J    For next loop counters
66 REM *    CF     Color of text
67 REM *    CB     Color of background
68 REM *    CD     Color of border
69 REM *    V      X register information
70 REM *    X      Offset for vertical position
71 REM *    Y      Offset for horizontal position
72 REM *
73 REM *
74 REM *  FILES USED:
75 REM *
76 REM *    GRAPH.EXE  is called by selecting <D>isplay
77 REM *    OUTPUT.EXE is called by selecting <O>utput
78 REM *    CONFIG.EXE is called by selecting <C>onfigure
79 REM *    CONFIG      Color information and drive name stored in this file
80 REM *    all.WFM     Waveform files listed, deleted by user
81 REM *    all.PRO     Program files listed, deleted by user
82 REM *    all.REG     X register files listed, deleted by user
83 REM *    GPIB.COM    Supplied with GPIB-PC
84 REM *    CONFIG.SYS  Supplied with GPIB-PC, modified by user
85 REM *    all.CMD     Command files listed, deleted by user
86 REM *  POSSIBLE ERRORS:
87 REM *
88 REM *    GPIB.COM program not on work diskette
89 REM *    CONFIG.SYS program not on work diskette
90 REM *    BASRUN.COM not on work diskette
91 REM *    Other errors should be handled by error handling routines
92 REM *
93 REM ***********************************************************************
99 'COMMON SHARED ibsta%, iberr%, IBCNT%              ' GPIB.QLB
100 COMMON SHARED /NISTATBLK/ ibsta%, iberr%, IBCNT%  ' QBIB4.OBJ
101 FL = 0
110 KEY OFF: SCREEN 0, 0, 0: LOCATE 1, 1
120 GOSUB 520
130 CLS : ON ERROR GOTO 4100: A$ = "config.dat": OPEN A$ FOR INPUT AS #1: INPUT #1, CF, CB, CD, D$: CLOSE #1
140 ON ERROR GOTO 4160: DEV$ = "DEV1"
150 CALL IBFIND(DEV$, dso%)
160 CALL ibclr(dso%)
170 IF ibsta% < 0 THEN GOSUB 680
171 FL = 1
180 wrt$ = "STORED"
190 CALL ibwrt(dso%, wrt$)
200 IF ibsta% < 0 THEN GOSUB 680
210 CALL ibloc(dso%)
220 '
230 REM Print main menu
240 '
250 COLOR CF, CB, CD: CLS : GOSUB 560
256 CALL ibclr(dso%): CALL ibloc(dso%)
260 COLOR CB, CF: LOCATE 1, 1: PRINT STRING$(80, 32); : LOCATE 1, 15: PRINT "7854/IBM PC UTILITIES - COPYRIGHT 1985 by TEKTRONIX Inc": COLOR CF, CB: LOCATE 25, 25: PRINT "Press desired key -";
270 LOCATE X + 2, Y: PRINT "  <P>ROGRAM TRANSFER....Load or save 7854 programs  "
280 LOCATE X + 4, Y: PRINT "  <W>AVEFORM TRANSFER....Send or receive waveforms  "
290 LOCATE X + 6, Y: PRINT "  <R>EGISTER TRANSFER..Read or write to X register  "
300 LOCATE X + 8, Y: PRINT "  <T>EXT TRANSFER................Send text to 7854  "
310 LOCATE X + 10, Y: PRINT "  <O>UTPUT COMMANDS....Send command string to 7854  "
320 LOCATE X + 12, Y: PRINT "  <D>ISPLAY WAVEFORM.......Plot waveform from disk  "
330 LOCATE X + 14, Y: PRINT "  <C>ONFIGURE SYSTEM..........Change system set-up  "
340 LOCATE X + 16, Y: PRINT "  <E>XIT...............................Exit to DOS  "
350 GOSUB 520
360 '
370 REM Menu selection with INKEY$ function
380 '
390 Q$ = INKEY$: IF Q$ = "" THEN 390
400 IF Q$ = "P" THEN GOTO 890
410 IF Q$ = "W" THEN GOTO 1550
420 IF Q$ = "T" THEN GOSUB 2400: GOTO 250
430 IF Q$ = "D" THEN CLS : V% = 0: CALL IBONL(dso%, V%): RUN "graph"
440 IF Q$ = "R" THEN GOTO 2860
450 IF Q$ = "C" THEN CLS : V% = 0: CALL IBONL(dso%, V%): RUN "config"
460 IF Q$ = "O" THEN CLS : V% = 0: CALL IBONL(dso%, V%): RUN "output"
470 IF Q$ = "E" THEN GOTO 4040
480 BEEP: GOTO 390
490 '
500 REM Turn on CAPS LOCK function
510 '
520 DEF SEG = 0: POKE 1047, 64: DEF SEG : RETURN
530 '
540 REM Draw box for main menu
550 '
560 X = 4: Y = 16: IF CF = 0 AND CB = 0 THEN CF = 7
570 LOCATE X, Y - 1: PRINT STRING$(53, 205); CHR$(187)
580 FOR I = 1 TO 18: LOCATE X + 1, Y + 52: PRINT CHR$(186): X = X + 1: NEXT I
590 LOCATE X, Y - 1: PRINT STRING$(53, 205); CHR$(188)
600 LOCATE X, Y - 1: PRINT CHR$(200)
610 FOR I = 18 TO 1 STEP -1: LOCATE X - 1, Y - 1: PRINT CHR$(186): X = X - 1: NEXT I
620 LOCATE X, Y - 1: PRINT CHR$(201)
630 LOCATE X, Y + 22: PRINT " M E N U "
640 RETURN
650 '
660 REM GPIB error routine- checks that 7854 is on-line.
670 '
680 S$ = HEX$(ibsta%): 'PRINT S$,IBERR%,IBCNT%:GOSUB 4470
690 IF S$ = "8000" AND FL = 0 THEN PRINT "GPIB error- Board and/or device not found.": GOSUB 4470: GOTO 750
700 IF S$ = "8100" THEN 730
710 IF S$ = "8900" THEN 730
720 RETURN
730 CLS : FL = 1: LOCATE 12, 1: PRINT "7854 is not on line. This software expects to find a device at address 1.       Press the 7854 ID front panel button and check for :                                      ADDRESS: 01, TALK LISTEN EOI/LF."
740 LOCATE 15, 1: PRINT "Check GPIB cable connection."
750 GOSUB 840: LOCATE 24, 2: PRINT "COMMAND:  <C>ontinue           <E>xit";
760 Q$ = INKEY$: IF Q$ = "" THEN 760
770 IF Q$ = "C" OR Q$ = "c" THEN 210
780 IF Q$ = "E" OR Q$ = "e" THEN 800
790 GOTO 760
800 CLS : GOTO 4040
810 '
820 REM Draw command box for all routines
830 '
840 LOCATE 23, 1: PRINT STRING$(1, 218); : LOCATE 23, 2: PRINT STRING$(78, 196); : LOCATE 23, 79: PRINT STRING$(1, 191);
850 LOCATE 25, 1: PRINT STRING$(1, 192); : LOCATE 25, 2: PRINT STRING$(78, 196); : LOCATE 25, 79: PRINT STRING$(1, 217);
860 LOCATE 24, 1: PRINT STRING$(1, 179); : LOCATE 24, 79: PRINT STRING$(1, 179);
870 RETURN
880 '
890 REM !THIS IS THE PROGRAM TRANSFER SECTION
900 '
910 CLS : LOCATE X + 6, 1: PRINT STRING$(80, 205): LOCATE 1, 1: COLOR CB, CF, CD: PRINT STRING$(80, 32)
920 LOCATE 1, Y + 8: PRINT "PROGRAM TRANSFERS TO AND FROM 7854": COLOR CF, CB, CD
930 LOCATE X + 8, Y: PRINT D$: A$ = "*.PRO": ON ERROR GOTO 4100: FILES D$ + A$
940 ON ERROR GOTO 4180
950 LOCATE X + 6, Y + 10: PRINT " 7854  P R O G R A M  FILES "
960 LOCATE 19, 11: PRINT "* WARNING * If no program exists in the 7854's memory using";
970 LOCATE 20, 11: PRINT "the <R>eceive command may cause the software to lock up.";
980 GOSUB 840: LOCATE 24, 2: PRINT STRING$(76, 32); : LOCATE 24, 2: PRINT "COMMANDS:    <S>end to 7854   <R>eceive from 7854                    <M>enu";
990 Q$ = INKEY$: IF Q$ = "" THEN 990
1000 IF Q$ = "R" THEN 1070
1010 IF Q$ = "S" THEN 1320
1020 IF Q$ = "M" THEN 1280
1030 BEEP: GOTO 990
1040 '
1050 REM Receive programs from 7854
1060 '
1070 LOCATE 24, 2: PRINT STRING$(76, 32);
1080 ON ERROR GOTO 4140
1090 LOCATE X + 18, 1: INPUT " File to save 7854 program (without extension):", file$
1100 IF LEN(file$) < 1 THEN LOCATE X + 18, 1: PRINT STRING$(79, 32); : GOTO 980
1110 ON ERROR GOTO 4180
1120 Y$ = ".": V = INSTR(file$, Y$)
1130 IF V > 0 THEN LOCATE 3, 3: PRINT "Do not use a  '.' in the file name.": LOCATE X + 18, 1: PRINT STRING$(79, 32): GOSUB 4470
1140 IF V > 0 THEN LOCATE 3, 3: PRINT STRING$(79, 32): GOTO 1090
1150 Y$ = ":": V = INSTR(file$, Y$): IF V > 0 THEN file$ = file$ + ".PRO": GOTO 1170
1160 file$ = D$ + file$ + ".PRO"
1170 OPEN file$ FOR OUTPUT AS #1
1180 wrt$ = "EXECUTE 0 GOTO"
1190 CALL ibwrt(dso%, wrt$)
1192 wrt$ = "program save"
1195 CALL ibwrt(dso%, wrt$)
1196 CALL ibrsp(dso%, sta%): IF sta% = 144 OR sta% = 208 THEN 1200 ELSE 1195
1200 RD$ = SPACE$(60)
1210 CALL IBRD(dso%, RD$)
1220 PRINT #1, RD$
1230 CALL ibrsp(dso%, sta%): IF sta% = 2 OR sta% = 66 THEN 1250
1235 FOR count = 1 TO 20: FOR counter = 1 TO 20: NEXT: NEXT
1240 GOTO 1200
1250 CLOSE #1
1260 wrt$ = "EXECUTE"
1270 CALL ibwrt(dso%, wrt$)
1280 CLS :  V% = 0: CALL IBONL(dso%, V%): GOTO 101
1290 '
1300 REM Send programs to 7854
1310 '
1320 LOCATE 24, 2: PRINT STRING$(76, 32);
1330 LOCATE X + 18, 1: PRINT STRING$(79, 32); : LOCATE X + 18, 1: ON ERROR GOTO 4130
1331 INPUT " File to send to 7854 (without extension):", file$
1340 IF LEN(file$) < 1 THEN LOCATE X + 18, 1: PRINT STRING$(79, 32); : GOTO 980
1350 Y$ = ".": V = INSTR(file$, Y$)
1360 IF V > 0 THEN LOCATE 3, 3: PRINT "Do not use a  '.' in the file name.": LOCATE X + 18, 1: PRINT STRING$(79, 32): GOSUB 4470
1370 IF V > 0 THEN LOCATE 3, 3: PRINT STRING$(79, 32): GOTO 1330
1380 Y$ = ":": V = INSTR(file$, Y$): IF V > 0 THEN file$ = file$ + ".PRO": GOTO 1400
1390 file$ = D$ + file$ + ".PRO"
1400 LOCATE X + 14, 1: PRINT STRING$(79, 32)
1410 OPEN file$ FOR INPUT AS #1
1420 wrt$ = "PROGRAM CLP NEXT"
1430 CALL ibwrt(dso%, wrt$)
1440 V% = 0: CALL IBTMO(dso%, V%)
1450 T$ = SPACE$(190)
1460 LINE INPUT #1, T$
1470 T$ = T$ + CHR$(13)
1480 IF EOF(1) THEN 1510
1490 CALL ibwrt(dso%, T$)
1500 GOTO 1450
1510 CLOSE #1: wrt$ = "EXECUTE"
1520 CALL ibwrt(dso%, wrt$)
1530 GOTO 1280
1540 '
1550 REM ! WAVEFORM TRANSFER ROUTINE
1560 '
1570 CLS : LOCATE X + 6, 1: PRINT STRING$(80, 205): LOCATE 1, 1: COLOR CB, CF, CD: PRINT STRING$(80, 32)
1580 LOCATE 1, Y + 15: PRINT " WAVEFORM TRANSFER ": COLOR CF, CB, CD
1590 LOCATE X + 8, Y: PRINT D$: A$ = "*.WFM": ON ERROR GOTO 4100: FILES D$ + A$
1600 ON ERROR GOTO 4180
1610 LOCATE X + 6, Y + 10: PRINT " 7854  W A V E F O R M  FILES "
1620 GOSUB 840: LOCATE 24, 2: PRINT STRING$(76, 32); : LOCATE 24, 2: PRINT "COMMANDS:   <S>end to 7854          <R>eceive from 7854              <M>enu";
1630 Q$ = INKEY$: IF Q$ = "" THEN 1630
1640 IF Q$ = "S" THEN 1970
1650 IF Q$ = "R" THEN 1710
1660 IF Q$ = "M" THEN GOTO 1280
1670 BEEP: GOTO 1630
1680 '
1690 REM Receive waveform from 7854
1700 '
1710 ON ERROR GOTO 4180: LOCATE 24, 2: PRINT STRING$(76, 32);
1720 LOCATE X + 18, 1: INPUT " File to save 7854 waveform (without extension):", file$
1730 IF LEN(file$) < 1 THEN LOCATE X + 18, 1: PRINT STRING$(79, 32); : GOTO 1620
1740 Y$ = ".": V = INSTR(file$, Y$)
1750 IF V > 0 THEN LOCATE 3, 3: PRINT "Do not use a  '.' in the file name.": LOCATE X + 18, 3: PRINT STRING$(79, 32): GOSUB 4470
1760 IF V > 0 THEN LOCATE 3, 3: PRINT STRING$(79, 32): GOTO 1720
1770 CLS : LOCATE 12, 15: PRINT "Transferring Waveform from 7854 . . . . . . . . . "
1780 Y$ = ":": V = INSTR(file$, Y$): IF V > 0 THEN file$ = file$ + ".WFM": GOTO 1800
1790 file$ = D$ + file$ + ".WFM"
1800 OPEN file$ FOR OUTPUT AS #1
1810 sta% = 0
1820 RD$ = SPACE$(255)
1830 wrt$ = "0 WFM SENDX"
1840 CALL ibwrt(dso%, wrt$)
1850 CALL IBRD(dso%, RD$)
1860 PRINT #1, RD$;
1870 CALL ibrsp(dso%, sta%): IF sta% = 2 THEN 1890
1880 GOTO 1850
1890 CLS : LOCATE X + 6, 1: PRINT STRING$(80, 205): LOCATE 1, 1: COLOR CB, CF, CD: PRINT STRING$(80, 32)
1900 LOCATE 1, Y + 6: PRINT "TRANSFER 7854 WAVEFORM TO THE DISK": COLOR CF, CB, CD
1910 LOCATE X + 8, Y: PRINT D$: A$ = "*.WFM": ON ERROR GOTO 4100: FILES D$ + A$
1920 ON ERROR GOTO 4180
1930 CLOSE #1: CALL ibloc(dso%): GOTO 1710
1940 '
1950 REM Send waveform to 7854
1960 '
1970 LOCATE 24, 2: PRINT STRING$(76, 32);
1980 LOCATE 18, 1: PRINT STRING$(79, 32); : LOCATE X + 18, 1: INPUT " File to send to 7854 (without extension):", file$
1990 IF LEN(file$) < 1 THEN LOCATE X + 18, 1: PRINT STRING$(79, 32); : GOTO 1620
2000 Y$ = ".": V = INSTR(file$, Y$)
2010 IF V > 0 THEN LOCATE 3, 3: PRINT "Do not use a  '.' in the file name.": LOCATE X + 18, 1: PRINT STRING$(79, 32): GOSUB 4470
2020 IF V > 0 THEN LOCATE 3, 3: PRINT STRING$(79, 32): GOTO 1980
2030 Y$ = ":": V = INSTR(file$, Y$): IF V > 0 THEN file$ = file$ + ".WFM": GOTO 2050
2040 file$ = D$ + file$ + ".WFM"
2050 ON ERROR GOTO 4120
2060 OPEN file$ FOR INPUT AS #1
2070 CLS : LOCATE 12, 20: PRINT "Loading Waveform from Diskette . . . . . . . "
2080 LINE INPUT #1, PRE$
2090 L = VAL(MID$(PRE$, INSTR(1, PRE$, "NR.PT:") + 6, 9))
2100 DIM W$(1024): I = 0
2110 I = I + 1
2120 c = I / 50: IF c = INT(c) THEN LOCATE 12, 60: PRINT c * 50
2130 IF EOF(1) THEN 2180
2140 INPUT #1, WFM$
2150 IF I = L THEN 2180
2160 W$(I) = WFM$ + CHR$(44)
2170 GOTO 2110
2180 W$(I) = WFM$: CLS : LOCATE 12, 20: PRINT "Transferring Waveform to 7854 . . . . . . . ."
2190 L$ = STR$(L): A = LEN(L$)
2200 FOR J = 1 TO A: LL$ = LL$ + LEFT$(L$, 1) + CHR$(32)
2210 L$ = RIGHT$(L$, A - J)
2220 NEXT J
2230 LL$ = LL$ + " >P/W": CALL ibwrt(dso%, LL$)
2240 wrt$ = "0 WFM READX"
2250 CALL ibwrt(dso%, wrt$)
2260 CALL ibrsp(dso%, SPR%): FOR count = 1 TO 200: NEXT
2265 IF SPR% <> 147 AND SPR% <> 211 THEN 2260
2270 V% = 0: CALL IBEOT(dso%, V%)
2280 CALL ibwrt(dso%, PRE$): IF ibsta% < 0 THEN GOSUB 680
2290 V% = 1
2300 FOR J = 1 TO L
2310 IF J = I THEN CALL IBEOT(dso%, V%)
2320 c = J / 10: IF c = INT(c) THEN LOCATE 12, 60: PRINT L - J
2330 CALL ibwrt(dso%, W$(J))
2340 NEXT J
2350 CLS : CLOSE #1: V% = &H40D: CALL IBEOS(dso%, V%)
2360 GOTO 1280
2370 '
2380 REM ! SEND TEXT TO THE 7854
2390 '
2400 COLOR CF, CB, CD: CLS : GOSUB 2750: LOCATE X - 2, Y + 12: PRINT " TEXT  T R A N S F E R "
2410 COLOR CB, CF: LOCATE 1, 1: PRINT STRING$(80, 32); : LOCATE 1, Y + 12: PRINT "TRANSFER TEXT TO 7854 "; : COLOR CF, CB
2420 GOSUB 840: LOCATE 24, 2: PRINT STRING$(76, 32); : LOCATE 24, 2: PRINT "COMMANDS:   <S>end text                                              <M>enu";
2430 Q$ = INKEY$: IF Q$ = "" THEN 2430
2440 IF Q$ = "S" THEN 2470
2450 IF Q$ = "M" THEN GOTO 1280
2460 BEEP: GOTO 2430
2470 LOCATE 20, 18: PRINT " Enter the text to be transferred. Each line     ";
2480 LOCATE 21, 18: PRINT "number will be printed. Enter 'XMT' to transfer  ";
2490 LOCATE 22, 18: PRINT "  text. A <ENTER> will enter a blank line.       ";
2500 LOCATE 24, 2: PRINT STRING$(76, 32);
2510 T$ = ""
2520 c$ = CHR$(13)
2530 FOR I = 1 TO 12
2540 LOCATE (X - 1) + I, 10: PRINT I: LOCATE (X - 1) + I, Y + 4: LINE INPUT L$
2550 IF L$ = "XMT" THEN 2620
2560 IF L$ = "xmt" THEN 2620
2570 L$ = LEFT$(L$, 40)
2580 T$ = T$ + L$
2590 T$ = T$ + c$
2600 IF I = 12 THEN L$ = "XMT": GOTO 2620
2610 NEXT I
2620 wrt$ = "EXECUTE  >TEXT"
2630 CALL ibwrt(dso%, wrt$)
2640 CALL ibrsp(dso%, sta%)
2641 FOR I = 1 TO 200: NEXT
2643 c = c + 1: IF c = 400 THEN 101
2645 IF sta% <> 149 AND sta% <> 213 THEN 2640
2650 IF LEN(T$) < 1 THEN T$ = CHR$(32)
2660 V% = &HD: CALL IBEOS(dso%, V%)
2670 CALL ibwrt(dso%, T$)
2680 wrt$ = "EXECUTE": CALL ibwrt(dso%, wrt$)
2690 IF ibsta% < 0 THEN GOSUB 680
2700 V% = &H40D: CALL IBEOS(dso%, V%)
2710 RETURN
2720 '
2730 REM Draws box for text transfer
2740 '
2750 COLOR CF, CB, CD: X = 5: Y = 16
2760 LOCATE X - 2, Y + 3: PRINT STRING$(41, 205); CHR$(187)
2770 FOR I = 1 TO 15: LOCATE X - 1, Y + 44: PRINT CHR$(186): X = X + 1: NEXT I
2780 LOCATE X - 1, Y + 3: PRINT STRING$(41, 205); CHR$(188)
2790 LOCATE X - 1, Y + 3: PRINT CHR$(200)
2800 FOR I = 15 TO 1 STEP -1: LOCATE X - 2, Y + 3: PRINT CHR$(186): X = X - 1: NEXT I
2810 LOCATE X - 2, Y + 3: PRINT CHR$(201)
2820 RETURN
2830 '
2840 REM X register transfer routine
2850 '
2860 DIM VL(30): J = 0: I = 0: V = 0
2870 CLS : LOCATE X + 5: PRINT STRING$(80, 205): LOCATE 1, 1: COLOR CB, CF, CD: PRINT STRING$(80, 32)
2880 V% = &HD: CALL IBEOS(dso%, V%)
2890 CALL ibloc(dso%)
2900 LOCATE 1, Y + 5: PRINT "TRANSFER NUMERIC DATA TO AND FROM 7854"; : COLOR CF, CB, CD
2910 GOSUB 840: LOCATE 24, 2
2920 PRINT " COMMANDS:  <S>end to 7854       <R>eceive from 7854                <M>enu ";
2930 Q$ = INKEY$: IF Q$ = "" THEN 2930
2940 IF Q$ = "R" THEN GOSUB 3010
2950 IF Q$ = "S" THEN GOSUB 3830
2960 IF Q$ = "M" THEN GOTO 1280
2970 BEEP: GOTO 2930
2980 '
2990 REM Receive numeric data from 7854 X register
3000 '
3010 Q$ = ""
3020 LOCATE 11, 2: PRINT "The <R>eceive and <A>ppend selections interact with a 7854 program to store"
3030 LOCATE 13, 2: PRINT "the program results on disk (see software Manual for 7854 program limits)."
3040 LOCATE 15, 2: PRINT "Both selections start a 7854 program, wait for any 'SENDX' from "
3050 LOCATE 17, 2: PRINT "the 7854 and terminate when a 'STOP' in encountered. "
3060 LOCATE 19, 2: PRINT "The <G>et function gets and displays single values from the X register."
3070 LOCATE 24, 2: PRINT "COMMANDS:<R>eceive results <A>ppend results <G>et single value <P>rev menu";
3080 Q$ = INKEY$: IF Q$ = "" THEN 3080
3090 IF Q$ = "R" THEN AA = 0: GOTO 3170
3100 IF Q$ = "A" THEN AA = 1: GOTO 3170
3110 IF Q$ = "G" THEN GOTO 3500
3120 IF Q$ = "P" THEN GOTO 2860
3130 BEEP: GOTO 3020
3140 '
3150 REM Transfer X register values from a running 7854 program to a file
3160 '
3170 CALL ibloc(dso%)
3180 S$ = SPACE$(40): LOCATE 11, 1: PRINT STRING$(240, 32); : LOCATE 14, 1: PRINT STRING$(240, 32);
3190 LOCATE 17, 1: PRINT STRING$(240, 32); : LOCATE 24, 2: PRINT STRING$(76, 32);
3200 LOCATE 15, 5: ON ERROR GOTO 4100: A$ = D$ + "*.REG": FILES A$
3210 ON ERROR GOTO 4180
3220 LOCATE X + 18, 1: INPUT "Input file name for storing results  ", file$
3230 IF LEN(file$) < 1 THEN 2860
3240 Y$ = ".": V = INSTR(file$, Y$)
3250 IF V > 0 THEN LOCATE 3, 3: PRINT "Do not use a  '.' in the file name.": LOCATE X + 18, 1: PRINT STRING$(79, 32): GOSUB 4470
3260 IF V > 0 THEN LOCATE 3, 3: PRINT STRING$(79, 32): GOTO 3220
3270 Y$ = ":": V = INSTR(file$, Y$): IF V > 0 THEN file$ = file$ + ".REG": GOTO 3290
3280 file$ = D$ + file$ + ".reg"
3290 IF AA = 1 THEN OPEN file$ FOR APPEND AS #1: GOTO 3310
3300 OPEN file$ FOR OUTPUT AS #1
3310 LOCATE 15, 1: PRINT STRING$(240, 32)
3320 wrt$ = "EXECUTE START": CALL ibwrt(dso%, wrt$)
3330 LOCATE 3, 1: PRINT STRING$(20, 32)
3340 LOCATE 3, 5: CALL ibrsp(dso%, sta%): PRINT "7854 Status is "; sta%: IF sta% <> 146 AND sta% <> 210 THEN 3340
3350 CALL IBRD(dso%, S$)
3360 S = VAL(S$): CR$ = CHR$(13): PRINT #1, S; CR$
3370 LOCATE 3, 1: PRINT STRING$(20, 32)
3380 LOCATE 3, 5: CALL ibrsp(dso%, sta%): PRINT "7854 Status is "; sta%: IF sta% = 66 THEN 3400 ELSE GOTO 3340
3390 LOCATE 3, 1: PRINT STRING$(20, 32)
3400 LOCATE 3, 5: CALL ibrsp(dso%, sta%): PRINT "7854 Status is "; sta%: IF sta% < 66 THEN 3410 ELSE GOTO 3350
3410 LOCATE 22, 1: PRINT STRING$(35, 32); : CLOSE #1: CALL ibloc(dso%)
3420 GOSUB 840: LOCATE 24, 2: PRINT "COMMAND:    <R>epeat transfer to same file                   <P>rev menu  ";
3430 Q$ = INKEY$: IF Q$ = "" THEN 3430
3440 IF Q$ = "R" THEN LOCATE 24, 2: PRINT STRING$(76, 32); : OPEN file$ FOR APPEND AS #1: GOTO 3310
3450 IF Q$ = "P" THEN GOTO 2860
3460 BEEP: GOTO 3420
3470 '
3480 REM Transfer single value from X register
3490 '
3500 LOCATE 11, 1: PRINT STRING$(240, 32); : LOCATE 14, 1: PRINT STRING$(240, 32); : LOCATE 17, 1: PRINT STRING$(240, 32);
3510 LOCATE 14, 10: PRINT "This will receive the contents of the X register"
3520 CALL ibloc(dso%): LOCATE 24, 2: PRINT STRING$(76, 32);
3530 LOCATE 16, 10: PRINT "You may setup the X register as needed. "
3540 LOCATE 18, 15: INPUT "Tap the 'ENTER' key to continue: ", ANS$
3550 LOCATE 14, 1: PRINT STRING$(240, 32); : LOCATE 18, 1: PRINT STRING$(79, 32);
3560 S$ = SPACE$(40)
3570 wrt$ = "STORED": CALL ibwrt(dso%, wrt$)
3580 wrt$ = "SENDX"
3590 CALL ibwrt(dso%, wrt$)
3600 CALL ibrsp(dso%, sta%): IF sta% <> 146 AND sta% <> 210 THEN 3600
3610 CALL IBRD(dso%, S$)
3620 LOCATE 3, 1: PRINT STRING$(240, 32); : LOCATE 6, 1: PRINT STRING$(160, 32);
3630 V = VAL(S$): LOCATE 3, 10: PRINT USING "##.###^^^^"; V: J = J + 1: VL(J) = V: LOCATE 5, 5: FOR I = 1 TO J: PRINT USING "##.###^^^^"; VL(I); : NEXT I
3640 GOSUB 840: LOCATE 24, 2: PRINT "COMMAND:    <R>epeat transfer     <S>ave on disk               <P>rev menu";
3650 Q$ = INKEY$: IF Q$ = "" THEN 3650
3660 IF Q$ = "R" THEN 3500
3670 IF Q$ = "S" THEN GOTO 3700
3680 IF Q$ = "P" THEN GOTO 2860
3690 BEEP: GOTO 3650
3700 LOCATE 15, 5: ON ERROR GOTO 4100: A$ = D$ + "*.REG": FILES A$: LOCATE X + 18, 5: INPUT "Input name of file (without extension)"; file$
3710 IF LEN(file$) < 1 THEN LOCATE 15, 1: PRINT STRING$(79, 32); : BEEP: GOTO 2860
3720 Y$ = ".": V = INSTR(file$, Y$)
3730 IF V > 0 THEN LOCATE 3, 3: PRINT "Do not use a  '.' in the file name.": LOCATE X + 18, 1: PRINT STRING$(79, 32): GOSUB 4470
3740 IF V > 0 THEN LOCATE 3, 3: PRINT STRING$(79, 32): GOTO 3700
3750 file$ = D$ + file$ + ".REG"
3760 OPEN file$ FOR OUTPUT AS #1
3770 FOR I = 1 TO J: PRINT #1, VL(I): NEXT I
3780 I = 0: J = 0
3790 CLOSE #1: LOCATE 3, 1: PRINT STRING$(240, 32): LOCATE 15, 1: PRINT STRING$(240, 32); : LOCATE 18, 1: PRINT STRING$(240, 32); : GOTO 2860
3800 '
3810 REM Send numeric data to 7854 X register
3820 '
3830 SS$ = SPACE$(40): sta% = 0: LOCATE 24, 2: PRINT STRING$(76, 32);
3840 LOCATE 15, 5: PRINT "      Either scientific notation (3E-6) or decimal numbers (.000003)                  may be entered."
3850 Q$ = "": LOCATE 20, 5: INPUT "Input the value to be sent to the X register  ", S$
3860 IF LEN(S$) < 1 THEN 2860
3870 Y$ = ".": V = INSTR(S$, Y$): IF V <> 0 THEN 3900
3880 IF (ASC(S$) > 47) AND (ASC(S$) < 58) THEN 3900
3890 BEEP: LOCATE 20, 5: PRINT STRING$(70, 32); : GOTO 3840
3900 SS$ = S$ + " ENTER"
3910 wrt$ = "READX"
3920 CALL ibwrt(dso%, wrt$)
3930 CALL ibrsp(dso%, sta%)
3931 FOR I = 1 TO 200: NEXT
3935 IF sta% <> 147 AND sta% <> 211 THEN 3930
3940 CALL ibwrt(dso%, SS$)
3950 CALL ibloc(dso%)
3960 LOCATE 24, 2: PRINT "COMMAND: <R>epeat transfer                                          <M>enu";
3970 Q$ = INKEY$: IF Q$ = "" THEN 3970
3980 IF Q$ = "R" THEN CALL ibloc(dso%): LOCATE 20, 1: PRINT STRING$(79, 32); : GOTO 3830
3990 IF Q$ = "M" THEN RETURN
4000 BEEP: GOTO 3970
4010 '
4020 REM !! EXIT ROUTINE CALL IBLOC(DSO%)
4030 '
4040 CALL ibloc(dso%)
4050 DEF SEG = 0: POKE 1047, 0: DEF SEG
4060 COLOR 7, 0, 0: CLS : V% = 0: CALL IBONL(dso%, V%): KEY ON: CLEAR : SYSTEM
4070 '
4080 REM Error routines
4090 '
4100 IF ERR = 53 THEN PRINT "NO FILES EXIST CALLED "; A$: CF = 7: CB = 0: GOSUB 4470: RESUME NEXT
4110 RESUME 140
4120 LOCATE 3, 1: PRINT STRING$(79, 32); : LOCATE 3, 1: PRINT "NO FILES EXIST CALLED "; file$: GOSUB 4470: LOCATE 3, 1: PRINT STRING$(60, 32): LOCATE X + 18, 1: PRINT STRING$(79, 32): RESUME 1980
4130 IF ERR = 53 THEN LOCATE 3, 1: PRINT STRING$(79, 32); : LOCATE 3, 1: PRINT "NO FILES EXIST CALLED "; file$: GOSUB 4470: LOCATE 3, 1: PRINT STRING$(79, 32): LOCATE X + 18, 1: PRINT STRING$(79, 32): RESUME 1330
4140 IF ERR = 53 THEN LOCATE 3, 1: PRINT STRING$(79, 32); : LOCATE 3, 1: PRINT "NO FILES EXIST CALLED "; file$: GOSUB 4470: LOCATE 3, 1: PRINT STRING$(79, 32): LOCATE X + 18, 1: PRINT STRING$(79, 32): RESUME 1090
4150 RESUME
4160 IF ERR = 27 THEN CLS : INPUT "Check printer, hit any key to resume"; E$: E$ = INKEY$: IF E$ = "" THEN 4160: RESUME 0
4170 LOCATE 2, 1: PRINT ERR
4180 IF ERR = 4 THEN CLS : PRINT "Out of data error. Possible diskette problem. Program will be restarted.": GOSUB 4470: RESUME 1280
4190 IF ERR = 7 THEN CLS : PRINT "Out of memory error. Program will be restarted.": GOSUB 4470: RESUME 1280
4200 IF ERR = 24 THEN CLS : PRINT "Device timeout. Should have been handled by GPIB timeout handler. Program    will be restarted.": GOSUB 4470: RESUME 1280
4210 IF ERR = 25 THEN CLS : PRINT "Device fault error. An interface problem that should be handled by the      interface error handler. Program will be restarted.": GOSUB 4470: RESUME 1280
4220 IF ERR = 57 THEN CLS : PRINT "Device I/O error. This error should not occur. Program will be restarted.": GOSUB 4470: RESUME 1280
4230 IF ERR = 58 THEN RESUME 0
4240 IF ERR = 51 THEN CLS : PRINT "See basic manual. This is a fatal error.": GOSUB 4470: RESUME 4040
4250 IF ERR = 53 THEN LOCATE 3, 3: INPUT "File not found, try another file name, hit any key to continue."; E$: E$ = INKEY$: IF E$ = "" THEN 4250: RESUME 4460
4260 IF ERR = 55 THEN LOCATE 3, 3: PRINT "File already opened. Software will continue from menu.": GOSUB 4470: RESUME 4460
4270 IF ERR = 61 THEN 4280 ELSE 4370
4280 V% = 0: CALL IBONL(dso%, V%)
4290 CLS : LOCATE 10, 5: PRINT "Disk is full. Replace disk with a formated disk or delete files "
4300 LOCATE 12, 5: PRINT "on disk presently being used. File being saved will be deleted. ";
4320 CLOSE #1: LOCATE 14, 5: PRINT " Tap any key to continue from the Main Menu.";
4330 Q$ = INKEY$: IF Q$ = "" THEN 4330
4350 KILL file$
4360 RUN "7854"
4370 IF ERR = 14 THEN CLS : CLEAR : PRINT "Out of string space. Program will be restarted.": GOSUB 4470: RESUME 1280
4380 IF (ERR = 15) OR (ERR = 16) THEN 4390 ELSE 4400
4390 PRINT "String too long. String is not demensioned for more than 255 characters.    Try to break the string into smaller strings.": GOSUB 4470: RESUME
4400 IF ERR = 62 THEN RESUME
4410 IF ERR = 67 THEN LOCATE 3, 3: INPUT "Replace diskette, hit any key to continue."; E$: E$ = INKEY$: IF E$ = "" THEN 4410: LOCATE 3, 3: PRINT STRING$(60, 32): RESUME
4420 IF ERR = 70 THEN LOCATE 3, 3: INPUT "Un-write protect diskette, hit any key to continue."; E$: E$ = INKEY$: IF E$ = "" THEN 4420: LOCATE 3, 3: PRINT STRING$(60, 32): RESUME
4430 IF ERR = 71 THEN LOCATE 3, 3: INPUT "Check diskette, hit any key to continue."; E$: E$ = INKEY$: IF E$ = "" THEN 4430: LOCATE 3, 1: PRINT STRING$(60, 32): RESUME 4460
4440 IF ERR = 72 THEN LOCATE 3, 3: INPUT "Replace diskette, hit any key to continue."; E$: E$ = INKEY$: IF E$ = "" THEN 4440: LOCATE 3, 3: PRINT STRING$(60, 32): RESUME
4450 RESUME NEXT
4460 GOTO 1280
4470 BEEP: FOR I = 1 TO 4000: NEXT I: RETURN

