1 REM This software cannot be run in IBM basic. It has been written to be
2 REM to be compiled. The DECL.BAS file could be merged with each software
3 REM package to have a file that will run in basic.
4 REM This would allow the user to modify the routines to fit a particular
5 REM application. The basic source code has been provided for this purpose.
6 REM
7 REM
8 REM
9 REM
10 REM ******************************************************************
11 REM *                                                                *
12 REM *      7854 to IBM PC UTILITY COMMUNICATIONS SOFTWARE            *
13 REM *                       for the                                  *
14 REM *             Tektronix 7854 Oscilloscope                        *
15 REM *                         and                                    *
16 REM *         IBM-PC, IBM-PC XT and IBM portable PC                  *
17 REM *           Copyright 1985 by TEKTRONIX Inc.                     *
18 REM *                All rights reserved                             *
19 REM *                   Version 1.00                                 *
20 REM *                                                                *
21 REM *   This software is provided on an 'as is' basis without        *
22 REM *       warranty of any kind. It is not supported.               *
23 REM *                                                                *
24 REM ******************************************************************
25 REM *
26 REM *   REQUIRED EQUIPMENT:
27 REM *
28 REM *   IBM-PC or IBM-XT with graphics adapter (color monitor is optional)
29 REM *   or IBM-PC PORTABLE
30 REM *   GPIB-PC card from -
32 REM *     National Instruments Inc.   part number 776043-01
33 REM *     Tektronix Inc.              part number 118-4200-00
34 REM *
35 REM *   PURPOSE:
36 REM *    Allows the user to set-up the system according to his needs
37 REM *    and desires.
38 REM *
39 REM *   CALLING FORMAT:
40 REM *    This is a stand-alone program. It is also part of a group of
41 REM *    five software programs that make up a utility software
42 REM *    package. 7854.EXE is the name of the software routine that
43 REM *    this software exits to.
44 REM *
45 REM *   VARIABLES:
46 REM *
47 REM *    DSO%   Device descriptor altered by IBCONF
48 REM *    DEV$   Specific device (7854) from IBCONF (address 1)
49 REM *    FILE$  Name of file to write to or read from
50 REM *    A$     Name or name and extension to search media for
51 REM *    D$     Drive name where waveforms are stored
52 REM *    CF$    String input for text color
53 REM *    CB$    String input for background color
54 REM *    CD$    String input for border color
55 REM *    Q$     String input for INKEY$ selection
56 REM *    CF     Color of text
57 REM *    CB     Color of background
58 REM *    CD     Color of border
59 REM *    X      Offset for vertical position
60 REM *    Y      Offset for horizontal position
61 REM *
62 REM *
63 REM *  ROUTINES CALLED:
64 REM *
65 REM *    7854.EXE is returned to by selecting <M>enu
66 REM *
67 REM *  FILES USED:
68 REM *
69 REM *    CONFIG      Color information and drive name stored in this file
70 REM *    all.WFM     Waveform files listed, deleted by user
71 REM *    all.PRO     Program files listed, deleted by user
72 REM *    all.REG     X register files listed, deleted by user
73 REM *    all.CMD     Command string files listed, deleted by user
74 REM *    7854.EXE    Main program, see ROUTINES CALLED
75 REM *    GPIB.COM    Supplied with GPIB-PC
77 REM *
79 REM *
80 REM *  POSSIBLE ERRORS:
81 REM *
83 REM *    No known errors not handled by 'ON ERROR' routines
84 REM *
90 REM ***********************************************************************
100 'COMMON SHARED ibsta%, iberr%, IBCNT%               ' GPIB.QLB
101 COMMON SHARED /NISTATBLK/ ibsta%, iberr%, IBCNT%  ' QBIB4.OBJ
110 DEF SEG = 0: POKE 1047, 64: DEF SEG
120 ON ERROR GOTO 1490: A$ = "CONFIG.DAT": OPEN A$ FOR INPUT AS #1: INPUT #1, CF, CB, CD, D$: CLOSE #1: CLS : COLOR CF, CB, CD
130 DEV$ = "DEV1": X = 4: Y = 16: ON ERROR GOTO 1510
140 CALL IBFIND(DEV$, DSO%)
150 CALL IBLOC(DSO%)
160 '
170 REM  This is the CONFIGURE menu
180 '
190 CLS : COLOR CB, CF, CD: LOCATE 1, 1: PRINT STRING$(80, 32); : LOCATE 1, 30: PRINT "CONFIGURE SYSTEM": COLOR CF, CB: LOCATE 25, 2: PRINT STRING$(78, 32);
200 GOSUB 1600: LOCATE 24, 2: PRINT "COMMANDS: <C>hange color  <D>elete files <N>ew drive  <S>ave config  <M>enu";
210 GOSUB 1560
220 Q$ = INKEY$: IF Q$ = "" THEN 220
230 IF Q$ = "C" THEN GOSUB 320: GOTO 190
240 IF Q$ = "D" THEN GOSUB 1120: GOTO 190
250 IF Q$ = "N" THEN GOSUB 1290: GOTO 200
260 IF Q$ = "M" THEN 1640
270 IF Q$ = "S" THEN GOSUB 1440: GOTO 1640
280 BEEP: GOTO 190
290 '
300 REM Color setting routine for text, background and border
310 '
320 CLS : COLOR 7, 0, 0: CLS : Y = 2: X = 4
330 COLOR 0, 7: LOCATE 1, 1: PRINT STRING$(79, 32)
340 LOCATE 2, 1: PRINT "          Text                      Background              Border             "; : COLOR 15, 0
350 LOCATE X - 3, Y - 1: PRINT STRING$(80, 205);
360 LOCATE X - 1, Y - 1: PRINT STRING$(80, 205);
370 LOCATE X + 16, Y - 1: PRINT STRING$(80, 205);
380 LOCATE X + 19, Y - 1: PRINT STRING$(80, 205);
390 FOR I = 1 TO 21: LOCATE X - 2, Y - 1: PRINT CHR$(186): X = X + 1: NEXT: X = X - 21
400 FOR I = 1 TO 18: LOCATE X - 2, Y + 27: PRINT CHR$(186): X = X + 1: NEXT: X = X - 18
410 FOR I = 1 TO 18: LOCATE X - 2, Y + 53: PRINT CHR$(186): X = X + 1: NEXT: X = X - 18
420 FOR I = 1 TO 21: LOCATE X - 2, Y + 78: PRINT CHR$(186): X = X + 1: NEXT: X = X - 21
430 LOCATE X - 1, Y - 1: PRINT CHR$(204)
440 LOCATE X - 1, Y + 78: PRINT CHR$(185)
450 LOCATE X - 3, Y - 1: PRINT CHR$(201)
460 LOCATE X - 3, Y + 27: PRINT CHR$(203)
470 LOCATE X - 3, Y + 53: PRINT CHR$(203)
480 LOCATE X - 3, Y + 78: PRINT CHR$(187)
490 LOCATE X - 1, Y + 27: PRINT CHR$(206)
500 LOCATE X - 1, Y + 53: PRINT CHR$(206)
510 LOCATE X + 16, Y - 1: PRINT CHR$(204)
520 LOCATE X + 16, Y + 27: PRINT CHR$(202)
530 LOCATE X + 16, Y + 53: PRINT CHR$(202)
540 LOCATE X + 16, Y + 78: PRINT CHR$(185)
550 LOCATE X + 19, Y - 1: PRINT CHR$(200);
560 LOCATE X + 19, Y + 78: PRINT CHR$(188);
570 '
580 REM This is the color 'memu'
590 '
600 COLOR 0, 7, 0: LOCATE X, Y: PRINT "  0 = Black                ": GOSUB 790: X = X + 1
610 COLOR 1, 0, 0: LOCATE X, Y: PRINT "  1 = Blue                 ": GOSUB 790: X = X + 1
620 COLOR 2, 0, 0: LOCATE X, Y: PRINT "  2 = Green                ": GOSUB 790: X = X + 1
630 COLOR 3, 0, 0: LOCATE X, Y: PRINT "  3 = Cyan                 ": GOSUB 790: X = X + 1
640 COLOR 4, 0, 0: LOCATE X, Y: PRINT "  4 = Red                  ": GOSUB 790: X = X + 1
650 COLOR 5, 0, 0: LOCATE X, Y: PRINT "  5 = Magenta              ": GOSUB 790: X = X + 1
660 COLOR 6, 0, 0: LOCATE X, Y: PRINT "  6 = Brown                ": GOSUB 790: X = X + 1
670 COLOR 7, 0, 0: LOCATE X, Y: PRINT "  7 = White                ": GOSUB 790: X = X + 1
680 COLOR 8, 7, 0: LOCATE X, Y: PRINT "  8 = Gray                 ": X = X + 1
690 COLOR 9, 0, 0: LOCATE X, Y: PRINT "  9 = Light Blue           ": X = X + 1
700 COLOR 10, 0, 0: LOCATE X, Y: PRINT " 10 = Light Green          ": X = X + 1
710 COLOR 11, 0, 0: LOCATE X, Y: PRINT " 11 = Light Cyan           ": X = X + 1
720 COLOR 12, 0, 0: LOCATE X, Y: PRINT " 12 = Light Red            ": X = X + 1
730 COLOR 13, 0, 0: LOCATE X, Y: PRINT " 13 = Light Magenta        ": X = X + 1
740 COLOR 14, 0, 0: LOCATE X, Y: PRINT " 14 = Yellow               ": X = X + 1
750 COLOR 15, 0, 0: LOCATE X, Y: PRINT " 15 = High-intensity White ": X = X + 1
760 COLOR 7, 0, 0: X = X - 15
770 LOCATE X + 10, Y + 60: PRINT "Not available": LOCATE X + 10, Y + 34: PRINT "Not available"
780 GOTO 850
790 LOCATE X, Y + 28: PRINT STRING$(25, 219); : LOCATE X, Y + 54: PRINT STRING$(24, 219); : RETURN
800 LOCATE 25, 20: PRINT STRING$(79, 32);
810 LOCATE X, Y + 28: PRINT STRING$(25, 219); : RETURN
820 '
830 REM Select color routine
840 '
850 COLOR 0, 7: LOCATE 24, 1: PRINT STRING$(79, 32);
860 LOCATE 24, 14: PRINT CF; : LOCATE 24, 2: INPUT ; "Text "; CF$
870 IF LEN(CF$) < 1 THEN 920
880 IF VAL(CF$) = 0 THEN CF1 = 0
890 NUM = ASC(CF$): IF (NUM > 47) AND (NUM < 58) THEN 900 ELSE BEEP: LOCATE 24, 2: PRINT STRING$(25, 32); : GOTO 860
900 IF VAL(CF$) > 15 THEN BEEP: LOCATE 24, 2: PRINT STRING$(25, 32); : GOTO 860
910 CF1 = VAL(CF$): LOCATE 24, 14: PRINT "   "; : CF = CF1
920 LOCATE 24, 51: PRINT CB; : LOCATE 24, 38: INPUT ; "Background"; CB$
930 IF LEN(CB$) < 1 THEN 980
940 IF VAL(CB$) = 0 THEN CB1 = 0
950 NUM = ASC(CB$): IF (NUM > 47) AND (NUM < 58) THEN 960 ELSE BEEP: LOCATE 24, 38: PRINT STRING$(25, 32); : GOTO 920
960 IF VAL(CB$) > 7 THEN BEEP: LOCATE 24, 38: PRINT STRING$(15, 32); : GOTO 920
970 CB1 = VAL(CB$): LOCATE 24, 51: PRINT "   "; : CB = CB1
980 LOCATE 24, 69: PRINT CD; : LOCATE 24, 60: INPUT ; "Border"; CD$
990 IF LEN(CD$) < 1 THEN 1040
1000 IF VAL(CD$) = 0 THEN CD1 = 0
1010 NUM = ASC(CD$): IF (NUM > 47) AND (NUM < 58) THEN 1020 ELSE BEEP: LOCATE 24, 60: PRINT STRING$(19, 32); : GOTO 980
1020 IF VAL(CD$) > 7 THEN BEEP: LOCATE 24, 60: PRINT STRING$(15, 32); : GOTO 980
1030 CD1 = VAL(CD$): LOCATE 24, 69: PRINT "  "; : CD = CD1
1040 IF CF = CB THEN CF = CB + 7
1050 CLS : COLOR CF, CB, CD: RETURN
1060 COLOR 7, 0
1070 Q$ = INKEY$: IF Q$ = "" THEN 1070
1080 GOTO 850
1090 '
1100 REM Delete files routine
1110 '
1120 GOSUB 1600: LOCATE 24, 2: PRINT STRING$(76, 32); : LOCATE 24, 2: PRINT "Enter the file name to be deleted or tap <ENTER> to return to CONFIG Menu ";
1130 GOSUB 1560
1140 X = 4: Y = 16
1150 COLOR CB, CF: LOCATE 1, 1: PRINT STRING$(80, 32): LOCATE 1, Y + 12: PRINT "FILES STORED ON MEDIA"; : COLOR CF, CB: LOCATE X, Y: A$ = "*.PRO"
1160 PRINT D$: FILES D$ + A$
1170 LOCATE X + 4, Y: A$ = "*.WFM": PRINT D$: FILES D$ + A$
1180 LOCATE X + 8, Y: A$ = "*.REG": PRINT D$: FILES D$ + A$
1190 LOCATE X + 12, Y: A$ = "*.CMD": PRINT D$: FILES D$ + A$
1200 LOCATE 22, 2: INPUT "Input name of file to delete (with Extension):", FILE$
1210 IF LEN(FILE$) < 1 THEN LOCATE 22, 2: PRINT STRING$(79, 32); : RETURN
1220 LOCATE 22, 2: PRINT "Are you sure you want to delete "; FILE$; "? Input a 'Y' to delete file."; : Q$ = INKEY$: IF Q$ = "" THEN 1220
1230 IF Q$ = "Y" THEN 1240 ELSE 1250
1235 Y$ = ":": V = INSTR(FILE$, Y$): IF V > 0 THEN GOTO 1240
1236 FILE$ = D$ + FILE$
1240 KILL FILE$: LOCATE 22, 2: PRINT STRING$(78, 32);
1250 CLS : Q$ = "": GOTO 1120
1260 '
1270 REM Change drive for storage and retrieval of files
1280 '
1290 LOCATE 10, 5: PRINT "Present drive is "; D$; ". To change drive for storage and retrieval"
1300 LOCATE 24, 2: PRINT STRING$(75, 32); : LOCATE 24, 2: PRINT "Input new drive letter (tap 'ENTER' with no letter to keep present drive).";
1310 LOCATE 12, 5: PRINT "of all data files (program, waveforms, command strings & registers)"
1320 LOCATE 14, 5: INPUT "enter drive name (A,B,C or D):", D1$
1330 IF D1$ = "A" THEN 1390
1340 IF D1$ = "B" THEN 1390
1350 IF D1$ = "C" THEN 1390
1360 IF D1$ = "D" THEN 1390
1370 IF LEN(D1$) < 1 THEN GOSUB 1400: RETURN
1380 LOCATE 14, 1: PRINT STRING$(79, 32); : BEEP: GOTO 1290
1390 D$ = D1$ + ":": GOSUB 1440: GOSUB 1400: RETURN
1400 LOCATE 10, 1: PRINT STRING$(240, 32): LOCATE 14, 1: PRINT STRING$(79, 32): RETURN
1410 '
1420 REM Save configuration routine
1430 '
1440 OPEN "CONFIG.DAT" FOR OUTPUT AS #1: WRITE #1, CF, CB, CD, D$, P$: CLOSE #1
1450 RETURN
1460 '
1470 REM Error routines
1480 '
1490 IF ERR = 53 THEN PRINT "No "; A$; " file found.": CF = 7: CB = 0: RESUME NEXT
1500 RESUME 130
1510 IF ERR = 53 THEN PRINT "No "; A$; " file found.": RESUME NEXT
1520 RESUME 0
1530 '
1540 REM Set CAPS LOCK on, only upper case accepted as inputs
1550 '
1560 DEF SEG = 0: POKE 1047, 64: DEF SEG : RETURN
1570 '
1580 REM Draw box for command line
1590 '
1600 LOCATE 23, 1: PRINT STRING$(1, 218); : LOCATE 23, 2: PRINT STRING$(78, 196); : LOCATE 23, 79: PRINT STRING$(1, 191);
1610 LOCATE 25, 1: PRINT STRING$(1, 192); : LOCATE 25, 2: PRINT STRING$(78, 196); : LOCATE 25, 79: PRINT STRING$(1, 217);
1620 LOCATE 24, 1: PRINT STRING$(1, 179); : LOCATE 24, 79: PRINT STRING$(1, 179);
1630 RETURN
1640 V% = 0: CALL IBONL(DSO%, V%): CLS : RUN "7854"

