1 REM This software cannot be run in IBM basic. It has been written to be
2 REM to be compiled. The DECL.BAS file could be merged with each software
3 REM package to have a file that will run in basic.
4 REM This would allow the user to modify the routines to fit a particular
5 REM application. The basic source code has been provided for this purpose.
6 REM
7 REM
8 REM
9 REM
10 REM ******************************************************************
11 REM *                                                                *
12 REM *      7854 to IBM PC UTILITY COMMUNICATIONS SOFTWARE            *
13 REM *                       for the                                  *
14 REM *             Tektronix 7854 Oscilloscope                        *
15 REM *                         and                                    *
16 REM *         IBM-PC, IBM-PC XT and IBM portable PC                  *
17 REM *           Copyright 1985 by TEKTRONIX Inc.                     *
18 REM *                All rights reserved                             *
19 REM *                   Version 1.00                                 *
20 REM *                                                                *
21 REM *   This software is provided on an 'as is' basis without        *
22 REM *       warranty of any kind. It is not supported.               *
23 REM *                                                                *
24 REM ******************************************************************
25 REM *
26 REM *   REQUIRED EQUIPMENT:
27 REM *
28 REM *   IBM-PC or IBM-XT with graphics adapter (color monitor is optional)
29 REM *   or IBM-PC PORTABLE
30 REM *   GPIB-PC card from -
32 REM *     National Instruments Inc.   part number 776043-01
33 REM *     Tektronix Inc.              part number 118-4200-00
34 REM *
35 REM *   PURPOSE:
36 REM *    Allow users to graph waveforms that have been stored on disk.
37 REM *
38 REM *
39 REM *   CALLING FORMAT:
40 REM *    This is a stand-alone program. It is also part of a group of
41 REM *    five software programs that make up a utility software
42 REM *    package. 7854.EXE is the name of the software routine that
43 REM *    this software exits to.
44 REM *
45 REM *   VARIABLES:
46 REM *
47 REM *    DSO%   Device descriptor altered by IBCONF
48 REM *    DEV$   Specific device (7854) from IBCONF (address 1)
49 REM *    FILE$  Name of file to write to or read from
50 REM *    A$     Name or name and extension to search media for
51 REM *    D$     Drive name where waveforms are stored
52 REM *    HHTC1$ String #1 for vertical graticule
53 REM *    HHTC2$ String #2 for vertical graticule
54 REM *    HTIC1$ String #3 for vertical graticule
55 REM *    HTIC2$ String #4 for vertical graticule
56 REM *    VTIC1$ String #1 for horizontal graticule
57 REM *    VTIC2$ String #2 for horizontal graticule
58 REM *    VTIC3$ String #3 for horizontal graticule
59 REM *    VVTC1$ String #4 for horizontal graticule
60 REM *    VVTC2$ String #5 for horizontal graticule
61 REM *    VVTC3$ String #6 for horizontal graticule
62 REM *    PRE$   Waveform preamble from file
63 REM *    PW$    Points per waveform (from PRE$)
64 REM *    Q$     String from INKEY$ function
65 REM *    TDIV$  Horizontal time per division for scale factor
66 REM *    VDIV$  Vertical units per division for scale factor
67 REM *    WFM$   String value of each waveform point from file
68 REM *
69 REM *    A-Z    Used in SCNDMP routine
70 REM *    B      Adjusts number of horizontal steps to fit graticule size
71 REM *    G      Flag to indicate graph another waveform
72 REM *    I & J  For/next counters
73 REM *    O & OO Offset information from waveform preamble
74 REM *    V      Horizontal time per point information from preamble
75 REM *    W      A waveform array containing values modified for graphing
76 REM *    CF     Color of text
77 REM *    CB     Color of background
78 REM *    CB     Color of background
79 REM *    X      Offset for vertical position
80 REM *    Y      Offset for horizontal position
81 REM *
82 REM *  ROUTINES CALLED:
83 REM *
84 REM *    7854.EXE is returned to by selecting <M>enu
85 REM *
86 REM *  FILES USED:
87 REM *
88 REM *    CONFIG      Color information and drive name stored in this file
89 REM *    all.WFM     Waveform files from which user calls waveform to graph
90 REM *    7854.EXE    Main program, see ROUTINES CALLED
93 REM *
94 REM *
95 REM *  POSSIBLE ERRORS:
96 REM *
97 REM *    No known errors not handled by 'ON ERROR' routines
98 REM *
99 REM ***********************************************************************
100 COMMON SHARED ibsta%, iberr%, IBCNT%               ' GPIB.QLB
101 'COMMON SHARED /NISTATBLK/ ibsta%, iberr%, IBCNT%  ' QBIB4.OBJ
109 DEF SEG = 0: POKE 1047, 64: DEF SEG
110 ON ERROR GOTO 1700: A$ = "CONFIG.DAT": OPEN A$ FOR INPUT AS #1: INPUT #1, CF, CB, CD, D$: CLOSE #1: COLOR CF, CB, CD: CLS
120 '
130 REM Check for GRAPHICS MONITOR
140 '
150 X = 4: Y = 16
160 DEF SEG = 0
170 IF (PEEK(&H410) AND &H30) <> &H30 THEN GMA = 1
180 DEF SEG : I = 0
190 IF GMA = 1 THEN 240
200 LOCATE 24, 2: PRINT "GRAPHIC MONITOR NOT INSTALLED; ABORTING COMMAND"; : FOR C = 1 TO 1000: NEXT C: RUN "7854"
210 '
220 REM Waveform files available
230 '
240 CLS : LOCATE 8, 1: PRINT STRING$(80, 205): LOCATE 1, 1: COLOR CB, CF, CD: PRINT STRING$(80, 32)
250 LOCATE 1, 23: PRINT "GRAPH 7854 WAVEFORM FROM THE DISK": COLOR CF, CB, CD
260 LOCATE 12, 16: PRINT D$: A$ = "*.wfm": ON ERROR GOTO 1700: FILES D$ + A$
270 LOCATE 8, 24: PRINT " 7854  W A V E F O R M FILES "
280 GOSUB 1460: LOCATE 24, 2: PRINT STRING$(76, 32); : LOCATE 24, 2: PRINT " An ENTER with no file name will return to the MAIN MENU. ";
290 '
300 REM Select waveform file
310 '
320 LOCATE X + 18, 1: INPUT "Select Waveform file for Graph (without extension):", FILE$
330 IF LEN(FILE$) < 1 THEN 1840
340 Y$ = ".": V = INSTR(FILE$, Y$)
350 IF V > 0 THEN LOCATE 18, 1: PRINT "Do not use a '.' in the file name.": LOCATE 22, 1: PRINT STRING$(79, 32): GOTO 320
360 Y$ = ":": V = INSTR(FILE$, Y$): IF V = 0 THEN FILE$ = D$ + FILE$
370 ON ERROR GOTO 1740: OPEN FILE$ + ".WFM" FOR INPUT AS #1
380 CLS : LOCATE 12, 20: PRINT "Loading Waveform from Disk . . . . . "
390 '
400 REM Bring in waveform preamble
410 '
420 LINE INPUT #1, PRE$
430 PW$ = "NR.PT:"
440 Y = INSTR(1, PRE$, PW$) + 6
450 X = VAL(MID$(PRE$, Y, 9))
460 DIM W(1024), H(1024)
470 '
480 REM Use preamble to find scale factor information
490 '
500 V = VAL(MID$(PRE$, INSTR(30, PRE$, "XINCR:") + 6, 9)): V = (V * X) / 10
510 O = VAL(MID$(PRE$, INSTR(30, PRE$, "YZERO:") + 6, 10))
520 Y = VAL(MID$(PRE$, INSTR(40, PRE$, "YMULT:") + 6, 10)): O = Y * O
530 OO = VAL(MID$(PRE$, INSTR(20, PRE$, "XZERO:") + 6, 10))
540 VOLT$ = MID$(PRE$, INSTR(40, PRE$, "YUNIT:") + 6, 1)
550 '
560 REM Bring in waveform point by point, do scaling for graph
570 '
580 B = 512 / X
590 SCALE = 3
600 IF EOF(1) THEN 700
610 I = I + 1
620 C = I / 10: IF C = INT(C) THEN LOCATE 12, 55: PRINT X - (I + 2)
630 INPUT #1, WFM$
640 W(I) = 75 - (VAL(WFM$)) * 20 * (SCALE / 4): H(I) = 40 + I * (SCALE / 4.11) * B
650 IF I = X THEN 680
660 GOTO 600
670 '
680 REM Go get graticule, then draw graticule and scale factor box
690 SCALE$ = STR$(SCALE)
700 GOSUB 1530:  DRAW "S=" + VARPTR$(SCALE)
710 DRAW "BM40,20;"
711 DRAW "X" + VARPTR$(HTIC1$)
712 DRAW "X" + VARPTR$(HTIC2$)
713 DRAW "X" + VARPTR$(VTIC1$)
714 DRAW "X" + VARPTR$(VTIC2$)
715 DRAW "X" + VARPTR$(VTIC3$)
716 DRAW "X" + VARPTR$(HHTC1$)
717 DRAW "X" + VARPTR$(HHTC2$)
718 DRAW "X" + VARPTR$(VVTC1$)
719 DRAW "X" + VARPTR$(VVTC2$)
720 DRAW "X" + VARPTR$(VVTC3$)
730 '
740 REM Draw waveform
750 '
751 H$ = STR$(H): W$ = STR$(W)
755 DRAW "BM40,90;"
760 FOR J = 1 TO X
761 ST = H(J)
762 VERT = W(J)
770 DRAW "M=" + VARPTR$(ST) + ",=" + VARPTR$(VERT)
780 NEXT J
790 '
800 REM Change horizontal scale factor into p,u, or m Sec
810 '
820 IF V < 1E-09 THEN V = V / 1E-12: TDIV$ = "p Sec": GOTO 900
830 IF V < .000001 THEN V = V / 1E-09: TDIV$ = "n Sec": GOTO 900
840 IF V < .001 THEN V = V / .000001: TDIV$ = "u Sec": GOTO 900
850 IF V < 1 THEN V = V / .001: TDIV$ = "m Sec": GOTO 900
860 TDIV$ = "Sec"
870 '
880 REM Change vertical scale factor into n, u or m
890 '
900 LOCATE 1, 1: PRINT DATE$: LOCATE 1, 65: PRINT TIME$
905 IF Y < .000001 THEN Y = Y / 1E-09: VDIV$ = "n": GOTO 980
910 IF Y < .001 THEN Y = Y / .000001: VDIV$ = "u": GOTO 980
920 IF Y < 1 THEN Y = Y / .001: VDIV$ = "m": GOTO 980
930 IF X < 900 THEN VDIV$ = CHR$(0): GOTO 980
940 IF Y > 900 THEN Y = Y / 1000: VDIV$ = "K"
950 '
960 REM Print scale factor information
970 '
980 LOCATE 5, 63: PRINT "SCALE FACTOR";
990 LOCATE 7, 57: PRINT "VERTICAL:";
1000 LOCATE 9, 57: Y = CINT(Y): PRINT USING "Unit/Div= ###"; Y: LOCATE 9, 71: IF VOLT$ = "V" THEN PRINT VDIV$; " Volt": GOTO 1030
1010 LOCATE 9, 71: IF VOLT$ = "p" THEN PRINT VDIV$; "Rho": GOTO 1030
1020 LOCATE 9, 71: PRINT VDIV$
1030 LOCATE 11, 57: PRINT "Offset=": LOCATE 11, 64: PRINT USING "##.##"; O: LOCATE 11, 70: PRINT "Volt"
1040 LOCATE 13, 57: PRINT "HORIZONTAL:";
1050 LOCATE 15, 57: V = CINT(V): PRINT USING "T/Div= ###"; V: LOCATE 15, 68: PRINT TDIV$
1060 LOCATE 17, 57: PRINT "Offset=": LOCATE 17, 64: PRINT USING "##.##"; OO: LOCATE 17, 70: PRINT TDIV$
1070 LOCATE 1, 30: PRINT FILE$; ".WFM"
1080 '
1090 REM Label waveform
1100 '
1110 LOCATE 22, 5: A$ = SPACE$(80): INPUT "Input <60 characters, describing waveform (NO commas please)                    ", A$: B$ = LEFT$(A$, 59)
1120 LOCATE 22, 1: PRINT STRING$(79, 32); : LOCATE 22, 6: PRINT B$;
1130 LOCATE 23, 1: PRINT STRING$(79, 32);
1150 REM Menu to print, get new waveform or return to menu
1160 '
1170 GOSUB 2010: LOCATE 24, 3: PRINT "COMMANDS:    <G>et different waveform          <M>enu";
1180 GOSUB 1440
1190 Q$ = INKEY$: IF Q$ = "" THEN 1180
1210 IF Q$ = "G" THEN CLOSE #1: CLS : SCREEN 0, 0, 0: VDIV$ = SPACE$(1): CLS : COLOR CF, CB, CD: GOTO 130
1220 IF Q$ = "M" THEN CLS : GOTO 1840
1230 BEEP: GOTO 1170
1240 '
1410 '
1420 REM Set CAPS LOCK on
1430 '
1440 DEF SEG = 0: POKE 1047, 64: DEF SEG : REM TURN ON CAPS  !
1450 RETURN
1460 LOCATE 23, 1: PRINT STRING$(1, 218); : LOCATE 23, 2: PRINT STRING$(78, 196); : LOCATE 23, 79: PRINT STRING$(1, 191);
1470 LOCATE 25, 1: PRINT STRING$(1, 192); : LOCATE 25, 2: PRINT STRING$(78, 196); : LOCATE 25, 79: PRINT STRING$(1, 217);
1480 LOCATE 24, 1: PRINT STRING$(1, 179); : LOCATE 24, 79: PRINT STRING$(1, 179);
1490 RETURN
1500 '
1510 REM Set up graphics screen, define graticule with tic marks
1520 '
1530 CLS : SCREEN 2, , 0, 0
1540 H = 160
1550 W = 500
1560 HTIC1$ = "D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L5 R5;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L5 R5;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L5 R5;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L5 R5;"
1570 HTIC2$ = "D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L5 R5;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L5 R5;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L5 R5;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;L2 R2;D4;"
1580 VTIC1$ = "R10;D2 U2;R11;D2 U2;R10;D2 U2;R11;D2 U2;R10;D5 U5;R11;D2 U2;R10;D2 U2;R11;D2 U2;R10;D2 U2;R11;D5 U5;R10;D2 U2;R11;D2 U2;R10;D2 U2;R11;D2 U2;R10;D5 U5;R11;D2 U2;R10;D2 U2;R11;D2 U2;R10;D2 U2;R11;D5 U5;"
1590 VTIC2$ = "R10;D2 U2;R11;D2 U2;R10;D2 U2;R11;D2 U2;R10;D5 U5;R11;D2 U2;R10;D2 U2;R11;D2 U2;R10;D2 U2;R11;D5 U5;R10;D2 U2;R11;D2 U2;R10;D2 U2;R11;D2 U2;R10;D5 U5;R11;D2 U2;R10;D2 U2;R11;D2 U2;R10;D2 U2;R11;D5 U5;"
1600 VTIC3$ = "R10;D2 U2;R11;D2 U2;R10;D2 U2;R11;D2 U2;R10;D5 U5;R11;D2 U2;R10;D2 U2;R11;D2 U2;R10;D2 U2;R11;"
1610 HHTC1$ = "U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R5 L5;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R5 L5;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R5 L5;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R5 L5;"
1620 HHTC2$ = "U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R5 L5;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R5 L5;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R5 L5;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;R2 L2;U4;"
1630 VVTC1$ = "L10;U2 D2;L11;U2 D2;L10;U2 D2;L11;U2 D2;L10;U5 D5;L11;U2 D2;L10;U2 D2;L11;U2 D2;L10;U2 D2;L11;U5 D5;L10;U2 D2;L11;U2 D2;L10;U2 D2;L11;U2 D2;L10;U5 D5;L11;U2 D2;L10;U2 D2;L11;U2 D2;L10;U2 D2;L11;U5 D5;"
1640 VVTC2$ = "L10;U2 D2;L11;U2 D2;L10;U2 D2;L11;U2 D2;L10;U5 D5;L11;U2 D2;L10;U2 D2;L11;U2 D2;L10;U2 D2;L11;U5 D5;L10;U2 D2;L11;U2 D2;L10;U2 D2;L11;U2 D2;L10;U5 D5;L11;U2 D2;L10;U2 D2;L11;U2 D2;L10;U2 D2;L11;U5 D5;"
1650 VVTC3$ = "L10;U2 D2;L11;U2 D2;L10;U2 D2;L11;U2 D2;L10;U5 D5;L11;U2 D2;L10;U2 D2;L11;U2 D2;L10;U2 D2;L10;"
1660 RETURN
1670 '
1680 REM Error handler routines
1690 '
1700 IF ERR = 53 THEN PRINT "No "; A$; " file found.": CF = 7: CB = 0: GOSUB 1800
1710 RESUME NEXT
1720 SC$ = "R150;D5 L150;U5 R150;D100 L150;U100;"
1730 RETURN
1740 IF ERR = 53 THEN BEEP: LOCATE 3, 3: PRINT "File not found. Re-enter file name.": LOCATE 22, 1: PRINT STRING$(79, 32): GOSUB 1800: LOCATE 3, 3: PRINT STRING$(75, 32): RESUME 320
1745 IF ERR = 5 THEN BEEP: RESUME
1750 IF ERR = 27 THEN PRINT "Printer error; out of paper.": GOSUB 1800: RESUME 1170
1760 IF ERR = 57 THEN PRINT "Printer error; check printer.": GOSUB 1800: RESUME 1170
1770 IF ERR = 24 THEN PRINT "Printer error;": GOSUB 1800: RESUME 1170
1780 IF ERR = 25 THEN PRINT "Printer error;": GOSUB 1800: RESUME 1170
1785 IF ERR = 62 THEN RESUME
1790 CLS : SCREEN 0, 0, 0: PRINT "Untrapped error, check error codes in IBM Basic manual.": GOSUB 1800: PRINT ERR: RESUME 1170
1800 BEEP: FOR I = 1 TO 30000: DEELY = I: DEELY = 0: NEXT I: RETURN
1810 '
1820 REM Return to 7854.EXE
1830 '
1840 SCREEN 0, 0, 0
1850 CLS : RUN "7854"
2000 '
2001 REM Box for command line
2002 '
2010 DRAW "bm1,183;r820;d16;l820;u16;"
2020 RETURN

