1 REM This software cannot be run in IBM basic. It has been written to be
2 REM to be compiled. The DECL.BAS file could be merged with each software
3 REM package to have a file that will run in basic.
4 REM This would allow the user to modify the routines to fit a particular
5 REM application. The basic source code has been provided for this purpose.
6 REM
7 REM
8 REM
9 REM
10 REM ******************************************************************
11 REM *                                                                *
12 REM *      7854 to IBM PC UTILITY COMMUNICATIONS SOFTWARE            *
13 REM *                       for the                                  *
14 REM *             Tektronix 7854 Oscilloscope                        *
15 REM *                         and                                    *
16 REM *         IBM-PC, IBM-PC XT and IBM portable PC                  *
17 REM *           Copyright 1985 by TEKTRONIX Inc.                     *
18 REM *                All rights reserved                             *
19 REM *                   Version 1.00                                 *
20 REM *                                                                *
21 REM *   This software is provided on an 'as is' basis without        *
22 REM *       warranty of any kind. It is not supported.               *
23 REM *                                                                *
24 REM ******************************************************************
25 REM *
26 REM *   REQUIRED EQUIPMENT:
27 REM *
28 REM *   IBM-PC or IBM-XT with graphics adapter (color monitor is optional)
29 REM *   or IBM-PC PORTABLE
30 REM *   GPIB-PC card from -
32 REM *     National Instruments Inc.   part number 776043-01
33 REM *     Tektronix Inc.              part number 118-4200-00
34 REM *
35 REM *   PURPOSE:
36 REM *    To provide a reference guide to the function of some of the
37 REM *    7854 commands for the users of this software package.
38 REM *
39 REM *   CALLING FORMAT:
40 REM *    This is a stand-alone program. It is also part of a group of
41 REM *    five software programs that make up a utility software
42 REM *    package. OUTPUT.EXE is the name of the software routine that
43 REM *    this software exits to.
44 REM *
45 REM *   VARIABLES:
46 REM *
47 REM *    DSO%   Device descriptor altered by IBCONF
48 REM *    DEV$   Specific device (7854) from IBCONF (address 1)
49 REM *    CF$    String input for text color
50 REM *    CB$    String input for background color
51 REM *    CD$    String input for border color
52 REM *    H$     String input for help selection
53 REM *    CF     Color of text
54 REM *    CB     Color of background
55 REM *    CD     Color of border
56 REM *    H      Value of H$ (Help selection)
57 REM *
58 REM *
59 REM *  ROUTINES CALLED:
60 REM *
61 REM *    OUTPUT.EXE is returned to by selecting <M>enu
62 REM *
63 REM *  FILES USED:
64 REM *
65 REM *    OUTPUT.EXE  Program returned to, see ROUTINES CALLED
68 REM *
69 REM *
70 REM *  POSSIBLE ERRORS:
71 REM *
72 REM *    No known errors not handled by 'ON ERROR' routines
73 REM *
74 REM ***********************************************************************
100 'COMMON SHARED ibsta%, iberr%, IBCNT%               ' GPIB.QLB
101 COMMON SHARED /NISTATBLK/ ibsta%, iberr%, IBCNT%  ' QBIB4.OBJ
109 A$ = "CONFIG.DAT": OPEN A$ FOR INPUT AS #1: INPUT #1, CF, CB, CD, D$: CLOSE #1: CLS : COLOR CF, CB, CD
110 X = 4: Y = 16
120 CLS : COLOR CB, CF: LOCATE 1, 1: PRINT STRING$(80, 32)
130 LOCATE 1, Y + 7: PRINT "HELP COMMANDS FOR THE 7854     "; : COLOR CF, CB, CD
140 '
150 REM Print list of commands
160 '
170 COLOR CB, CF: LOCATE X - 1, 2: PRINT "  DISPLAY  ": LOCATE X - 1, Y: PRINT " CURSORS ": LOCATE X - 1, Y + 16: PRINT " WAVEFORM PARAMETERS ": LOCATE X - 1, Y + 48: PRINT " ALGEBRAIC ": COLOR CF, CB
180 LOCATE X, 2: PRINT "1  SCOPE": LOCATE X, Y: PRINT "9  OFF": LOCATE X, Y + 16: PRINT "30 RISE": LOCATE X, Y + 32: PRINT "37 RMS ": LOCATE X, Y + 48: PRINT "48 - (minus)"
190 LOCATE X + 1, 2: PRINT "2  STORED": LOCATE X + 1, Y: PRINT "10 CRS1": LOCATE X + 1, Y + 16: PRINT "31 FALL": LOCATE X + 1, Y + 32: PRINT "38 MEAN": LOCATE X + 1, Y + 48: PRINT "49 + (plus)"
200 LOCATE X + 2, 2: PRINT "3  BOTH": LOCATE X + 2, Y: PRINT "11 CRS1<": LOCATE X + 2, Y + 16: PRINT "32 DELAY": LOCATE X + 2, Y + 32: PRINT "39 MID": LOCATE X + 2, Y + 48: PRINT "50 * (times)"
210 LOCATE X + 3, Y: PRINT "12 CRS1>": LOCATE X + 3, Y + 16: PRINT "33 WIDTH": LOCATE X + 3, Y + 32: PRINT "40 ENERGY": LOCATE X + 3, Y + 48: PRINT "51 / (divide)"
220 COLOR CB, CF: LOCATE X + 5, 2: PRINT " ACQUISITION ": COLOR CF, CB: LOCATE X + 4, Y: PRINT "13 CRS2-1": LOCATE X + 4, Y + 16: PRINT "34 MAX": LOCATE X + 4, Y + 32: PRINT "41 AREA "
230 LOCATE X + 5, Y: PRINT "14 CRS2<": LOCATE X + 5, Y + 16: PRINT "35 MIN": LOCATE X + 5, Y + 32: PRINT "42 FREQ": COLOR CB, CF: LOCATE X + 5, Y + 48: PRINT "   MISC   ": COLOR CF, CB
240 LOCATE X + 6, 2: PRINT "4  AQR": LOCATE X + 6, Y: PRINT "15 CRS2>": LOCATE X + 6, Y + 16: PRINT "36 P-P": LOCATE X + 6, Y + 32: PRINT "43 PER"
250 LOCATE X + 7, 2: PRINT "5  AQS": LOCATE X + 7, Y: PRINT "16 HCRD": LOCATE X + 6, Y + 48: PRINT "52 VS  "
260 LOCATE X + 8, 2: PRINT "6  AVG": LOCATE X + 8, Y: PRINT "17 VCRD": COLOR CB, CF: LOCATE X + 8, Y + 16: PRINT " WAVEFORM FUNCTIONS ": COLOR CF, CB: LOCATE X + 7, Y + 48: PRINT "53 TIME"
270 LOCATE X + 9, 2: PRINT "7  GND": LOCATE X + 9, Y: PRINT "18 >HCRD": LOCATE X + 8, Y + 48: PRINT "54 SGN"
280 LOCATE X + 10, 2: PRINT "8  RDOUT": LOCATE X + 10, Y: PRINT "19 >VCRD": LOCATE X + 9, Y + 16: PRINT "44 INTG": LOCATE X + 9, Y + 32: PRINT "46 SMOOTH": LOCATE X + 9, Y + 48: PRINT "55 HCSL "
290 LOCATE X + 10, Y + 16: PRINT "45 DIFF": LOCATE X + 10, Y + 32: PRINT "47 HXPD": LOCATE X + 10, Y + 48: PRINT "56 VSCL"
300 LOCATE X + 12, 2: COLOR CB, CF: PRINT "     DATA and WAVEFORM STORAGE     ": COLOR CF, CB: LOCATE X + 11, Y + 48: PRINT "57 ENTER"
310 LOCATE X + 13, 2: PRINT "20 WFM": LOCATE X + 13, Y: PRINT "23 >P/W": LOCATE X + 13, Y + 16: PRINT "27 DSW"
320 LOCATE X + 14, 2: PRINT "21 >WFM": LOCATE X + 14, Y: PRINT "24 CNS": LOCATE X + 14, Y + 16: PRINT "28 CLW"
330 LOCATE X + 15, 2: PRINT "22 P/W": LOCATE X + 15, Y: PRINT "25 >CNS": LOCATE X + 15, Y + 16: PRINT "29 CLD"
340 '
350 REM Select command and print help message for that command
360 '
370 GOSUB 3780
380 LOCATE 24, 2: PRINT "To return to the OUTPUT COMMAND MENU, tap 'ENTER'.";
390 LOCATE 22, 1: PRINT STRING$(79, 32); : LOCATE 22, 1: INPUT "Select which one "; H$: IF LEN(H$) > 2 THEN BEEP: GOTO 390
400 H = VAL(H$)
410 IF LEN(H$) > 0 AND H = 0 THEN BEEP: GOTO 390
420 IF H = 0 THEN CLS : RUN "output"
430 IF H < 1 THEN BEEP: GOTO 390
440 IF H > 57 THEN BEEP: GOTO 390
450 CLS : LOCATE 1, 1: COLOR CB, CF: PRINT STRING$(79, 32)
460 LOCATE 1, 20: PRINT " 7854 COMMANDS - - - HELP - - - ": COLOR CF, CB
470 IF H = 1 THEN 480 ELSE 520
480 LOCATE 5, 20: PRINT "SCOPE (scope display)"
490 LOCATE 8, 10: PRINT "This display function of the 7854 shows only the real time "
500 LOCATE 9, 10: PRINT "display. This is the signal that can be digitized. This command "
510 LOCATE 10, 10: PRINT "requires no other action to make it function."
520 IF H = 2 THEN 530 ELSE 580
530 LOCATE 5, 20: PRINT "STORED (stored waveform display)"
540 LOCATE 8, 10: PRINT "This display is the digitized waveform (or waveforms). When the "
550 LOCATE 9, 10: PRINT "7854 is first turned on, a waveform containing all zeros is stored "
560 LOCATE 10, 10: PRINT "in waveform memory location 0. This command requires no other "
570 LOCATE 11, 10: PRINT "action to make it function."
580 IF H = 3 THEN 590 ELSE 640
590 LOCATE 5, 20: PRINT "BOTH (combined display)"
600 LOCATE 8, 10: PRINT "Both the real time waveform and the stored waveform (or "
610 LOCATE 9, 10: PRINT "waveforms) are displayed. This mode allows the user to make "
620 LOCATE 10, 10: PRINT "comparisons between the active and stored waveforms. This "
630 LOCATE 11, 10: PRINT "command requires no other action to make it function."
640 IF H = 4 THEN 650 ELSE 710
650 LOCATE 5, 20: PRINT "AQR (acquire repetitive waveforms)"
660 LOCATE 8, 10: PRINT "The real-time waveform is digitized and stored in waveform "
670 LOCATE 9, 10: PRINT "location 0. If there are two signals on screen (plug-in mode "
680 LOCATE 10, 10: PRINT "ALT; or mainframe mode ALT or CHOP) the waveforms will be "
690 LOCATE 11, 10: PRINT "stored in WFM memory locations 0 & 1. This command requires "
700 LOCATE 12, 10: PRINT "no other action to make it function."
710 IF H = 5 THEN 720 ELSE 800
720 LOCATE 5, 20: PRINT "AQS (acquire single-sweep waveforms)"
730 LOCATE 8, 10: PRINT "The 7854 requires a 7B87 Horizontal plug-in be used in the "
740 LOCATE 9, 10: PRINT "B horizontal compartment in this mode. One or two waveforms "
750 LOCATE 10, 10: PRINT "can be acquired in this mode. The same restrictions apply "
760 LOCATE 11, 10: PRINT "as per AQR. The fastest possible Time/Div setting is 50  "
770 LOCATE 12, 10: PRINT "uSec/Div @ 128 points per waveform. The time-base must be "
780 LOCATE 13, 10: PRINT "set to single sweep mode before this command is sent. "
790 LOCATE 14, 10: PRINT "A trigger will then start acquistion of the waveform."
800 IF H = 6 THEN 810 ELSE 880
810 LOCATE 5, 20: PRINT "AVG (average waveforms)"
820 LOCATE 8, 10: PRINT "The real-time waveform is averaged n times. The number of averages "
830 LOCATE 9, 10: PRINT "must be in the X register (n AVG is the correct syntax). The "
840 LOCATE 10, 10: PRINT "resultant waveform is stored in 0 WFM  memory, with 1 WFM memory "
850 LOCATE 11, 10: PRINT "used as a work area. A numeric value must be in the X register. "
860 LOCATE 12, 10: PRINT "It can be sent as part of the command string using the INPUT "
870 LOCATE 13, 10: PRINT "function."
880 IF H = 7 THEN 890 ELSE 940
890 LOCATE 5, 20: PRINT "GND (set ground reference)"
900 LOCATE 8, 10: PRINT "The 7854 digitizes the first 128 points of the real time "
910 LOCATE 9, 10: PRINT "waveform and calculates the mean. Grounding the vertical "
920 LOCATE 10, 10: PRINT "amplifiers prior to sending this command will provide an "
930 LOCATE 11, 10: PRINT "accurate ground reference."
940 IF H = 8 THEN 950 ELSE 1020
950 LOCATE 5, 20: PRINT "RDOUT (returns real-time readout value)"
960 LOCATE 8, 10: PRINT "Reads the readout of the selected channel into the X register. "
970 LOCATE 9, 10: PRINT "Readout channel must be specified in the X register (0 RDOUT "
980 LOCATE 10, 10: PRINT "is the correct syntax). Readout channels are numbered from "
990 LOCATE 11, 10: PRINT "0 to 7 (from upper left thru lower right). A numeric value "
1000 LOCATE 12, 10: PRINT "between 0 and 7 must be in the X register. It can be sent "
1010 LOCATE 13, 10: PRINT "as part of the command string using the INPUT function."
1020 IF H = 9 THEN 1030 ELSE 1060
1030 LOCATE 5, 20: PRINT "OFF (cursors off)"
1040 LOCATE 8, 10: PRINT "Cursors are turned off. This command requires no other "
1050 LOCATE 9, 10: PRINT "action to make it function."
1060 IF H = 10 THEN 1070 ELSE 1100
1070 LOCATE 5, 20: PRINT "CRS1 (one cursor on)"
1080 LOCATE 8, 10: PRINT "Cursor 1 is turned on. This command requires no other "
1090 LOCATE 9, 10: PRINT "action to make it function."
1100 IF H = 11 THEN 1110 ELSE 1160
1110 LOCATE 5, 20: PRINT "CRS1< (cursor 1 left one point)"
1120 LOCATE 8, 10: PRINT "Cursor 1 is moved one point toward the start of the waveform. "
1130 LOCATE 9, 10: PRINT "A warning error is issued if cursor 1 is at the start of "
1140 LOCATE 10, 10: PRINT "the waveform. An error is issued if cursor 1 is not on. "
1150 LOCATE 11, 10: PRINT "This command requires no other action to make it function."
1160 IF H = 12 THEN 1170 ELSE 1220
1170 LOCATE 5, 20: PRINT "CRS1> (cursor 1 right one point)"
1180 LOCATE 8, 10: PRINT "Cursor 1 is moved one point toward the end of the waveform. "
1190 LOCATE 9, 10: PRINT "A warning error is issued if cursor 1 is at the end of the "
1200 LOCATE 10, 10: PRINT "waveform. An error is issued if cursor 1 is not on. this "
1210 LOCATE 11, 10: PRINT "command requires no other action to make it function."
1220 IF H = 13 THEN 1230 ELSE 1260
1230 LOCATE 5, 20: PRINT "CRS2-1 (both cursors on)"
1240 LOCATE 8, 10: PRINT "Two cursors are turned on. This command requires no other "
1250 LOCATE 9, 10: PRINT "action to make it function."
1260 IF H = 14 THEN 1270 ELSE 1320
1270 LOCATE 5, 20: PRINT "CRS2< (cursor 2 left one point)"
1280 LOCATE 8, 10: PRINT "Cursor 2 is moved one point toward the start of the waveform. "
1290 LOCATE 9, 10: PRINT "A warning error is issued if cursor 2 is at the same point "
1300 LOCATE 10, 10: PRINT "as cursor 1. An error is issued if cursor 2 is not on. "
1310 LOCATE 11, 10: PRINT "This command requires no other action to make it function."
1320 IF H = 15 THEN 1330 ELSE 1380
1330 LOCATE 5, 20: PRINT "CRS2> (cursor 2 right one point)"
1340 LOCATE 8, 10: PRINT "Cursor 2 is moved one point toward the end of the waveform. "
1350 LOCATE 9, 10: PRINT "A warning error is issued if cursor 2 is at the end of the "
1360 LOCATE 10, 10: PRINT "waveform. An error is issued if cursor 2 is not on. This "
1370 LOCATE 11, 10: PRINT "command requires no other action to make it function."
1380 IF H = 16 THEN 1390 ELSE 1440
1390 LOCATE 5, 20: PRINT "HCRD (returns horizontal coordinate)"
1400 LOCATE 8, 10: PRINT "Copies either the displayed horizontal position (CRS1 mode) "
1410 LOCATE 9, 10: PRINT "or the relative position (CRS2-1 mode) into the X register. "
1420 LOCATE 10, 10: PRINT "An error occurs if cursors are off. This command requires "
1430 LOCATE 11, 10: PRINT "no other action to make it function."
1440 IF H = 17 THEN 1450 ELSE 1510
1450 LOCATE 5, 20: PRINT "VCRD (returns vertical coordinate)"
1460 LOCATE 8, 10: PRINT "Copies either the displayed vertical position (as referenced "
1470 LOCATE 9, 10: PRINT "to VZR (vertical zero)) (CRS1 mode) or relative position "
1480 LOCATE 10, 10: PRINT "(CRS2-1 mode) into the X register. Error occurs if cursors "
1490 LOCATE 11, 10: PRINT "are off. This command requires no other action to make "
1500 LOCATE 12, 10: PRINT "it function."
1510 IF H = 18 THEN 1520 ELSE 1600
1520 LOCATE 5, 20: PRINT ">HCRD (set horizontal coordinate)"
1530 LOCATE 8, 10: PRINT "Moves either cursor 1 (CRS1 mode) or cursor 2 (CRS2-1 mode) "
1540 LOCATE 9, 10: PRINT "so that the horizontal position or relative position is equal "
1550 LOCATE 10, 10: PRINT "to the value of the X register. Error occurs if cursors are "
1560 LOCATE 11, 10: PRINT "off. If value is too large, warning is generated, but cursor "
1570 LOCATE 12, 10: PRINT "is moved to the end of the waveform. A numeric value must "
1580 LOCATE 13, 10: PRINT "be in the X register. It can be sent as part of the command "
1590 LOCATE 14, 10: PRINT "string using the INPUT function."
1600 IF H = 19 THEN 1610 ELSE 1690
1610 LOCATE 5, 20: PRINT ">VCRD (set vertical coordinate)"
1620 LOCATE 8, 10: PRINT "Moves either cursor 1 (CRS1 mode) or cursor 2 (CRS2-1 mode) "
1630 LOCATE 9, 10: PRINT "so that the vertical position or relative position is equal to "
1640 LOCATE 10, 10: PRINT "the value of the X register. Error occurs if cursors are off. "
1650 LOCATE 11, 10: PRINT "If value is too large, an error is generated and cursors "
1660 LOCATE 12, 10: PRINT "are not moved. A numeric value must be in the X register. "
1670 LOCATE 13, 10: PRINT "It can be sent as part of the command string using the "
1680 LOCATE 14, 10: PRINT "INPUT function."
1690 IF H = 49 THEN 1700 ELSE 1740
1700 LOCATE 5, 20: PRINT "+ (add)"
1710 LOCATE 8, 10: PRINT "The contents of the Y register are added to the contents "
1720 LOCATE 9, 10: PRINT "of the X register. These could be numeric values, waveforms, "
1730 LOCATE 10, 10: PRINT "or a combination of numerics and waveforms."
1740 IF H = 48 THEN 1750 ELSE 1790
1750 LOCATE 5, 20: PRINT "- (subtract)"
1760 LOCATE 8, 10: PRINT "The contents of the X register are subtracted from the "
1770 LOCATE 9, 10: PRINT "contents of the Y register. These could be numeric values, "
1780 LOCATE 10, 10: PRINT "waveforms, or a combination of numerics and waveforms. "
1790 IF H = 50 THEN 1800 ELSE 1840
1800 LOCATE 5, 20: PRINT "* (multiply)"
1810 LOCATE 8, 10: PRINT "The contents of the Y register are multiplied by the contents "
1820 LOCATE 9, 10: PRINT "of the X register. These could be numeric values, waveforms, "
1830 LOCATE 10, 10: PRINT "or a combination of numerics and waveforms. "
1840 IF H = 51 THEN 1850 ELSE 1890
1850 LOCATE 5, 20: PRINT "/ (divide)"
1860 LOCATE 8, 10: PRINT "The contents of the Y register are divided by the contents "
1870 LOCATE 9, 10: PRINT "of the X register. These could be numeric values, waveforms, "
1880 LOCATE 10, 10: PRINT "or a combination of numerics and waveforms. "
1890 IF H = 44 THEN 1900 ELSE 1960
1900 LOCATE 5, 20: PRINT "INTG (integrate)"
1910 LOCATE 8, 10: PRINT "Integrates the operational waveform. The resultant waveform is "
1920 LOCATE 9, 10: PRINT "stored in 0 WFM, which then becomes the operational waveform. "
1930 LOCATE 10, 10: PRINT "The vertical scale factor is blanked. A valid waveform  "
1940 LOCATE 11, 10: PRINT "address must be in the X register. It can be sent as part "
1950 LOCATE 12, 10: PRINT "of the command string using the INPUT function."
1960 IF H = 39 THEN 1970 ELSE 2000
1970 LOCATE 5, 20: PRINT "MID  "
1980 LOCATE 8, 10: PRINT "Returns the middle value of the operational waveform"
1990 LOCATE 9, 10: PRINT "(MAX+MIN/2) to the X register."
2000 IF H = 54 THEN 2010 ELSE 2060
2010 LOCATE 5, 20: PRINT "SGN (signum)"
2020 LOCATE 8, 10: PRINT "Computes the signum of the X register. If operand is"
2030 LOCATE 9, 10: PRINT "a waveform, scale factor is set to 1, VZR is set to 0."
2040 LOCATE 10, 10: PRINT "Positive values are set to 1, negative values set to -1,"
2050 LOCATE 11, 10: PRINT "and values of 0 set to 0. "
2060 IF H = 57 THEN 2070 ELSE 2140
2070 LOCATE 5, 20: PRINT "ENTER (enter data)"
2080 LOCATE 8, 10: PRINT "Terminates the entry of numeric data. Otherwise, the"
2090 LOCATE 9, 10: PRINT "contents of the stack is altered as follows: "
2100 LOCATE 10, 10: PRINT "   copies contents of X register to Y register,"
2110 LOCATE 11, 10: PRINT "   contents of  Y to Z, contents of Z to T, contents"
2120 LOCATE 12, 10: PRINT "   of  T to W, contents W are lost. "
2130 LOCATE 13, 10: PRINT "Please refer to 7854 Operators manual for more information."
2140 IF H = 41 THEN 2150 ELSE 2200
2150 LOCATE 5, 20: PRINT "AREA (returns area)"
2160 LOCATE 8, 10: PRINT "Returns the area under all spanned waveform points"
2170 LOCATE 9, 10: PRINT "to the X register. This is the equivalent of estimating"
2180 LOCATE 10, 10: PRINT "the area by linear interpolation between points (Trapezoidal"
2190 LOCATE 11, 10: PRINT "rule). Readout is in volt-seconds."
2200 IF H = 40 THEN 2210 ELSE 2240
2210 LOCATE 5, 20: PRINT "ENERGY (returns energy)"
2220 LOCATE 8, 10: PRINT "Returns the squared area under all spanned points (see AREA)."
2230 LOCATE 9, 10: PRINT "The readout is in volt-seconds squared."
2240 IF H = 34 THEN 2250 ELSE 2280
2250 LOCATE 5, 20: PRINT "MAX (returns maximum value)"
2260 LOCATE 8, 10: PRINT "Returns waveform maximum (most positive) value to the"
2270 LOCATE 9, 10: PRINT "X register."
2280 IF H = 38 THEN 2290 ELSE 2320
2290 LOCATE 5, 20: PRINT "MEAN (returns mean value)"
2300 LOCATE 8, 10: PRINT "Computes the algebraic mean value of all spanned points "
2310 LOCATE 9, 10: PRINT "and returns the results to the X register."
2320 IF H = 35 THEN 2330 ELSE 2360
2330 LOCATE 5, 20: PRINT "MIN (returns minimum value)"
2340 LOCATE 8, 10: PRINT "Returns the minimum value (most negative) of the waveform "
2350 LOCATE 9, 10: PRINT "to the X register."
2360 IF H = 36 THEN 2370 ELSE 2400
2370 LOCATE 5, 20: PRINT "P-P (returns peak-to-peak value)"
2380 LOCATE 8, 10: PRINT "Returns the peak-to peak value (MAX - MIN) of the waveform "
2390 LOCATE 9, 10: PRINT "to the X register."
2400 IF H = 37 THEN 2410 ELSE 2440
2410 LOCATE 5, 20: PRINT "RMS (returns root-mean-square value)"
2420 LOCATE 8, 10: PRINT "Returns root-mean-square value of all spanned points"
2430 LOCATE 9, 10: PRINT "to the X register."
2440 IF H = 32 THEN 2450 ELSE 2510
2450 LOCATE 5, 20: PRINT "DELAY (returns delay)"
2460 LOCATE 8, 10: PRINT "Returns the time from cursor 1 to the last 50 % point"
2470 LOCATE 9, 10: PRINT "before cursor 2 to the X register. If both cursors"
2480 LOCATE 10, 10: PRINT "are off, cursor 1 is assumed to be at the first point"
2490 LOCATE 11, 10: PRINT "and cursor 2 at the last point. There is a minimum "
2500 LOCATE 12, 10: PRINT "time restriction."
2510 IF H = 42 THEN 2520 ELSE 2580
2520 LOCATE 5, 20: PRINT "FREQ (returns frequency)"
2530 LOCATE 8, 10: PRINT "Returns the reciprocal of the time between crossings of "
2540 LOCATE 9, 10: PRINT "the level found in the X register. This level must be "
2550 LOCATE 10, 10: PRINT "crossed twice in the same direction. For example; the "
2560 LOCATE 11, 10: PRINT "value found with the MEAN function can be used to find "
2570 LOCATE 12, 10: PRINT "the frequency (0 WFM MEAN FREQ)."
2580 IF H = 43 THEN 2590 ELSE 2650
2590 LOCATE 5, 20: PRINT "PER (returns period)"
2600 LOCATE 8, 10: PRINT "Returns the time between crossings of the value stored"
2610 LOCATE 9, 10: PRINT "in the X register. Two crossings in the same direction"
2620 LOCATE 10, 10: PRINT "must occur. Results are returned to the X register."
2630 LOCATE 11, 10: PRINT "The MEAN function could be used to establish the "
2640 LOCATE 12, 10: PRINT "crossing points (0 WFM MEAN PER for example)."
2650 IF H = 31 THEN 2660 ELSE 2710
2660 LOCATE 5, 20: PRINT "FALL (returns fall time)"
2670 LOCATE 8, 10: PRINT "Returns the time between the 90 % and 10 % points to the "
2680 LOCATE 9, 10: PRINT "right of cursor 2. The 50 % point crossed between cursors 1 "
2690 LOCATE 10, 10: PRINT "and 2 must also be crossed following cursor 2. Errors include; "
2700 LOCATE 11, 10: PRINT "mode not CRS2-1 and 50 % point not found following cursor 2. "
2710 IF H = 30 THEN 2720 ELSE 2770
2720 LOCATE 5, 20: PRINT "RISE (returns rise time)"
2730 LOCATE 8, 10: PRINT "Returns the time between the 10% and 90% points to the "
2740 LOCATE 9, 10: PRINT "left of cursor 2. If cursor 2 is not on, it is assumed to "
2750 LOCATE 10, 10: PRINT "be on the last point on the waveform. Results are returned "
2760 LOCATE 11, 10: PRINT "to the X register."
2770 IF H = 33 THEN 2780 ELSE 2820
2780 LOCATE 5, 20: PRINT "WIDTH (returns width)"
2790 LOCATE 8, 10: PRINT "Returns the time between the closest 50% points before"
2800 LOCATE 9, 10: PRINT "and after cursor 2. Mode must be CRS2-1. 50% point "
2810 LOCATE 10, 10: PRINT "must be crossed following cursor 2."
2820 IF H = 24 THEN 2830 ELSE 2860
2830 LOCATE 5, 20: PRINT "CNS (returns constant)"
2840 LOCATE 8, 10: PRINT "The contents of the constant register, designated   "
2850 LOCATE 9, 10: PRINT "in the X register, is returned to the X register.   "
2860 IF H = 25 THEN 2870 ELSE 2940
2870 LOCATE 5, 20: PRINT ">CNS (stores constant)"
2880 LOCATE 8, 10: PRINT "Copies the contents of the Y register to the constant"
2890 LOCATE 9, 10: PRINT "register number in the X register. If the Y register"
2900 LOCATE 10, 10: PRINT "is a waveform address, only the waveform number "
2910 LOCATE 11, 10: PRINT "is copied to the X register."
2920 LOCATE 13, 10: PRINT "A numeric value must be in the X register. It can"
2930 LOCATE 14, 10: PRINT "be sent as part of the command string using the INPUT function."
2940 IF H = 45 THEN 2950 ELSE 2990
2950 LOCATE 5, 20: PRINT "DIFF (differentiate)"
2960 LOCATE 8, 10: PRINT "Differentiates the operational waveform. Stores the resultant"
2970 LOCATE 9, 10: PRINT "waveform in 0 waveform. X register must contain a valid "
2980 LOCATE 10, 10: PRINT "waveform memory address."
2990 IF H = 46 THEN 3000 ELSE 3050
3000 LOCATE 5, 20: PRINT "SMOOTH"
3010 LOCATE 8, 10: PRINT "Averages the operational waveform by the number of"
3020 LOCATE 9, 10: PRINT "divisions in the X register (between 0 an 2). The"
3030 LOCATE 10, 10: PRINT "X register value must be a constant between 0 and 2"
3040 LOCATE 11, 10: PRINT "and Y register must contain a valid waveform address."
3050 IF H = 22 THEN 3060 ELSE 3090
3060 LOCATE 5, 20: PRINT "P/W (returns points per waveform)"
3070 LOCATE 8, 10: PRINT "Returns the points per waveform setting into the  "
3080 LOCATE 9, 10: PRINT "X register.    "
3090 IF H = 23 THEN 3100 ELSE 3140
3100 LOCATE 5, 20: PRINT ">P/W (set points per waveform)"
3110 LOCATE 8, 10: PRINT "The waveform memory is reconfigured so that the size of all"
3120 LOCATE 9, 10: PRINT "waveforms are equal to the value in the X register. The"
3130 LOCATE 10, 10: PRINT "X register must contain either 128, 256, 512, or 1024."
3140 IF H = 20 THEN 3150 ELSE 3210
3150 LOCATE 5, 20: PRINT "WFM (recall waveform)"
3160 LOCATE 8, 10: PRINT "Contents of the waveform memory called out in X register, "
3170 LOCATE 9, 10: PRINT "becomes the operational waveform. X register must contain"
3180 LOCATE 10, 10: PRINT "a valid number between 0 and the maximum valid waveform"
3190 LOCATE 11, 10: PRINT "memory address. The maximum value is determined by the "
3200 LOCATE 12, 10: PRINT "memory size (option number) and the selected points/waveform. "
3210 IF H = 21 THEN 3220 ELSE 3270
3220 LOCATE 5, 20: PRINT ">WFM (copy stored waveform)"
3230 LOCATE 8, 10: PRINT "Operational waveform is copied into the waveform memory"
3240 LOCATE 9, 10: PRINT "address designated in the X register.  The Y register must"
3250 LOCATE 10, 10: PRINT "contain a valid waveform memory address and the X register"
3260 LOCATE 11, 10: PRINT "must be a valid waveform number."
3270 IF H = 29 THEN 3280 ELSE 3310
3280 LOCATE 5, 20: PRINT "CLD (clear display)"
3290 LOCATE 8, 10: PRINT "All waveforms being displayed via the DSW command are"
3300 LOCATE 9, 10: PRINT "cleared. Only the operational waveform is displayed."
3310 IF H = 28 THEN 3320 ELSE 3360
3320 LOCATE 5, 20: PRINT "CLW (removes waveform from display)"
3330 LOCATE 8, 10: PRINT "Clears the waveform specified in the X register from"
3340 LOCATE 9, 10: PRINT "the display. Waveform must have been displayed with"
3350 LOCATE 10, 10: PRINT "a DSW command. "
3360 IF H = 52 THEN 3370 ELSE 3430
3370 LOCATE 5, 20: PRINT "VS (displays waveform versus waveform)"
3380 LOCATE 8, 10: PRINT "The waveform whose memory address is contained in the X register "
3390 LOCATE 9, 10: PRINT "provides the horizontal axis for all displayed waveforms. This "
3400 LOCATE 10, 10: PRINT "is equivalent to a X-Y display on a scope. In the example "
3410 LOCATE 11, 10: PRINT "2 DSW 3 VS ; 2 waveform is the vertical component and 3 "
3420 LOCATE 12, 10: PRINT "waveform the horizontal component. "
3430 IF H = 53 THEN 3440 ELSE 3480
3440 LOCATE 5, 20: PRINT "TIME (displays waveform versus time)"
3450 LOCATE 8, 10: PRINT "Time is the horizontal axis for all displayed waveforms."
3460 LOCATE 9, 10: PRINT "All waveforms displayed with the DSW command are  "
3470 LOCATE 10, 10: PRINT "displayed versus time."
3480 IF H = 27 THEN 3490 ELSE 3540
3490 LOCATE 5, 20: PRINT "DSW (display stored waveform)"
3500 LOCATE 8, 10: PRINT "Displays stored waveforms. Up to 8 waveforms can be displayed  "
3510 LOCATE 9, 10: PRINT "with this command. The waveforms displayed with this command "
3520 LOCATE 10, 10: PRINT "are listed on the 7854 CRT on line 2 of the readout in a top "
3530 LOCATE 11, 10: PRINT "to bottom order. The operational waveform is always displayed. "
3540 IF H = 47 THEN 3550 ELSE 3630
3550 LOCATE 5, 20: PRINT "HXPD (expand waveform horizontally)"
3560 LOCATE 8, 10: PRINT "Horizontally expands the operational waveform. The cursor "
3570 LOCATE 9, 10: PRINT "status determines actual expansion. With cursors off, the waveform "
3580 LOCATE 10, 10: PRINT "is magnified by a value in the X register. The first waveform "
3590 LOCATE 11, 10: PRINT "point remains fixed. With 1 cursor, the waveform is magnified "
3600 LOCATE 12, 10: PRINT "from the cursor to end of waveform. With 2 cursors, the portion "
3610 LOCATE 13, 10: PRINT "of the waveform between the cursors is magnified. For further "
3620 LOCATE 14, 10: PRINT "details, refer to the 7854 operators manual."
3630 IF H = 55 THEN 3640 ELSE 3670
3640 LOCATE 5, 20: PRINT "HSCL (returns horizontal scale factor)"
3650 LOCATE 8, 10: PRINT "Copies the horizontal scale factor into the X register."
3660 LOCATE 9, 10: PRINT "This is the scale factor of the operational waveform. "
3670 IF H = 56 THEN 3680 ELSE 3710
3680 LOCATE 5, 20: PRINT "VSCL (returns vertical scale factor)"
3690 LOCATE 8, 10: PRINT "Copies the vertical scale factor into the X register. "
3700 LOCATE 9, 10: PRINT "This is the scale factor of the operational waveform."
3710 IF H = 26 THEN 3720 ELSE 3730
3720 LOCATE 5, 20: PRINT "Function #26 - Not implemented."
3730 LOCATE 22, 1: INPUT " Tap 'enter' to continue ", ANS$
3740 CLS : GOTO 110
3750 '
3760 REM Draw command box
3770 '
3780 LOCATE 23, 1: PRINT STRING$(1, 218); : LOCATE 23, 2: PRINT STRING$(78, 196); : LOCATE 23, 79: PRINT STRING$(1, 191);
3790 LOCATE 25, 1: PRINT STRING$(1, 192); : LOCATE 25, 2: PRINT STRING$(78, 196); : LOCATE 25, 79: PRINT STRING$(1, 217);
3800 LOCATE 24, 1: PRINT STRING$(1, 179); : LOCATE 24, 79: PRINT STRING$(1, 179);
3810 RETURN

