1 REM This software cannot be run in IBM basic. It has been written to be
2 REM to be compiled. The DECL.BAS file could be merged with each software
3 REM package to have a file that will run in basic.
4 REM This would allow the user to modify the routines to fit a particular
5 REM application. The basic source code has been provided for this purpose.
6 REM
7 REM
8 REM
9 REM
10 REM ******************************************************************
11 REM *                                                                *
12 REM *      7854 to IBM PC UTILITY COMMUNICATIONS SOFTWARE            *
13 REM *                       for the                                  *
14 REM *             Tektronix 7854 Oscilloscope                        *
15 REM *                         and                                    *
16 REM *         IBM-PC, IBM-PC XT and IBM portable PC                  *
17 REM *           Copyright 1985 by TEKTRONIX Inc.                     *
18 REM *                All rights reserved                             *
19 REM *                   Version 1.00                                 *
20 REM *                                                                *
21 REM *   This software is provided on an 'as is' basis without        *
22 REM *       warranty of any kind. It is not supported.               *
23 REM *                                                                *
24 REM ******************************************************************
25 REM *
26 REM *   REQUIRED EQUIPMENT:
27 REM *
28 REM *   IBM-PC or IBM-XT with graphics adapter (color monitor is optional)
29 REM *   or IBM-PC PORTABLE
30 REM *   GPIB-PC card from -
32 REM *     National Instruments Inc.   part number 776043-01
33 REM *     Tektronix Inc.              part number 118-4200-00
34 REM *
35 REM *   PURPOSE:
36 REM *    Sends commands to the 7854, singly or in strings
37 REM *
38 REM *   CALLING FORMAT:
39 REM *    This is a stand-alone program. It is also part of a group of
40 REM *    five software programs that make up a utility software
41 REM *    package. 7854.EXE is the name of the software routine that
42 REM *    this software exits to. A help menu is provided through
43 REM *    the HELP.EXE routine.
44 REM *
45 REM *   VARIABLES:
46 REM *
47 REM *    DSO%   Device descriptor altered by IBCONF
48 REM *    DEV$   Specific device (7854) from IBCONF (address 1)
49 REM *    FILE$  Name of file to write to or read from
50 REM *    A$     Name or name and extension to search media for
51 REM *    C$     Selected command
52 REM *    D$     Drive name where data files are stored
53 REM *    FILE$  Selected data file name to write to or read from
54 REM *    SEL$   Individually selected commands
55 REM *    VEW$   Multiple commands in a string
56 REM *    Q$     String input for INKEY$ selection
65 REM *    C      Value of C$, used as pointer to SEL$
66 REM *    CF     Color of text
67 REM *    CB     Color of background
68 REM *    CD     Color of border
69 REM *    X      Offset for vertical position
70 REM *    Y      Offset for horizontal position
71 REM *
72 REM *
73 REM *  ROUTINES CALLED:
74 REM *
75 REM *    7854.EXE is returned to by selecting <M>enu
76 REM *    HELP.EXE give users information on specific commands. Selected
77 REM *             from the menu (<H>elp).
78 REM *  FILES USED:
79 REM *    CONFIG      Color information adn drive name stored in this file
83 REM *    all.CMD     Command string files listed for user
84 REM *    7854.EXE    Main program, see ROUTINES CALLED
85 REM *    GPIB.COM    Supplied with GPIB-PC
87 REM *
89 REM *
90 REM *  POSSIBLE ERRORS:
91 REM *
93 REM *    No known errors not handled by 'ON ERROR' routines
94 REM *
99 REM ***********************************************************************
100 'COMMON SHARED ibsta%, iberr%, IBCNT%               ' GPIB.QLB
101 COMMON SHARED /NISTATBLK/ ibsta%, iberr%, IBCNT%  ' QBIB4.OBJ
110 X = 4: Y = 16
120 DEF SEG = 0: POKE 1047, 64: DEF SEG
130 ON ERROR GOTO 2000: A$ = "CONFIG.DAT": OPEN A$ FOR INPUT AS #1: INPUT #1, CF, CB, CD, D$, VEW$: CLOSE #1: CLS : COLOR CF, CB, CD
140 DEV$ = "DEV1"
150 CALL IBFIND(DEV$, DSO%)
170 CALL IBLOC(DSO%)
180 '
190 REM Command string selection menu
200 '
210 CLS : GOSUB 1920: COLOR CB, CF: LOCATE 1, 1: PRINT STRING$(80, 32): LOCATE 1, Y + 7: PRINT "SENDING COMMANDS TO THE 7854 "; : IF LEN(VEW$) < 2 THEN 230
220 LOCATE X + 17, 1: PRINT VEW$: COLOR CF, CB
230 GOSUB 1510
240 LOCATE 24, 2: PRINT STRING$(76, 32);
250 LOCATE 24, 2: PRINT "COMMAND: <S>elect  <I>nput frm kbd  <T>ransmit  <D>elete  <H>elp     <M>enu";
260 Q$ = INKEY$: IF Q$ = "" THEN 260
270 LOCATE 22, 1: PRINT STRING$(70, 32)
280 IF Q$ = "T" THEN 1060
290 IF Q$ = "H" THEN 2150
300 IF Q$ = "D" THEN 1830
310 IF Q$ = "S" THEN 380
320 IF Q$ = "M" THEN CLS : GOTO 2130
330 IF Q$ = "I" THEN 1720
340 BEEP: GOTO 250
350 '
360 REM Select command by number
370 '
380 LOCATE 24, 2: PRINT STRING$(75, 32); : LOCATE 22, 1: PRINT STRING$(79, 32); : LOCATE 22, 2: INPUT " Select which one "; C$: IF LEN(C$) < 1 THEN LOCATE 22, 1: PRINT STRING$(79, 32); : GOTO 250
390 C = VAL(C$): IF C < 1 OR C > 57 THEN BEEP: GOTO 380
400 IF C = 26 THEN BEEP: GOTO 380
410 IF LEN(C$) > 2 THEN BEEP: GOTO 380
420 LOCATE 22, 1: PRINT STRING$(79, 32); : COLOR CB, CF
430 IF C = 1 THEN SEL$ = " SCOPE "
440 IF C = 2 THEN SEL$ = " STORED "
450 IF C = 3 THEN SEL$ = " BOTH "
460 IF C = 4 THEN SEL$ = " AQR "
470 IF C = 5 THEN SEL$ = " AQS "
480 IF C = 6 THEN SEL$ = " AVG "
490 IF C = 7 THEN SEL$ = " GND "
500 IF C = 8 THEN SEL$ = " RDOUT "
510 IF C = 9 THEN SEL$ = " OFF "
520 IF C = 10 THEN SEL$ = " CRS1 "
530 IF C = 11 THEN SEL$ = " CRS1< "
540 IF C = 12 THEN SEL$ = " CRS1> "
550 IF C = 13 THEN SEL$ = " CRS2-1 "
560 IF C = 14 THEN SEL$ = " CRS2< "
570 IF C = 15 THEN SEL$ = " CRS2> "
580 IF C = 16 THEN SEL$ = " HCRD "
590 IF C = 17 THEN SEL$ = " VCRD "
600 IF C = 18 THEN SEL$ = " >HCRD "
610 IF C = 19 THEN SEL$ = " >VCRD "
620 IF C = 49 THEN SEL$ = " + "
630 IF C = 48 THEN SEL$ = " - "
640 IF C = 50 THEN SEL$ = " * "
650 IF C = 51 THEN SEL$ = " / "
660 IF C = 44 THEN SEL$ = " INTG "
670 IF C = 45 THEN SEL$ = " DIFF "
680 IF C = 46 THEN SEL$ = " SMOOTH "
690 IF C = 47 THEN SEL$ = " HXPD "
700 IF C = 41 THEN SEL$ = " AREA "
710 IF C = 40 THEN SEL$ = " ENERGY "
720 IF C = 34 THEN SEL$ = " MAX "
730 IF C = 38 THEN SEL$ = " MEAN "
740 IF C = 39 THEN SEL$ = " MID "
750 IF C = 35 THEN SEL$ = " MIN "
760 IF C = 36 THEN SEL$ = " P-P "
770 IF C = 37 THEN SEL$ = " RMS "
780 IF C = 32 THEN SEL$ = " DELAY "
790 IF C = 43 THEN SEL$ = " PER "
800 IF C = 42 THEN SEL$ = " FREQ "
810 IF C = 31 THEN SEL$ = " FALL "
820 IF C = 30 THEN SEL$ = " RISE "
830 IF C = 33 THEN SEL$ = " WIDTH "
840 IF C = 24 THEN SEL$ = " CNS "
850 IF C = 25 THEN SEL$ = " >CNS "
860 IF C = 22 THEN SEL$ = " P/W "
870 IF C = 23 THEN SEL$ = " >P/W "
880 IF C = 20 THEN SEL$ = " WFM "
890 IF C = 21 THEN SEL$ = " >WFM "
900 IF C = 29 THEN SEL$ = " CLD "
910 IF C = 28 THEN SEL$ = " CLW "
920 IF C = 52 THEN SEL$ = " VS "
930 IF C = 53 THEN SEL$ = " TIME "
940 IF C = 27 THEN SEL$ = " DSW "
950 IF C = 54 THEN SEL$ = " SGN "
960 IF C = 55 THEN SEL$ = " HSCL "
970 IF C = 56 THEN SEL$ = " VSCL "
980 IF C = 57 THEN SEL$ = " ENTER "
990 VEW$ = VEW$ + SEL$
1000 LOCATE 21, 1: PRINT VEW$;
1010 IF LEN(VEW$) > 70 THEN BEEP: COLOR CF, CB: LOCATE 22, 2: PRINT " String is too long, <T>ransmit or <D>elete string.": GOTO 240
1020 COLOR CF, CB: GOTO 240
1030 '
1040 REM Transfer commands menu
1050 '
1060 CLS : GOSUB 1920: COLOR CB, CF: LOCATE 1, 1: PRINT STRING$(80, 32): LOCATE 1, Y + 7: PRINT "SENDING COMMANDS TO THE 7854 "; : IF LEN(VEW$) < 1 THEN 1070
1065 LOCATE X + 17, 1: PRINT VEW$
1070 COLOR CF, CB: LOCATE 24, 2: PRINT "COMMANDS:<W>rite to disk  <R>ead from disk  <T>ransfer to 7854  <P>rev menu";
1080 Q$ = INKEY$: IF Q$ = "" THEN 1080
1090 IF Q$ = "W" THEN 1170
1100 IF Q$ = "R" THEN 1300
1110 IF Q$ = "T" THEN 1440
1120 IF Q$ = "P" THEN 210
1130 BEEP: GOTO 1080
1140 '
1150 REM Write command string to disk
1160 '
1170 ON ERROR GOTO 2030
1190 LOCATE 5, 1: FILES D$ + "*.CMD"
1200 LOCATE 24, 2: PRINT STRING$(76, 32); : LOCATE 24, 12: PRINT "Write to a file";
1210 LOCATE 22, 1: PRINT STRING$(70, 32); : LOCATE 22, 1: INPUT " Input file name "; FILE$
1220 IF LEN(FILE$) < 1 THEN LOCATE 20, 1: PRINT STRING$(79, 32); : LOCATE 22, 1: PRINT STRING$(79, 32); : GOTO 210
1230 Y$ = ".": V = INSTR(FILE$, Y$)
1240 IF V <> 0 THEN LOCATE 20, 1: PRINT STRING$(79, 32): LOCATE 20, 1: PRINT "Do not use a '.' in the file name.": GOSUB 2090: GOTO 1170
1250 OPEN D$ + FILE$ + ".CMD" FOR OUTPUT AS #1: PRINT #1, VEW$: CLOSE #1
1260 GOTO 210
1270 '
1280 REM Read command string from disk
1290 '
1300 ON ERROR GOTO 2030
1310 LOCATE 5, 1: FILES D$ + "*.CMD"
1320 LOCATE 24, 2: PRINT STRING$(76, 32); : LOCATE 24, 12: PRINT "Read from a file";
1330 LOCATE 22, 1: PRINT STRING$(70, 32); : LOCATE 22, 1: INPUT " Input file name (without extension) "; FILE$
1340 IF LEN(FILE$) < 1 THEN LOCATE 20, 1: PRINT STRING$(79, 32); : LOCATE 22, 1: PRINT STRING$(79, 32); : GOTO 210
1350 Y$ = ".": V = INSTR(FILE$, Y$)
1360 IF V <> 0 THEN LOCATE 20, 1: PRINT STRING$(79, 32): LOCATE 20, 1: PRINT "Do not use a '.' in the file name.": GOSUB 2090: GOTO 1300
1370 ON ERROR GOTO 2040
1380 OPEN D$ + FILE$ + ".CMD" FOR INPUT AS #1: INPUT #1, VEW$
1390 CLOSE #1: LOCATE 10, 1: PRINT STRING$(240, 32); : LOCATE 13, 1: PRINT STRING$(240, 32);
1400 LOCATE 21, 1: COLOR CB, CF: PRINT VEW$: COLOR CF, CB: GOTO 1060
1410 '
1420 REM Transfer command string to 7854
1430 '
1440 CALL IBWRT(DSO%, VEW$)
1450 LOCATE 20, 1: PRINT STRING$(240, 32): VEW$ = ""
1460 GOSUB 1910: CALL IBLOC(DSO%): GOTO 210
1470 '
1480 REM Print command list
1490 '
1500 X = 5: Y = 15
1510 COLOR CB, CF: LOCATE X - 1, 2: PRINT "  DISPLAY  ": LOCATE X - 1, Y: PRINT " CURSORS ": LOCATE X - 1, Y + 16: PRINT " WAVEFORM PARAMETERS ": LOCATE X - 1, Y + 48: PRINT " ALGEBRAIC ": COLOR CF, CB
1520 LOCATE X, 2: PRINT "1  SCOPE": LOCATE X, Y: PRINT "9  OFF": LOCATE X, Y + 16: PRINT "30 RISE": LOCATE X, Y + 32: PRINT "37 RMS ": LOCATE X, Y + 48: PRINT "48 - (minus)"
1530 LOCATE X + 1, 2: PRINT "2  STORED": LOCATE X + 1, Y: PRINT "10 CRS1": LOCATE X + 1, Y + 16: PRINT "31 FALL": LOCATE X + 1, Y + 32: PRINT "38 MEAN": LOCATE X + 1, Y + 48: PRINT "49 + (plus)"
1540 LOCATE X + 2, 2: PRINT "3  BOTH": LOCATE X + 2, Y: PRINT "11 CRS1<": LOCATE X + 2, Y + 16: PRINT "32 DELAY": LOCATE X + 2, Y + 32: PRINT "39 MID": LOCATE X + 2, Y + 48: PRINT "50 * (times)"
1550 LOCATE X + 3, Y: PRINT "12 CRS1>": LOCATE X + 3, Y + 16: PRINT "33 WIDTH": LOCATE X + 3, Y + 32: PRINT "40 ENERGY": LOCATE X + 3, Y + 48: PRINT "51 / (divide)"
1560 COLOR CB, CF: LOCATE X + 5, 2: PRINT " ACQUISITION ": COLOR CF, CB: LOCATE X + 4, Y: PRINT "13 CRS2-1": LOCATE X + 4, Y + 16: PRINT "34 MAX": LOCATE X + 4, Y + 32: PRINT "41 AREA "
1570 LOCATE X + 5, Y: PRINT "14 CRS2<": LOCATE X + 5, Y + 16: PRINT "35 MIN": LOCATE X + 5, Y + 32: PRINT "42 FREQ": COLOR CB, CF: LOCATE X + 5, Y + 48: PRINT "   MISC   ": COLOR CF, CB
1580 LOCATE X + 6, 2: PRINT "4  AQR": LOCATE X + 6, Y: PRINT "15 CRS2>": LOCATE X + 6, Y + 16: PRINT "36 P-P": LOCATE X + 6, Y + 32: PRINT "43 PER"
1590 LOCATE X + 7, 2: PRINT "5  AQS": LOCATE X + 7, Y: PRINT "16 HCRD": LOCATE X + 6, Y + 48: PRINT "52 VS  "
1600 LOCATE X + 8, 2: PRINT "6  AVG": LOCATE X + 8, Y: PRINT "17 VCRD": COLOR CB, CF: LOCATE X + 8, Y + 16: PRINT " WAVEFORM FUNCTIONS ": COLOR CF, CB: LOCATE X + 7, Y + 48: PRINT "53 TIME"
1610 LOCATE X + 9, 2: PRINT "7  GND": LOCATE X + 9, Y: PRINT "18 >HCRD": LOCATE X + 8, Y + 48: PRINT "54 SGN"
1620 LOCATE X + 10, 2: PRINT "8  RDOUT": LOCATE X + 10, Y: PRINT "19 >VCRD": LOCATE X + 9, Y + 16: PRINT "44 INTG": LOCATE X + 9, Y + 32: PRINT "46 SMOOTH": LOCATE X + 9, Y + 48: PRINT "55 HCSL "
1630 LOCATE X + 10, Y + 16: PRINT "45 DIFF": LOCATE X + 10, Y + 32: PRINT "47 HXPD": LOCATE X + 10, Y + 48: PRINT "56 VSCL"
1640 LOCATE X + 12, 2: COLOR CB, CF: PRINT "     DATA and WAVEFORM STORAGE     ": COLOR CF, CB: LOCATE X + 11, Y + 48: PRINT "57 ENTER"
1650 LOCATE X + 13, 2: PRINT "20 WFM": LOCATE X + 13, Y: PRINT "23 >P/W": LOCATE X + 13, Y + 16: PRINT "27 DSW"
1660 LOCATE X + 14, 2: PRINT "21 >WFM": LOCATE X + 14, Y: PRINT "24 CNS": LOCATE X + 14, Y + 16: PRINT "28 CLW"
1670 LOCATE X + 15, 2: PRINT "22 P/W": LOCATE X + 15, Y: PRINT "25 >CNS": LOCATE X + 15, Y + 16: PRINT "29 CLD"
1680 RETURN
1690 '
1700 REM Input command(s) from keyboard
1710 '
1720 LOCATE 22, 1: PRINT STRING$(60, 32); : LOCATE 22, 2: INPUT "INPUT A COMMAND:", SEL$
1730 SEL$ = " " + SEL$ + " ": LOCATE 22, 1: PRINT STRING$(60, 32); : COLOR CB, CF: GOTO 990
1740 '
1750 REM Write command string to 7854
1760 '
1770 CALL IBWRT(DSO%, VEW$)
1780 IF ibsta% < 0 THEN 2030
1790 GOTO 210
1800 '
1810 REM Prints command string, deletes string
1820 '
1830 LOCATE 24, 2: PRINT STRING$(76, 32); : COLOR CB, CF: LOCATE 21, 1: PRINT VEW$; : COLOR CF, CB
1840 LOCATE 20, 2: PRINT "Do you wish to Delete this string (input Y or N)"; : Q$ = INKEY$: IF Q$ = "" THEN 1840
1850 IF Q$ = "Y" OR Q$ = "y" THEN 1880 ELSE 1870
1860 GOTO 1840
1870 LOCATE 20, 1: PRINT STRING$(240, 32); : LOCATE 21, 1: COLOR CB, CF: PRINT VEW$; : COLOR CF, CB: GOTO 250
1880 LOCATE 20, 1: PRINT STRING$(240, 32); : VEW$ = "": GOTO 250
1890 '
1900 REM Draw box for command line
1910 '
1920 LOCATE 23, 1: PRINT STRING$(1, 218); : LOCATE 23, 2: PRINT STRING$(78, 196); : LOCATE 23, 79: PRINT STRING$(1, 191);
1930 LOCATE 25, 1: PRINT STRING$(1, 192); : LOCATE 25, 2: PRINT STRING$(78, 196); : LOCATE 25, 79: PRINT STRING$(1, 217);
1940 CALL IBLOC(DSO%)
1950 LOCATE 24, 1: PRINT STRING$(1, 179); : LOCATE 24, 79: PRINT STRING$(1, 179);
1960 RETURN
1970 '
1980 REM Error routines
1990 '
2000 IF ERR = 53 THEN PRINT "No "; A$; " file found.": GOSUB 2090: CF = 7: CB = 0: RESUME 140
2010 RESUME
2020 RESUME 1060
2030 IF ERR = 53 THEN LOCATE 20, 1: PRINT STRING$(240, 32): LOCATE 20, 1: PRINT "No file exist with that extension.": GOSUB 2090: RESUME NEXT
2040 IF ERR = 53 THEN LOCATE 20, 1: PRINT STRING$(79, 32); : LOCATE 20, 1: PRINT "No file exists with that name.": GOSUB 2090: RESUME 1310
2050 RESUME 240
2060 '
2070 REM Simple timing loop
2080 '
2090 FOR I = 1 TO 4000: NEXT I: RETURN
2100 '
2110 REM Return to main program (7854.EXE)
2120 '
2130 VEW$ = SPACE$(1): OPEN "CONFIG.DAT" FOR OUTPUT AS #1: WRITE #1, CF, CB, CD, D$, VEW$: CLOSE #1
2140 CALL IBLOC(DSO%): V% = 0: CALL IBONL(DSO%, V%): CLS : RUN "7854"
2150 OPEN "CONFIG.DAT" FOR OUTPUT AS #1: WRITE #1, CF, CB, CD, D$, VEW$: CLOSE #1
2160 CLS : V% = 0: CALL IBONL(DSO%, V%): RUN "HELP"

